/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.scm.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.sourceclear.scm.core.SCMAggregate;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SCMPermissions {
    @JsonProperty
    private final boolean privateRepoAccess;
    @JsonProperty
    private final boolean orgTeam;
    @JsonProperty
    private final boolean repoWebhooks;
    @JsonProperty
    private final boolean orgWebhooks;
    @JsonProperty
    private final boolean deployments;
    @JsonProperty
    private final boolean commits;
    @JsonProperty
    private final List<SCMAggregate> aggregates;

    public SCMPermissions(Builder builder) {
        this.privateRepoAccess = builder.privateRepoAccess;
        this.orgTeam = builder.orgTeam;
        this.repoWebhooks = builder.repoWebhooks;
        this.orgWebhooks = builder.orgWebhooks;
        this.deployments = builder.deployments;
        this.commits = builder.commits;
        this.aggregates = builder.aggregates;
    }

    @JsonCreator
    public SCMPermissions(@JsonProperty(value="privateRepoAccess") boolean privateRepoAccess, @JsonProperty(value="orgTeam") boolean orgTeam, @JsonProperty(value="repoWebhooks") boolean repoWebhooks, @JsonProperty(value="orgWebhooks") boolean orgWebhooks, @JsonProperty(value="deployments") boolean deployments, @JsonProperty(value="commits") boolean commits, @JsonProperty(value="aggregates") List<SCMAggregate> aggregates) {
        this.privateRepoAccess = privateRepoAccess;
        this.orgTeam = orgTeam;
        this.repoWebhooks = repoWebhooks;
        this.orgWebhooks = orgWebhooks;
        this.deployments = deployments;
        this.commits = commits;
        this.aggregates = aggregates;
    }

    public boolean isPrivateRepoAccess() {
        return this.privateRepoAccess;
    }

    public boolean isOrgTeam() {
        return this.orgTeam;
    }

    public boolean isRepoWebhooks() {
        return this.repoWebhooks;
    }

    public boolean isOrgWebhooks() {
        return this.orgWebhooks;
    }

    public boolean isDeployments() {
        return this.deployments;
    }

    public boolean isCommits() {
        return this.commits;
    }

    public List<SCMAggregate> getAggregates() {
        return this.aggregates;
    }

    public static class Builder {
        private boolean privateRepoAccess;
        private boolean orgTeam;
        private boolean repoWebhooks;
        private boolean orgWebhooks;
        private boolean deployments;
        private boolean commits;
        private List<SCMAggregate> aggregates = Lists.newArrayList();

        public Builder withPrivateRepoAccess(boolean privateRepoAccess) {
            this.privateRepoAccess = privateRepoAccess;
            return this;
        }

        public Builder withOrgTeam(boolean orgTeam) {
            this.orgTeam = orgTeam;
            return this;
        }

        public Builder withRepoWebhooks(boolean repoWebhooks) {
            this.repoWebhooks = repoWebhooks;
            return this;
        }

        public Builder withOrgWebhooks(boolean orgWebhooks) {
            this.orgWebhooks = orgWebhooks;
            return this;
        }

        public Builder withDeployments(boolean deployments) {
            this.deployments = deployments;
            return this;
        }

        public Builder withCommits(boolean commits) {
            this.commits = commits;
            return this;
        }

        public Builder addAggregate(SCMAggregate aggregate) {
            this.aggregates.add(aggregate);
            return this;
        }

        public Builder addAggregates(List<SCMAggregate> aggregates) {
            this.aggregates.addAll(aggregates);
            return this;
        }

        public SCMPermissions build() {
            return new SCMPermissions(this);
        }
    }
}

