/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.sgl.Utility;
import com.sourceclear.sgl.Vertex;
import java.util.Objects;

public class Method
implements Vertex {
    @JsonProperty
    private final String type = "method";
    @JsonProperty
    private final String language;
    @JsonProperty
    private final String coord1;
    @JsonProperty
    private final String coord2;
    @JsonProperty
    private final String version;
    @JsonProperty
    private final String moduleName;
    @JsonProperty
    private final String className;
    @JsonProperty
    private final String methodName;
    @JsonProperty
    private final String descriptor;

    public Method(@JsonProperty(value="language") String language, @JsonProperty(value="coord1") String coord1, @JsonProperty(value="coord2") String coord2, @JsonProperty(value="version") String version, @JsonProperty(value="module_name") String moduleName, @JsonProperty(value="class_name") String className, @JsonProperty(value="method_name") String methodName, @JsonProperty(value="descriptor") String descriptor) {
        this.language = language;
        this.coord1 = coord1;
        this.coord2 = coord2;
        this.version = version;
        this.moduleName = moduleName;
        this.className = className;
        this.methodName = methodName;
        this.descriptor = descriptor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("method(");
        sb.append("language:").append(Utility.quoteString(this.language));
        sb.append(", coord1:").append(Utility.quoteString(this.coord1));
        sb.append(", coord2:").append(Utility.quoteString(this.coord2));
        sb.append(", version:").append(Utility.quoteString(this.version));
        sb.append(", module_name:").append(Utility.quoteString(this.moduleName));
        sb.append(", class_name:").append(Utility.quoteString(this.className));
        sb.append(", method_name:").append(Utility.quoteString(this.methodName));
        sb.append(", descriptor:").append(Utility.quoteString(this.descriptor));
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        return Objects.equals("method", method.type) && Objects.equals(this.language, method.language) && Objects.equals(this.coord1, method.coord1) && Objects.equals(this.coord2, method.coord2) && Objects.equals(this.version, method.version) && Objects.equals(this.moduleName, method.moduleName) && Objects.equals(this.className, method.className) && Objects.equals(this.methodName, method.methodName) && Objects.equals(this.descriptor, method.descriptor);
    }

    public int hashCode() {
        return Objects.hash("method", this.language, this.coord1, this.coord2, this.version, this.moduleName, this.className, this.methodName, this.descriptor);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCoord1() {
        return this.coord1;
    }

    public String getCoord2() {
        return this.coord2;
    }

    public String getVersion() {
        return this.version;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescriptor() {
        return this.descriptor;
    }
}

