/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.BindingExpansionVisitor;
import com.sourceclear.sgl.lang.argument.PredicateArgument;
import com.sourceclear.sgl.lang.argument.StepArgument;
import com.sourceclear.sgl.lang.argument.WildcardArgument;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.step.Step;
import java.util.Comparator;
import java.util.Objects;

public class CostAnalysisVisitor
extends ASTVisitor<Void, Integer, Integer> {
    private final Result result = new Result();

    public static boolean useOLAP(Expr expr) {
        return CostAnalysisVisitor.useOLAP(CostAnalysisVisitor.analyze(expr));
    }

    public static boolean useOLAP(Result result) {
        boolean deepQuery;
        if (result.isSGDL || result.hasPathStep || result.hasMetaStep) {
            return false;
        }
        boolean bl = deepQuery = result.maxDepth > 3;
        return result.hasScan || deepQuery;
    }

    public static Result analyze(Expr expr) {
        CostAnalysisVisitor visitor2 = new CostAnalysisVisitor();
        expr = BindingExpansionVisitor.expand(expr);
        expr.accept(visitor2);
        Result result = visitor2.result;
        result.isSGDL = expr.isSGDL();
        return result;
    }

    @Override
    public Void visitBindingSequence(BindingSequence bindingSequence) {
        throw new IllegalStateException("bindings should have been stripped by this point");
    }

    @Override
    public Void visitSequence(Sequence sequence) {
        sequence.getActions().forEach(a -> a.accept(this));
        return null;
    }

    @Override
    public Void visitAddAction(AddAction action) {
        action.getStep().accept(this);
        return null;
    }

    @Override
    public Void visitRemoveAction(RemoveAction action) {
        action.getStep().accept(this);
        return null;
    }

    @Override
    public Void visitQuery(Query query) {
        query.getStep().accept(this);
        return null;
    }

    @Override
    public Integer visitStep(Step step) {
        switch (step.getName()) {
            case "path": {
                this.result.hasPathStep = true;
                break;
            }
            case "where": 
            case "not": 
            case "union": {
                this.result.hasMetaStep = true;
            }
        }
        if (step.getArguments().size() == 1 && step.getArguments().get(0) instanceof WildcardArgument) {
            this.result.hasScan = true;
        }
        int depthSoFar = 1 + step.getNext().map(n -> n.accept(this)).orElse(0);
        int argDepth = step.getArguments().stream().map(a -> a.accept(this)).max(Comparator.comparingInt(a -> a)).orElse(0);
        this.result.maxDepth = Math.max(Math.max(this.result.maxDepth, depthSoFar), argDepth);
        return this.result.maxDepth;
    }

    @Override
    public Integer visitPredicateArgument(PredicateArgument predicateArgument) {
        return 0;
    }

    @Override
    public Integer visitTraversalArgument(StepArgument stepArgument) {
        return stepArgument.getStep().accept(this);
    }

    @Override
    public Integer visitWildcardArgument(WildcardArgument wildcardArgument) {
        return 0;
    }

    @Override
    public Void visitPatterns(Patterns patterns) {
        patterns.getSteps().forEach(s -> s.accept(this));
        return null;
    }

    public static class Result {
        public int maxDepth = 0;
        public boolean hasPathStep = false;
        public boolean hasMetaStep = false;
        public boolean isSGDL = false;
        public boolean hasScan = false;

        Result() {
        }

        public Result(int maxDepth, boolean hasPathStep, boolean hasMetaStep, boolean isSGDL, boolean hasScan) {
            this.maxDepth = maxDepth;
            this.hasPathStep = hasPathStep;
            this.hasMetaStep = hasMetaStep;
            this.isSGDL = isSGDL;
            this.hasScan = hasScan;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.maxDepth == result.maxDepth && this.hasPathStep == result.hasPathStep && this.hasMetaStep == result.hasMetaStep && this.isSGDL == result.isSGDL && this.hasScan == result.hasScan;
        }

        public int hashCode() {
            return Objects.hash(this.maxDepth, this.hasPathStep, this.hasMetaStep, this.isSGDL, this.hasScan);
        }

        public String toString() {
            return "Result{maxDepth=" + this.maxDepth + ", hasPathStep=" + this.hasPathStep + ", hasMetaStep=" + this.hasMetaStep + ", isSGDL=" + this.isSGDL + ", hasScan=" + this.hasScan + '}';
        }
    }
}

