/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.argument;

import com.sourceclear.sgl.lang.argument.WildcardArgument;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.jetbrains.annotations.Nullable;

public class EvaluatedArgument<V> {
    @Nullable
    private final String keyword;
    private final V value;

    public EvaluatedArgument(@Nullable String keyword, V value) {
        this.keyword = keyword;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedArgument that = (EvaluatedArgument)o;
        return Objects.equals(this.keyword, that.keyword) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.keyword, this.value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EvaluatedArgument{");
        sb.append("keyword='").append(this.keyword).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public Optional<String> getKeyword() {
        return Optional.ofNullable(this.keyword);
    }

    public V getValue() {
        return this.value;
    }

    public boolean isPredicate() {
        return this.value instanceof P;
    }

    public boolean isTraversal() {
        return this.value instanceof GraphTraversal;
    }

    public boolean isWildcard() {
        return this.value instanceof WildcardArgument;
    }
}

