/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.util.config.ContainerConfigScanReport;
import com.sourceclear.util.config.DockerfileScanReport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class ContainerConfigScanReport_Builder {
    private final DockerfileScanReportBuilderList dockerfileScanReports = new DockerfileScanReportBuilderList();
    private String remarks;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    ContainerConfigScanReport_Builder() {
    }

    public static ContainerConfigScanReport.Builder from(ContainerConfigScanReport value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new ContainerConfigScanReport.Builder().mergeFrom(value);
    }

    public ContainerConfigScanReport.Builder addDockerfileScanReports(DockerfileScanReport element) {
        this.dockerfileScanReports.addValue(element);
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder addDockerfileScanReports(DockerfileScanReport.Builder builder) {
        this.dockerfileScanReports.add(new DockerfileScanReport.Builder().mergeFrom(builder));
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder addDockerfileScanReports(DockerfileScanReport ... elements) {
        return this.addAllDockerfileScanReports(Arrays.asList(elements));
    }

    public ContainerConfigScanReport.Builder addDockerfileScanReports(DockerfileScanReport.Builder ... elementBuilders) {
        return this.addAllBuildersOfDockerfileScanReports(Arrays.asList(elementBuilders));
    }

    public ContainerConfigScanReport.Builder addAllDockerfileScanReports(Spliterator<? extends DockerfileScanReport> elements) {
        long newSize;
        if ((elements.characteristics() & 0x40) != 0 && (newSize = elements.estimateSize() + (long)this.dockerfileScanReports.size()) <= Integer.MAX_VALUE) {
            this.dockerfileScanReports.ensureCapacity((int)newSize);
        }
        elements.forEachRemaining(this::addDockerfileScanReports);
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder addAllBuildersOfDockerfileScanReports(Spliterator<? extends DockerfileScanReport.Builder> elementBuilders) {
        long newSize;
        if ((elementBuilders.characteristics() & 0x40) != 0 && (newSize = elementBuilders.estimateSize() + (long)this.dockerfileScanReports.size()) <= Integer.MAX_VALUE) {
            this.dockerfileScanReports.ensureCapacity((int)newSize);
        }
        elementBuilders.forEachRemaining(this::addDockerfileScanReports);
        return (ContainerConfigScanReport.Builder)this;
    }

    @JsonProperty(value="dockerfileScanReports")
    public ContainerConfigScanReport.Builder addAllDockerfileScanReports(Iterable<? extends DockerfileScanReport> elements) {
        this.dockerfileScanReports.addAllValues(elements);
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder addAllBuildersOfDockerfileScanReports(Iterable<? extends DockerfileScanReport.Builder> elementBuilders) {
        return this.addAllBuildersOfDockerfileScanReports(elementBuilders.spliterator());
    }

    public ContainerConfigScanReport.Builder addAllDockerfileScanReports(BaseStream<? extends DockerfileScanReport, ?> elements) {
        return this.addAllDockerfileScanReports(elements.spliterator());
    }

    public ContainerConfigScanReport.Builder addAllBuildersOfDockerfileScanReports(BaseStream<? extends DockerfileScanReport.Builder, ?> elementBuilders) {
        return this.addAllBuildersOfDockerfileScanReports(elementBuilders.spliterator());
    }

    public ContainerConfigScanReport.Builder mutateDockerfileScanReports(Consumer<? super List<DockerfileScanReport.Builder>> mutator) {
        mutator.accept(this.dockerfileScanReports);
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder clearDockerfileScanReports() {
        this.dockerfileScanReports.clear();
        return (ContainerConfigScanReport.Builder)this;
    }

    public List<DockerfileScanReport.Builder> buildersOfDockerfileScanReports() {
        return Collections.unmodifiableList(this.dockerfileScanReports);
    }

    @JsonProperty(value="remarks")
    public ContainerConfigScanReport.Builder remarks(String remarks) {
        this.remarks = Objects.requireNonNull(remarks);
        this._unsetProperties.remove((Object)Property.REMARKS);
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder mapRemarks(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.remarks((String)mapper.apply(this.remarks()));
    }

    public String remarks() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.REMARKS) ? 1 : 0) != 0, (Object)"remarks not set");
        return this.remarks;
    }

    public ContainerConfigScanReport.Builder mergeFrom(ContainerConfigScanReport value) {
        this.addAllDockerfileScanReports(value.dockerfileScanReports());
        ContainerConfigScanReport.Builder defaults = new ContainerConfigScanReport.Builder();
        if (defaults._unsetProperties.contains((Object)Property.REMARKS) || !Objects.equals(value.remarks(), ((ContainerConfigScanReport_Builder)defaults).remarks())) {
            this.remarks(value.remarks());
        }
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder mergeFrom(ContainerConfigScanReport.Builder template) {
        ContainerConfigScanReport.Builder base = template;
        this.addAllBuildersOfDockerfileScanReports(base.dockerfileScanReports);
        ContainerConfigScanReport.Builder defaults = new ContainerConfigScanReport.Builder();
        if (!(base._unsetProperties.contains((Object)Property.REMARKS) || !defaults._unsetProperties.contains((Object)Property.REMARKS) && Objects.equals(template.remarks(), ((ContainerConfigScanReport_Builder)defaults).remarks()))) {
            this.remarks(template.remarks());
        }
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport.Builder clear() {
        this.clearDockerfileScanReports();
        ContainerConfigScanReport.Builder defaults = new ContainerConfigScanReport.Builder();
        this.remarks = defaults.remarks;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (ContainerConfigScanReport.Builder)this;
    }

    public ContainerConfigScanReport build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public ContainerConfigScanReport buildPartial() {
        return new Partial(this);
    }

    private class DockerfileScanReportBuilderList
    extends AbstractList<DockerfileScanReport.Builder>
    implements RandomAccess {
        private List elements = ImmutableList.of();

        private DockerfileScanReportBuilderList() {
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public DockerfileScanReport.Builder get(int index) {
            Object element = this.elements.get(index);
            if (element instanceof DockerfileScanReport) {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                element = new DockerfileScanReport.Builder().mergeFrom((DockerfileScanReport)element);
                this.elements.set(index, element);
            }
            return (DockerfileScanReport.Builder)element;
        }

        @Override
        public DockerfileScanReport.Builder set(int index, DockerfileScanReport.Builder element) {
            DockerfileScanReport.Builder oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.set(index, element)) instanceof DockerfileScanReport) {
                oldElement = new DockerfileScanReport.Builder().mergeFrom((DockerfileScanReport)((Object)oldElement));
            }
            return oldElement;
        }

        @Override
        public void add(int index, DockerfileScanReport.Builder element) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(index, element);
        }

        @Override
        public DockerfileScanReport.Builder remove(int index) {
            Object oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.remove(index)) instanceof DockerfileScanReport) {
                oldElement = new DockerfileScanReport.Builder().mergeFrom((DockerfileScanReport)oldElement);
            }
            return (DockerfileScanReport.Builder)oldElement;
        }

        void ensureCapacity(int minCapacity) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            ((ArrayList)this.elements).ensureCapacity(minCapacity);
        }

        void addValue(DockerfileScanReport element) {
            Objects.requireNonNull(element);
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(element);
        }

        void addAllValues(Iterable<? extends DockerfileScanReport> values) {
            if (this.elements.isEmpty() && values instanceof ImmutableList) {
                this.elements = (ImmutableList)values;
            } else {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                if (values instanceof Collection) {
                    int newSize = this.elements.size() + ((Collection)values).size();
                    ((ArrayList)this.elements).ensureCapacity(newSize);
                }
                values.forEach(this::addValue);
            }
        }

        ImmutableList<DockerfileScanReport> build() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.build(element));
            }
            return values.build();
        }

        private DockerfileScanReport build(Object element) {
            if (element instanceof DockerfileScanReport) {
                return (DockerfileScanReport)element;
            }
            return ((DockerfileScanReport.Builder)element).build();
        }

        ImmutableList<DockerfileScanReport> buildPartial() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.buildPartial(element));
            }
            return values.build();
        }

        private DockerfileScanReport buildPartial(Object element) {
            if (element instanceof DockerfileScanReport) {
                return (DockerfileScanReport)element;
            }
            return ((DockerfileScanReport.Builder)element).buildPartial();
        }
    }

    private static final class Partial
    extends Rebuildable {
        private final ImmutableList<DockerfileScanReport> dockerfileScanReports;
        private final String remarks;
        private final EnumSet<Property> _unsetProperties;

        Partial(ContainerConfigScanReport_Builder builder) {
            this.dockerfileScanReports = builder.dockerfileScanReports.buildPartial();
            this.remarks = builder.remarks;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="dockerfileScanReports")
        public List<DockerfileScanReport> dockerfileScanReports() {
            return this.dockerfileScanReports;
        }

        @Override
        @JsonProperty(value="remarks")
        public String remarks() {
            if (this._unsetProperties.contains((Object)Property.REMARKS)) {
                throw new UnsupportedOperationException("remarks not set");
            }
            return this.remarks;
        }

        @Override
        public ContainerConfigScanReport.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((ContainerConfigScanReport_Builder)builder).addAllDockerfileScanReports((Iterable<? extends DockerfileScanReport>)this.dockerfileScanReports);
            ((ContainerConfigScanReport_Builder)builder).remarks = this.remarks;
            ((ContainerConfigScanReport_Builder)builder)._unsetProperties.clear();
            ((ContainerConfigScanReport_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.dockerfileScanReports, other.dockerfileScanReports) && Objects.equals(this.remarks, other.remarks) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.dockerfileScanReports, this.remarks, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial ContainerConfigScanReport{dockerfileScanReports=").append(this.dockerfileScanReports);
            if (!this._unsetProperties.contains((Object)Property.REMARKS)) {
                result.append(", remarks=").append(this.remarks);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends ContainerConfigScanReport.Builder {
            private PartialBuilder() {
            }

            @Override
            public ContainerConfigScanReport build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final ImmutableList<DockerfileScanReport> dockerfileScanReports;
        private final String remarks;

        private Value(ContainerConfigScanReport_Builder builder) {
            this.dockerfileScanReports = builder.dockerfileScanReports.build();
            this.remarks = builder.remarks;
        }

        @Override
        @JsonProperty(value="dockerfileScanReports")
        public List<DockerfileScanReport> dockerfileScanReports() {
            return this.dockerfileScanReports;
        }

        @Override
        @JsonProperty(value="remarks")
        public String remarks() {
            return this.remarks;
        }

        @Override
        public ContainerConfigScanReport.Builder toBuilder() {
            ContainerConfigScanReport.Builder builder = new ContainerConfigScanReport.Builder();
            ((ContainerConfigScanReport_Builder)builder).addAllDockerfileScanReports((Iterable<? extends DockerfileScanReport>)this.dockerfileScanReports);
            ((ContainerConfigScanReport_Builder)builder).remarks = this.remarks;
            ((ContainerConfigScanReport_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.dockerfileScanReports, other.dockerfileScanReports) && Objects.equals(this.remarks, other.remarks);
        }

        public int hashCode() {
            return Objects.hash(this.dockerfileScanReports, this.remarks);
        }

        public String toString() {
            return "ContainerConfigScanReport{dockerfileScanReports=" + this.dockerfileScanReports + ", remarks=" + this.remarks + "}";
        }
    }

    private static abstract class Rebuildable
    implements ContainerConfigScanReport {
        private Rebuildable() {
        }

        public abstract ContainerConfigScanReport.Builder toBuilder();
    }

    private static enum Property {
        REMARKS("remarks");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

