/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.util.fingerprints.Version;
import com.sourceclear.util.fingerprints.VersionResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class VersionMatcher {
    private static final VersionResolver VERSION_RESOLVER = VersionResolver.getInstance();
    @VisibleForTesting
    static final Pattern DIGIT_DASH_DIGIT = Pattern.compile("\\d-\\d");
    @VisibleForTesting
    static final Pattern LETTER_DASH_NUMBER_DOT = Pattern.compile("[a-zA-Z]-\\d+\\.");
    private static final Pattern ALL_VERSIONS = Pattern.compile("all versions of .+ prior to ");
    private static final Pattern BTCD = Pattern.compile("BTCD");
    private static final Pattern LXD = Pattern.compile("lxd");
    private static final Pattern DOUBLY_QUOTED = Pattern.compile("\"(.*)\"");
    private static final Pattern RELEASE = Pattern.compile("RELEASE");
    private static final Pattern SEMVER = Pattern.compile("\\d+\\.\\d+\\.\\d+");
    private static final Pattern SINGLY_QUOTED = Pattern.compile("'(.*)'");
    private static final Pattern UPPYSEMVER = Pattern.compile("uppy@\\d+\\.\\d+\\.\\d+");
    private static final Pattern VSEMVER = Pattern.compile("v\\d+\\.\\d+(\\.\\d+)?");

    @Deprecated
    public static Context matcher(String versionString) {
        return new Context(versionString);
    }

    public static Context matcher(String low, String high) {
        return new Context(low, high);
    }

    public static List<Range> parse(String versionString) {
        String[] rangeStrings;
        Matcher singlyQuotedMatcher;
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (versionString == null || versionString.isEmpty()) {
            return ranges;
        }
        Optional<Range> loneRangeOptional = VersionMatcher.maybeGetSingularRange(versionString);
        if (loneRangeOptional.isPresent()) {
            ranges.add(loneRangeOptional.get());
            return ranges;
        }
        Matcher doublyQuotedMatcher = DOUBLY_QUOTED.matcher(versionString = versionString.trim());
        if (doublyQuotedMatcher.find()) {
            versionString = doublyQuotedMatcher.group(1);
        }
        if ((singlyQuotedMatcher = SINGLY_QUOTED.matcher(versionString)).find()) {
            versionString = singlyQuotedMatcher.group(1);
        }
        for (String rangeString : rangeStrings = versionString.split(",")) {
            Matcher semverMatcher;
            rangeString = rangeString.trim();
            int separatorIndex = 0;
            int lowEndFromIndex = 1;
            int highEndFromIndex = 2;
            Matcher allVersionsMatcher = ALL_VERSIONS.matcher(rangeString.toLowerCase());
            if (allVersionsMatcher.find() && allVersionsMatcher.start() == 0 && (semverMatcher = SEMVER.matcher(rangeString)).find()) {
                rangeString = "0.0.0-" + semverMatcher.group();
                separatorIndex = 4;
            }
            Matcher vSemverRangeMatcher = VSEMVER.matcher(rangeString);
            if (separatorIndex == 0 && vSemverRangeMatcher.find() && vSemverRangeMatcher.start() == 0 && vSemverRangeMatcher.find()) {
                separatorIndex = vSemverRangeMatcher.start() - 2;
            }
            Matcher uppySemverMatcher = UPPYSEMVER.matcher(rangeString);
            if (separatorIndex == 0 && uppySemverMatcher.find() && uppySemverMatcher.start() == 0 && uppySemverMatcher.find()) {
                separatorIndex = uppySemverMatcher.start() - 2;
            }
            Matcher btcdMatcher = BTCD.matcher(rangeString);
            if (separatorIndex == 0 && btcdMatcher.find() && btcdMatcher.start() == 0 && btcdMatcher.find()) {
                separatorIndex = btcdMatcher.start() - 2;
            }
            Matcher lxdMatcher = LXD.matcher(rangeString);
            if (separatorIndex == 0 && lxdMatcher.find() && lxdMatcher.start() == 0 && lxdMatcher.find()) {
                separatorIndex = lxdMatcher.start() - 2;
            }
            Matcher releaseMatcher = RELEASE.matcher(rangeString);
            if (separatorIndex == 0 && releaseMatcher.find() && releaseMatcher.start() == 0 && releaseMatcher.find()) {
                separatorIndex = releaseMatcher.start() - 2;
            }
            Matcher semverMatcher2 = SEMVER.matcher(rangeString);
            if (separatorIndex == 0 && semverMatcher2.find() && semverMatcher2.start() == 0) {
                int lowVersionLength = semverMatcher2.end();
                Matcher vSemverMatcher = VSEMVER.matcher(rangeString);
                if (vSemverMatcher.find()) {
                    separatorIndex = vSemverMatcher.start() - 2;
                } else if (semverMatcher2.find()) {
                    int candidateSeparatorIndex;
                    int highVersionLength = semverMatcher2.end() - semverMatcher2.start();
                    int versionLengthDifference = highVersionLength - lowVersionLength;
                    if (versionLengthDifference > -3 && versionLengthDifference < 3 && rangeString.charAt(candidateSeparatorIndex = semverMatcher2.start() - 2) != '-' && rangeString.charAt(candidateSeparatorIndex + 1) == '-') {
                        separatorIndex = candidateSeparatorIndex;
                    }
                } else if (rangeString.equals("0.20.0-rc.1-1")) {
                    ranges.add(new Range(rangeString, rangeString));
                    continue;
                }
            }
            if (separatorIndex == 0) {
                Matcher digitDashDigitMatcher = DIGIT_DASH_DIGIT.matcher(rangeString);
                if (digitDashDigitMatcher.find()) {
                    separatorIndex = digitDashDigitMatcher.start();
                    if (digitDashDigitMatcher.end() == 3) {
                        ++separatorIndex;
                        --lowEndFromIndex;
                        --highEndFromIndex;
                    }
                } else {
                    Matcher alphabetDashDigitDotMatcher = LETTER_DASH_NUMBER_DOT.matcher(rangeString);
                    if (alphabetDashDigitDotMatcher.find()) {
                        separatorIndex = alphabetDashDigitDotMatcher.start();
                    }
                }
            }
            Range r = new Range(separatorIndex == 0 ? rangeString : rangeString.substring(0, separatorIndex + lowEndFromIndex).trim(), separatorIndex == 0 ? rangeString : rangeString.substring(separatorIndex + highEndFromIndex).trim());
            ranges.add(r);
        }
        return ranges;
    }

    @VisibleForTesting
    static Optional<Range> maybeGetSingularRange(String versionString) {
        String second;
        if (versionString.length() % 2 == 0) {
            return Optional.empty();
        }
        int midCharIndex = versionString.length() / 2;
        if (versionString.charAt(midCharIndex) != '-') {
            return Optional.empty();
        }
        String first = versionString.substring(0, midCharIndex);
        if (!first.equals(second = versionString.substring(midCharIndex + 1))) {
            return Optional.empty();
        }
        return Optional.of(new Range(first, first));
    }

    private static VersionMatch versionMatch(Range range, String version) {
        Version lowVersion = VERSION_RESOLVER.resolve(range.low);
        Version highVersion = VERSION_RESOLVER.resolve(range.high);
        Version testVersion = VERSION_RESOLVER.resolve(version);
        boolean matches = lowVersion.compareTo(testVersion) <= 0 && highVersion.compareTo(testVersion) >= 0;
        return new VersionMatch(testVersion, matches);
    }

    private static boolean match(Range range, String version) {
        return VersionMatcher.versionMatch(range, version).match;
    }

    public boolean matches(@Nonnull String low, @Nonnull String high, @Nonnull String version) {
        Range range = new Range(low, high);
        try {
            return VersionMatcher.match(range, version);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    public boolean matches(String versionRange, String version) {
        if (versionRange == null || versionRange.isEmpty() || version == null || version.isEmpty()) {
            return true;
        }
        List<Range> ranges = VersionMatcher.parse(versionRange);
        for (Range range : ranges) {
            try {
                if (!VersionMatcher.match(range, version)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private static class VersionMatch {
        private final Version version;
        private final boolean match;

        private VersionMatch(Version version, boolean match) {
            this.version = version;
            this.match = match;
        }
    }

    public static class Range {
        private final String low;
        private final String high;

        public Range(String low, String high) {
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return "range [low=" + this.low + ", high=" + this.high + "]";
        }

        public String getLow() {
            return this.low;
        }

        public String getHigh() {
            return this.high;
        }
    }

    public static class Context {
        private final SortedSet<Version> versions = new TreeSet<Version>();
        private final List<Range> ranges;

        private Context(String versionString) {
            this.ranges = VersionMatcher.parse(versionString);
        }

        private Context(String low, String high) {
            this.ranges = Collections.singletonList(new Range(low, high));
        }

        public boolean matches(String version) {
            for (Range range : this.ranges) {
                VersionMatch versionMatch = VersionMatcher.versionMatch(range, version);
                if (!versionMatch.match) continue;
                this.versions.add(versionMatch.version);
                return true;
            }
            return false;
        }

        public SortedSet<Version> getVersions() {
            return Collections.unmodifiableSortedSet(this.versions);
        }
    }
}

