/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.util.fingerprints.Version;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
public final class VersionResolver {
    private static final VersionResolver instance = new VersionResolver();
    private static final Pattern SEPARATORS = Pattern.compile("[:.\\-_]");
    private static final Pattern ALPHABET_DIGIT_SPLIT = Pattern.compile("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
    private static final Pattern STARTS_WITH_CHARACTERS_THEN_DIGIT = Pattern.compile("^[A-Z]+([0-9]+)");
    private static final Pattern COMMIT_HASH = Pattern.compile("[A-F0-9]{7,40}");
    private static final ImmutableSet<String> BLACKLISTED_TOKENS = ImmutableSet.of((Object)"RELEASE", (Object)"FINAL");
    private final LoadingCache<CacheKey, Version> cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, Version>(){

        public Version load(@Nonnull CacheKey key) {
            String normalized = VersionResolver.normalize(key.versionString);
            return Version.fromNormalizedString(normalized, key.releaseDate);
        }
    });

    public static VersionResolver getInstance() {
        return instance;
    }

    private VersionResolver() {
    }

    public Version resolve(String versionString) {
        return this.resolveWithReleaseDate(versionString, null);
    }

    public Version resolveWithReleaseDate(String versionString, @Nullable Date releaseDate) {
        CacheKey key = new CacheKey(versionString, releaseDate);
        return (Version)this.cache.getUnchecked((Object)key);
    }

    private static String normalize(String version) {
        ArrayList<String> separatorTokenList = new ArrayList<String>();
        List<String> tokens = new ArrayList<String>();
        String upperCasedVersion = version.toUpperCase();
        if (upperCasedVersion.matches(COMMIT_HASH.pattern())) {
            return version;
        }
        Matcher matcher = STARTS_WITH_CHARACTERS_THEN_DIGIT.matcher(upperCasedVersion);
        if (matcher.find()) {
            upperCasedVersion = matcher.replaceFirst("$1");
        }
        for (String token : SEPARATORS.split(upperCasedVersion)) {
            if (token.isEmpty()) continue;
            separatorTokenList.add(token);
        }
        for (String separatorToken : separatorTokenList) {
            if (separatorToken.matches(COMMIT_HASH.pattern())) {
                tokens.add(separatorToken);
                continue;
            }
            for (String token : ALPHABET_DIGIT_SPLIT.split(separatorToken)) {
                if (token.isEmpty()) continue;
                tokens.add(token);
            }
        }
        List<String> noBlacklistTokens = VersionResolver.removeBlacklistFromTokens(tokens);
        tokens = VersionResolver.filterTrailing(noBlacklistTokens, noBlacklistTokens.size() - 1);
        return tokens.stream().map(String::toLowerCase).collect(Collectors.joining(":"));
    }

    private static List<String> filterTrailing(List<String> tokens, int index) {
        if (tokens.isEmpty() || index == 0) {
            return tokens;
        }
        try {
            int lastNumber = Integer.parseInt(tokens.get(index));
            if (lastNumber == 0) {
                tokens.remove(index);
                return VersionResolver.filterTrailing(tokens, index - 1);
            }
            if (VersionResolver.tokenContainString(tokens.subList(0, index))) {
                return VersionResolver.filterTrailing(tokens, index - 1);
            }
            return tokens;
        }
        catch (NumberFormatException ex) {
            return VersionResolver.filterTrailing(tokens, --index);
        }
    }

    private static List<String> removeBlacklistFromTokens(List<String> tokens) {
        ArrayList<String> filtered = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            if (BLACKLISTED_TOKENS.contains((Object)token.toUpperCase())) continue;
            filtered.add(token);
        }
        return filtered;
    }

    private static boolean tokenContainString(List<String> tokens) {
        for (String token : tokens) {
            if (!StringUtils.isAlpha((CharSequence)token)) continue;
            return true;
        }
        return false;
    }

    private static class CacheKey {
        private final String versionString;
        private final Date releaseDate;

        private CacheKey(String versionString, @Nullable Date releaseDate) {
            this.versionString = versionString;
            this.releaseDate = releaseDate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.versionString, cacheKey.versionString) && Objects.equals(this.releaseDate, cacheKey.releaseDate);
        }

        public int hashCode() {
            return Objects.hash(this.versionString, this.releaseDate);
        }
    }
}

