/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class BoundedSortedSet<E extends Comparable<E>> {
    private final NavigableSet<E> set;
    private final int size;

    public BoundedSortedSet(int size) {
        this.size = size;
        this.set = new TreeSet();
    }

    public void add(E e) {
        this.set.add(e);
        this.bound();
    }

    public List<E> toList() {
        return Lists.newArrayList(this.set.iterator());
    }

    public static <X extends Comparable<X>> BoundedSortedSet<X> empty() {
        return new BoundedSortedSet(0);
    }

    private void bound() {
        while (this.set.size() > this.size) {
            this.set.pollLast();
        }
    }
}

