/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io.renderers;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.LicenseData;
import com.sourceclear.api.data.PlanType;
import com.sourceclear.api.data.artifact.CVEStatus;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.artifact.LibraryMatchWithArtifactsApiModel;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidenceType;
import com.sourceclear.api.data.evidence.LibraryInstanceModel;
import com.sourceclear.api.data.evidence.LibraryModel;
import com.sourceclear.api.data.evidence.LicenseInfoModel;
import com.sourceclear.api.data.match.MatchResponse;
import com.sourceclear.api.data.match.ScanFinishUploadResponse;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.api.data.methods.MethodModel;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.util.config.Commons;
import com.sourceclear.util.config.ContainerConfigScanReport;
import com.sourceclear.util.config.DockerfileScanReport;
import com.sourceclear.util.config.ScanConfig;
import com.sourceclear.util.config.UpdateAdvice;
import com.sourceclear.util.config.UpdateAdvisorReport;
import com.sourceclear.util.io.renderers.RenderException;
import com.sourceclear.util.io.renderers.Renderer;
import com.sourceclear.util.io.renderers.ScanReport;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class SummaryRenderer
implements Renderer {
    private static final SimpleDateFormat SCAN_DATE_FORMAT = new SimpleDateFormat("MMM dd yyyy hh:mmaa zzz");
    private static final SimpleDateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("MMMM dd");
    private static final int EXTRA_PADDING_AFTER_FIRST_COL = 10;
    private static final String PREMIUM_VULN_TITLE = "Vulnerabilities - Premium Data";
    private static final String PUBLIC_VULN_TITLE = "Vulnerabilities - Public Data";
    private static final String PAID_FEATURE_TEXT = "PRO only";
    private final Map<Commons.Severity, Function<String, String>> colourerBySeverity = ImmutableMap.of((Object)((Object)Commons.Severity.Critical), (Object)new MagentaTextFunction(), (Object)((Object)Commons.Severity.High), (Object)new RedTextFunction(), (Object)((Object)Commons.Severity.Medium), (Object)new YellowTextFunction(), (Object)((Object)Commons.Severity.Low), (Object)new BoldTextFunction());
    private final PrintStream out;
    private final String version;
    private final String latestVersion;
    private final boolean withColor;
    private final boolean withPolicy;
    private final Set<Evidence> unmatchedEvidences = new HashSet<Evidence>();
    private final Set<Long> libraryInstanceIdentifiers = new HashSet<Long>();
    private final Set<Long> transitiveLibs = new HashSet<Long>();
    private final Set<Long> directLibs = new HashSet<Long>();
    private Set<Long> vulnerableLibraries;
    private final Map<Commons.Severity, List<LibraryInstanceArtifact>> srcclrPremiumDataBySeverity = new EnumMap<Commons.Severity, List<LibraryInstanceArtifact>>(Commons.Severity.class);
    private final Map<Commons.Severity, List<LibraryInstanceArtifact>> publicDataBySeverity = new EnumMap<Commons.Severity, List<LibraryInstanceArtifact>>(Commons.Severity.class);
    private final Set<String> distinctLicenses = new HashSet<String>();
    private int gplCount;
    private int libsWithoutLicense;
    private int libsWithMultipleLicenses;
    private int libsWithHighRiskLicense;
    private int libsWithMediumRiskLicense;
    private int libsWithLowRiskLicense;
    int libsWithUnassessableLicense;
    private Long totalLocInAllLibs;
    private int vulnMethodCount;
    private final Map<String, Pair<String, String>> compById = new HashMap<String, Pair<String, String>>();
    private List<UpdateAdvisorRowDetails> updateAdvisorRowDetailsList = new ArrayList<UpdateAdvisorRowDetails>();
    private boolean showBreakingColumn = false;
    private ScanReport report;
    private ScanConfig scanConfig;
    private PlanType planType;
    @Nullable
    private UpdateAdvisorReport updateAdvisorReport;
    @Nullable
    private ContainerConfigScanReport containerConfigScanReport;

    public SummaryRenderer(String version, @Nullable String latestVersion, PrintStream out) {
        this(version, latestVersion, out, null != System.console() || Boolean.getBoolean("force.ansi"), false);
    }

    public SummaryRenderer(String version, @Nullable String latestVersion, PrintStream out, boolean withPolicy) {
        this(version, latestVersion, out, null != System.console() || Boolean.getBoolean("force.ansi"), withPolicy);
    }

    public SummaryRenderer(String version, @Nullable String latestVersion, PrintStream out, boolean withColor, boolean withPolicy) {
        this.out = out;
        this.version = version;
        this.latestVersion = latestVersion;
        this.withColor = withColor;
        this.withPolicy = withPolicy;
        if (withColor) {
            AnsiConsole.systemInstall();
        }
    }

    @Override
    public void accept(ScanReport report) {
        this.accept(report, null, null);
    }

    public void accept(ScanReport report, @Nullable UpdateAdvisorReport updateAdvisorReport) {
        this.accept(report, updateAdvisorReport, null);
    }

    public void accept(ScanReport report, @Nullable UpdateAdvisorReport updateAdvisorReport, ContainerConfigScanReport containerConfigScanReport) {
        this.report = report;
        this.updateAdvisorReport = updateAdvisorReport;
        this.containerConfigScanReport = containerConfigScanReport;
        if (report != null) {
            this.scanConfig = this.report.getScanConfig();
            this.planType = this.scanConfig.getLicenseData().getPlanType();
            this.vulnMethodCount = this.report.getVulnerableMethods() == null ? 0 : this.report.getVulnerableMethods();
        }
        try {
            if (report != null) {
                this.extractVulnsDetails();
            }
            if (updateAdvisorReport != null) {
                this.extractUpdateAdvisorDetails();
            }
        }
        catch (Exception e) {
            String msg = "Project scanning completed successfully but an exception occurred while extracting details for the report. The exception was:\n" + e.getMessage();
            throw new RenderException(msg, e);
        }
        try {
            int longestLeftColumnTextLength = 0;
            if (report != null) {
                longestLeftColumnTextLength = this.getLongestLeftColumnTextLength();
                this.renderSummaryReportSection(longestLeftColumnTextLength);
                if (this.planType != PlanType.OPEN) {
                    this.renderOpenSourceLibsSection(longestLeftColumnTextLength);
                    if (report.shouldListUnmatched()) {
                        this.renderUnmatchedLibrariesSection(longestLeftColumnTextLength);
                    }
                    this.renderVulnMethodsSection(longestLeftColumnTextLength);
                    this.renderSecuritySection(longestLeftColumnTextLength);
                    this.renderVulnerabilitiesSection(longestLeftColumnTextLength);
                    this.renderLicensingSection(longestLeftColumnTextLength);
                    if (this.withPolicy && report.getScanFinishUploadResponse() != null) {
                        this.renderIssuesSection(report.getScanFinishUploadResponse());
                    }
                    if (updateAdvisorReport != null) {
                        this.renderUpdateAdvisorSection(longestLeftColumnTextLength);
                    }
                }
            }
            if (containerConfigScanReport != null) {
                this.renderContainerConfigScanSection();
            }
            if (report != null) {
                this.renderCallToActionSection(longestLeftColumnTextLength);
            }
        }
        catch (Exception e) {
            String msg = "Project scanning completed successfully but an exception occurred while rendering the report. The exception was:\n" + e.getMessage();
            throw new RenderException(msg, e);
        }
    }

    private void renderSummaryReportSection(int longestColumnText) {
        String packageManager;
        String project;
        String SECTION_HEADER = "Summary Report";
        String scanId = this.scanConfig.getScanID();
        String scanDatetime = SCAN_DATE_FORMAT.format(this.scanConfig.getScanStart());
        String accountType = this.planType == null ? "Unknown" : (this.planType == PlanType.OPEN ? "Hobby" : this.planType.name());
        String latestVersionText = StringUtils.isNotBlank((CharSequence)this.latestVersion) ? String.format(" (latest %s)", this.latestVersion) : "";
        String scanEngine = String.format("%s%s", this.version, latestVersionText);
        String analysisTime = this.report.getDuration() + " seconds";
        String username = System.getProperty("user.name");
        switch (this.report.getScanType()) {
            case REPO: {
                project = this.report.getScanPath();
                packageManager = Joiner.on((String)", ").join(this.report.getCollectorsList());
                break;
            }
            case CONTAINER: {
                project = String.format("%s:%s", this.report.getMatchResponse().getContainerName(), this.report.getMatchResponse().getContainerTag());
                packageManager = "Container";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.out.println(this.bold("Summary Report"));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.SCAN_ID_COLUMN.getLabel(), 10) + scanId);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.SCAN_DATETIME_COLUMN.getLabel(), 10) + scanDatetime);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.ACCOUNT_TYPE_COLUMN.getLabel(), 10) + accountType);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.SCAN_ENGINE_COLUMN.getLabel(), 10) + scanEngine);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.ANALYSIS_TIME_COLUMN.getLabel(), 10) + analysisTime);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.USER_COLUMN.getLabel(), 10) + username);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.PROJECT_COLUMN.getLabel(), 10) + project);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.PACKAGE_MANAGER_COLUMN.getLabel(), 10) + packageManager);
        this.out.println();
    }

    private void renderOpenSourceLibsSection(int longestColumnText) {
        String SECTION_HEADER = "Open-Source Libraries";
        int totalLibraries = this.libraryInstanceIdentifiers.size();
        int directLibraries = this.directLibs.size();
        int transitiveLibraries = this.transitiveLibs.size();
        Long projectLOC = this.report.getLineCount();
        DecimalFormat atMostOneDecimalFormat = new DecimalFormat("#.#");
        atMostOneDecimalFormat.setRoundingMode(RoundingMode.FLOOR);
        String directLibsToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", directLibraries));
        String transitiveLibsToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", transitiveLibraries));
        this.out.println(this.bold("Open-Source Libraries"));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.TOTAL_LIBRARIES.getLabel(), 10) + String.format("%d", totalLibraries));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.DIRECT_LIBRARIES.getLabel(), 10) + directLibsToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.TRANSITIVE_LIBRARIES.getLabel(), 10) + transitiveLibsToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.VULNERABLE_LIBRARIES.getLabel(), 10) + String.format("%d", this.vulnerableLibraries.size()));
        if (projectLOC != null) {
            double projectLibraryCodePercentage = this.totalLocInAllLibs + projectLOC == 0L ? 0.0 : this.totalLocInAllLibs.doubleValue() / (double)(this.totalLocInAllLibs + projectLOC) * 100.0;
            this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.PROJECT_LIBRARY_CODE.getLabel(), 10) + atMostOneDecimalFormat.format(projectLibraryCodePercentage) + "%");
        }
        if (this.report.shouldListUnmatched()) {
            this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.UNMATCHED_LIBRARIES.getLabel(), 10) + String.format("%d", this.unmatchedEvidences.size()));
        }
        this.out.println();
    }

    private void renderSecuritySection(int longestColumnText) {
        String SECTION_HEADER = "Security";
        int criticalRiskVulns = this.srcclrPremiumDataBySeverity.get((Object)Commons.Severity.Critical).size() + this.publicDataBySeverity.get((Object)Commons.Severity.Critical).size();
        int highRiskVulns = this.srcclrPremiumDataBySeverity.get((Object)Commons.Severity.High).size() + this.publicDataBySeverity.get((Object)Commons.Severity.High).size();
        int mediumRiskVulns = this.srcclrPremiumDataBySeverity.get((Object)Commons.Severity.Medium).size() + this.publicDataBySeverity.get((Object)Commons.Severity.Medium).size();
        int lowRiskVulns = this.srcclrPremiumDataBySeverity.get((Object)Commons.Severity.Low).size() + this.publicDataBySeverity.get((Object)Commons.Severity.Low).size();
        String vulnMethodCountToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.vulnMethodCount));
        this.out.println(this.bold("Security"));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.USING_VULN_METHODS.getLabel(), 10) + vulnMethodCountToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.CRITICAL_RISK_VULNS.getLabel(), 10) + String.format("%d", criticalRiskVulns));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.HIGH_RISK_VULNS.getLabel(), 10) + String.format("%d", highRiskVulns));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.MEDIUM_RISK_VULNS.getLabel(), 10) + String.format("%d", mediumRiskVulns));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LOW_RISK_VULNS.getLabel(), 10) + String.format("%d", lowRiskVulns));
        this.out.println();
    }

    private void renderVulnMethodsSection(int longestColumnText) {
        if (this.vulnMethodCount < 1) {
            return;
        }
        List<InstanceVulnMethod> vulnMethods = this.report.getVulnMethods();
        String SECTION_HEADER = "Vulnerable Methods";
        this.out.println(this.bold("Vulnerable Methods"));
        this.out.printf("%,d vulnerable %s can be reached via the code's call graph%n", this.vulnMethodCount, this.vulnMethodCount == 1 ? "method" : "methods");
        this.out.println();
        ArrayList<String> sourceNames = new ArrayList<String>(this.vulnMethodCount);
        ArrayList<String> methodNames = new ArrayList<String>(this.vulnMethodCount);
        ArrayList<String> libraryNames = new ArrayList<String>(this.vulnMethodCount);
        if (vulnMethods != null) {
            for (InstanceVulnMethod vulnMethod : vulnMethods) {
                String libraryInstanceRef = vulnMethod.getLibraryInstanceRef();
                for (MethodCallData mcd : vulnMethod.getMethods()) {
                    MethodModel method = mcd.getMethod();
                    for (CallChainModel ccm : mcd) {
                        CallSite callSite = this.report.getSpanningEdges().get(ccm);
                        MethodInfo caller = callSite.getCaller();
                        String moduleName = Strings.nullToEmpty((String)caller.getModuleName());
                        String callerMethodName = Strings.nullToEmpty((String)caller.getMethodName());
                        String simpleCallerClass = SummaryRenderer.simpleMethodClass(caller.getClassName());
                        StringBuilder sb = new StringBuilder();
                        if (!moduleName.isEmpty()) {
                            sb.append(moduleName);
                            if (!simpleCallerClass.isEmpty()) {
                                sb.append(" ");
                            }
                        }
                        if (!simpleCallerClass.isEmpty()) {
                            sb.append(simpleCallerClass);
                        }
                        if (!callerMethodName.isEmpty()) {
                            sb.append(".");
                            sb.append(callerMethodName);
                        }
                        if (callSite.getLineNumber() > 0) {
                            sb.append(" [line ").append(callSite.getLineNumber()).append("]");
                        }
                        sourceNames.add(sb.toString());
                        String methodName = SummaryRenderer.reportMethodName(method);
                        methodNames.add(methodName);
                        Pair<String, String> affectedComponent = this.compById.get(libraryInstanceRef);
                        String libraryName = affectedComponent != null ? String.format("%s : %s", affectedComponent.getLeft(), affectedComponent.getRight()) : "";
                        libraryNames.add(libraryName);
                    }
                }
            }
            String method_header = "Method Name";
            int longestSource = Math.max(this.maxLength(sourceNames), longestColumnText);
            int longestMethod = Math.max(this.maxLength(methodNames), "Method Name".length());
            this.out.print(this.getColumnWithSpacesNeeded(longestSource, "Call Source", 10));
            this.out.print(this.getColumnWithSpacesNeeded(longestMethod, "Method Name", 5));
            this.out.println("Library");
            for (int i = 0; i < sourceNames.size(); ++i) {
                this.out.print(this.getColumnWithSpacesNeeded(longestSource, (String)sourceNames.get(i), 10));
                this.out.print(this.getColumnWithSpacesNeeded(longestMethod, (String)methodNames.get(i), 5));
                this.out.println((String)libraryNames.get(i));
            }
        }
        this.out.println();
    }

    static String reportMethodName(MethodModel method) {
        String methodName = Strings.nullToEmpty((String)method.getMethodName()) + Strings.nullToEmpty((String)method.getDescriptor());
        String simpleMethodClass = SummaryRenderer.simpleMethodClass(method.getClassName());
        if (!simpleMethodClass.isEmpty()) {
            return simpleMethodClass + "." + methodName;
        }
        return methodName;
    }

    static String simpleMethodClass(String className) {
        return Strings.nullToEmpty((String)className).replaceFirst(".*?/([^/]+)$", "$1");
    }

    private void renderUnmatchedLibrariesSection(int longestColumnText) {
        String SECTION_HEADER = "Unmatched Libraries";
        this.out.println(this.bold("Unmatched Libraries"));
        if (this.unmatchedEvidences.isEmpty()) {
            this.out.println("No unmatched libraries.");
            this.out.println();
            return;
        }
        LinkedList<String> unmatchedFiles = new LinkedList<String>();
        for (Evidence e : this.unmatchedEvidences) {
            if (e.getCoordinates() != null || e.getEvidencePaths().isEmpty()) continue;
            unmatchedFiles.add(e.getEvidencePaths().get(0).getFilePath());
        }
        int unmatchedCount = this.unmatchedEvidences.size();
        ArrayList<String> libraryNames = new ArrayList<String>(unmatchedCount);
        ArrayList<String> versions = new ArrayList<String>(unmatchedCount);
        ArrayList<String> commitHashes = new ArrayList<String>(unmatchedCount);
        boolean hasCommitHash = false;
        for (Evidence evidence : this.unmatchedEvidences) {
            Coordinates coordinates = evidence.getCoordinates();
            if (coordinates == null) continue;
            String libraryName = coordinates.getCoordinate2() == null ? coordinates.getCoordinate1() : String.format("%s:%s", coordinates.getCoordinate1(), coordinates.getCoordinate2());
            String commitHash = "";
            if (evidence.getCommitHash() != null) {
                hasCommitHash = true;
                commitHash = evidence.getCommitHash();
            }
            libraryNames.add(libraryName);
            String version = coordinates.getVersion();
            versions.add(Strings.nullToEmpty((String)version));
            commitHashes.add(commitHash);
        }
        String libraryNameHeader = "Library";
        String versionHeader = "Version";
        String commitHashHeader = "Commit Hash";
        int longestName = Math.max(this.maxLength(libraryNames), longestColumnText);
        int longestVersion = Math.max(this.maxLength(versions), versionHeader.length());
        if (unmatchedCount > unmatchedFiles.size()) {
            this.out.print(this.getColumnWithSpacesNeeded(longestName, libraryNameHeader, 10));
            this.out.print(this.getColumnWithSpacesNeeded(longestVersion, versionHeader, 5));
            if (hasCommitHash) {
                this.out.println(commitHashHeader);
            } else {
                this.out.println();
            }
            for (int i = 0; i < libraryNames.size(); ++i) {
                this.out.print(this.getColumnWithSpacesNeeded(longestName, (String)libraryNames.get(i), 10));
                this.out.print(this.getColumnWithSpacesNeeded(longestVersion, (String)versions.get(i), 5));
                this.out.println((String)commitHashes.get(i));
            }
        }
        if (!unmatchedFiles.isEmpty()) {
            this.out.println("\nUnmatched Files");
            for (String filename : unmatchedFiles) {
                this.out.println(filename);
            }
        }
        this.out.println();
    }

    private void renderVulnerabilitiesSection(int longestColumnText) {
        String[] subSections = new String[]{PUBLIC_VULN_TITLE, PREMIUM_VULN_TITLE};
        ImmutableMap riskLabels = ImmutableMap.of((Object)((Object)Commons.Severity.Critical), (Object)"Critical Risk", (Object)((Object)Commons.Severity.High), (Object)"High Risk", (Object)((Object)Commons.Severity.Medium), (Object)"Medium Risk", (Object)((Object)Commons.Severity.Low), (Object)"Low Risk");
        int longestRiskLabelLength = "Critical Risk".length();
        int longestTitle = 0;
        for (Commons.Severity severity : Commons.Severity.values()) {
            for (LibraryInstanceArtifact libInstanceArtifact : this.srcclrPremiumDataBySeverity.get((Object)severity)) {
                longestTitle = Math.max(longestTitle, libInstanceArtifact.artifact.getTitle().length());
            }
            for (LibraryInstanceArtifact libInstanceArtifact : this.publicDataBySeverity.get((Object)severity)) {
                longestTitle = Math.max(longestTitle, libInstanceArtifact.artifact.getTitle().length());
            }
        }
        for (String string : subSections) {
            List<LibraryInstanceArtifact> artifactList;
            Map<Commons.Severity, List<LibraryInstanceArtifact>> groupChosen = string.equals(PREMIUM_VULN_TITLE) ? this.srcclrPremiumDataBySeverity : this.publicDataBySeverity;
            boolean isEmpty = true;
            for (Commons.Severity sev : groupChosen.keySet()) {
                if (groupChosen.get((Object)sev).isEmpty()) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) continue;
            this.out.println(this.bold(string));
            List<Commons.Severity> sevList = Arrays.asList(Commons.Severity.values());
            Collections.reverse(sevList);
            if (groupChosen == this.publicDataBySeverity) {
                for (Commons.Severity severityValue : sevList) {
                    artifactList = groupChosen.get((Object)severityValue);
                    for (LibraryInstanceArtifact libInstanceArtifact : artifactList) {
                        this.out.print(this.getColumnWithSpacesNeeded(longestColumnText, libInstanceArtifact.getFullyQualifiedCVEId(), 10));
                        this.out.print(this.getColumnWithSpacesNeeded(longestRiskLabelLength, (String)riskLabels.get((Object)severityValue), 5));
                        this.out.print(this.getColumnWithSpacesNeeded(longestTitle, libInstanceArtifact.artifact.getTitle(), 5));
                        this.out.print(libInstanceArtifact.library);
                        this.out.println();
                    }
                }
            } else {
                for (Commons.Severity severityValue : sevList) {
                    artifactList = groupChosen.get((Object)severityValue);
                    Function<String, String> textFunction = this.colourerBySeverity.get((Object)severityValue);
                    for (LibraryInstanceArtifact libInstanceArtifact : artifactList) {
                        String cveToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(libInstanceArtifact.getFullyQualifiedCVEId());
                        String artifactTitleToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(libInstanceArtifact.artifact.getTitle());
                        String libraryToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(libInstanceArtifact.library);
                        this.out.print(this.getColumnWithSpacesNeeded(longestColumnText, cveToDisplay, 10));
                        this.out.print((String)textFunction.apply((Object)this.getColumnWithSpacesNeeded(longestRiskLabelLength, (String)riskLabels.get((Object)severityValue), 5)));
                        this.out.print(this.getColumnWithSpacesNeeded(longestTitle, artifactTitleToDisplay, 5));
                        this.out.print(libraryToDisplay);
                        this.out.println();
                    }
                }
            }
            this.out.println();
        }
    }

    private void renderContainerConfigScanSection() {
        String SECTION_HEADER = "Container Images and Build File";
        this.out.println(this.bold("Container Images and Build File"));
        List<DockerfileScanReport> dockerfileReports = this.containerConfigScanReport.dockerfileScanReports();
        if (dockerfileReports.isEmpty()) {
            this.out.println("No issues detected.");
            this.out.println();
            return;
        }
        OptionalInt maxMessageLengthOpt = dockerfileReports.stream().flatMap(report -> report.issues().stream()).map(DockerfileScanReport.DockerfileScanIssue::description).mapToInt(String::length).max();
        OptionalInt maxRecommendationLengthOpt = dockerfileReports.stream().flatMap(report -> report.issues().stream()).map(issue -> issue.violation().recommendation()).mapToInt(String::length).max();
        int longestMessageLength = maxMessageLengthOpt.orElse(-1);
        int longestRecommendationLengthOpt = maxRecommendationLengthOpt.orElse(-1);
        HashMap sectionIssuesMap = new HashMap();
        dockerfileReports.stream().flatMap(report -> report.issues().stream()).forEach(issue -> {
            DockerfileScanReport.DockerfileScanIssue.DockerfileScanViolation violation = issue.violation();
            String type = violation.type();
            String section = String.join((CharSequence)"-", type, violation.section());
            if (sectionIssuesMap.get(section) == null) {
                sectionIssuesMap.put(section, new ArrayList<DockerfileScanReport.DockerfileScanIssue>(Arrays.asList(issue)));
            } else {
                ((List)sectionIssuesMap.get(section)).add(issue);
            }
        });
        this.out.print(this.getColumnWithSpacesNeeded(longestMessageLength, "Issue", 10));
        this.out.print(this.getColumnWithSpacesNeeded(20, "Category", 5));
        this.out.print(this.getColumnWithSpacesNeeded(5, "Section", 5));
        this.out.print(this.getColumnWithSpacesNeeded(longestRecommendationLengthOpt, "Recommendation", 5));
        this.out.print("Line Numbers");
        this.out.println();
        sectionIssuesMap.keySet().stream().forEach(section -> {
            List dockerfileScanIssues = (List)sectionIssuesMap.get(section);
            String lineNumbers = dockerfileScanIssues.stream().filter(issue -> !Objects.isNull(issue.startLineNumber())).map(issue -> issue.startLineNumber().toString()).collect(Collectors.joining(", "));
            DockerfileScanReport.DockerfileScanIssue issueToDisplay = (DockerfileScanReport.DockerfileScanIssue)dockerfileScanIssues.get(0);
            this.out.print(this.getColumnWithSpacesNeeded(longestMessageLength, issueToDisplay.description(), 10));
            this.out.print(this.getColumnWithSpacesNeeded(20, CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, issueToDisplay.violation().type()), 5));
            this.out.print(this.getColumnWithSpacesNeeded(5, issueToDisplay.violation().section(), 5));
            this.out.print(this.getColumnWithSpacesNeeded(longestRecommendationLengthOpt, issueToDisplay.violation().recommendation(), 5));
            this.out.print(lineNumbers.length() > 0 ? lineNumbers : "n/a");
            this.out.println();
        });
        this.out.println();
        this.out.println(this.containerConfigScanReport.remarks());
        this.out.println();
        this.out.println();
    }

    private void renderUpdateAdvisorSection(int longestLeftColumnTextLength) {
        String SECTION_HEADER = "Update Advisor";
        String libraryNameLabel = "Library Name & Version";
        String updateVersionLabel = "Safe Version";
        String verifiedLabel = "Breaking Update";
        this.out.println(this.bold("Update Advisor"));
        if (this.updateAdvisorRowDetailsList.isEmpty()) {
            this.out.println("No results from Update Advisor.");
            this.out.println();
            return;
        }
        int secondColumnPad = 5;
        int longestUpdateToVersionLength = 0;
        for (UpdateAdvisorRowDetails updateAdvisorRowDetails : this.updateAdvisorRowDetailsList) {
            int versionLength = updateAdvisorRowDetails.updateToVersion.length();
            longestUpdateToVersionLength = versionLength > longestUpdateToVersionLength ? versionLength : longestUpdateToVersionLength;
        }
        longestUpdateToVersionLength = Math.max("Safe Version".length(), longestUpdateToVersionLength);
        this.out.print(this.getColumnWithSpacesNeeded(longestLeftColumnTextLength, "Library Name & Version", 10));
        this.out.print(this.getColumnWithSpacesNeeded(longestUpdateToVersionLength, "Safe Version", 5));
        if (this.showBreakingColumn) {
            this.out.println("Breaking Update");
        } else {
            this.out.println();
        }
        for (UpdateAdvisorRowDetails updateAdvisorRowDetails : this.updateAdvisorRowDetailsList) {
            this.out.print(this.getColumnWithSpacesNeeded(longestLeftColumnTextLength, updateAdvisorRowDetails.libraryName, 10));
            this.out.print(this.getColumnWithSpacesNeeded(longestUpdateToVersionLength, updateAdvisorRowDetails.updateToVersion, 5));
            if (this.showBreakingColumn) {
                this.out.println(updateAdvisorRowDetails.buildBreakingState.getText());
                continue;
            }
            this.out.println();
        }
        this.out.println();
    }

    private <T> void printList(String prefix, Collection<T> things, Function<T, String> toString, Function<String, String> highlight, PrintStream out) {
        if (things.isEmpty()) {
            out.printf("%s%s\n", prefix, "None");
        } else {
            Iterator<T> it = things.iterator();
            T first = it.next();
            String item = (String)toString.apply(first);
            if (highlight != null) {
                item = (String)highlight.apply((Object)item);
            }
            out.printf("%s%s\n", prefix, item);
            String padding = SummaryRenderer.spaces(prefix.length());
            while (it.hasNext()) {
                item = (String)toString.apply(it.next());
                if (highlight != null) {
                    item = (String)highlight.apply((Object)item);
                }
                out.printf("%s%s\n", padding, item);
            }
        }
    }

    private static String spaces(int n) {
        char[] a = new char[n];
        Arrays.fill(a, ' ');
        return new String(a);
    }

    private void renderLicensingSection(int longestColumnText) {
        String SECTION_HEADER = "Licenses";
        String gplCountToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.gplCount));
        String libsWithUnrecognizableLicenseToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.libsWithoutLicense));
        String libsWithMultipleLicensesToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.libsWithMultipleLicenses));
        String libsWithUnassessableLicenseToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.libsWithUnassessableLicense));
        String libsWithHighRiskLicenseToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.libsWithHighRiskLicense));
        String libsWithMediumRiskLicenseToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.libsWithMediumRiskLicense));
        String libsWithLowRiskLicenseToDisplay = this.getDataOrPaidFeatureLabelBasedOnPlanType(String.format("%d", this.libsWithLowRiskLicense));
        this.out.println(this.bold("Licenses"));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.UNIQUE_LICENSES.getLabel(), 10) + String.format("%d", this.distinctLicenses.size()));
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LIBS_USING_GPL.getLabel(), 10) + gplCountToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LIBS_WITH_HIGH_RISK_LICENSE.getLabel(), 10) + libsWithHighRiskLicenseToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LIBS_WITH_MEDIUM_RISK_LICENSE.getLabel(), 10) + libsWithMediumRiskLicenseToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LIBS_WITH_LOW_RISK_LICENSE.getLabel(), 10) + libsWithLowRiskLicenseToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LIBS_WITH_MULTIPLE_LICENSES.getLabel(), 10) + libsWithMultipleLicensesToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LIBS_WITH_UNASSESSABLE_LICENSE.getLabel(), 10) + libsWithUnassessableLicenseToDisplay);
        this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.LIBS_WITH_UNRECOGNIZABLE_LICENSE.getLabel(), 10) + libsWithUnrecognizableLicenseToDisplay);
        this.out.println();
    }

    private void renderIssuesSection(ScanFinishUploadResponse scanFinishUploadResponse) {
        String SECTION_HEADER = "Issues";
        String issues = scanFinishUploadResponse.getIssues();
        if (StringUtils.isNotBlank((CharSequence)issues)) {
            this.out.println(this.bold("Issues"));
            this.out.println(issues);
            this.out.println();
        }
    }

    private void renderCallToActionSection(int longestColumnText) {
        String upgradeLink;
        ScanFinishUploadResponse scanFinishUploadResponse;
        String reportLink = this.withPolicy ? ((scanFinishUploadResponse = this.report.getScanFinishUploadResponse()) != null ? scanFinishUploadResponse.getLink("html") : null) : this.report.getMatchResponse().getLink("html");
        LicenseData licenseData = this.scanConfig.getLicenseData();
        if (reportLink != null && !reportLink.isEmpty()) {
            this.out.println(this.getColumnWithSpacesNeeded(longestColumnText, RowTitle.FULL_REPORT_DETAILS.getLabel(), 10) + reportLink);
            this.out.println();
        }
        if (Strings.isNullOrEmpty((String)(upgradeLink = licenseData.getLink("upgrade")))) {
            upgradeLink = this.report.getMatchResponse().getLink("upgrade");
        }
        String upgradeInfo = Strings.isNullOrEmpty((String)upgradeLink) ? "by calling 1-888-ZER-0DAY (937-0329) or +44 (0)20 3761 5501 (UK)" : "at " + upgradeLink;
        if (this.planType == PlanType.OPEN) {
            String indentation = "   * ";
            this.out.println(this.bold("You are using our free Hobby plan. Upgrade today to access the following premium features:\n"));
            this.out.println("   * Higher scan counts");
            this.out.println("   * Access to premium Veracode SCA vulnerability data");
            this.out.println("   * Reduce false positives with vulnerable methods");
            this.out.println("   * Access to previous scan results with project history");
            this.out.println("   * Integrations with developer tools like JIRA and GitHub Issues");
            this.out.println("   * Automate your CI workflow with instant insights right in the agent");
            this.out.println("   * And more");
            if (licenseData.getCanTrial()) {
                this.out.println("\nStart your free trial " + upgradeInfo);
            } else {
                this.out.println("\nUpgrade now " + upgradeInfo);
            }
            this.out.println();
        } else if (this.planIsOnTrial(licenseData.getTrialEndDate())) {
            String callToAction = String.format("Your trial expires on %s.", SHORT_DATE_FORMAT.format(licenseData.getTrialEndDate()));
            this.out.println(this.bold(callToAction));
            this.out.println("Upgrade now " + upgradeInfo);
            this.out.println();
        }
    }

    public void extractVulnsDetails() {
        MatchResponse matchResponse = this.report.getMatchResponse();
        HashMap<String, String> evidenceMatchedByCommitAndCommitHash = new HashMap<String, String>();
        for (Evidence matchedEvidence : this.report.getEvidence()) {
            if (!matchedEvidence.getEvidenceType().equals(EvidenceType.COMMIT)) continue;
            evidenceMatchedByCommitAndCommitHash.put(matchedEvidence.getCoordinates().getCoordinate1().toLowerCase(), matchedEvidence.getCommitHash());
        }
        this.unmatchedEvidences.clear();
        this.libraryInstanceIdentifiers.clear();
        this.directLibs.clear();
        this.transitiveLibs.clear();
        this.distinctLicenses.clear();
        this.srcclrPremiumDataBySeverity.clear();
        this.publicDataBySeverity.clear();
        for (Commons.Severity severityValue : Commons.Severity.values()) {
            this.srcclrPremiumDataBySeverity.put(severityValue, new ArrayList());
            this.publicDataBySeverity.put(severityValue, new ArrayList());
        }
        this.vulnerableLibraries = new HashSet<Long>();
        this.gplCount = 0;
        this.libsWithoutLicense = 0;
        this.libsWithMultipleLicenses = 0;
        this.libsWithHighRiskLicense = 0;
        this.libsWithMediumRiskLicense = 0;
        this.libsWithLowRiskLicense = 0;
        this.libsWithUnassessableLicense = 0;
        this.totalLocInAllLibs = 0L;
        for (LibraryMatchWithArtifactsApiModel libWithArt : matchResponse.getComponents()) {
            Collection<LicenseInfoModel> licenses;
            boolean isUnmatched;
            LibraryModel component = libWithArt.getComponent();
            boolean bl = isUnmatched = component == null;
            if (isUnmatched) {
                this.unmatchedEvidences.add(libWithArt.getEvidence());
                continue;
            }
            LibraryInstanceModel inst = SummaryRenderer.getOnlyInstance(component);
            if (inst == null) continue;
            this.compById.put(inst.getCoordVersionHash(), (Pair<String, String>)Pair.of((Object)component.getName(), (Object)inst.getLibraryVersion()));
            Set<LibraryArtifactApiModel> artifacts = libWithArt.getArtifacts();
            if (!artifacts.isEmpty()) {
                this.vulnerableLibraries.add(component.getId());
            }
            Long instId = inst.getId();
            this.libraryInstanceIdentifiers.add(instId);
            if (inst.getLineCount() != null) {
                this.totalLocInAllLibs = this.totalLocInAllLibs + inst.getLineCount();
            }
            if ((licenses = inst.getLicenseInfoModels()).isEmpty()) {
                ++this.libsWithoutLicense;
            }
            if (licenses.size() > 1) {
                ++this.libsWithMultipleLicenses;
            }
            for (LicenseInfoModel license : licenses) {
                this.distinctLicenses.add(license.getName());
                this.incrementCountOfLibrariesWithLicenseRisk(license);
                if (!license.getName().matches(".*\\bA?GPL.*")) continue;
                ++this.gplCount;
            }
            for (LibraryArtifactApiModel artifact : artifacts) {
                LibraryInstanceArtifact libraryInstanceArtifact;
                String versionToDisplay;
                Commons.Severity severity = Commons.determineSeverity(artifact);
                boolean vulnIsPublic = this.isVulnPublic(artifact.getCveStatus());
                Map<Commons.Severity, List<LibraryInstanceArtifact>> groupChosen = null;
                groupChosen = vulnIsPublic ? this.publicDataBySeverity : this.srcclrPremiumDataBySeverity;
                List<LibraryInstanceArtifact> artifactsForSeverity = groupChosen.get((Object)severity);
                if (inst.getLibraryVersion().equalsIgnoreCase("HEAD")) {
                    String key = component.getCoordinate1().toLowerCase();
                    if (evidenceMatchedByCommitAndCommitHash.containsKey(key)) {
                        String commitHash = (String)evidenceMatchedByCommitAndCommitHash.get(key);
                        versionToDisplay = "HEAD (" + (commitHash.length() > 7 ? commitHash.substring(0, 7) : commitHash) + ")";
                    } else {
                        versionToDisplay = inst.getLibraryVersion();
                    }
                } else {
                    versionToDisplay = inst.getLibraryVersion();
                }
                if (artifactsForSeverity.contains(libraryInstanceArtifact = new LibraryInstanceArtifact(artifact, component.getName(), versionToDisplay))) continue;
                artifactsForSeverity.add(libraryInstanceArtifact);
            }
            Evidence evidence = libWithArt.getEvidence();
            Commons.DependencyMode dependencyMode = Commons.determineDependencyMode(evidence);
            if (dependencyMode == Commons.DependencyMode.DIRECT) {
                this.directLibs.add(instId);
                continue;
            }
            if (dependencyMode == Commons.DependencyMode.TRANSITIVE) {
                this.transitiveLibs.add(instId);
                continue;
            }
            if (dependencyMode != Commons.DependencyMode.BOTH) continue;
            this.directLibs.add(instId);
            this.transitiveLibs.add(instId);
        }
    }

    void incrementCountOfLibrariesWithLicenseRisk(LicenseInfoModel license) {
        if (license.getRisk() == null) {
            ++this.libsWithUnassessableLicense;
        } else {
            switch (license.getRisk()) {
                case HIGH: {
                    ++this.libsWithHighRiskLicense;
                    break;
                }
                case MEDIUM: {
                    ++this.libsWithMediumRiskLicense;
                    break;
                }
                case LOW: {
                    ++this.libsWithLowRiskLicense;
                    break;
                }
                case UNKNOWN: {
                    ++this.libsWithUnassessableLicense;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public void extractUpdateAdvisorDetails() {
        this.updateAdvisorRowDetailsList.clear();
        if (this.updateAdvisorReport != null) {
            List<UpdateAdvice> updateAdvices = this.updateAdvisorReport.getUpdateAdvices();
            updateAdvices.stream().map(UpdateAdvisorRowDetails::new).forEach(updateAdvisorRowDetails -> this.updateAdvisorRowDetailsList.add((UpdateAdvisorRowDetails)updateAdvisorRowDetails));
            this.showBreakingColumn = updateAdvices.stream().map(UpdateAdvice::getBuildBreakingState).anyMatch(breakingState -> breakingState != UpdateAdvice.BuildBreakingState.NO_INFO);
        }
        this.updateAdvisorRowDetailsList.sort(Comparator.comparingInt(o -> ((UpdateAdvisorRowDetails)o).buildBreakingState.ordinal()));
    }

    private int getLongestLeftColumnTextLength() {
        int longestCveTextLength = 0;
        for (Commons.Severity severityValue : Commons.Severity.values()) {
            List<LibraryInstanceArtifact> artifactList = this.srcclrPremiumDataBySeverity.get((Object)severityValue);
            List<LibraryInstanceArtifact> artifactList2 = this.publicDataBySeverity.get((Object)severityValue);
            for (LibraryInstanceArtifact libInstanceArtifact : artifactList) {
                if (libInstanceArtifact.getFullyQualifiedCVEId().length() <= longestCveTextLength) continue;
                longestCveTextLength = libInstanceArtifact.getFullyQualifiedCVEId().length();
            }
            for (LibraryInstanceArtifact libInstanceArtifact : artifactList2) {
                if (libInstanceArtifact.getFullyQualifiedCVEId().length() <= longestCveTextLength) continue;
                longestCveTextLength = libInstanceArtifact.getFullyQualifiedCVEId().length();
            }
        }
        ArrayList<Integer> textLengths = new ArrayList<Integer>(RowTitle.values().length + 1);
        for (RowTitle title : RowTitle.values()) {
            textLengths.add(title.getLabel().length());
        }
        textLengths.add(longestCveTextLength);
        if (this.report.shouldListUnmatched()) {
            for (Evidence unmatchedEvidence : this.unmatchedEvidences) {
                Coordinates coordinates = unmatchedEvidence.getCoordinates();
                if (coordinates == null) continue;
                String libraryName = coordinates.getCoordinate2() == null ? coordinates.getCoordinate1() : String.format("%s:%s", coordinates.getCoordinate1(), coordinates.getCoordinate2());
                textLengths.add(libraryName.length());
            }
        }
        int longestAdvisorLibraryNameLength = 0;
        for (UpdateAdvisorRowDetails updateAdvisorRowDetails : this.updateAdvisorRowDetailsList) {
            int l = updateAdvisorRowDetails.libraryName.length();
            longestAdvisorLibraryNameLength = l > longestAdvisorLibraryNameLength ? l : longestAdvisorLibraryNameLength;
        }
        textLengths.add(longestAdvisorLibraryNameLength);
        return (Integer)Collections.max(textLengths);
    }

    @Nullable
    private static LibraryInstanceModel getOnlyInstance(LibraryModel component) {
        List<LibraryInstanceModel> instances = component.getInstances();
        if (instances.size() != 1) {
            return null;
        }
        return instances.get(0);
    }

    private String bold(String text) {
        if (this.withColor) {
            return Ansi.ansi().bold().a(text).boldOff().toString();
        }
        return text;
    }

    private String red(String text) {
        if (this.withColor) {
            return Ansi.ansi().fg(Ansi.Color.RED).a(text).reset().toString();
        }
        return text;
    }

    private String magenta(String text) {
        if (this.withColor) {
            return Ansi.ansi().fg(Ansi.Color.MAGENTA).a(text).reset().toString();
        }
        return text;
    }

    private String yellow(String text) {
        if (this.withColor) {
            return Ansi.ansi().fg(Ansi.Color.YELLOW).a(text).reset().toString();
        }
        return text;
    }

    private String green(String text) {
        if (this.withColor) {
            return Ansi.ansi().fg(Ansi.Color.GREEN).a(text).reset().toString();
        }
        return text;
    }

    private String getColumnWithSpacesNeeded(int longestTextLength, String thisText, int padExtra) {
        assert (longestTextLength >= thisText.length());
        assert (padExtra >= 0);
        int numSpaces = 0;
        numSpaces = longestTextLength == thisText.length() ? padExtra : longestTextLength - thisText.length() + padExtra;
        String ret = thisText;
        for (int i = 0; i < numSpaces; ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    private int maxLength(Collection<?> collection) {
        int maxLength = 0;
        for (Object o : collection) {
            if (o == null) continue;
            maxLength = Math.max(maxLength, o.toString().length());
        }
        return maxLength;
    }

    private boolean isVulnPublic(CVEStatus cveStatus) {
        return cveStatus == CVEStatus.FINAL;
    }

    private String getDataOrPaidFeatureLabelBasedOnPlanType(String dataToDisplayIfPaid) {
        return this.planType.equals((Object)PlanType.OPEN) ? PAID_FEATURE_TEXT : dataToDisplayIfPaid;
    }

    private boolean planIsOnTrial(Date trialEndDate) {
        return trialEndDate != null && trialEndDate.after(new Date());
    }

    private class BoldTextFunction
    implements Function<String, String> {
        private BoldTextFunction() {
        }

        @Nullable
        public String apply(@Nullable String input) {
            return SummaryRenderer.this.bold(input);
        }
    }

    private class GreenTextFunction
    implements Function<String, String> {
        private GreenTextFunction() {
        }

        public String apply(String input) {
            return SummaryRenderer.this.green(input);
        }
    }

    private class YellowTextFunction
    implements Function<String, String> {
        private YellowTextFunction() {
        }

        @Nullable
        public String apply(@Nullable String input) {
            return SummaryRenderer.this.yellow(input);
        }
    }

    private class MagentaTextFunction
    implements Function<String, String> {
        private MagentaTextFunction() {
        }

        @Nullable
        public String apply(@Nullable String input) {
            return SummaryRenderer.this.magenta(input);
        }
    }

    private class RedTextFunction
    implements Function<String, String> {
        private RedTextFunction() {
        }

        @Nullable
        public String apply(@Nullable String input) {
            return SummaryRenderer.this.red(input);
        }
    }

    private static class UpdateAdvisorRowDetails {
        private final String libraryName;
        private final String updateToVersion;
        private final UpdateAdvice.BuildBreakingState buildBreakingState;

        UpdateAdvisorRowDetails(UpdateAdvice updateAdvice) {
            this.libraryName = updateAdvice.getLibraryName() + " " + updateAdvice.getEvidence().getCoordinates().getVersion();
            this.updateToVersion = updateAdvice.getUpdateToVersion();
            this.buildBreakingState = updateAdvice.getBuildBreakingState();
        }
    }

    private static class LibraryInstanceArtifact
    implements Comparable<LibraryInstanceArtifact> {
        private static final String NO_CVE = "NO-CVE";
        private static final String CVE_FQNAME_FORMAT = "CVE-%s-%s";
        private final LibraryArtifactApiModel artifact;
        private final String library;

        LibraryInstanceArtifact(LibraryArtifactApiModel artifact, String libraryName, String libraryVersion) {
            this.artifact = artifact;
            this.library = libraryName + " " + libraryVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LibraryInstanceArtifact that = (LibraryInstanceArtifact)o;
            if (!this.artifact.equals(that.artifact)) {
                return false;
            }
            return this.library.equals(that.library);
        }

        public int hashCode() {
            int result = this.artifact.hashCode();
            result = 31 * result + this.library.hashCode();
            return result;
        }

        @Override
        public int compareTo(@Nonnull LibraryInstanceArtifact o) {
            return this.artifact.getId().compareTo(o.artifact.getId());
        }

        public String getFullyQualifiedCVEId() {
            if (this.artifact.getCveStatus() == CVEStatus.NA) {
                return NO_CVE;
            }
            if (this.artifact.getCveStatus() == CVEStatus.RESERVED) {
                return CVEStatus.RESERVED + " (" + String.format(CVE_FQNAME_FORMAT, this.artifact.getCveYear(), this.artifact.getCveDigits()) + ")";
            }
            return String.format(CVE_FQNAME_FORMAT, this.artifact.getCveYear(), this.artifact.getCveDigits());
        }
    }

    private static enum RowTitle {
        SCAN_ID_COLUMN("Scan ID"),
        SCAN_DATETIME_COLUMN("Scan Date & Time"),
        ACCOUNT_TYPE_COLUMN("Account type"),
        SCAN_ENGINE_COLUMN("Scan engine"),
        ANALYSIS_TIME_COLUMN("Analysis time"),
        USER_COLUMN("User"),
        PROJECT_COLUMN("Project"),
        PACKAGE_MANAGER_COLUMN("Package Manager(s)"),
        TOTAL_LIBRARIES("Total Libraries"),
        DIRECT_LIBRARIES("Direct Libraries"),
        TRANSITIVE_LIBRARIES("Transitive Libraries"),
        VULNERABLE_LIBRARIES("Vulnerable Libraries"),
        PROJECT_LIBRARY_CODE("Third Party Code"),
        UNMATCHED_LIBRARIES("Unmatched Libraries"),
        CRITICAL_RISK_VULNS("Critical Risk Vulnerabilities"),
        HIGH_RISK_VULNS("High Risk Vulnerabilities"),
        MEDIUM_RISK_VULNS("Medium Risk Vulnerabilities"),
        LOW_RISK_VULNS("Low Risk Vulnerabilities"),
        USING_VULN_METHODS("With Vulnerable Methods"),
        UNIQUE_LICENSES("Unique Library Licenses"),
        LIBS_USING_GPL("Libraries Using GPL"),
        LIBS_WITH_UNRECOGNIZABLE_LICENSE("Libraries With Unrecognizable License"),
        LIBS_WITH_MULTIPLE_LICENSES("Libraries With Multiple Licenses"),
        LIBS_WITH_UNASSESSABLE_LICENSE("Libraries With Unassessable License"),
        LIBS_WITH_HIGH_RISK_LICENSE("Libraries With High Risk License"),
        LIBS_WITH_MEDIUM_RISK_LICENSE("Libraries With Medium Risk License"),
        LIBS_WITH_LOW_RISK_LICENSE("Libraries With Low Risk License"),
        FULL_REPORT_DETAILS("Full Report Details"),
        WHY_THIS_MATTERS("Why This Matters");

        private final String label;

        private RowTitle(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

