/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.system;

import com.sourceclear.util.system.ComposerRequirementAssessor;
import com.sourceclear.util.system.NoRequirementsAssessor;
import com.sourceclear.util.system.SystemInfoResult;
import com.sourceclear.util.system.SystemInfoResults;
import com.sourceclear.util.system.SystemItemRequirementAssessor;
import com.sourceclear.util.system.SystemItemRequirementNotMetException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public enum SystemItem {
    OS("OS", null, null, NoRequirementsAssessor.getInstance()),
    JAVA("Java", null, null, NoRequirementsAssessor.getInstance()),
    GIT("Git", "git", Pattern.compile("git version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    MAVEN("Maven", "mvn", Pattern.compile("^Apache Maven (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    NPM("NPM", "npm", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    BUNDLER("Bundler", "bundler", Pattern.compile("^Bundler version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GEM("Gem", "gem", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    PYTHON("Python", "python", Pattern.compile("Python (?<version>\\S+).*?", 32), NoRequirementsAssessor.getInstance()),
    PIP("PIP", "pip", Pattern.compile("pip (?<version>\\S+).*?", 32), NoRequirementsAssessor.getInstance()),
    PYTHON3("Python3", "python3", Pattern.compile("Python (?<version>\\S+).*?", 32), NoRequirementsAssessor.getInstance()),
    PIP3("PIP3", "pip3", Pattern.compile("pip (?<version>\\S+).*?", 32), NoRequirementsAssessor.getInstance()),
    GRADLE("Gradle", "gradle", Pattern.compile(".+^Gradle (?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance()),
    BOWER("Bower", "bower", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    ANT("Ant", "ant", () -> Collections.singletonList("-version"), Pattern.compile("^Apache Ant\\(TM\\) version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    YARN("Yarn", "yarn", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    COCOAPODS("CocoaPods", "pod", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    SBT("sbt", "sbt", () -> {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Arrays.asList("\"-Dsbt.log.noformat=true\"", "sbtVersion");
        }
        return Arrays.asList("-Dsbt.log.noformat=true", "sbtVersion");
    }, Pattern.compile(".+\\[info\\] (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance(), d -> {
        try {
            Files.createDirectory(d.toPath().resolve("project"), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }),
    GO("Go", "go", () -> Arrays.asList("version"), Pattern.compile("^go version go(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GLIDE("Glide", "glide", () -> Arrays.asList(DEFAULT_VERSION_ARGUMENT), Pattern.compile("^glide version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    TRASH("Trash", "trash", () -> Arrays.asList(DEFAULT_VERSION_ARGUMENT), Pattern.compile("^trash version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GOVENDOR("Govendor", "govendor", () -> Arrays.asList("-version"), Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GODEP("Godep", "godep", () -> Arrays.asList("version"), Pattern.compile("^godep (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    DEP("Dep", "dep", () -> Arrays.asList("version"), Pattern.compile("^dep:\\s*version\\s*:\\s*(?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance()),
    PHP("PHP", "php", Pattern.compile("^PHP (?<version>\\S+).*?$", 40), ComposerRequirementAssessor.getInstance()),
    COMPOSER("Composer", "composer", Pattern.compile("^Composer version (?<version>\\S+).*?$", 32), ComposerRequirementAssessor.getInstance()),
    DOTNET("Dotnet", "dotnet", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    NUGET("Nuget", "nuget", () -> Arrays.asList("help"), Pattern.compile("^NuGet Version: (?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance()),
    MSBUILD("MSBuild", "msbuild", () -> Arrays.asList("/version"), Pattern.compile("^Microsoft \\(R\\) Build Engine version (?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance());

    private final String title;
    private final String executable;
    private final List<String> versionArgument;
    private final Pattern versionPattern;
    private final SystemItemRequirementAssessor requirementAssessor;
    private final TempDirectoryPreparer preparer;
    private static final String DEFAULT_VERSION_ARGUMENT = "--version";

    private SystemItem(String title, String executable, Pattern versionPattern, SystemItemRequirementAssessor requirementAssessor) {
        this(title, executable, () -> Collections.singletonList(DEFAULT_VERSION_ARGUMENT), versionPattern, requirementAssessor, d -> {});
    }

    private SystemItem(String title, String executable, Pattern versionPattern, SystemItemRequirementAssessor requirementAssessor, TempDirectoryPreparer preparer) {
        this(title, executable, () -> Collections.singletonList(DEFAULT_VERSION_ARGUMENT), versionPattern, requirementAssessor, preparer);
    }

    private SystemItem(String title, String executable, VersionArgumentGenerator versionArgumentGenerator, Pattern versionPattern, SystemItemRequirementAssessor requirementAssessor) {
        this(title, executable, versionArgumentGenerator, versionPattern, requirementAssessor, d -> {});
    }

    private SystemItem(String title, String executable, VersionArgumentGenerator versionArgumentGenerator, Pattern versionPattern, SystemItemRequirementAssessor requirementAssessor, TempDirectoryPreparer preparer) {
        this.title = title;
        this.executable = executable;
        this.versionArgument = versionArgumentGenerator.getVersionArgument();
        this.versionPattern = versionPattern;
        this.requirementAssessor = requirementAssessor;
        this.preparer = preparer;
    }

    public String toString() {
        return this.title;
    }

    public String getExecutable() {
        return this.executable;
    }

    public static List<SystemItem> getValuesWithExec() {
        ArrayList<SystemItem> valuesWithExec = new ArrayList<SystemItem>(SystemItem.values().length);
        for (SystemItem systemItem : SystemItem.values()) {
            if (systemItem.getExecutable() == null) continue;
            valuesWithExec.add(systemItem);
        }
        return valuesWithExec;
    }

    public Pattern getVersionPattern() {
        return this.versionPattern;
    }

    public List<String> getVersionArgument() {
        return this.versionArgument;
    }

    public File createTempDirectoryForGetVersion() throws IOException {
        File tempDirectory = Files.createTempDirectory(((Object)((Object)this)).getClass().getName(), new FileAttribute[0]).toFile();
        tempDirectory.deleteOnExit();
        this.preparer.exec(tempDirectory);
        return tempDirectory;
    }

    public void assess(SystemInfoResults results) throws SystemItemRequirementNotMetException {
        SystemInfoResult result = results.getItem(this);
        this.assess(result);
    }

    public void assess(SystemInfoResult result) throws SystemItemRequirementNotMetException {
        if (result == null || StringUtils.isBlank((CharSequence)result.getVersion())) {
            throw new SystemItemRequirementNotMetException(String.format("Couldn't find %s installation.", this.toString()));
        }
        this.requirementAssessor.assess(result);
    }

    public static interface VersionArgumentGenerator {
        public List<String> getVersionArgument();
    }

    public static interface TempDirectoryPreparer {
        public void exec(File var1);
    }
}

