/*
 * Decompiled with CFR 0.152.
 */
package parquet;

import java.io.Closeable;
import java.io.IOException;
import parquet.Log;

public final class Closeables {
    private static final Log LOG = Log.getLog(Closeables.class);

    private Closeables() {
    }

    public static void close(Closeable c) throws IOException {
        if (c == null) {
            return;
        }
        c.close();
    }

    public static void closeAndSwallowIOExceptions(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            LOG.warn("Encountered exception closing closeable", e);
        }
    }
}

