/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DIGESTMD5BindRequest
extends SASLBindRequest
implements CallbackHandler {
    public static final String DIGESTMD5_MECHANISM_NAME = "DIGEST-MD5";
    private static final long serialVersionUID = 867592367640540593L;
    private final ASN1OctetString password;
    private int messageID = -1;
    private final List<String> unhandledCallbackMessages;
    private final String authenticationID;
    private final String authorizationID;
    private final String realm;

    public DIGESTMD5BindRequest(String authenticationID, String password) {
        this(authenticationID, null, new ASN1OctetString(password), null, NO_CONTROLS);
        Validator.ensureNotNull(password);
    }

    public DIGESTMD5BindRequest(String authenticationID, byte[] password) {
        this(authenticationID, null, new ASN1OctetString(password), null, NO_CONTROLS);
        Validator.ensureNotNull(password);
    }

    public DIGESTMD5BindRequest(String authenticationID, ASN1OctetString password) {
        this(authenticationID, null, password, null, NO_CONTROLS);
    }

    public DIGESTMD5BindRequest(String authenticationID, String authorizationID, String password, String realm, Control ... controls) {
        this(authenticationID, authorizationID, new ASN1OctetString(password), realm, controls);
        Validator.ensureNotNull(password);
    }

    public DIGESTMD5BindRequest(String authenticationID, String authorizationID, byte[] password, String realm, Control ... controls) {
        this(authenticationID, authorizationID, new ASN1OctetString(password), realm, controls);
        Validator.ensureNotNull(password);
    }

    public DIGESTMD5BindRequest(String authenticationID, String authorizationID, ASN1OctetString password, String realm, Control ... controls) {
        super(controls);
        Validator.ensureNotNull(authenticationID, password);
        this.authenticationID = authenticationID;
        this.authorizationID = authorizationID;
        this.password = password;
        this.realm = realm;
        this.unhandledCallbackMessages = new ArrayList<String>(5);
    }

    public String getSASLMechanismName() {
        return DIGESTMD5_MECHANISM_NAME;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public String getPasswordString() {
        return this.password.stringValue();
    }

    public byte[] getPasswordBytes() {
        return this.password.getValue();
    }

    public String getRealm() {
        return this.realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        SaslClient saslClient;
        this.unhandledCallbackMessages.clear();
        String[] mechanisms = new String[]{DIGESTMD5_MECHANISM_NAME};
        HashMap<String, String> saslProperties = new HashMap<String, String>();
        saslProperties.put("javax.security.sasl.qop", "auth");
        saslProperties.put("javax.security.sasl.server.authentication", "false");
        try {
            saslClient = Sasl.createSaslClient(mechanisms, this.authorizationID, "ldap", connection.getConnectedAddress(), saslProperties, this);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_DIGESTMD5_CANNOT_CREATE_SASL_CLIENT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        SASLHelper helper = new SASLHelper(this, connection, DIGESTMD5_MECHANISM_NAME, saslClient, this.getControls(), this.getResponseTimeoutMillis(connection), this.unhandledCallbackMessages);
        try {
            BindResult bindResult = helper.processSASLBind();
            Object var9_9 = null;
            this.messageID = helper.getMessageID();
            return bindResult;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.messageID = helper.getMessageID();
            throw throwable;
        }
    }

    public DIGESTMD5BindRequest getRebindRequest(String host, int port) {
        return new DIGESTMD5BindRequest(this.authenticationID, this.authorizationID, this.password, this.realm, this.getControls());
    }

    @InternalUseOnly
    public void handle(Callback[] callbacks) {
        block0: for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.authenticationID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.stringValue().toCharArray());
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                if (this.realm == null) {
                    this.unhandledCallbackMessages.add(LDAPMessages.ERR_DIGESTMD5_REALM_REQUIRED_BUT_NONE_PROVIDED.get(String.valueOf(rc.getPrompt())));
                    continue;
                }
                rc.setText(this.realm);
                continue;
            }
            if (callback instanceof RealmChoiceCallback) {
                Object choices;
                RealmChoiceCallback rcc = (RealmChoiceCallback)callback;
                if (this.realm == null) {
                    choices = StaticUtils.concatenateStrings("{", " '", ",", "'", " }", rcc.getChoices());
                    this.unhandledCallbackMessages.add(LDAPMessages.ERR_DIGESTMD5_REALM_REQUIRED_BUT_NONE_PROVIDED.get(rcc.getPrompt(), choices));
                    continue;
                }
                choices = rcc.getChoices();
                for (int i = 0; i < ((String[])choices).length; ++i) {
                    if (!choices[i].equals(this.realm)) continue;
                    rcc.setSelectedIndex(i);
                    continue block0;
                }
                continue;
            }
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "Unexpected DIGEST-MD5 SASL callback of type " + callback.getClass().getName());
            }
            this.unhandledCallbackMessages.add(LDAPMessages.ERR_DIGESTMD5_UNEXPECTED_CALLBACK.get(callback.getClass().getName()));
        }
    }

    public int getLastMessageID() {
        return this.messageID;
    }

    public DIGESTMD5BindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public DIGESTMD5BindRequest duplicate(Control[] controls) {
        DIGESTMD5BindRequest bindRequest = new DIGESTMD5BindRequest(this.authenticationID, this.authorizationID, this.password, this.realm, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("DIGESTMD5BindRequest(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

