/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.examples.SearchRate;
import com.unboundid.ldap.sdk.examples.SearchRateAsyncListener;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class SearchRateThread
extends Thread
implements SearchResultListener {
    private static final long serialVersionUID = -6714705986829223364L;
    private final AtomicBoolean stopRequested;
    private final AtomicLong entryCounter;
    private final AtomicLong errorCounter;
    private final AtomicLong remainingIterationsBeforeReconnect;
    private final AtomicLong searchCounter;
    private final AtomicLong searchDurations;
    private final AtomicReference<Thread> searchThread;
    private final boolean async;
    private LDAPConnection connection;
    private final AtomicReference<ResultCode> resultCode;
    private final CyclicBarrier startBarrier;
    private final long iterationsBeforeReconnect;
    private final ResultCodeCounter rcCounter;
    private final SearchRate searchRate;
    private final SearchRequest searchRequest;
    private final SearchScope scope;
    private final Semaphore asyncSemaphore;
    private final String[] attributes;
    private final ValuePattern authzID;
    private final ValuePattern baseDN;
    private final ValuePattern filter;
    private final FixedRateBarrier fixedRateBarrier;

    SearchRateThread(SearchRate searchRate, int threadNumber, LDAPConnection connection, boolean async, ValuePattern baseDN, SearchScope scope, ValuePattern filter, String[] attributes, ValuePattern authzID, long iterationsBeforeReconnect, CyclicBarrier startBarrier, AtomicLong searchCounter, AtomicLong entryCounter, AtomicLong searchDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, FixedRateBarrier rateBarrier, Semaphore asyncSemaphore) {
        this.setName("SearchRate Thread " + threadNumber);
        this.setDaemon(true);
        this.searchRate = searchRate;
        this.connection = connection;
        this.async = async;
        this.baseDN = baseDN;
        this.scope = scope;
        this.filter = filter;
        this.attributes = attributes;
        this.authzID = authzID;
        this.iterationsBeforeReconnect = iterationsBeforeReconnect;
        this.searchCounter = searchCounter;
        this.entryCounter = entryCounter;
        this.searchDurations = searchDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.startBarrier = startBarrier;
        this.asyncSemaphore = asyncSemaphore;
        this.fixedRateBarrier = rateBarrier;
        this.remainingIterationsBeforeReconnect = iterationsBeforeReconnect > 0L ? new AtomicLong(iterationsBeforeReconnect) : null;
        connection.setConnectionName("search-" + threadNumber);
        this.resultCode = new AtomicReference<Object>(null);
        this.searchThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.searchRequest = new SearchRequest((SearchResultListener)this, "", scope, Filter.createPresenceFilter("objectClass"), attributes);
    }

    public void run() {
        this.searchThread.set(SearchRateThread.currentThread());
        try {
            this.startBarrier.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        while (!this.stopRequested.get()) {
            long startTime;
            block25: {
                block24: {
                    ResultCode rc;
                    if (this.iterationsBeforeReconnect > 0L && this.remainingIterationsBeforeReconnect.decrementAndGet() <= 0L) {
                        this.remainingIterationsBeforeReconnect.set(this.iterationsBeforeReconnect);
                        if (this.connection != null) {
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                    if (this.connection == null) {
                        try {
                            this.connection = this.searchRate.getConnection();
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.errorCounter.incrementAndGet();
                            rc = le.getResultCode();
                            this.rcCounter.increment(rc);
                            this.resultCode.compareAndSet(null, rc);
                            if (this.fixedRateBarrier == null) continue;
                            this.fixedRateBarrier.await();
                            continue;
                        }
                    }
                    if (this.fixedRateBarrier != null) {
                        this.fixedRateBarrier.await();
                    }
                    if (this.async) {
                        if (this.asyncSemaphore != null) {
                            try {
                                this.asyncSemaphore.acquire();
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                this.errorCounter.incrementAndGet();
                                rc = ResultCode.LOCAL_ERROR;
                                this.rcCounter.increment(rc);
                                this.resultCode.compareAndSet(null, rc);
                                continue;
                            }
                        }
                        SearchRateAsyncListener listener = new SearchRateAsyncListener(this.searchCounter, this.entryCounter, this.searchDurations, this.errorCounter, this.rcCounter, this.asyncSemaphore, this.resultCode);
                        try {
                            this.connection.asyncSearch(new SearchRequest((SearchResultListener)listener, this.baseDN.nextValue(), this.scope, this.filter.nextValue(), this.attributes));
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.errorCounter.incrementAndGet();
                            ResultCode rc2 = le.getResultCode();
                            this.rcCounter.increment(rc2);
                            this.resultCode.compareAndSet(null, rc2);
                            if (this.asyncSemaphore == null) continue;
                            this.asyncSemaphore.release();
                        }
                        continue;
                    }
                    try {
                        this.searchRequest.setBaseDN(this.baseDN.nextValue());
                        this.searchRequest.setFilter(this.filter.nextValue());
                        if (this.authzID == null) break block24;
                        this.searchRequest.setControls(new ProxiedAuthorizationV2RequestControl(this.authzID.nextValue()));
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.errorCounter.incrementAndGet();
                        rc = le.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        continue;
                    }
                }
                startTime = System.nanoTime();
                try {
                    SearchResult r = this.connection.search(this.searchRequest);
                    this.entryCounter.addAndGet(r.getEntryCount());
                }
                catch (LDAPSearchException lse) {
                    Debug.debugException(lse);
                    this.errorCounter.incrementAndGet();
                    this.entryCounter.addAndGet(lse.getEntryCount());
                    ResultCode rc = lse.getResultCode();
                    this.rcCounter.increment(rc);
                    this.resultCode.compareAndSet(null, rc);
                    if (lse.getResultCode().isConnectionUsable()) break block25;
                    this.connection.close();
                    this.connection = null;
                }
            }
            this.searchCounter.incrementAndGet();
            this.searchDurations.addAndGet(System.nanoTime() - startTime);
        }
        if (this.asyncSemaphore != null) {
            while (this.asyncSemaphore.availablePermits() < this.searchRate.getMaxOutstandingRequests()) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.searchThread.set(null);
    }

    void signalShutdown() {
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
    }

    ResultCode waitForShutdown() {
        Thread t = this.searchThread.get();
        if (t != null) {
            try {
                t.join();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }

    public void searchEntryReturned(SearchResultEntry searchEntry) {
    }

    public void searchReferenceReturned(SearchResultReference searchReference) {
    }
}

