/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class UnsaltedMessageDigestInMemoryPasswordEncoder
extends InMemoryPasswordEncoder {
    private final int digestLengthBytes;
    private final MessageDigest messageDigest;

    public UnsaltedMessageDigestInMemoryPasswordEncoder(String prefix, PasswordEncoderOutputFormatter outputFormatter, MessageDigest messageDigest) {
        super(prefix, outputFormatter);
        Validator.ensureNotNull(messageDigest);
        this.messageDigest = messageDigest;
        this.digestLengthBytes = messageDigest.getDigestLength();
        Validator.ensureTrue(this.digestLengthBytes > 0, "The message digest use a fixed digest length, and that length must be greater than zero.");
    }

    public String getDigestAlgorithm() {
        return this.messageDigest.getAlgorithm();
    }

    public int getDigestLengthBytes() {
        return this.digestLengthBytes;
    }

    @Override
    protected byte[] encodePassword(byte[] clearPassword, ReadOnlyEntry userEntry, List<Modification> modifications) throws LDAPException {
        return this.messageDigest.digest(clearPassword);
    }

    @Override
    protected void ensurePreEncodedPasswordAppearsValid(byte[] unPrefixedUnFormattedEncodedPasswordBytes, ReadOnlyEntry userEntry, List<Modification> modifications) throws LDAPException {
        if (unPrefixedUnFormattedEncodedPasswordBytes.length != this.digestLengthBytes) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_UNSALTED_DIGEST_PW_ENCODER_PRE_ENCODED_LENGTH_MISMATCH.get(this.messageDigest.getAlgorithm(), unPrefixedUnFormattedEncodedPasswordBytes.length, this.digestLengthBytes));
        }
    }

    @Override
    protected boolean passwordMatches(byte[] clearPasswordBytes, byte[] unPrefixedUnFormattedEncodedPasswordBytes, ReadOnlyEntry userEntry) throws LDAPException {
        byte[] expectedEncodedPassword = this.messageDigest.digest(clearPasswordBytes);
        return Arrays.equals(unPrefixedUnFormattedEncodedPasswordBytes, expectedEncodedPassword);
    }

    @Override
    protected byte[] extractClearPassword(byte[] unPrefixedUnFormattedEncodedPasswordBytes, ReadOnlyEntry userEntry) throws LDAPException {
        throw new LDAPException(ResultCode.NOT_SUPPORTED, ListenerMessages.ERR_UNSALTED_DIGEST_PW_ENCODER_NOT_REVERSIBLE.get());
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SaltedMessageDigestInMemoryPasswordEncoder(prefix='");
        buffer.append(this.getPrefix());
        buffer.append("', outputFormatter=");
        PasswordEncoderOutputFormatter outputFormatter = this.getOutputFormatter();
        if (outputFormatter == null) {
            buffer.append("null");
        } else {
            outputFormatter.toString(buffer);
        }
        buffer.append(", digestAlgorithm='");
        buffer.append(this.messageDigest.getAlgorithm());
        buffer.append("', digestLengthBytes=");
        buffer.append(this.messageDigest.getDigestLength());
        buffer.append(')');
    }
}

