/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.transformations.LDIFChangeRecordTransformation;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExcludeAttributeTransformation
implements EntryTransformation,
LDIFChangeRecordTransformation {
    private final Schema schema;
    private final Set<String> attributes;

    public ExcludeAttributeTransformation(Schema schema, String ... attributes) {
        this(schema, StaticUtils.toList(attributes));
    }

    public ExcludeAttributeTransformation(Schema schema, Collection<String> attributes) {
        Schema s = schema;
        if (s == null) {
            try {
                s = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s;
        HashSet<String> attrNames = new HashSet<String>(StaticUtils.computeMapCapacity(3 * attributes.size()));
        for (String attrName : attributes) {
            AttributeTypeDefinition at;
            String baseName = Attribute.getBaseName(StaticUtils.toLowerCase(attrName));
            attrNames.add(baseName);
            if (s == null || (at = s.getAttributeType(baseName)) == null) continue;
            attrNames.add(StaticUtils.toLowerCase(at.getOID()));
            for (String name : at.getNames()) {
                attrNames.add(StaticUtils.toLowerCase(name));
            }
        }
        this.attributes = Collections.unmodifiableSet(attrNames);
    }

    @Override
    public Entry transformEntry(Entry e) {
        if (e == null) {
            return null;
        }
        boolean hasAttributeToRemove = false;
        Collection<Attribute> originalAttributes = e.getAttributes();
        for (Attribute a : originalAttributes) {
            if (!this.attributes.contains(StaticUtils.toLowerCase(a.getBaseName()))) continue;
            hasAttributeToRemove = true;
            break;
        }
        if (!hasAttributeToRemove) {
            return e;
        }
        ArrayList<Attribute> attributesToKeep = new ArrayList<Attribute>(originalAttributes.size());
        for (Attribute a : originalAttributes) {
            if (this.attributes.contains(StaticUtils.toLowerCase(a.getBaseName()))) continue;
            attributesToKeep.add(a);
        }
        return new Entry(e.getDN(), this.schema, attributesToKeep);
    }

    @Override
    public LDIFChangeRecord transformChangeRecord(LDIFChangeRecord r) {
        if (r == null) {
            return null;
        }
        if (r instanceof LDIFAddChangeRecord) {
            LDIFAddChangeRecord addRecord = (LDIFAddChangeRecord)r;
            Entry updatedEntry = this.transformEntry(addRecord.getEntryToAdd());
            if (updatedEntry.getAttributes().isEmpty()) {
                return null;
            }
            return new LDIFAddChangeRecord(updatedEntry, addRecord.getControls());
        }
        if (r instanceof LDIFModifyChangeRecord) {
            LDIFModifyChangeRecord modifyRecord = (LDIFModifyChangeRecord)r;
            Modification[] originalMods = modifyRecord.getModifications();
            ArrayList<Modification> modsToKeep = new ArrayList<Modification>(originalMods.length);
            for (Modification m : originalMods) {
                String attrName = StaticUtils.toLowerCase(Attribute.getBaseName(m.getAttributeName()));
                if (this.attributes.contains(attrName)) continue;
                modsToKeep.add(m);
            }
            if (modsToKeep.isEmpty()) {
                return null;
            }
            return new LDIFModifyChangeRecord(modifyRecord.getDN(), modsToKeep, modifyRecord.getControls());
        }
        return r;
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public LDIFChangeRecord translate(LDIFChangeRecord original, long firstLineNumber) {
        return this.transformChangeRecord(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }

    @Override
    public LDIFChangeRecord translateChangeRecordToWrite(LDIFChangeRecord original) {
        return this.transformChangeRecord(original);
    }
}

