/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.SubCommand;
import java.util.List;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ArgumentHelper {
    private ArgumentHelper() {
    }

    @InternalUseOnly
    public static void reset(ArgumentParser parser) {
        parser.reset();
    }

    @InternalUseOnly
    public static void incrementOccurrences(Argument argument) throws ArgumentException {
        argument.incrementOccurrences();
    }

    @InternalUseOnly
    public static void incrementOccurrencesSuppressException(Argument argument) {
        try {
            argument.incrementOccurrences();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    @InternalUseOnly
    public static void setSelectedSubCommand(ArgumentParser parser, SubCommand subcommand) {
        parser.setSelectedSubCommand(subcommand);
    }

    @InternalUseOnly
    public static void addValue(Argument argument, String valueString) throws ArgumentException {
        argument.addValue(valueString);
        ArgumentHelper.incrementOccurrencesSuppressException(argument);
    }

    @InternalUseOnly
    public static void addValueSuppressException(Argument argument, String valueString) {
        try {
            argument.addValue(valueString);
            ArgumentHelper.incrementOccurrencesSuppressException(argument);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    @InternalUseOnly
    public static boolean hasDefaultValue(Argument argument) {
        return argument.hasDefaultValue();
    }

    @InternalUseOnly
    public static void reset(Argument argument) {
        argument.reset();
    }

    @InternalUseOnly
    public static void addToCommandLine(Argument argument, List<String> argStrings) {
        argument.addToCommandLine(argStrings);
    }

    @InternalUseOnly
    public static void resetTrailingArguments(ArgumentParser parser) {
        parser.resetTrailingArguments();
    }

    @InternalUseOnly
    public static void addTrailingArgument(ArgumentParser parser, String value) throws ArgumentException {
        parser.addTrailingArgument(value);
    }
}

