/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OID
implements Serializable,
Comparable<OID> {
    private static final long serialVersionUID = -4542498394670806081L;
    private final List<Integer> components;
    private final String oidString;

    public OID(String oidString) {
        this.oidString = oidString == null ? "" : oidString;
        this.components = OID.parseComponents(oidString);
    }

    public OID(int ... components) {
        this(OID.toList(components));
    }

    public OID(List<Integer> components) {
        if (components == null || components.isEmpty()) {
            this.components = null;
            this.oidString = "";
        } else {
            this.components = Collections.unmodifiableList(new ArrayList<Integer>(components));
            StringBuilder buffer = new StringBuilder();
            for (Integer i : components) {
                if (buffer.length() > 0) {
                    buffer.append('.');
                }
                buffer.append(i);
            }
            this.oidString = buffer.toString();
        }
    }

    private static List<Integer> toList(int ... components) {
        if (components == null) {
            return null;
        }
        ArrayList<Integer> compList = new ArrayList<Integer>(components.length);
        for (int i : components) {
            compList.add(i);
        }
        return compList;
    }

    public static List<Integer> parseComponents(String oidString) {
        if (oidString == null || oidString.length() == 0 || oidString.startsWith(".") || oidString.endsWith(".") || oidString.indexOf("..") > 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(oidString, ".");
        ArrayList<Integer> compList = new ArrayList<Integer>(10);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                compList.add(Integer.parseInt(token));
            }
            catch (Exception e) {
                Debug.debugException(e);
                return null;
            }
        }
        return Collections.unmodifiableList(compList);
    }

    public static boolean isValidNumericOID(String s) {
        return new OID(s).isValidNumericOID();
    }

    public boolean isValidNumericOID() {
        return this.components != null;
    }

    public static boolean isStrictlyValidNumericOID(String s) {
        return new OID(s).isStrictlyValidNumericOID();
    }

    public boolean isStrictlyValidNumericOID() {
        if (this.components == null || this.components.size() < 2) {
            return false;
        }
        int firstComponent = this.components.get(0);
        int secondComponent = this.components.get(1);
        switch (firstComponent) {
            case 0: 
            case 1: {
                return secondComponent <= 39;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public List<Integer> getComponents() {
        return this.components;
    }

    public int hashCode() {
        if (this.components == null) {
            return this.oidString.hashCode();
        }
        int hashCode = 0;
        for (int i : this.components) {
            hashCode += i;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof OID) {
            OID oid = (OID)o;
            if (this.components == null) {
                return this.oidString.equals(oid.oidString);
            }
            return this.components.equals(oid.components);
        }
        return false;
    }

    @Override
    public int compareTo(OID oid) {
        if (this.components == null) {
            if (oid.components == null) {
                return this.oidString.compareTo(oid.oidString);
            }
            return 1;
        }
        if (oid.components == null) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.components.size(), oid.components.size()); ++i) {
            int thatValue;
            int thisValue = this.components.get(i);
            if (thisValue < (thatValue = oid.components.get(i).intValue())) {
                return -1;
            }
            if (thisValue <= thatValue) continue;
            return 1;
        }
        if (this.components.size() < oid.components.size()) {
            return -1;
        }
        if (this.components.size() > oid.components.size()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.oidString;
    }
}

