/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataArchiveFragmentIntermediateResponse;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataExtendedRequestProperties;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataIntermediateResponseListener;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataOutputIntermediateResponse;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataSecurityLevel;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CollectSupportDataExtendedRequest
extends ExtendedRequest
implements IntermediateResponseListener {
    public static final String COLLECT_SUPPORT_DATA_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.64";
    private static final byte TYPE_ARCHIVE_FILE_NAME = -128;
    static final byte TYPE_ENCRYPTION_PASSPHRASE = -127;
    private static final byte TYPE_INCLUDE_EXPENSIVE_DATA = -126;
    private static final byte TYPE_INCLUDE_REPLICATION_STATE_DUMP = -125;
    private static final byte TYPE_INCLUDE_BINARY_FILES = -124;
    private static final byte TYPE_INCLUDE_EXTENSION_SOURCE = -123;
    private static final byte TYPE_USE_SEQUENTIAL_MODE = -122;
    private static final byte TYPE_SECURITY_LEVEL = -121;
    private static final byte TYPE_JSTACK_COUNT = -120;
    private static final byte TYPE_REPORT_COUNT = -119;
    private static final byte TYPE_REPORT_INTERVAL_SECONDS = -118;
    private static final byte TYPE_LOG_CAPTURE_WINDOW = -85;
    private static final byte TYPE_COMMENT = -116;
    private static final byte TYPE_PROXY_TO_SERVER = -83;
    private static final byte TYPE_MAXIMUM_FRAGMENT_SIZE_BYTES = -114;
    private static final int SECURITY_LEVEL_VALUE_NONE = 0;
    private static final int SECURITY_LEVEL_VALUE_OBSCURE_SECRETS = 1;
    private static final int SECURITY_LEVEL_VALUE_MAXIMUM = 2;
    private static final long serialVersionUID = -8884596371195896085L;
    private final ASN1OctetString encryptionPassphrase;
    private final Boolean includeBinaryFiles;
    private final Boolean includeExpensiveData;
    private final Boolean includeExtensionSource;
    private final Boolean includeReplicationStateDump;
    private final Boolean useSequentialMode;
    private final CollectSupportDataIntermediateResponseListener intermediateResponseListener;
    private final CollectSupportDataLogCaptureWindow logCaptureWindow;
    private final CollectSupportDataSecurityLevel securityLevel;
    private final Integer jstackCount;
    private final Integer maximumFragmentSizeBytes;
    private final Integer proxyToServerPort;
    private final Integer reportCount;
    private final Integer reportIntervalSeconds;
    private final String archiveFileName;
    private final String comment;
    private final String proxyToServerAddress;

    public CollectSupportDataExtendedRequest(CollectSupportDataExtendedRequestProperties properties, CollectSupportDataIntermediateResponseListener intermediateResponseListener, Control ... controls) {
        super(COLLECT_SUPPORT_DATA_REQUEST_OID, CollectSupportDataExtendedRequest.encodeValue(properties), controls);
        Validator.ensureNotNullWithMessage(intermediateResponseListener, "CollectSupportDataExtendedRequest.intermediateResponseListener must not be null.");
        this.intermediateResponseListener = intermediateResponseListener;
        this.archiveFileName = properties.getArchiveFileName();
        this.encryptionPassphrase = properties.getEncryptionPassphrase();
        this.includeBinaryFiles = properties.getIncludeBinaryFiles();
        this.includeExpensiveData = properties.getIncludeExpensiveData();
        this.includeExtensionSource = properties.getIncludeExtensionSource();
        this.includeReplicationStateDump = properties.getIncludeReplicationStateDump();
        this.useSequentialMode = properties.getUseSequentialMode();
        this.logCaptureWindow = properties.getLogCaptureWindow();
        this.securityLevel = properties.getSecurityLevel();
        this.jstackCount = properties.getJStackCount();
        this.reportCount = properties.getReportCount();
        this.reportIntervalSeconds = properties.getReportIntervalSeconds();
        this.maximumFragmentSizeBytes = properties.getMaximumFragmentSizeBytes();
        this.proxyToServerPort = properties.getProxyToServerPort();
        this.comment = properties.getComment();
        this.proxyToServerAddress = properties.getProxyToServerAddress();
        this.setIntermediateResponseListener(this);
    }

    private static ASN1OctetString encodeValue(CollectSupportDataExtendedRequestProperties properties) {
        Integer maximumFragmentSizeBytes;
        String proxyToServerAddress;
        String comment;
        CollectSupportDataLogCaptureWindow logCaptureWindow;
        Integer reportIntervalSeconds;
        Integer reportCount;
        Integer jstackCount;
        CollectSupportDataSecurityLevel securityLevel;
        Boolean useSequentialMode;
        Boolean includeExtensionSource;
        Boolean includeBinaryFiles;
        Boolean includeReplicationStateDump;
        Boolean includeExpensiveData;
        ASN1OctetString encryptionPassphrase;
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(20);
        String archiveFileName = properties.getArchiveFileName();
        if (archiveFileName != null) {
            elements.add(new ASN1OctetString(-128, archiveFileName));
        }
        if ((encryptionPassphrase = properties.getEncryptionPassphrase()) != null) {
            elements.add(encryptionPassphrase);
        }
        if ((includeExpensiveData = properties.getIncludeExpensiveData()) != null) {
            elements.add(new ASN1Boolean(-126, includeExpensiveData));
        }
        if ((includeReplicationStateDump = properties.getIncludeReplicationStateDump()) != null) {
            elements.add(new ASN1Boolean(-125, includeReplicationStateDump));
        }
        if ((includeBinaryFiles = properties.getIncludeBinaryFiles()) != null) {
            elements.add(new ASN1Boolean(-124, includeBinaryFiles));
        }
        if ((includeExtensionSource = properties.getIncludeExtensionSource()) != null) {
            elements.add(new ASN1Boolean(-123, includeExtensionSource));
        }
        if ((useSequentialMode = properties.getUseSequentialMode()) != null) {
            elements.add(new ASN1Boolean(-122, useSequentialMode));
        }
        if ((securityLevel = properties.getSecurityLevel()) != null) {
            int securityLevelIntValue;
            switch (securityLevel) {
                case NONE: {
                    securityLevelIntValue = 0;
                    break;
                }
                case OBSCURE_SECRETS: {
                    securityLevelIntValue = 1;
                    break;
                }
                case MAXIMUM: {
                    securityLevelIntValue = 2;
                    break;
                }
                default: {
                    throw new LDAPRuntimeException(new LDAPException(ResultCode.LOCAL_ERROR, ExtOpMessages.ERR_CSD_REQUEST_UNSUPPORTED_SECURITY_LEVEL.get(securityLevel.getName())));
                }
            }
            elements.add(new ASN1Enumerated(-121, securityLevelIntValue));
        }
        if ((jstackCount = properties.getJStackCount()) != null) {
            elements.add(new ASN1Integer(-120, jstackCount));
        }
        if ((reportCount = properties.getReportCount()) != null) {
            elements.add(new ASN1Integer(-119, reportCount));
        }
        if ((reportIntervalSeconds = properties.getReportIntervalSeconds()) != null) {
            elements.add(new ASN1Integer(-118, reportIntervalSeconds));
        }
        if ((logCaptureWindow = properties.getLogCaptureWindow()) != null) {
            elements.add(new ASN1Element(-85, logCaptureWindow.encode().encode()));
        }
        if ((comment = properties.getComment()) != null) {
            elements.add(new ASN1OctetString(-116, comment));
        }
        if ((proxyToServerAddress = properties.getProxyToServerAddress()) != null) {
            elements.add(new ASN1Sequence(-83, new ASN1OctetString(proxyToServerAddress), new ASN1Integer(properties.getProxyToServerPort())));
        }
        if ((maximumFragmentSizeBytes = properties.getMaximumFragmentSizeBytes()) != null) {
            elements.add(new ASN1Integer(-114, maximumFragmentSizeBytes));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public CollectSupportDataExtendedRequest(ExtendedRequest request, CollectSupportDataIntermediateResponseListener intermediateResponseListener) throws LDAPException {
        super(request);
        Validator.ensureNotNullWithMessage(intermediateResponseListener, "CollectSupportDataExtendedRequest.intermediateResponseListener must not be null.");
        this.intermediateResponseListener = intermediateResponseListener;
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_REQUEST_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements;
            ASN1OctetString encPassphrase = null;
            Boolean includeExpensive = null;
            Boolean includeReplication = null;
            Boolean includeBinary = null;
            Boolean includeSource = null;
            Boolean sequentialMode = null;
            CollectSupportDataSecurityLevel secLevel = null;
            Integer jCount = null;
            Integer rCount = null;
            Integer rInterval = null;
            CollectSupportDataLogCaptureWindow lcw = null;
            String archiveName = null;
            String commentStr = null;
            String proxyToAddress = null;
            Integer proxyToPort = null;
            Integer maxFragmentSize = null;
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            block27: for (ASN1Element e : elements = valueSequence.elements()) {
                switch (e.getType()) {
                    case -128: {
                        archiveName = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block27;
                    }
                    case -127: {
                        encPassphrase = ASN1OctetString.decodeAsOctetString(e);
                        continue block27;
                    }
                    case -126: {
                        includeExpensive = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block27;
                    }
                    case -125: {
                        includeReplication = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block27;
                    }
                    case -124: {
                        includeBinary = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block27;
                    }
                    case -123: {
                        includeSource = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block27;
                    }
                    case -122: {
                        sequentialMode = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block27;
                    }
                    case -121: {
                        int secLevelIntValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        switch (secLevelIntValue) {
                            case 0: {
                                secLevel = CollectSupportDataSecurityLevel.NONE;
                                continue block27;
                            }
                            case 1: {
                                secLevel = CollectSupportDataSecurityLevel.OBSCURE_SECRETS;
                                continue block27;
                            }
                            case 2: {
                                secLevel = CollectSupportDataSecurityLevel.MAXIMUM;
                                continue block27;
                            }
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_REQUEST_DECODE_UNSUPPORTED_SECURITY_LEVEL.get(secLevelIntValue));
                    }
                    case -120: {
                        jCount = ASN1Integer.decodeAsInteger(e).intValue();
                        continue block27;
                    }
                    case -119: {
                        rCount = ASN1Integer.decodeAsInteger(e).intValue();
                        continue block27;
                    }
                    case -118: {
                        rInterval = ASN1Integer.decodeAsInteger(e).intValue();
                        continue block27;
                    }
                    case -85: {
                        ASN1Element lcwElement = ASN1Element.decode(e.getValue());
                        try {
                            lcw = CollectSupportDataLogCaptureWindow.decode(lcwElement);
                            continue block27;
                        }
                        catch (Exception ex) {
                            Debug.debugException(ex);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_REQUEST_DECODE_LCW_FAILED.get(StaticUtils.getExceptionMessage(ex)), ex);
                        }
                    }
                    case -116: {
                        commentStr = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block27;
                    }
                    case -83: {
                        ASN1Element[] proxyToElements = ASN1Sequence.decodeAsSequence(e).elements();
                        proxyToAddress = ASN1OctetString.decodeAsOctetString(proxyToElements[0]).stringValue();
                        proxyToPort = ASN1Integer.decodeAsInteger(proxyToElements[1]).intValue();
                        continue block27;
                    }
                    case -114: {
                        maxFragmentSize = ASN1Integer.decodeAsInteger(e).intValue();
                    }
                }
            }
            this.archiveFileName = archiveName;
            this.encryptionPassphrase = encPassphrase;
            this.includeExpensiveData = includeExpensive;
            this.includeReplicationStateDump = includeReplication;
            this.includeBinaryFiles = includeBinary;
            this.includeExtensionSource = includeSource;
            this.useSequentialMode = sequentialMode;
            this.securityLevel = secLevel;
            this.jstackCount = jCount;
            this.reportCount = rCount;
            this.reportIntervalSeconds = rInterval;
            this.logCaptureWindow = lcw;
            this.comment = commentStr;
            this.proxyToServerAddress = proxyToAddress;
            this.proxyToServerPort = proxyToPort;
            this.maximumFragmentSizeBytes = maxFragmentSize;
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_REQUEST_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public CollectSupportDataIntermediateResponseListener getCollectSupportDataIntermediateResponseListener() {
        return this.intermediateResponseListener;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public ASN1OctetString getEncryptionPassphrase() {
        return this.encryptionPassphrase;
    }

    public Boolean getIncludeExpensiveData() {
        return this.includeExpensiveData;
    }

    public Boolean getIncludeReplicationStateDump() {
        return this.includeReplicationStateDump;
    }

    public Boolean getIncludeBinaryFiles() {
        return this.includeBinaryFiles;
    }

    public Boolean getIncludeExtensionSource() {
        return this.includeExtensionSource;
    }

    public Boolean getUseSequentialMode() {
        return this.useSequentialMode;
    }

    public CollectSupportDataSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public Integer getJStackCount() {
        return this.jstackCount;
    }

    public Integer getReportCount() {
        return this.reportCount;
    }

    public Integer getReportIntervalSeconds() {
        return this.reportIntervalSeconds;
    }

    public CollectSupportDataLogCaptureWindow getLogCaptureWindow() {
        return this.logCaptureWindow;
    }

    public String getComment() {
        return this.comment;
    }

    public String getProxyToServerAddress() {
        return this.proxyToServerAddress;
    }

    public Integer getProxyToServerPort() {
        return this.proxyToServerPort;
    }

    public Integer getMaximumFragmentSizeBytes() {
        return this.maximumFragmentSizeBytes;
    }

    @Override
    public CollectSupportDataExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new CollectSupportDataExtendedResult(extendedResponse);
    }

    @Override
    public CollectSupportDataExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public CollectSupportDataExtendedRequest duplicate(Control[] controls) {
        return new CollectSupportDataExtendedRequest(new CollectSupportDataExtendedRequestProperties(this), this.intermediateResponseListener, controls);
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_COLLECT_SUPPORT_DATA_REQUEST_NAME.get();
    }

    @Override
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        switch (intermediateResponse.getOID()) {
            case "1.3.6.1.4.1.30221.2.6.65": {
                CollectSupportDataOutputIntermediateResponse outputIntermediateResponse;
                try {
                    outputIntermediateResponse = new CollectSupportDataOutputIntermediateResponse(intermediateResponse);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.intermediateResponseListener.handleOtherIntermediateResponse(intermediateResponse);
                    return;
                }
                this.intermediateResponseListener.handleOutputIntermediateResponse(outputIntermediateResponse);
                break;
            }
            case "1.3.6.1.4.1.30221.2.6.66": {
                CollectSupportDataArchiveFragmentIntermediateResponse fragmentIntermediateResponse;
                try {
                    fragmentIntermediateResponse = new CollectSupportDataArchiveFragmentIntermediateResponse(intermediateResponse);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.intermediateResponseListener.handleOtherIntermediateResponse(intermediateResponse);
                    return;
                }
                this.intermediateResponseListener.handleArchiveFragmentIntermediateResponse(fragmentIntermediateResponse);
                break;
            }
            default: {
                this.intermediateResponseListener.handleOtherIntermediateResponse(intermediateResponse);
            }
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("CollectSupportDataExtendedRequest(oid='");
        buffer.append(this.getOID());
        buffer.append('\'');
        if (this.archiveFileName != null) {
            buffer.append(", archiveFileName='");
            buffer.append(this.archiveFileName);
            buffer.append('\'');
        }
        if (this.encryptionPassphrase != null) {
            buffer.append(", encryptionPassphrase='*****REDACTED*****'");
        }
        if (this.includeExpensiveData != null) {
            buffer.append(", includeExpensiveData=");
            buffer.append(this.includeExpensiveData);
        }
        if (this.includeReplicationStateDump != null) {
            buffer.append(", includeReplicationStateDump=");
            buffer.append(this.includeReplicationStateDump);
        }
        if (this.includeBinaryFiles != null) {
            buffer.append(", includeBinaryFiles=");
            buffer.append(this.includeBinaryFiles);
        }
        if (this.includeExtensionSource != null) {
            buffer.append(", includeExtensionSource=");
            buffer.append(this.includeExtensionSource);
        }
        if (this.useSequentialMode != null) {
            buffer.append(", useSequentialMode=");
            buffer.append(this.useSequentialMode);
        }
        if (this.securityLevel != null) {
            buffer.append(", securityLevel='");
            buffer.append(this.securityLevel.getName());
            buffer.append('\'');
        }
        if (this.jstackCount != null) {
            buffer.append(", jstackCount=");
            buffer.append(this.jstackCount);
        }
        if (this.reportCount != null) {
            buffer.append(", reportCount=");
            buffer.append(this.reportCount);
        }
        if (this.reportIntervalSeconds != null) {
            buffer.append(", reportIntervalSeconds=");
            buffer.append(this.reportIntervalSeconds);
        }
        if (this.logCaptureWindow != null) {
            buffer.append(", logCaptureWindow=");
            this.logCaptureWindow.toString(buffer);
        }
        if (this.comment != null) {
            buffer.append(", comment='");
            buffer.append(this.comment);
            buffer.append('\'');
        }
        if (this.proxyToServerAddress != null) {
            buffer.append(", proxyToServerAddress='");
            buffer.append(this.proxyToServerAddress);
            buffer.append('\'');
        }
        if (this.proxyToServerPort != null) {
            buffer.append(", proxyToServerPort=");
            buffer.append(this.proxyToServerPort);
        }
        if (this.maximumFragmentSizeBytes != null) {
            buffer.append(", maximumFragmentSizeBytes=");
            buffer.append(this.maximumFragmentSizeBytes);
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

