/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.ServerSetBlacklistManager;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RoundRobinServerSet
extends ServerSet {
    static final String PROPERTY_DEFAULT_BLACKLIST_CHECK_INTERVAL_MILLIS = RoundRobinServerSet.class.getName() + ".defaultBlacklistCheckIntervalMillis";
    private final AtomicLong nextSlot;
    private final BindRequest bindRequest;
    private final int[] ports;
    private final LDAPConnectionOptions connectionOptions;
    private final PostConnectProcessor postConnectProcessor;
    private final ServerSetBlacklistManager blacklistManager;
    private final SocketFactory socketFactory;
    private final String[] addresses;

    public RoundRobinServerSet(String[] addresses, int[] ports) {
        this(addresses, ports, null, null);
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, null, connectionOptions);
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, SocketFactory socketFactory) {
        this(addresses, ports, socketFactory, null);
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, socketFactory, connectionOptions, null, null);
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) {
        this(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor, RoundRobinServerSet.getDefaultBlacklistCheckIntervalMillis());
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor, long blacklistCheckIntervalMillis) {
        Validator.ensureNotNull(addresses, ports);
        Validator.ensureTrue(addresses.length > 0, "RoundRobinServerSet.addresses must not be empty.");
        Validator.ensureTrue(addresses.length == ports.length, "RoundRobinServerSet addresses and ports arrays must be the same size.");
        this.addresses = addresses;
        this.ports = ports;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
        this.nextSlot = new AtomicLong(0L);
        this.blacklistManager = blacklistCheckIntervalMillis > 0L ? new ServerSetBlacklistManager(this, socketFactory, connectionOptions, bindRequest, postConnectProcessor, blacklistCheckIntervalMillis) : null;
    }

    private static long getDefaultBlacklistCheckIntervalMillis() {
        String propertyValue = StaticUtils.getSystemProperty(PROPERTY_DEFAULT_BLACKLIST_CHECK_INTERVAL_MILLIS);
        if (propertyValue != null) {
            try {
                return Long.parseLong(propertyValue);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return 30000L;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @Override
    public boolean includesAuthentication() {
        return this.bindRequest != null;
    }

    @Override
    public boolean includesPostConnectProcessing() {
        return this.postConnectProcessor != null;
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        int initialSlotNumber = (int)(this.nextSlot.getAndIncrement() % (long)this.addresses.length);
        LDAPException lastException = null;
        ArrayList<ObjectPair<String, Integer>> blacklistedServers = null;
        for (int i = 0; i < this.addresses.length; ++i) {
            int n = (initialSlotNumber + i) % this.addresses.length;
            String address = this.addresses[n];
            int port = this.ports[n];
            if (this.blacklistManager != null && this.blacklistManager.isBlacklisted(address, port)) {
                if (blacklistedServers == null) {
                    blacklistedServers = new ArrayList<ObjectPair<String, Integer>>(this.addresses.length);
                }
                blacklistedServers.add(new ObjectPair<String, Integer>(address, port));
                continue;
            }
            try {
                LDAPConnection c = new LDAPConnection(this.socketFactory, this.connectionOptions, this.addresses[n], this.ports[n]);
                RoundRobinServerSet.doBindPostConnectAndHealthCheckProcessing(c, this.bindRequest, this.postConnectProcessor, healthCheck);
                this.associateConnectionWithThisServerSet(c);
                return c;
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                lastException = e;
                if (this.blacklistManager == null) continue;
                this.blacklistManager.addToBlacklist(address, port, healthCheck);
            }
        }
        if (blacklistedServers != null) {
            for (ObjectPair objectPair : blacklistedServers) {
                try {
                    LDAPConnection c = new LDAPConnection(this.socketFactory, this.connectionOptions, (String)objectPair.getFirst(), (Integer)objectPair.getSecond());
                    RoundRobinServerSet.doBindPostConnectAndHealthCheckProcessing(c, this.bindRequest, this.postConnectProcessor, healthCheck);
                    this.associateConnectionWithThisServerSet(c);
                    this.blacklistManager.removeFromBlacklist(objectPair);
                    return c;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    lastException = e;
                }
            }
        }
        throw lastException;
    }

    public ServerSetBlacklistManager getBlacklistManager() {
        return this.blacklistManager;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("RoundRobinServerSet(servers={");
        for (int i = 0; i < this.addresses.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.addresses[i]);
            buffer.append(':');
            buffer.append(this.ports[i]);
        }
        buffer.append("}, includesAuthentication=");
        buffer.append(this.bindRequest != null);
        buffer.append(", includesPostConnectProcessing=");
        buffer.append(this.postConnectProcessor != null);
        buffer.append(')');
    }
}

