/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.SCRAMBindRequest;
import com.unboundid.ldap.sdk.SCRAMClientFirstMessage;
import com.unboundid.ldap.sdk.SCRAMServerFirstMessage;
import com.unboundid.util.Base64;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import javax.crypto.Mac;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SCRAMClientFinalMessage
implements Serializable {
    private static final byte[] CLIENT_KEY_INPUT_BYTES = StaticUtils.getBytes("Client Key");
    private static final byte[] ONE_BYTES = new byte[]{0, 0, 0, 1};
    private static final long serialVersionUID = -5228385127923425294L;
    private final byte[] authMessageBytes;
    private final byte[] saltedPassword;
    private final SCRAMBindRequest bindRequest;
    private final SCRAMClientFirstMessage clientFirstMessage;
    private final SCRAMServerFirstMessage serverFirstMessage;
    private final String clientFinalMessage;
    private final String clientProofBase64;

    SCRAMClientFinalMessage(SCRAMBindRequest bindRequest, SCRAMClientFirstMessage clientFirstMessage, SCRAMServerFirstMessage serverFirstMessage) throws LDAPBindException {
        this.bindRequest = bindRequest;
        this.clientFirstMessage = clientFirstMessage;
        this.serverFirstMessage = serverFirstMessage;
        this.saltedPassword = SCRAMClientFinalMessage.computeSaltedPassword(bindRequest, serverFirstMessage);
        byte[] clientKey = bindRequest.mac(this.saltedPassword, CLIENT_KEY_INPUT_BYTES);
        byte[] storedKey = bindRequest.digest(clientKey);
        String clientFinalMessageWithoutProof = "c=" + clientFirstMessage.getGS2HeaderBase64() + ",r=" + serverFirstMessage.getCombinedNonce();
        String authMessage = clientFirstMessage.getClientFirstMessageBare() + ',' + serverFirstMessage.getServerFirstMessage() + ',' + clientFinalMessageWithoutProof;
        this.authMessageBytes = StaticUtils.getBytes(authMessage);
        byte[] clientSignature = bindRequest.mac(storedKey, this.authMessageBytes);
        byte[] clientProof = new byte[clientKey.length];
        for (int i = 0; i < clientProof.length; ++i) {
            clientProof[i] = (byte)(clientKey[i] ^ clientSignature[i]);
        }
        this.clientProofBase64 = Base64.encode(clientProof);
        this.clientFinalMessage = clientFinalMessageWithoutProof + ",p=" + this.clientProofBase64;
    }

    private static byte[] computeSaltedPassword(SCRAMBindRequest bindRequest, SCRAMServerFirstMessage serverFirstMessage) throws LDAPBindException {
        Mac mac = bindRequest.getMac(bindRequest.getPasswordBytes());
        byte[] salt = serverFirstMessage.getSalt();
        byte[] dataToMAC = new byte[salt.length + ONE_BYTES.length];
        System.arraycopy(salt, 0, dataToMAC, 0, salt.length);
        System.arraycopy(ONE_BYTES, 0, dataToMAC, salt.length, ONE_BYTES.length);
        byte[] xorBytes = null;
        for (int i = 0; i < serverFirstMessage.getIterationCount(); ++i) {
            byte[] macResult = mac.doFinal(dataToMAC);
            if (i == 0) {
                xorBytes = macResult;
            } else {
                for (int j = 0; j < macResult.length; ++j) {
                    int n = j;
                    xorBytes[n] = (byte)(xorBytes[n] ^ macResult[j]);
                }
            }
            dataToMAC = macResult;
        }
        return xorBytes;
    }

    SCRAMBindRequest getBindRequest() {
        return this.bindRequest;
    }

    SCRAMClientFirstMessage getClientFirstMessage() {
        return this.clientFirstMessage;
    }

    SCRAMServerFirstMessage getServerFirstMessage() {
        return this.serverFirstMessage;
    }

    byte[] getSaltedPassword() {
        return this.saltedPassword;
    }

    byte[] getAuthMessageBytes() {
        return this.authMessageBytes;
    }

    String getClientProofBase64() {
        return this.clientProofBase64;
    }

    String getClientFinalMessage() {
        return this.clientFinalMessage;
    }

    public String toString() {
        return this.clientFinalMessage;
    }
}

