/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.AttributeSyntaxDefinition;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.DITContentRuleDefinition;
import com.unboundid.ldap.sdk.schema.DITStructureRuleDefinition;
import com.unboundid.ldap.sdk.schema.EntryValidator;
import com.unboundid.ldap.sdk.schema.MatchingRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleUseDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaElementType;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SchemaValidator {
    static final boolean PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE;
    static final File PING_IDENTITY_DIRECTORY_SERVER_SCHEMA_DIR;
    private boolean allowAttributeTypesWithoutEqualityMatchingRule = true;
    private boolean allowAttributeTypesWithoutSyntax = PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE;
    private boolean allowCollectiveAttributes = !PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE;
    private boolean allowElementsWithoutNames = true;
    private boolean allowEmptyDescription = false;
    private boolean allowInvalidObjectClassInheritance = false;
    private boolean allowMultipleEntriesPerFile = false;
    private boolean allowMultipleSuperiorObjectClasses = !PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE;
    private boolean allowNamesWithInitialDigit = false;
    private boolean allowNamesWithInitialHyphen = false;
    private boolean allowNamesWithUnderscore = false;
    private boolean allowNonNumericOIDsNotUsingName = false;
    private boolean allowNonNumericOIDsUsingName = false;
    private boolean allowObsoleteElements = true;
    private boolean allowRedefiningElements = false;
    private boolean allowSchemaFilesInSubDirectories = false;
    private boolean allowStructuralObjectClassWithoutSuperior = false;
    private boolean ensureSchemaEntryIsValid = true;
    private boolean ignoreSchemaFilesNotMatchingFileNamePattern = !PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE;
    private boolean useStrictOIDValidation = true;
    private List<AttributeSyntaxDefinition> attributeSyntaxList;
    private Map<String, AttributeSyntaxDefinition> attributeSyntaxMap = new LinkedHashMap<String, AttributeSyntaxDefinition>();
    private List<MatchingRuleDefinition> matchingRuleList;
    private Map<String, MatchingRuleDefinition> matchingRuleMap;
    private Pattern schemaFileNamePattern = null;
    private final Set<SchemaElementType> allowedSchemaElementTypes;
    private final Set<SchemaElementType> allowReferencesToUndefinedElementTypes;

    public SchemaValidator() {
        this.attributeSyntaxList = new ArrayList<AttributeSyntaxDefinition>();
        this.matchingRuleMap = new LinkedHashMap<String, MatchingRuleDefinition>();
        this.matchingRuleList = new ArrayList<MatchingRuleDefinition>();
        this.allowedSchemaElementTypes = EnumSet.allOf(SchemaElementType.class);
        this.allowReferencesToUndefinedElementTypes = EnumSet.noneOf(SchemaElementType.class);
        if (PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE) {
            this.configureLDAPSDKDefaultAttributeSyntaxes();
            this.configureLDAPSDKDefaultMatchingRules();
            this.schemaFileNamePattern = Pattern.compile("^\\d\\d-.+\\.ldif$");
        }
    }

    public Pattern getSchemaFileNamePattern() {
        return this.schemaFileNamePattern;
    }

    public boolean ignoreSchemaFilesNotMatchingFileNamePattern() {
        return this.ignoreSchemaFilesNotMatchingFileNamePattern;
    }

    public void setSchemaFileNamePattern(Pattern schemaFileNamePattern, boolean ignoreSchemaFilesNotMatchingFileNamePattern) {
        this.schemaFileNamePattern = schemaFileNamePattern;
        this.ignoreSchemaFilesNotMatchingFileNamePattern = ignoreSchemaFilesNotMatchingFileNamePattern;
    }

    public boolean allowMultipleEntriesPerFile() {
        return this.allowMultipleEntriesPerFile;
    }

    public void setAllowMultipleEntriesPerFile(boolean allowMultipleEntriesPerFile) {
        this.allowMultipleEntriesPerFile = allowMultipleEntriesPerFile;
    }

    public boolean allowSchemaFilesInSubDirectories() {
        return this.allowSchemaFilesInSubDirectories;
    }

    public void setAllowSchemaFilesInSubDirectories(boolean allowSchemaFilesInSubDirectories) {
        this.allowSchemaFilesInSubDirectories = allowSchemaFilesInSubDirectories;
    }

    public boolean ensureSchemaEntryIsValid() {
        return this.ensureSchemaEntryIsValid;
    }

    public void setEnsureSchemaEntryIsValid(boolean ensureSchemaEntryIsValid) {
        this.ensureSchemaEntryIsValid = ensureSchemaEntryIsValid;
    }

    public Set<SchemaElementType> getAllowedSchemaElementTypes() {
        return Collections.unmodifiableSet(this.allowedSchemaElementTypes);
    }

    public void setAllowedSchemaElementTypes(SchemaElementType ... allowedSchemaElementTypes) {
        this.setAllowedSchemaElementTypes(StaticUtils.toList(allowedSchemaElementTypes));
    }

    public void setAllowedSchemaElementTypes(Collection<SchemaElementType> allowedSchemaElementTypes) {
        Validator.ensureTrue(allowedSchemaElementTypes != null && !allowedSchemaElementTypes.isEmpty(), "SchemaValidator.allowedSchemaElementTypes must not be null or empty.");
        this.allowedSchemaElementTypes.clear();
        this.allowedSchemaElementTypes.addAll(allowedSchemaElementTypes);
    }

    public Set<SchemaElementType> getAllowReferencesToUndefinedElementTypes() {
        return Collections.unmodifiableSet(this.allowReferencesToUndefinedElementTypes);
    }

    public void setAllowReferencesToUndefinedElementTypes(SchemaElementType ... undefinedElementTypes) {
        this.setAllowReferencesToUndefinedElementTypes(StaticUtils.toList(undefinedElementTypes));
    }

    public void setAllowReferencesToUndefinedElementTypes(Collection<SchemaElementType> undefinedElementTypes) {
        this.allowReferencesToUndefinedElementTypes.clear();
        if (undefinedElementTypes != null) {
            this.allowReferencesToUndefinedElementTypes.addAll(undefinedElementTypes);
        }
    }

    public boolean allowRedefiningElements() {
        return this.allowRedefiningElements;
    }

    public void setAllowRedefiningElements(boolean allowRedefiningElements) {
        this.allowRedefiningElements = allowRedefiningElements;
    }

    public boolean allowElementsWithoutNames() {
        return this.allowElementsWithoutNames;
    }

    public void setAllowElementsWithoutNames(boolean allowElementsWithoutNames) {
        this.allowElementsWithoutNames = allowElementsWithoutNames;
    }

    public boolean allowNonNumericOIDsUsingName() {
        return this.allowNonNumericOIDsUsingName;
    }

    public boolean allowNonNumericOIDsNotUsingName() {
        return this.allowNonNumericOIDsNotUsingName;
    }

    public boolean useStrictOIDValidation() {
        return this.useStrictOIDValidation;
    }

    public void setOIDValidation(boolean allowNonNumericOIDsUsingName, boolean allowNonNumericOIDsNotUsingName, boolean useStrictOIDValidation) {
        this.allowNonNumericOIDsUsingName = allowNonNumericOIDsUsingName;
        this.allowNonNumericOIDsNotUsingName = allowNonNumericOIDsNotUsingName;
        this.useStrictOIDValidation = useStrictOIDValidation;
    }

    public boolean allowNamesWithInitialDigit() {
        return this.allowNamesWithInitialDigit;
    }

    public void setAllowNamesWithInitialDigit(boolean allowNamesWithInitialDigit) {
        this.allowNamesWithInitialDigit = allowNamesWithInitialDigit;
    }

    public boolean allowNamesWithInitialHyphen() {
        return this.allowNamesWithInitialHyphen;
    }

    public void setAllowNamesWithInitialHyphen(boolean allowNamesWithInitialHyphen) {
        this.allowNamesWithInitialHyphen = allowNamesWithInitialHyphen;
    }

    public boolean allowNamesWithUnderscore() {
        return this.allowNamesWithUnderscore;
    }

    public void setAllowNamesWithUnderscore(boolean allowNamesWithUnderscore) {
        this.allowNamesWithUnderscore = allowNamesWithUnderscore;
    }

    public boolean allowEmptyDescription() {
        return this.allowEmptyDescription;
    }

    public void setAllowEmptyDescription(boolean allowEmptyDescription) {
        this.allowEmptyDescription = allowEmptyDescription;
    }

    public List<AttributeSyntaxDefinition> getAttributeSyntaxes() {
        return Collections.unmodifiableList(new ArrayList<AttributeSyntaxDefinition>(this.attributeSyntaxList));
    }

    public void setAttributeSyntaxes(Collection<AttributeSyntaxDefinition> attributeSyntaxes) {
        this.attributeSyntaxList = new ArrayList<AttributeSyntaxDefinition>();
        this.attributeSyntaxMap = new HashMap<String, AttributeSyntaxDefinition>();
        if (attributeSyntaxes != null) {
            for (AttributeSyntaxDefinition d : attributeSyntaxes) {
                this.attributeSyntaxList.add(d);
                this.attributeSyntaxMap.put(StaticUtils.toLowerCase(d.getOID()), d);
            }
        }
    }

    public void configureLDAPSDKDefaultAttributeSyntaxes() {
        try {
            LinkedHashSet<AttributeSyntaxDefinition> defaultSyntaxes = new LinkedHashSet<AttributeSyntaxDefinition>();
            Schema schema = Schema.getDefaultStandardSchema();
            defaultSyntaxes.addAll(schema.getAttributeSyntaxes());
            if (PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE) {
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.1.3.1 DESC 'User Password Syntax' )"));
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.1.3.2 DESC 'Relative Subtree Specification' )"));
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.1.3.3 DESC 'Absolute Subtree Specification' )"));
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.1.3.4 DESC 'Sun-defined Access Control Information' )"));
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.2.3.1 DESC 'Compact Timestamp' )"));
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.2.3.2 DESC 'LDAP URL' )"));
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.2.3.3 DESC 'Hex String' )"));
                defaultSyntaxes.add(new AttributeSyntaxDefinition("( 1.3.6.1.4.1.30221.2.3.4 DESC 'JSON Object' )"));
            }
            this.setAttributeSyntaxes(defaultSyntaxes);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    public boolean allowAttributeTypesWithoutSyntax() {
        return this.allowAttributeTypesWithoutSyntax;
    }

    public void setAllowAttributeTypesWithoutSyntax(boolean allowAttributeTypesWithoutSyntax) {
        this.allowAttributeTypesWithoutSyntax = allowAttributeTypesWithoutSyntax;
    }

    public List<MatchingRuleDefinition> getMatchingRuleDefinitions() {
        return Collections.unmodifiableList(new ArrayList<MatchingRuleDefinition>(this.matchingRuleList));
    }

    public void setMatchingRules(Collection<MatchingRuleDefinition> matchingRules) {
        this.matchingRuleList = new ArrayList<MatchingRuleDefinition>();
        this.matchingRuleMap = new HashMap<String, MatchingRuleDefinition>();
        if (matchingRules != null) {
            for (MatchingRuleDefinition d : matchingRules) {
                this.matchingRuleList.add(d);
                this.matchingRuleMap.put(StaticUtils.toLowerCase(d.getOID()), d);
                for (String name : d.getNames()) {
                    this.matchingRuleMap.put(StaticUtils.toLowerCase(name), d);
                }
            }
        }
    }

    public void configureLDAPSDKDefaultMatchingRules() {
        try {
            LinkedHashSet<MatchingRuleDefinition> defaultMatchingRules = new LinkedHashSet<MatchingRuleDefinition>();
            Schema schema = Schema.getDefaultStandardSchema();
            defaultMatchingRules.addAll(schema.getMatchingRules());
            if (PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE) {
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.1.4.1 NAME 'ds-mr-double-metaphone-approx' DESC 'Double Metaphone Approximate Match' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.1.4.2 NAME 'ds-mr-user-password-exact' DESC 'user password exact matching rule' SYNTAX 1.3.6.1.4.1.30221.1.3.1 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.1.4.3 NAME 'ds-mr-user-password-equality' DESC 'user password matching rule' SYNTAX 1.3.6.1.4.1.30221.1.3.1 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.1.4.4 NAME 'historicalCsnOrderingMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.1.4.902 NAME 'caseExactIA5SubstringsMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.58 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.1 NAME 'compactTimestampMatch' SYNTAX 1.3.6.1.4.1.30221.2.3.1 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.2 NAME 'compactTimestampOrderingMatch' SYNTAX 1.3.6.1.4.1.30221.2.3.1 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.3 NAME 'ldapURLMatch' SYNTAX 1.3.6.1.4.1.30221.2.3.2 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.4 NAME 'hexStringMatch' SYNTAX 1.3.6.1.4.1.30221.2.3.3 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.5 NAME 'hexStringOrderingMatch' SYNTAX 1.3.6.1.4.1.30221.2.3.3 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.12 NAME 'jsonObjectExactMatch' SYNTAX 1.3.6.1.4.1.30221.2.3.4 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.13 NAME 'jsonObjectFilterExtensibleMatch' SYNTAX 1.3.6.1.4.1.30221.2.3.4 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.14 NAME 'relativeTimeExtensibleMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.24 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.15 NAME 'jsonObjectCaseSensitiveNamesCaseSensitiveValues' SYNTAX 1.3.6.1.4.1.30221.2.3.4 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.16 NAME 'jsonObjectCaseInsensitiveNamesCaseSensitiveValues' SYNTAX 1.3.6.1.4.1.30221.2.3.4 )"));
                defaultMatchingRules.add(new MatchingRuleDefinition("( 1.3.6.1.4.1.30221.2.4.17 NAME 'jsonObjectCaseInsensitiveNamesCaseInsensitiveValues' SYNTAX 1.3.6.1.4.1.30221.2.3.4 )"));
            }
            this.setMatchingRules(defaultMatchingRules);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    public boolean allowAttributeTypesWithoutEqualityMatchingRule() {
        return this.allowAttributeTypesWithoutEqualityMatchingRule;
    }

    public void setAllowAttributeTypesWithoutEqualityMatchingRule(boolean allowAttributeTypesWithoutEqualityMatchingRule) {
        this.allowAttributeTypesWithoutEqualityMatchingRule = allowAttributeTypesWithoutEqualityMatchingRule;
    }

    public boolean allowMultipleSuperiorObjectClasses() {
        return this.allowMultipleSuperiorObjectClasses;
    }

    public void setAllowMultipleSuperiorObjectClasses(boolean allowMultipleSuperiorObjectClasses) {
        this.allowMultipleSuperiorObjectClasses = allowMultipleSuperiorObjectClasses;
    }

    public boolean allowStructuralObjectClassWithoutSuperior() {
        return this.allowStructuralObjectClassWithoutSuperior;
    }

    public void setAllowStructuralObjectClassWithoutSuperior(boolean allowStructuralObjectClassWithoutSuperior) {
        this.allowStructuralObjectClassWithoutSuperior = allowStructuralObjectClassWithoutSuperior;
    }

    public boolean allowInvalidObjectClassInheritance() {
        return this.allowInvalidObjectClassInheritance;
    }

    public void setAllowInvalidObjectClassInheritance(boolean allowInvalidObjectClassInheritance) {
        this.allowInvalidObjectClassInheritance = allowInvalidObjectClassInheritance;
    }

    public boolean allowCollectiveAttributes() {
        return this.allowCollectiveAttributes;
    }

    public void setAllowCollectiveAttributes(boolean allowCollectiveAttributes) {
        this.allowCollectiveAttributes = allowCollectiveAttributes;
    }

    public boolean allowObsoleteElements() {
        return this.allowObsoleteElements;
    }

    public void setAllowObsoleteElements(boolean allowObsoleteElements) {
        this.allowObsoleteElements = allowObsoleteElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema validateSchema(File schemaPath, Schema existingSchema, List<String> errorMessages) {
        boolean originalAllowEmptyDescription = SchemaElement.allowEmptyDescription();
        try {
            SchemaElement.setAllowEmptyDescription(true);
            int originalErrorMessagesSize = errorMessages.size();
            AtomicInteger schemaFilesProcessed = new AtomicInteger(0);
            ArrayList<File> nonSchemaFilesIgnored = new ArrayList<File>();
            Schema schema = this.validateSchema(schemaPath, errorMessages, existingSchema, schemaFilesProcessed, nonSchemaFilesIgnored);
            if (schemaFilesProcessed.get() == 0 && errorMessages.size() == originalErrorMessagesSize) {
                switch (nonSchemaFilesIgnored.size()) {
                    case 0: {
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NO_SCHEMA_FILES_NONE_IGNORED.get(schemaPath.getAbsolutePath()));
                        break;
                    }
                    case 1: {
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NO_SCHEMA_FILES_ONE_IGNORED.get(schemaPath.getAbsolutePath(), ((File)nonSchemaFilesIgnored.get(0)).getAbsolutePath()));
                        break;
                    }
                    default: {
                        StringBuilder buffer = new StringBuilder();
                        Iterator fileIterator = nonSchemaFilesIgnored.iterator();
                        while (fileIterator.hasNext()) {
                            buffer.append('\'');
                            buffer.append(((File)fileIterator.next()).getAbsolutePath());
                            buffer.append('\'');
                            if (!fileIterator.hasNext()) continue;
                            buffer.append(", ");
                        }
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NO_SCHEMA_FILES_MULTIPLE_IGNORED.get(schemaPath.getAbsolutePath(), buffer.toString()));
                    }
                }
            }
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            SchemaElement.setAllowEmptyDescription(originalAllowEmptyDescription);
        }
    }

    private Schema validateSchema(File schemaPath, List<String> errorMessages, Schema existingSchema, AtomicInteger schemaFilesProcessed, List<File> nonSchemaFilesIgnored) {
        if (!schemaPath.exists()) {
            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NO_SUCH_PATH.get(schemaPath.getAbsolutePath()));
            return existingSchema;
        }
        if (schemaPath.isDirectory()) {
            return this.validateSchemaDirectory(schemaPath, errorMessages, existingSchema, schemaFilesProcessed, nonSchemaFilesIgnored);
        }
        return this.validateSchemaFile(schemaPath, errorMessages, existingSchema, schemaFilesProcessed, nonSchemaFilesIgnored);
    }

    private Schema validateSchemaDirectory(File schemaDirectory, List<String> errorMessages, Schema existingSchema, AtomicInteger schemaFilesProcessed, List<File> nonSchemaFilesIgnored) {
        Schema newSchema;
        TreeMap<String, File> schemaFiles = new TreeMap<String, File>();
        TreeMap<String, File> subDirectories = new TreeMap<String, File>();
        for (File f : schemaDirectory.listFiles()) {
            String name = f.getName();
            if (f.isFile()) {
                schemaFiles.put(name, f);
                continue;
            }
            if (this.allowSchemaFilesInSubDirectories) {
                subDirectories.put(name, f);
                continue;
            }
            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DIR_CONTAINS_SUBDIR.get(schemaDirectory.getAbsolutePath(), name));
        }
        Schema schema = existingSchema;
        for (File f : schemaFiles.values()) {
            newSchema = this.validateSchemaFile(f, errorMessages, schema, schemaFilesProcessed, nonSchemaFilesIgnored);
            if (schema == null) {
                schema = newSchema;
                continue;
            }
            schema = Schema.mergeSchemas(schema, newSchema);
        }
        for (File f : subDirectories.values()) {
            newSchema = this.validateSchemaDirectory(f, errorMessages, schema, schemaFilesProcessed, nonSchemaFilesIgnored);
            if (schema == null) {
                schema = newSchema;
                continue;
            }
            schema = Schema.mergeSchemas(schema, newSchema);
        }
        return schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema validateSchemaFile(File schemaFile, List<String> errorMessages, Schema existingSchema, AtomicInteger schemaFilesProcessed, List<File> nonSchemaFilesIgnored) {
        String name;
        if (this.schemaFileNamePattern != null && !this.schemaFileNamePattern.matcher(name = schemaFile.getName()).matches()) {
            if (this.ignoreSchemaFilesNotMatchingFileNamePattern) {
                nonSchemaFilesIgnored.add(schemaFile);
                return existingSchema;
            }
            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_FILE_NAME_DOES_NOT_MATCH_PATTERN.get(schemaFile.getAbsoluteFile().getParentFile().getAbsolutePath(), name));
            return existingSchema;
        }
        schemaFilesProcessed.incrementAndGet();
        Schema newSchema = existingSchema;
        try (LDIFReader ldifReader = new LDIFReader(schemaFile);){
            Entry schemaEntry = ldifReader.readEntry();
            if (schemaEntry == null) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NO_ENTRY_IN_FILE.get(schemaFile.getAbsolutePath()));
                Schema schema = existingSchema;
                return schema;
            }
            newSchema = this.validateSchemaEntry(schemaEntry, schemaFile, errorMessages, newSchema);
            while (true) {
                if ((schemaEntry = ldifReader.readEntry()) == null) {
                    return newSchema;
                }
                if (!this.allowMultipleEntriesPerFile) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MULTIPLE_ENTRIES_IN_FILE.get(schemaFile.getAbsolutePath()));
                    Schema schema = newSchema;
                    return schema;
                }
                newSchema = this.validateSchemaEntry(schemaEntry, schemaFile, errorMessages, newSchema);
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_ERROR_READING_FILE.get(schemaFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
            return newSchema;
        }
        catch (LDIFException e) {
            Debug.debugException(e);
            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MALFORMED_LDIF_ENTRY.get(schemaFile.getAbsolutePath(), e.getMessage()));
        }
        return newSchema;
    }

    private Schema validateSchemaEntry(Entry schemaEntry, File schemaFile, List<String> errorMessages, Schema existingSchema) {
        ArrayList<String> schemaEntryInvalidReasons;
        EntryValidator entryValidator;
        Schema s;
        if (schemaEntry.hasAttribute("ldapSyntaxes")) {
            this.validateAttributeSyntaxes(schemaEntry, schemaFile, errorMessages);
        }
        if (schemaEntry.hasAttribute("matchingRules")) {
            if (this.attributeSyntaxMap.isEmpty()) {
                this.configureLDAPSDKDefaultAttributeSyntaxes();
            }
            this.validateMatchingRules(schemaEntry, schemaFile, existingSchema, errorMessages);
        }
        if (schemaEntry.hasAttribute("attributeTypes")) {
            if (this.attributeSyntaxMap.isEmpty()) {
                this.configureLDAPSDKDefaultAttributeSyntaxes();
            }
            if (this.matchingRuleMap.isEmpty()) {
                this.configureLDAPSDKDefaultMatchingRules();
            }
            HashMap<String, AttributeTypeDefinition> attributeTypeMap = new HashMap<String, AttributeTypeDefinition>();
            this.validateAttributeTypes(schemaEntry, schemaFile, attributeTypeMap, existingSchema, errorMessages);
        }
        if (schemaEntry.hasAttribute("objectClasses")) {
            Entry schemaEntryWithoutObjectClasses = schemaEntry.duplicate();
            schemaEntryWithoutObjectClasses.removeAttribute("objectClasses");
            s = new Schema(schemaEntryWithoutObjectClasses);
            if (existingSchema != null) {
                s = Schema.mergeSchemas(existingSchema, s);
            }
            HashMap<String, ObjectClassDefinition> objectClassMap = new HashMap<String, ObjectClassDefinition>();
            this.validateObjectClasses(schemaEntry, schemaFile, objectClassMap, s, errorMessages);
        }
        if (schemaEntry.hasAttribute("nameForms")) {
            Entry schemaEntryWithoutNameForms = schemaEntry.duplicate();
            schemaEntryWithoutNameForms.removeAttribute("nameForms");
            s = new Schema(schemaEntryWithoutNameForms);
            if (existingSchema != null) {
                s = Schema.mergeSchemas(existingSchema, s);
            }
            HashMap<String, NameFormDefinition> nameFormsByNameOrOID = new HashMap<String, NameFormDefinition>();
            HashMap<ObjectClassDefinition, NameFormDefinition> nameFormsByOC = new HashMap<ObjectClassDefinition, NameFormDefinition>();
            this.validateNameForms(schemaEntry, schemaFile, nameFormsByNameOrOID, nameFormsByOC, s, errorMessages);
        }
        if (schemaEntry.hasAttribute("dITContentRules")) {
            Entry schemaEntryWithoutDITContentRules = schemaEntry.duplicate();
            schemaEntryWithoutDITContentRules.removeAttribute("dITContentRules");
            s = new Schema(schemaEntryWithoutDITContentRules);
            if (existingSchema != null) {
                s = Schema.mergeSchemas(existingSchema, s);
            }
            HashMap<String, DITContentRuleDefinition> dcrMap = new HashMap<String, DITContentRuleDefinition>();
            this.validateDITContentRules(schemaEntry, schemaFile, dcrMap, s, errorMessages);
        }
        if (schemaEntry.hasAttribute("dITStructureRules")) {
            Entry schemaEntryWithoutDITStructureRules = schemaEntry.duplicate();
            schemaEntryWithoutDITStructureRules.removeAttribute("dITStructureRules");
            s = new Schema(schemaEntryWithoutDITStructureRules);
            if (existingSchema != null) {
                s = Schema.mergeSchemas(existingSchema, s);
            }
            HashMap<String, DITStructureRuleDefinition> dsrIDAndNameMap = new HashMap<String, DITStructureRuleDefinition>();
            HashMap<NameFormDefinition, DITStructureRuleDefinition> dsrNFMap = new HashMap<NameFormDefinition, DITStructureRuleDefinition>();
            this.validateDITStructureRules(schemaEntry, schemaFile, dsrIDAndNameMap, dsrNFMap, s, errorMessages);
        }
        if (schemaEntry.hasAttribute("matchingRuleUse")) {
            Entry schemaEntryWithoutMatchingRuleUses = schemaEntry.duplicate();
            schemaEntryWithoutMatchingRuleUses.removeAttribute("matchingRuleUse");
            s = new Schema(schemaEntryWithoutMatchingRuleUses);
            if (existingSchema != null) {
                s = Schema.mergeSchemas(existingSchema, s);
            }
            HashMap<String, MatchingRuleUseDefinition> mruMap = new HashMap<String, MatchingRuleUseDefinition>();
            this.validateMatchingRuleUses(schemaEntry, schemaFile, mruMap, s, errorMessages);
        }
        Schema s2 = new Schema(schemaEntry);
        if (existingSchema != null) {
            s2 = Schema.mergeSchemas(existingSchema, s2);
        }
        if (this.ensureSchemaEntryIsValid && !(entryValidator = new EntryValidator(s2)).entryIsValid(schemaEntry, schemaEntryInvalidReasons = new ArrayList<String>())) {
            for (String invalidReason : schemaEntryInvalidReasons) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_ENTRY_NOT_VALID.get(schemaEntry.getDN(), schemaFile.getAbsolutePath(), invalidReason));
            }
        }
        return s2;
    }

    private void validateAttributeSyntaxes(Entry schemaEntry, File schemaFile, List<String> errorMessages) {
        for (String syntaxString : schemaEntry.getAttributeValues("ldapSyntaxes")) {
            String lowerOID;
            AttributeSyntaxDefinition existingSyntax;
            String description;
            AttributeSyntaxDefinition syntax;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_SYNTAX)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_SYNTAX_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), syntaxString));
                continue;
            }
            try {
                syntax = new AttributeSyntaxDefinition(syntaxString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_SYNTAX.get(syntaxString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            try {
                this.validateOID(syntax.getOID(), StaticUtils.NO_STRINGS);
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_SYNTAX_INVALID_OID.get(syntaxString, schemaFile.getAbsolutePath(), e.getMessage()));
            }
            if (!this.allowEmptyDescription && (description = syntax.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_SYNTAX_EMPTY_DESCRIPTION.get(syntaxString, schemaFile.getAbsolutePath()));
            }
            if ((existingSyntax = this.attributeSyntaxMap.get(lowerOID = StaticUtils.toLowerCase(syntax.getOID()))) != null && !this.allowRedefiningElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_SYNTAX_ALREADY_DEFINED.get(syntaxString, schemaFile.getAbsolutePath(), existingSyntax.toString()));
            }
            this.attributeSyntaxMap.put(lowerOID, syntax);
        }
    }

    private void validateMatchingRules(Entry schemaEntry, File schemaFile, Schema existingSchema, List<String> errorMessages) {
        for (String matchingRuleString : schemaEntry.getAttributeValues("matchingRules")) {
            String lowerSyntaxOID;
            String description;
            MatchingRuleDefinition matchingRule;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.MATCHING_RULE)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), matchingRuleString));
                continue;
            }
            try {
                matchingRule = new MatchingRuleDefinition(matchingRuleString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_MR.get(matchingRuleString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            try {
                this.validateOID(matchingRule.getOID(), matchingRule.getNames());
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_INVALID_OID.get(matchingRuleString, schemaFile.getAbsolutePath(), e.getMessage()));
            }
            if (matchingRule.getNames().length == 0 && !this.allowElementsWithoutNames) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_NO_NAME.get(matchingRuleString, schemaFile.getAbsolutePath()));
            }
            for (String name : matchingRule.getNames()) {
                try {
                    this.validateName(name);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_INVALID_NAME.get(matchingRuleString, schemaFile.getAbsolutePath(), name, e.getMessage()));
                }
            }
            if (!this.allowEmptyDescription && (description = matchingRule.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_EMPTY_DESCRIPTION.get(matchingRuleString, schemaFile.getAbsolutePath()));
            }
            if (matchingRule.isObsolete() && !this.allowObsoleteElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_OBSOLETE.get(matchingRuleString, schemaFile.getAbsolutePath()));
            }
            String syntaxOID = matchingRule.getSyntaxOID();
            try {
                this.validateOID(syntaxOID, StaticUtils.NO_STRINGS);
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_INVALID_SYNTAX_OID.get(matchingRuleString, schemaFile.getAbsolutePath(), syntaxOID, e.getMessage()));
            }
            if (!(this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_SYNTAX) || this.attributeSyntaxMap.containsKey(lowerSyntaxOID = StaticUtils.toLowerCase(syntaxOID)) || existingSchema != null && existingSchema.getAttributeSyntax(lowerSyntaxOID) != null)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_UNDEFINED_SYNTAX.get(matchingRuleString, schemaFile.getAbsolutePath(), syntaxOID));
            }
            boolean isDuplicate = false;
            String lowerOID = StaticUtils.toLowerCase(matchingRule.getOID());
            if (this.matchingRuleMap.containsKey(lowerOID) && !this.allowRedefiningElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_ALREADY_DEFINED_WITH_OID.get(matchingRuleString, schemaFile.getAbsolutePath(), this.matchingRuleMap.get(lowerOID).toString()));
                isDuplicate = true;
            }
            if (!isDuplicate) {
                for (String name : matchingRule.getNames()) {
                    String lowerName = StaticUtils.toLowerCase(name);
                    if (!this.matchingRuleMap.containsKey(lowerName) || this.allowRedefiningElements) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MR_ALREADY_DEFINED_WITH_NAME.get(matchingRuleString, schemaFile.getAbsolutePath(), name, this.matchingRuleMap.get(lowerName).toString()));
                    isDuplicate = true;
                    break;
                }
            }
            if (isDuplicate) continue;
            this.matchingRuleMap.put(lowerOID, matchingRule);
            for (String name : matchingRule.getNames()) {
                this.matchingRuleMap.put(StaticUtils.toLowerCase(name), matchingRule);
            }
        }
    }

    private void validateAttributeTypes(Entry schemaEntry, File schemaFile, Map<String, AttributeTypeDefinition> attributeTypeMap, Schema existingSchema, List<String> errorMessages) {
        for (String attributeTypeString : schemaEntry.getAttributeValues("attributeTypes")) {
            String syntaxOID;
            AttributeTypeDefinition superiorType;
            String superiorTypeNameOrOID;
            String description;
            AttributeTypeDefinition attributeType;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), attributeTypeString));
                continue;
            }
            try {
                attributeType = new AttributeTypeDefinition(attributeTypeString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_AT.get(attributeTypeString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            try {
                this.validateOID(attributeType.getOID(), attributeType.getNames());
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_INVALID_OID.get(attributeTypeString, schemaFile.getAbsolutePath(), e.getMessage()));
            }
            if (attributeType.getNames().length == 0 && !this.allowElementsWithoutNames) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_NO_NAME.get(attributeTypeString, schemaFile.getAbsolutePath()));
            }
            for (String name : attributeType.getNames()) {
                try {
                    this.validateName(name);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_INVALID_NAME.get(attributeTypeString, schemaFile.getAbsolutePath(), name, e.getMessage()));
                }
            }
            if (!this.allowEmptyDescription && (description = attributeType.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_EMPTY_DESCRIPTION.get(attributeTypeString, schemaFile.getAbsolutePath()));
            }
            if (attributeType.isObsolete() && !this.allowObsoleteElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_OBSOLETE.get(attributeTypeString, schemaFile.getAbsolutePath()));
            }
            if ((superiorTypeNameOrOID = attributeType.getSuperiorType()) == null) {
                superiorType = null;
            } else {
                String lowerSuperiorTypeNameOrOID = StaticUtils.toLowerCase(superiorTypeNameOrOID);
                superiorType = attributeTypeMap.get(lowerSuperiorTypeNameOrOID);
                if (superiorType == null && existingSchema != null) {
                    superiorType = existingSchema.getAttributeType(lowerSuperiorTypeNameOrOID);
                }
                if (superiorType == null && !this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_UNDEFINED_SUPERIOR.get(attributeTypeString, schemaFile.getAbsolutePath(), superiorTypeNameOrOID));
                }
            }
            String equalityMRNameOrOID = attributeType.getEqualityMatchingRule();
            if (equalityMRNameOrOID == null && superiorTypeNameOrOID == null && !this.allowAttributeTypesWithoutEqualityMatchingRule) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_NO_EQ_MR.get(attributeTypeString, schemaFile.getAbsolutePath()));
            }
            if (!this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.MATCHING_RULE)) {
                String substringMRNameOrOID;
                String orderingMRNameOrOID;
                if (!(equalityMRNameOrOID == null || this.matchingRuleMap.containsKey(StaticUtils.toLowerCase(equalityMRNameOrOID)) || existingSchema != null && existingSchema.getMatchingRule(equalityMRNameOrOID) != null)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_UNDEFINED_EQ_MR.get(attributeTypeString, schemaFile.getAbsolutePath(), equalityMRNameOrOID));
                }
                if (!((orderingMRNameOrOID = attributeType.getOrderingMatchingRule()) == null || this.matchingRuleMap.containsKey(StaticUtils.toLowerCase(orderingMRNameOrOID)) || existingSchema != null && existingSchema.getMatchingRule(orderingMRNameOrOID) != null)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_UNDEFINED_ORD_MR.get(attributeTypeString, schemaFile.getAbsolutePath(), orderingMRNameOrOID));
                }
                if (!((substringMRNameOrOID = attributeType.getSubstringMatchingRule()) == null || this.matchingRuleMap.containsKey(StaticUtils.toLowerCase(substringMRNameOrOID)) || existingSchema != null && existingSchema.getMatchingRule(substringMRNameOrOID) != null)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_UNDEFINED_SUB_MR.get(attributeTypeString, schemaFile.getAbsolutePath(), substringMRNameOrOID));
                }
            }
            if ((syntaxOID = attributeType.getSyntaxOID()) == null) {
                if (superiorTypeNameOrOID == null && !this.allowAttributeTypesWithoutSyntax) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_NO_SYNTAX.get(attributeTypeString, schemaFile.getAbsolutePath()));
                }
            } else if (!this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_SYNTAX)) {
                String baseOID = AttributeTypeDefinition.getBaseSyntaxOID(syntaxOID);
                try {
                    this.validateOID(baseOID, StaticUtils.NO_STRINGS);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_INVALID_SYNTAX_OID.get(attributeTypeString, schemaFile.getAbsolutePath(), baseOID, e.getMessage()));
                }
                String lowerSyntaxOID = StaticUtils.toLowerCase(baseOID);
                if (!(this.attributeSyntaxMap.containsKey(lowerSyntaxOID) || existingSchema != null && existingSchema.getAttributeSyntax(lowerSyntaxOID) != null)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_UNDEFINED_SYNTAX.get(attributeTypeString, schemaFile.getAbsolutePath(), baseOID));
                }
            }
            if (attributeType.isCollective() && !this.allowCollectiveAttributes) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_COLLECTIVE.get(attributeTypeString, schemaFile.getAbsolutePath()));
            }
            if (attributeType.isNoUserModification() && !attributeType.isOperational()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_NO_USER_MOD_WITHOUT_OP_USAGE.get(attributeTypeString, schemaFile.getAbsolutePath()));
            }
            boolean isDuplicate = false;
            if (!this.allowRedefiningElements) {
                String lowerOID = StaticUtils.toLowerCase(attributeType.getOID());
                AttributeTypeDefinition existingDefinition = attributeTypeMap.get(lowerOID);
                if (existingDefinition == null && existingSchema != null) {
                    existingDefinition = existingSchema.getAttributeType(lowerOID);
                }
                if (existingDefinition != null) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_ALREADY_DEFINED_WITH_OID.get(attributeTypeString, schemaFile.getAbsolutePath(), existingDefinition.toString()));
                    isDuplicate = true;
                }
                if (!isDuplicate) {
                    for (String name : attributeType.getNames()) {
                        String lowerName = StaticUtils.toLowerCase(name);
                        existingDefinition = attributeTypeMap.get(lowerName);
                        if (existingDefinition == null && existingSchema != null) {
                            existingDefinition = existingSchema.getAttributeType(lowerName);
                        }
                        if (existingDefinition == null) continue;
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_AT_ALREADY_DEFINED_WITH_NAME.get(attributeTypeString, schemaFile.getAbsolutePath(), name, existingDefinition.toString()));
                        isDuplicate = true;
                        break;
                    }
                }
            }
            if (isDuplicate) continue;
            attributeTypeMap.put(StaticUtils.toLowerCase(attributeType.getOID()), attributeType);
            for (String name : attributeType.getNames()) {
                attributeTypeMap.put(StaticUtils.toLowerCase(name), attributeType);
            }
        }
    }

    private void validateObjectClasses(Entry schemaEntry, File schemaFile, Map<String, ObjectClassDefinition> objectClassMap, Schema existingSchema, List<String> errorMessages) {
        for (String objectClassString : schemaEntry.getAttributeValues("objectClasses")) {
            AttributeTypeDefinition at;
            String description;
            ObjectClassDefinition objectClass;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.OBJECT_CLASS)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), objectClassString));
                continue;
            }
            try {
                objectClass = new ObjectClassDefinition(objectClassString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_OC.get(objectClassString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            try {
                this.validateOID(objectClass.getOID(), objectClass.getNames());
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_INVALID_OID.get(objectClassString, schemaFile.getAbsolutePath(), e.getMessage()));
            }
            if (objectClass.getNames().length == 0 && !this.allowElementsWithoutNames) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_NO_NAME.get(objectClassString, schemaFile.getAbsolutePath()));
            }
            for (String name : objectClass.getNames()) {
                try {
                    this.validateName(name);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_INVALID_NAME.get(objectClassString, schemaFile.getAbsolutePath(), name, e.getMessage()));
                }
            }
            if (!this.allowEmptyDescription && (description = objectClass.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_EMPTY_DESCRIPTION.get(objectClassString, schemaFile.getAbsolutePath()));
            }
            if (objectClass.isObsolete() && !this.allowObsoleteElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_OBSOLETE.get(objectClassString, schemaFile.getAbsolutePath()));
            }
            this.validateSuperiorObjectClasses(schemaFile, objectClass, objectClassMap, existingSchema, errorMessages);
            HashSet<String> requiredAttrNamesAndOIDs = new HashSet<String>();
            for (String attrNameOrOID : objectClass.getRequiredAttributes()) {
                requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(attrNameOrOID));
                at = existingSchema.getAttributeType(attrNameOrOID);
                if (at == null) {
                    if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_UNDEFINED_REQUIRED_ATTR.get(objectClassString, schemaFile.getAbsolutePath(), attrNameOrOID));
                    continue;
                }
                requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(at.getOID()));
                for (String name : at.getNames()) {
                    requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(name));
                }
            }
            for (String attrNameOrOID : objectClass.getOptionalAttributes()) {
                if (requiredAttrNamesAndOIDs.contains(StaticUtils.toLowerCase(attrNameOrOID))) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_AT_REQ_AND_OPT.get(objectClassString, schemaFile.getAbsolutePath(), attrNameOrOID));
                }
                if ((at = existingSchema.getAttributeType(attrNameOrOID)) != null || this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_UNDEFINED_OPTIONAL_ATTR.get(objectClassString, schemaFile.getAbsolutePath(), attrNameOrOID));
            }
            boolean isDuplicate = false;
            if (!this.allowRedefiningElements) {
                String lowerOID = StaticUtils.toLowerCase(objectClass.getOID());
                ObjectClassDefinition existingDefinition = objectClassMap.get(lowerOID);
                if (existingDefinition == null) {
                    existingDefinition = existingSchema.getObjectClass(lowerOID);
                }
                if (existingDefinition != null) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_ALREADY_DEFINED_WITH_OID.get(objectClassString, schemaFile.getAbsolutePath(), existingDefinition.toString()));
                    isDuplicate = true;
                }
                if (!isDuplicate) {
                    for (String name : objectClass.getNames()) {
                        String lowerName = StaticUtils.toLowerCase(name);
                        existingDefinition = objectClassMap.get(lowerName);
                        if (existingDefinition == null) {
                            existingDefinition = existingSchema.getObjectClass(lowerName);
                        }
                        if (existingDefinition == null) continue;
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_ALREADY_DEFINED_WITH_NAME.get(objectClassString, schemaFile.getAbsolutePath(), name, existingDefinition.toString()));
                        isDuplicate = true;
                        break;
                    }
                }
            }
            if (isDuplicate) continue;
            objectClassMap.put(StaticUtils.toLowerCase(objectClass.getOID()), objectClass);
            for (String name : objectClass.getNames()) {
                objectClassMap.put(StaticUtils.toLowerCase(name), objectClass);
            }
        }
    }

    private void validateSuperiorObjectClasses(File schemaFile, ObjectClassDefinition objectClass, Map<String, ObjectClassDefinition> objectClassMap, Schema existingSchema, List<String> errorMessages) {
        String[] superiorClassNamesOrOIDs = objectClass.getSuperiorClasses();
        if (superiorClassNamesOrOIDs.length == 0) {
            if (!this.allowStructuralObjectClassWithoutSuperior) {
                ObjectClassType type = objectClass.getObjectClassType();
                if (type == null) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_NO_SUP_NULL_TYPE.get(objectClass.toString(), schemaFile.getAbsolutePath()));
                } else if (type == ObjectClassType.STRUCTURAL) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_NO_SUP_STRUCTURAL_TYPE.get(objectClass.toString(), schemaFile.getAbsolutePath()));
                }
            }
            return;
        }
        if (superiorClassNamesOrOIDs.length > 1 && !this.allowMultipleSuperiorObjectClasses) {
            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_MULTIPLE_SUP.get(objectClass.toString(), schemaFile.getAbsolutePath()));
        }
        LinkedHashMap<String, ObjectClassDefinition> superiorClasses = new LinkedHashMap<String, ObjectClassDefinition>();
        for (String nameOrOID : superiorClassNamesOrOIDs) {
            String lowerNameOrOID = StaticUtils.toLowerCase(nameOrOID);
            ObjectClassDefinition superiorClass = objectClassMap.get(lowerNameOrOID);
            if (superiorClass == null) {
                superiorClass = existingSchema.getObjectClass(lowerNameOrOID);
            }
            if (superiorClass == null) {
                if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.OBJECT_CLASS)) continue;
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_UNDEFINED_SUP.get(objectClass.toString(), schemaFile.getAbsolutePath(), nameOrOID));
                continue;
            }
            superiorClasses.put(nameOrOID, superiorClass);
        }
        if (!this.allowInvalidObjectClassInheritance && !superiorClasses.isEmpty()) {
            if (objectClass.getObjectClassType() == null) {
                for (Map.Entry e : superiorClasses.entrySet()) {
                    if (((ObjectClassDefinition)e.getValue()).getObjectClassType() != ObjectClassType.AUXILIARY) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_IMPLIED_STRUCTURAL_SUP_OF_AUXILIARY.get(objectClass.toString(), schemaFile.getAbsolutePath(), e.getKey()));
                    break;
                }
            } else {
                block0 : switch (objectClass.getObjectClassType()) {
                    case STRUCTURAL: {
                        for (Map.Entry e : superiorClasses.entrySet()) {
                            if (((ObjectClassDefinition)e.getValue()).getObjectClassType() != ObjectClassType.AUXILIARY) continue;
                            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_STRUCTURAL_SUP_OF_AUXILIARY.get(objectClass.toString(), schemaFile.getAbsolutePath(), e.getKey()));
                            break block0;
                        }
                        break;
                    }
                    case AUXILIARY: {
                        for (Map.Entry e : superiorClasses.entrySet()) {
                            if (((ObjectClassDefinition)e.getValue()).getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
                            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_AUXILIARY_SUP_OF_STRUCTURAL.get(objectClass.toString(), schemaFile.getAbsolutePath(), e.getKey()));
                            break block0;
                        }
                        break;
                    }
                    case ABSTRACT: {
                        for (Map.Entry e : superiorClasses.entrySet()) {
                            if (((ObjectClassDefinition)e.getValue()).getObjectClassType() == ObjectClassType.STRUCTURAL) {
                                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_ABSTRACT_SUP_OF_STRUCTURAL.get(objectClass.toString(), schemaFile.getAbsolutePath(), e.getKey()));
                                break block0;
                            }
                            if (((ObjectClassDefinition)e.getValue()).getObjectClassType() != ObjectClassType.AUXILIARY) continue;
                            errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_OC_ABSTRACT_SUP_OF_AUXILIARY.get(objectClass.toString(), schemaFile.getAbsolutePath(), e.getKey()));
                            break block0;
                        }
                        break;
                    }
                }
            }
        }
    }

    private void validateNameForms(Entry schemaEntry, File schemaFile, Map<String, NameFormDefinition> nameFormsByNameOrOID, Map<ObjectClassDefinition, NameFormDefinition> nameFormsByOC, Schema existingSchema, List<String> errorMessages) {
        for (String nameFormString : schemaEntry.getAttributeValues("nameForms")) {
            AttributeTypeDefinition attrType;
            String structuralClassNameOrOID;
            ObjectClassDefinition structuralClass;
            String description;
            NameFormDefinition nameForm;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.NAME_FORM)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), nameFormString));
                continue;
            }
            try {
                nameForm = new NameFormDefinition(nameFormString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_NF.get(nameFormString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            try {
                this.validateOID(nameForm.getOID(), nameForm.getNames());
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_INVALID_OID.get(nameFormString, schemaFile.getAbsolutePath(), e.getMessage()));
            }
            if (nameForm.getNames().length == 0 && !this.allowElementsWithoutNames) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_NO_NAME.get(nameFormString, schemaFile.getAbsolutePath()));
            }
            for (String name : nameForm.getNames()) {
                try {
                    this.validateName(name);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_INVALID_NAME.get(nameFormString, schemaFile.getAbsolutePath(), name, e.getMessage()));
                }
            }
            if (!this.allowEmptyDescription && (description = nameForm.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_EMPTY_DESCRIPTION.get(nameFormString, schemaFile.getAbsolutePath()));
            }
            if (nameForm.isObsolete() && !this.allowObsoleteElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_OBSOLETE.get(nameFormString, schemaFile.getAbsolutePath()));
            }
            if ((structuralClass = existingSchema.getObjectClass(structuralClassNameOrOID = nameForm.getStructuralClass())) == null) {
                if (!this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.OBJECT_CLASS)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_UNDEFINED_OC.get(nameFormString, schemaFile.getAbsolutePath(), structuralClassNameOrOID));
                }
            } else if (structuralClass.getObjectClassType() != null && structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_OC_NOT_STRUCTURAL.get(nameFormString, schemaFile.getAbsolutePath(), structuralClassNameOrOID));
            }
            HashSet<String> requiredAttrNamesAndOIDs = new HashSet<String>();
            for (String attrNameOrOID : nameForm.getRequiredAttributes()) {
                requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(attrNameOrOID));
                attrType = existingSchema.getAttributeType(attrNameOrOID);
                if (attrType == null) {
                    if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_UNDEFINED_REQ_ATTR.get(nameFormString, schemaFile.getAbsolutePath(), attrNameOrOID));
                    continue;
                }
                requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(attrType.getOID()));
                for (String name : attrType.getNames()) {
                    requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(name));
                }
                if (structuralClass == null || structuralClass.getRequiredAttributes(existingSchema, true).contains(attrType) || structuralClass.getOptionalAttributes(existingSchema, true).contains(attrType)) continue;
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_REQ_ATTR_NOT_PERMITTED.get(nameFormString, schemaFile.getAbsolutePath(), attrNameOrOID, structuralClassNameOrOID));
            }
            for (String attrNameOrOID : nameForm.getOptionalAttributes()) {
                if (requiredAttrNamesAndOIDs.contains(StaticUtils.toLowerCase(attrNameOrOID))) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_ATTR_REQ_AND_OPT.get(nameFormString, schemaFile.getAbsolutePath(), attrNameOrOID));
                }
                if ((attrType = existingSchema.getAttributeType(attrNameOrOID)) != null || this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_UNDEFINED_OPT_ATTR.get(nameFormString, schemaFile.getAbsolutePath(), attrNameOrOID));
            }
            boolean isDuplicate = false;
            if (!this.allowRedefiningElements) {
                String lowerOID = StaticUtils.toLowerCase(nameForm.getOID());
                NameFormDefinition existingDefinition = nameFormsByNameOrOID.get(lowerOID);
                if (existingDefinition == null) {
                    existingDefinition = existingSchema.getNameFormByName(lowerOID);
                }
                if (existingDefinition != null) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_ALREADY_DEFINED_WITH_OID.get(nameFormString, schemaFile.getAbsolutePath(), existingDefinition.toString()));
                    isDuplicate = true;
                }
                if (!isDuplicate) {
                    for (String name : nameForm.getNames()) {
                        String lowerName = StaticUtils.toLowerCase(name);
                        existingDefinition = nameFormsByNameOrOID.get(lowerName);
                        if (existingDefinition == null) {
                            existingDefinition = existingSchema.getNameFormByName(lowerName);
                        }
                        if (existingDefinition == null) continue;
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_ALREADY_DEFINED_WITH_NAME.get(nameFormString, schemaFile.getAbsolutePath(), name, existingDefinition.toString()));
                        isDuplicate = true;
                        break;
                    }
                }
                if (!isDuplicate && structuralClass != null) {
                    existingDefinition = nameFormsByOC.get(structuralClass);
                    if (existingDefinition == null) {
                        existingDefinition = existingSchema.getNameFormByObjectClass(structuralClassNameOrOID);
                    }
                    if (existingDefinition != null) {
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_NF_ALREADY_DEFINED_WITH_OC.get(nameFormString, schemaFile.getAbsolutePath(), structuralClassNameOrOID, existingDefinition.toString()));
                        isDuplicate = true;
                    }
                }
            }
            if (isDuplicate) continue;
            nameFormsByNameOrOID.put(StaticUtils.toLowerCase(nameForm.getOID()), nameForm);
            for (String name : nameForm.getNames()) {
                nameFormsByNameOrOID.put(StaticUtils.toLowerCase(name), nameForm);
            }
            if (structuralClass == null) continue;
            nameFormsByOC.put(structuralClass, nameForm);
        }
    }

    private void validateDITContentRules(Entry schemaEntry, File schemaFile, Map<String, DITContentRuleDefinition> dcrMap, Schema existingSchema, List<String> errorMessages) {
        for (String dcrString : schemaEntry.getAttributeValues("dITContentRules")) {
            int i$;
            String lowerNameOrOID;
            String description;
            DITContentRuleDefinition dcr;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.DIT_CONTENT_RULE)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), dcrString));
                continue;
            }
            try {
                dcr = new DITContentRuleDefinition(dcrString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_DCR.get(dcrString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            try {
                this.validateOID(dcr.getOID(), dcr.getNames());
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_INVALID_OID.get(dcrString, schemaFile.getAbsolutePath(), e.getMessage()));
            }
            ObjectClassDefinition structuralObjectClass = existingSchema.getObjectClass(dcr.getOID());
            if (structuralObjectClass == null) {
                if (!this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.OBJECT_CLASS)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_UNKNOWN_STRUCTURAL_CLASS.get(dcrString, schemaFile.getAbsolutePath(), dcr.getOID()));
                }
            } else if (structuralObjectClass.getObjectClassType() != null && structuralObjectClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_STRUCTURAL_CLASS_NOT_STRUCTURAL.get(dcrString, schemaFile.getAbsolutePath(), dcr.getOID(), structuralObjectClass.toString()));
            }
            if (dcr.getNames().length == 0 && !this.allowElementsWithoutNames) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_NO_NAME.get(dcrString, schemaFile.getAbsolutePath()));
            }
            for (String name : dcr.getNames()) {
                try {
                    this.validateName(name);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_INVALID_NAME.get(dcrString, schemaFile.getAbsolutePath(), name, e.getMessage()));
                }
            }
            if (!this.allowEmptyDescription && (description = dcr.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_EMPTY_DESCRIPTION.get(dcrString, schemaFile.getAbsolutePath()));
            }
            if (dcr.isObsolete() && !this.allowObsoleteElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_OBSOLETE.get(dcrString, schemaFile.getAbsolutePath()));
            }
            for (String auxClassNameOrOID : dcr.getAuxiliaryClasses()) {
                ObjectClassDefinition auxClass = existingSchema.getObjectClass(auxClassNameOrOID);
                if (auxClass == null) {
                    if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.OBJECT_CLASS)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_UNDEFINED_AUX_CLASS.get(dcrString, schemaFile.getAbsolutePath(), auxClassNameOrOID));
                    continue;
                }
                if (auxClass.getObjectClassType() == ObjectClassType.AUXILIARY) continue;
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_AUX_CLASS_NOT_AUX.get(dcrString, schemaFile.getAbsolutePath(), auxClass.toString()));
            }
            HashSet<String> requiredAttrNamesAndOIDs = new HashSet<String>();
            for (String attrNameOrOID : dcr.getRequiredAttributes()) {
                requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(attrNameOrOID));
                AttributeTypeDefinition at = existingSchema.getAttributeType(attrNameOrOID);
                if (at == null) {
                    if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_UNDEFINED_REQUIRED_ATTR.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID));
                    continue;
                }
                requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(at.getOID()));
                for (String name : at.getNames()) {
                    requiredAttrNamesAndOIDs.add(StaticUtils.toLowerCase(name));
                }
            }
            HashSet<String> optionalAttrNamesAndOIDs = new HashSet<String>();
            for (String attrNameOrOID : dcr.getOptionalAttributes()) {
                AttributeTypeDefinition at;
                lowerNameOrOID = StaticUtils.toLowerCase(attrNameOrOID);
                optionalAttrNamesAndOIDs.add(lowerNameOrOID);
                if (requiredAttrNamesAndOIDs.contains(lowerNameOrOID)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_ATTR_REQ_AND_OPT.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID));
                }
                if ((at = existingSchema.getAttributeType(lowerNameOrOID)) == null) {
                    if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_UNDEFINED_OPTIONAL_ATTR.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID));
                    continue;
                }
                optionalAttrNamesAndOIDs.add(StaticUtils.toLowerCase(at.getOID()));
                String[] arr$ = at.getNames();
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String name = arr$[i$];
                    optionalAttrNamesAndOIDs.add(StaticUtils.toLowerCase(name));
                }
            }
            for (String attrNameOrOID : dcr.getProhibitedAttributes()) {
                AttributeTypeDefinition at;
                lowerNameOrOID = StaticUtils.toLowerCase(attrNameOrOID);
                if (requiredAttrNamesAndOIDs.contains(lowerNameOrOID)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_ATTR_REQ_AND_NOT.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID));
                }
                if (optionalAttrNamesAndOIDs.contains(lowerNameOrOID)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_ATTR_OPT_AND_NOT.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID));
                }
                if ((at = existingSchema.getAttributeType(lowerNameOrOID)) == null) {
                    if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_UNDEFINED_PROHIBITED_ATTR.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID));
                    continue;
                }
                if (structuralObjectClass != null && structuralObjectClass.getRequiredAttributes(existingSchema, true).contains(at)) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_PROHIBITED_ATTR_REQUIRED_BY_STRUCT.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID));
                }
                String[] arr$ = dcr.getAuxiliaryClasses();
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String auxClassNameOrOID = arr$[i$];
                    ObjectClassDefinition auxClass = existingSchema.getObjectClass(auxClassNameOrOID);
                    if (auxClass == null || !auxClass.getRequiredAttributes(existingSchema, true).contains(at)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_PROHIBITED_ATTR_REQUIRED_BY_AUX.get(dcrString, schemaFile.getAbsolutePath(), attrNameOrOID, auxClassNameOrOID));
                }
            }
            boolean isDuplicate = false;
            if (!this.allowRedefiningElements) {
                String lowerOID = StaticUtils.toLowerCase(dcr.getOID());
                DITContentRuleDefinition existingDefinition = dcrMap.get(lowerOID);
                if (existingDefinition == null) {
                    existingDefinition = existingSchema.getDITContentRule(lowerOID);
                }
                if (existingDefinition != null) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_ALREADY_DEFINED_WITH_OID.get(dcrString, schemaFile.getAbsolutePath(), existingDefinition.toString()));
                    isDuplicate = true;
                }
                if (!isDuplicate) {
                    for (String name : dcr.getNames()) {
                        String lowerName = StaticUtils.toLowerCase(name);
                        existingDefinition = dcrMap.get(lowerName);
                        if (existingDefinition == null) {
                            existingDefinition = existingSchema.getDITContentRule(lowerName);
                        }
                        if (existingDefinition == null) continue;
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DCR_ALREADY_DEFINED_WITH_NAME.get(dcrString, schemaFile.getAbsolutePath(), name, existingDefinition.toString()));
                        isDuplicate = true;
                        break;
                    }
                }
            }
            if (isDuplicate) continue;
            dcrMap.put(StaticUtils.toLowerCase(dcr.getOID()), dcr);
            for (String name : dcr.getNames()) {
                dcrMap.put(StaticUtils.toLowerCase(name), dcr);
            }
        }
    }

    private void validateDITStructureRules(Entry schemaEntry, File schemaFile, Map<String, DITStructureRuleDefinition> dsrIDAndNameMap, Map<NameFormDefinition, DITStructureRuleDefinition> dsrNFMap, Schema existingSchema, List<String> errorMessages) {
        for (String dsrString : schemaEntry.getAttributeValues("dITStructureRules")) {
            String nameFormNameOrOID;
            NameFormDefinition nameForm;
            String description;
            DITStructureRuleDefinition dsr;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.DIT_STRUCTURE_RULE)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), dsrString));
                continue;
            }
            try {
                dsr = new DITStructureRuleDefinition(dsrString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_DSR.get(dsrString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            if (dsr.getNames().length == 0 && !this.allowElementsWithoutNames) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_NO_NAME.get(dsrString, schemaFile.getAbsolutePath()));
            }
            for (String name : dsr.getNames()) {
                try {
                    this.validateName(name);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_INVALID_NAME.get(dsrString, schemaFile.getAbsolutePath(), name, e.getMessage()));
                }
            }
            if (!this.allowEmptyDescription && (description = dsr.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_EMPTY_DESCRIPTION.get(dsrString, schemaFile.getAbsolutePath()));
            }
            if (dsr.isObsolete() && !this.allowObsoleteElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_OBSOLETE.get(dsrString, schemaFile.getAbsolutePath()));
            }
            if ((nameForm = existingSchema.getNameFormByName(nameFormNameOrOID = dsr.getNameFormID())) == null && !this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.NAME_FORM)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_UNDEFINED_NF.get(dsrString, schemaFile.getAbsolutePath(), nameFormNameOrOID));
            }
            if (!this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.DIT_STRUCTURE_RULE)) {
                for (int superiorRuleID : dsr.getSuperiorRuleIDs()) {
                    DITStructureRuleDefinition superiorDSR = dsrIDAndNameMap.get(String.valueOf(superiorRuleID));
                    if (superiorDSR != null) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_UNDEFINED_SUP.get(dsrString, schemaFile.getAbsolutePath(), superiorRuleID));
                }
            }
            boolean isDuplicate = false;
            if (!this.allowRedefiningElements) {
                DITStructureRuleDefinition existingDefinition = dsrIDAndNameMap.get(String.valueOf(dsr.getRuleID()));
                if (existingDefinition == null) {
                    existingDefinition = existingSchema.getDITStructureRuleByID(dsr.getRuleID());
                }
                if (existingDefinition != null) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_ALREADY_DEFINED_WITH_ID.get(dsrString, schemaFile.getAbsolutePath(), existingDefinition.toString()));
                    isDuplicate = true;
                }
                if (!isDuplicate) {
                    for (String name : dsr.getNames()) {
                        String lowerName = StaticUtils.toLowerCase(name);
                        existingDefinition = dsrIDAndNameMap.get(lowerName);
                        if (existingDefinition == null) {
                            existingDefinition = existingSchema.getDITStructureRuleByName(lowerName);
                        }
                        if (existingDefinition == null) continue;
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_ALREADY_DEFINED_WITH_NAME.get(dsrString, schemaFile.getAbsolutePath(), name, existingDefinition.toString()));
                        isDuplicate = true;
                        break;
                    }
                }
                if (!isDuplicate && nameForm != null) {
                    existingDefinition = dsrNFMap.get(nameForm);
                    if (existingDefinition == null) {
                        existingDefinition = existingSchema.getDITStructureRuleByNameForm(nameFormNameOrOID);
                    }
                    if (existingDefinition != null) {
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_DSR_ALREADY_DEFINED_WITH_NF.get(dsrString, schemaFile.getAbsolutePath(), nameFormNameOrOID, existingDefinition.toString()));
                        isDuplicate = true;
                    }
                }
            }
            if (isDuplicate) continue;
            dsrIDAndNameMap.put(String.valueOf(dsr.getRuleID()), dsr);
            for (String name : dsr.getNames()) {
                dsrIDAndNameMap.put(StaticUtils.toLowerCase(name), dsr);
            }
            if (nameForm == null) continue;
            dsrNFMap.put(nameForm, dsr);
        }
    }

    private void validateMatchingRuleUses(Entry schemaEntry, File schemaFile, Map<String, MatchingRuleUseDefinition> mruMap, Schema existingSchema, List<String> errorMessages) {
        for (String mruString : schemaEntry.getAttributeValues("matchingRuleUse")) {
            String description;
            MatchingRuleUseDefinition mru;
            if (!this.allowedSchemaElementTypes.contains((Object)SchemaElementType.MATCHING_RULE_USE)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_NOT_ALLOWED.get(schemaFile.getAbsolutePath(), mruString));
                continue;
            }
            try {
                mru = new MatchingRuleUseDefinition(mruString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_CANNOT_PARSE_MRU.get(mruString, schemaFile.getAbsolutePath(), e.getMessage()));
                continue;
            }
            try {
                this.validateOID(mru.getOID(), mru.getNames());
            }
            catch (ParseException e) {
                Debug.debugException(e);
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_INVALID_OID.get(mruString, schemaFile.getAbsolutePath(), e.getMessage()));
            }
            MatchingRuleDefinition matchingRule = this.matchingRuleMap.get(StaticUtils.toLowerCase(mru.getOID()));
            if (matchingRule == null) {
                matchingRule = existingSchema.getMatchingRule(mru.getOID());
            }
            if (matchingRule == null && !this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.MATCHING_RULE)) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_UNDEFINED_MR.get(mruString, schemaFile.getAbsolutePath(), mru.getOID()));
            }
            if (mru.getNames().length == 0 && !this.allowElementsWithoutNames) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_NO_NAME.get(mruString, schemaFile.getAbsolutePath()));
            }
            for (String name : mru.getNames()) {
                try {
                    this.validateName(name);
                }
                catch (ParseException e) {
                    Debug.debugException(e);
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_INVALID_NAME.get(mruString, schemaFile.getAbsolutePath(), name, e.getMessage()));
                }
            }
            if (!this.allowEmptyDescription && (description = mru.getDescription()) != null && description.isEmpty()) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_EMPTY_DESCRIPTION.get(mruString, schemaFile.getAbsolutePath()));
            }
            if (mru.isObsolete() && !this.allowObsoleteElements) {
                errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_OBSOLETE.get(mruString, schemaFile.getAbsolutePath()));
            }
            HashSet<AttributeTypeDefinition> applicableTypes = new HashSet<AttributeTypeDefinition>();
            for (String attrNameOrOID : mru.getApplicableAttributeTypes()) {
                AttributeTypeDefinition at = existingSchema.getAttributeType(attrNameOrOID);
                if (at == null) {
                    if (this.allowReferencesToUndefinedElementTypes.contains((Object)SchemaElementType.ATTRIBUTE_TYPE)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_UNDEFINED_AT.get(mruString, schemaFile.getAbsolutePath(), attrNameOrOID));
                    continue;
                }
                applicableTypes.add(at);
            }
            if (matchingRule != null) {
                for (AttributeTypeDefinition at : existingSchema.getAttributeTypes()) {
                    String subMR;
                    String ordMR;
                    if (applicableTypes.contains(at)) continue;
                    String eqMR = at.getEqualityMatchingRule();
                    if (eqMR != null && matchingRule.hasNameOrOID(eqMR)) {
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_PROHIBITS_AT_EQ.get(at.toString(), eqMR, mruString, schemaFile.getAbsolutePath()));
                    }
                    if ((ordMR = at.getOrderingMatchingRule()) != null && matchingRule.hasNameOrOID(ordMR)) {
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_PROHIBITS_AT_ORD.get(at.toString(), ordMR, mruString, schemaFile.getAbsolutePath()));
                    }
                    if ((subMR = at.getSubstringMatchingRule()) == null || !matchingRule.hasNameOrOID(subMR)) continue;
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_PROHIBITS_AT_SUB.get(at.toString(), subMR, mruString, schemaFile.getAbsolutePath()));
                }
            }
            boolean isDuplicate = false;
            if (!this.allowRedefiningElements) {
                String lowerOID = StaticUtils.toLowerCase(mru.getOID());
                MatchingRuleUseDefinition existingDefinition = mruMap.get(lowerOID);
                if (existingDefinition == null) {
                    existingDefinition = existingSchema.getMatchingRuleUse(lowerOID);
                }
                if (existingDefinition != null) {
                    errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_ALREADY_DEFINED_WITH_OID.get(mruString, schemaFile.getAbsolutePath(), existingDefinition.toString()));
                    isDuplicate = true;
                }
                if (!isDuplicate) {
                    for (String name : mru.getNames()) {
                        String lowerName = StaticUtils.toLowerCase(name);
                        existingDefinition = mruMap.get(lowerName);
                        if (existingDefinition == null) {
                            existingDefinition = existingSchema.getMatchingRuleUse(lowerName);
                        }
                        if (existingDefinition == null) continue;
                        errorMessages.add(SchemaMessages.ERR_SCHEMA_VALIDATOR_MRU_ALREADY_DEFINED_WITH_NAME.get(mruString, schemaFile.getAbsolutePath(), name, existingDefinition.toString()));
                        isDuplicate = true;
                        break;
                    }
                }
            }
            if (isDuplicate) continue;
            mruMap.put(StaticUtils.toLowerCase(mru.getOID()), mru);
            for (String name : mru.getNames()) {
                mruMap.put(StaticUtils.toLowerCase(name), mru);
            }
        }
    }

    private void validateOID(String oid, String[] names) throws ParseException {
        block5: {
            try {
                OID.parseNumericOID(oid, this.useStrictOIDValidation);
            }
            catch (ParseException e) {
                Debug.debugException(e);
                boolean acceptable = false;
                if (this.allowNonNumericOIDsUsingName && names != null) {
                    for (String name : names) {
                        if (!oid.equalsIgnoreCase(name + "-oid")) continue;
                        acceptable = true;
                        break;
                    }
                }
                if (!acceptable && this.allowNonNumericOIDsNotUsingName) {
                    acceptable = true;
                }
                if (acceptable) break block5;
                throw e;
            }
        }
    }

    void validateName(String name) throws ParseException {
        if (name.isEmpty()) {
            throw new ParseException(SchemaMessages.ERR_SCHEMA_VALIDATOR_ELEMENT_NAME_EMPTY.get(), 0);
        }
        char firstChar = name.charAt(0);
        if (!(firstChar >= 'a' && firstChar <= 'z' || firstChar >= 'A' && firstChar <= 'Z')) {
            if (firstChar >= '0' && firstChar <= '9') {
                if (!this.allowNamesWithInitialDigit) {
                    throw new ParseException(SchemaMessages.ERR_SCHEMA_VALIDATOR_ELEMENT_NAME_DOES_NOT_START_WITH_LETTER.get(), 0);
                }
            } else if (firstChar == '-') {
                if (!this.allowNamesWithInitialHyphen) {
                    throw new ParseException(SchemaMessages.ERR_SCHEMA_VALIDATOR_ELEMENT_NAME_DOES_NOT_START_WITH_LETTER.get(), 0);
                }
            } else if (firstChar == '_') {
                if (!this.allowNamesWithUnderscore) {
                    throw new ParseException(SchemaMessages.ERR_SCHEMA_VALIDATOR_ELEMENT_NAME_DOES_NOT_START_WITH_LETTER.get(), 0);
                }
            } else {
                throw new ParseException(SchemaMessages.ERR_SCHEMA_VALIDATOR_ELEMENT_NAME_DOES_NOT_START_WITH_LETTER.get(), 0);
            }
        }
        for (int i = 1; i < name.length(); ++i) {
            char subsequentChar = name.charAt(i);
            if (subsequentChar >= 'a' && subsequentChar <= 'z' || subsequentChar >= 'A' && subsequentChar <= 'Z' || subsequentChar >= '0' && subsequentChar <= '9' || subsequentChar == '-' || subsequentChar == '_' && this.allowNamesWithUnderscore) continue;
            throw new ParseException(SchemaMessages.ERR_SCHEMA_VALIDATOR_ELEMENT_NAME_ILLEGAL_CHARACTER.get(Character.valueOf(subsequentChar), i), i);
        }
    }

    static {
        boolean pingIdentityDSAvailable = false;
        File schemaDir = null;
        try {
            File instanceRootSchemaDir;
            File instanceRoot = InternalSDKHelper.getPingIdentityServerRoot();
            if (instanceRoot != null && new File(instanceRootSchemaDir = StaticUtils.constructPath(instanceRoot, "config", "schema"), "00-core.ldif").exists()) {
                Class.forName("com.unboundid.directory.server.types.Schema");
                pingIdentityDSAvailable = true;
                schemaDir = instanceRootSchemaDir;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE = pingIdentityDSAvailable;
        PING_IDENTITY_DIRECTORY_SERVER_SCHEMA_DIR = schemaDir;
    }
}

