/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.schema.SchemaElementType;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.ldap.sdk.schema.SchemaValidator;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ValidateLDAPSchema
extends CommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private final AtomicReference<String> completionMessage = new AtomicReference();
    private BooleanArgument allowAttributeTypesWithoutSyntax = null;
    private BooleanArgument allowElementsWithoutNames = null;
    private BooleanArgument allowEmptyDescriptions = null;
    private BooleanArgument allowMultipleEntriesPerSchemaFile = null;
    private BooleanArgument allowNonNumericOIDs = null;
    private BooleanArgument allowRedefiningElements = null;
    private BooleanArgument allowSchemaFilesInSubdirectories = null;
    private BooleanArgument allowStructuralObjectClassesWithoutSuperior = null;
    private BooleanArgument rejectAttributeTypesWithoutEqualityMatchingRule = null;
    private BooleanArgument rejectObjectClassesWithMultipleSuperiors = null;
    private BooleanArgument useLenientNameValidation = null;
    private BooleanArgument useLenientOIDValidation = null;
    private FileArgument schemaPath = null;
    private StringArgument allowedElementType = null;
    private StringArgument allowUndefinedElementType = null;
    private StringArgument prohibitedElementType = null;

    public static void main(String ... args) {
        ResultCode resultCode = ValidateLDAPSchema.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        ValidateLDAPSchema tool = new ValidateLDAPSchema(out, err);
        return tool.runTool(args);
    }

    public ValidateLDAPSchema(OutputStream out, OutputStream err) {
        super(out, err);
    }

    @Override
    public String getToolName() {
        return "validate-ldap-schema";
    }

    @Override
    public String getToolDescription() {
        return SchemaMessages.INFO_VALIDATE_SCHEMA_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "5.1.0";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return !SchemaValidator.PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return false;
    }

    @Override
    protected String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    @Override
    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        boolean pingIdentityDSAvailable = SchemaValidator.PING_IDENTITY_DIRECTORY_SERVER_AVAILABLE;
        ArrayList<File> defaultSchemaPaths = new ArrayList<File>(1);
        if (pingIdentityDSAvailable && SchemaValidator.PING_IDENTITY_DIRECTORY_SERVER_SCHEMA_DIR != null) {
            defaultSchemaPaths.add(SchemaValidator.PING_IDENTITY_DIRECTORY_SERVER_SCHEMA_DIR);
        }
        this.schemaPath = new FileArgument(null, "schema-path", true, 0, null, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_SCHEMA_PATH.get(), true, true, false, false, defaultSchemaPaths);
        this.schemaPath.addLongIdentifier("schemaPath", true);
        this.schemaPath.addLongIdentifier("schema-file", true);
        this.schemaPath.addLongIdentifier("schemaFile", true);
        this.schemaPath.addLongIdentifier("schema-directory", true);
        this.schemaPath.addLongIdentifier("schemaDirectory", true);
        this.schemaPath.addLongIdentifier("schema-dir", true);
        this.schemaPath.addLongIdentifier("schemaDir", true);
        this.schemaPath.addLongIdentifier("file", true);
        this.schemaPath.addLongIdentifier("directory", true);
        this.schemaPath.addLongIdentifier("path", true);
        this.schemaPath.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_INPUT.get());
        parser.addArgument(this.schemaPath);
        this.allowMultipleEntriesPerSchemaFile = new BooleanArgument(null, "allow-multiple-entries-per-schema-file", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_MULTIPLE_ENTRIES.get());
        this.allowMultipleEntriesPerSchemaFile.addLongIdentifier("allowMultipleEntriesPerSchemaFile", true);
        this.allowMultipleEntriesPerSchemaFile.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_INPUT.get());
        parser.addArgument(this.allowMultipleEntriesPerSchemaFile);
        this.allowSchemaFilesInSubdirectories = new BooleanArgument(null, "allow-schema-files-in-subdirectories", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_SUB_DIRS.get());
        this.allowSchemaFilesInSubdirectories.addLongIdentifier("allow-schema-files-in-sub-directories", true);
        this.allowSchemaFilesInSubdirectories.addLongIdentifier("allowSchemaFilesInSubDirectories", true);
        this.allowSchemaFilesInSubdirectories.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_INPUT.get());
        parser.addArgument(this.allowSchemaFilesInSubdirectories);
        this.allowedElementType = new StringArgument(null, "allowed-element-type", false, 0, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_PLACEHOLDER_ELEMENT_TYPE.get(), SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOWED_ELEMENT_TYPE.get());
        this.allowedElementType.addLongIdentifier("allowedElementType", true);
        this.allowedElementType.addLongIdentifier("allowed-schema-element-type", true);
        this.allowedElementType.addLongIdentifier("allowedSchemaElementType", true);
        this.allowedElementType.addLongIdentifier("allow-element-type", true);
        this.allowedElementType.addLongIdentifier("allowElementType", true);
        this.allowedElementType.addLongIdentifier("allow-schema-element-type", true);
        this.allowedElementType.addLongIdentifier("allowSchemaElementType", true);
        this.allowedElementType.addLongIdentifier("allowed-element", true);
        this.allowedElementType.addLongIdentifier("allowedElement", true);
        this.allowedElementType.addLongIdentifier("allow-element", true);
        this.allowedElementType.addLongIdentifier("allowElement", true);
        this.allowedElementType.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowedElementType);
        this.prohibitedElementType = new StringArgument(null, "prohibited-element-type", false, 0, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_PLACEHOLDER_ELEMENT_TYPE.get(), SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_PROHIBITED_ELEMENT_TYPE.get());
        this.prohibitedElementType.addLongIdentifier("prohibitedElementType", true);
        this.prohibitedElementType.addLongIdentifier("prohibited-schema-element-type", true);
        this.prohibitedElementType.addLongIdentifier("prohibitedSchemaElementType", true);
        this.prohibitedElementType.addLongIdentifier("prohibit-element-type", true);
        this.prohibitedElementType.addLongIdentifier("prohibitElementType", true);
        this.prohibitedElementType.addLongIdentifier("prohibit-schema-element-type", true);
        this.prohibitedElementType.addLongIdentifier("prohibitSchemaElementType", true);
        this.prohibitedElementType.addLongIdentifier("prohibited-element", true);
        this.prohibitedElementType.addLongIdentifier("prohibitedElement", true);
        this.prohibitedElementType.addLongIdentifier("prohibit-element", true);
        this.prohibitedElementType.addLongIdentifier("prohibitElement", true);
        this.prohibitedElementType.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.prohibitedElementType);
        this.allowRedefiningElements = new BooleanArgument(null, "allow-redefining-elements", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_REDEFINING.get());
        this.allowRedefiningElements.addLongIdentifier("allow-re-defining-elements", true);
        this.allowRedefiningElements.addLongIdentifier("allowRedefiningElements", true);
        this.allowRedefiningElements.addLongIdentifier("allow-redefining-schema-elements", true);
        this.allowRedefiningElements.addLongIdentifier("allow-re-defining-schema-elements", true);
        this.allowRedefiningElements.addLongIdentifier("allowRedefiningSchemaElements", true);
        this.allowRedefiningElements.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowRedefiningElements);
        this.allowUndefinedElementType = new StringArgument(null, "allow-undefined-element-type", false, 0, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_PLACEHOLDER_ELEMENT_TYPE.get(), SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_UNDEFINED.get());
        this.allowUndefinedElementType.addLongIdentifier("allowUndefinedElementType", true);
        this.allowUndefinedElementType.addLongIdentifier("allow-undefined-schema-element-type", true);
        this.allowUndefinedElementType.addLongIdentifier("allowUndefinedSchemaElementType", true);
        this.allowUndefinedElementType.addLongIdentifier("allowed-undefined-element-type", true);
        this.allowUndefinedElementType.addLongIdentifier("allowedUndefinedElementType", true);
        this.allowUndefinedElementType.addLongIdentifier("allowed-undefined-schema-element-type", true);
        this.allowUndefinedElementType.addLongIdentifier("allowedUndefinedSchemaElementType", true);
        this.allowUndefinedElementType.addLongIdentifier("allow-undefined-element", true);
        this.allowUndefinedElementType.addLongIdentifier("allowUndefinedType", true);
        this.allowUndefinedElementType.addLongIdentifier("allow-undefined-type", true);
        this.allowUndefinedElementType.addLongIdentifier("allowUndefinedElement", true);
        this.allowUndefinedElementType.addLongIdentifier("allowed-undefined-element", true);
        this.allowUndefinedElementType.addLongIdentifier("allowedUndefinedType", true);
        this.allowUndefinedElementType.addLongIdentifier("allowed-undefined-type", true);
        this.allowUndefinedElementType.addLongIdentifier("allowedUndefinedElement", true);
        this.allowUndefinedElementType.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowUndefinedElementType);
        this.useLenientOIDValidation = new BooleanArgument(null, "use-lenient-oid-validation", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_LENIENT_OID.get());
        this.useLenientOIDValidation.addLongIdentifier("useLenientOIDValidation", true);
        this.useLenientOIDValidation.addLongIdentifier("allow-lenient-oid-validation", true);
        this.useLenientOIDValidation.addLongIdentifier("allowLenientOIDValidation", true);
        this.useLenientOIDValidation.addLongIdentifier("lenient-oid-validation", true);
        this.useLenientOIDValidation.addLongIdentifier("lenientOIDValidation", true);
        this.useLenientOIDValidation.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.useLenientOIDValidation);
        this.allowNonNumericOIDs = new BooleanArgument(null, "allow-non-numeric-oids", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_NON_NUMERIC_OID.get());
        this.allowNonNumericOIDs.addLongIdentifier("allow-nonnumeric-oids", true);
        this.allowNonNumericOIDs.addLongIdentifier("allowNonNumericOIDs", true);
        this.allowNonNumericOIDs.addLongIdentifier("allow-non-numeric-oid", true);
        this.allowNonNumericOIDs.addLongIdentifier("allow-nonnumeric-oid", true);
        this.allowNonNumericOIDs.addLongIdentifier("allowNonNumericOID", true);
        this.allowNonNumericOIDs.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowNonNumericOIDs);
        this.allowElementsWithoutNames = new BooleanArgument(null, "allow-elements-without-names", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_MISSING_NAME.get());
        this.allowElementsWithoutNames.addLongIdentifier("allowElementsWithoutNames", true);
        this.allowElementsWithoutNames.addLongIdentifier("allow-schema-elements-without-names", true);
        this.allowElementsWithoutNames.addLongIdentifier("allowSchemaElementsWithoutNames", true);
        this.allowElementsWithoutNames.addLongIdentifier("allow-elements-missing-names", true);
        this.allowElementsWithoutNames.addLongIdentifier("allowElementsMissingNames", true);
        this.allowElementsWithoutNames.addLongIdentifier("allow-schema-elements-missing-names", true);
        this.allowElementsWithoutNames.addLongIdentifier("allowSchemaElementsMissingNames", true);
        this.allowElementsWithoutNames.addLongIdentifier("allow-missing-names", true);
        this.allowElementsWithoutNames.addLongIdentifier("allowEMissingNames", true);
        this.allowElementsWithoutNames.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowElementsWithoutNames);
        this.useLenientNameValidation = new BooleanArgument(null, "use-lenient-name-validation", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_LENIENT_NAMES.get());
        this.useLenientNameValidation.addLongIdentifier("useLenientNameValidation", true);
        this.useLenientNameValidation.addLongIdentifier("allow-lenient-name-validation", true);
        this.useLenientNameValidation.addLongIdentifier("allowLenientNameValidation", true);
        this.useLenientNameValidation.addLongIdentifier("lenient-name-validation", true);
        this.useLenientNameValidation.addLongIdentifier("lenientNameValidation", true);
        this.useLenientNameValidation.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.useLenientNameValidation);
        this.allowAttributeTypesWithoutSyntax = new BooleanArgument(null, "allow-attribute-types-without-syntax", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_AT_WITHOUT_SYNTAX.get());
        this.allowAttributeTypesWithoutSyntax.addLongIdentifier("allowAttributeTypesWithoutSyntax", true);
        this.allowAttributeTypesWithoutSyntax.addLongIdentifier("allow-attribute-type-without-syntax", true);
        this.allowAttributeTypesWithoutSyntax.addLongIdentifier("allowAttributeTypeWithoutSyntax", true);
        this.allowAttributeTypesWithoutSyntax.addLongIdentifier("allow-attribute-types-missing-Syntax", true);
        this.allowAttributeTypesWithoutSyntax.addLongIdentifier("allowAttributeTypesMissingSyntax", true);
        this.allowAttributeTypesWithoutSyntax.addLongIdentifier("allow-attribute-type-missing-syntax", true);
        this.allowAttributeTypesWithoutSyntax.addLongIdentifier("allowAttributeTypeMissingSyntax", true);
        this.allowAttributeTypesWithoutSyntax.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowAttributeTypesWithoutSyntax);
        this.rejectAttributeTypesWithoutEqualityMatchingRule = new BooleanArgument(null, "reject-attribute-types-without-equality-matching-rule", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_REJECT_AT_WITHOUT_EQ_MR.get());
        this.rejectAttributeTypesWithoutEqualityMatchingRule.addLongIdentifier("rejectAttributeTypesWithoutEqualityMatchingRule", true);
        this.rejectAttributeTypesWithoutEqualityMatchingRule.addLongIdentifier("reject-attribute-type-without-equality-matching-rule", true);
        this.rejectAttributeTypesWithoutEqualityMatchingRule.addLongIdentifier("rejectAttributeTypeWithoutEqualityMatchingRule", true);
        this.rejectAttributeTypesWithoutEqualityMatchingRule.addLongIdentifier("reject-attribute-types-missing-equality-matching-rule", true);
        this.rejectAttributeTypesWithoutEqualityMatchingRule.addLongIdentifier("rejectAttributeTypesMissingEqualityMatchingRule", true);
        this.rejectAttributeTypesWithoutEqualityMatchingRule.addLongIdentifier("reject-attribute-type-missing-equality-matching-rule", true);
        this.rejectAttributeTypesWithoutEqualityMatchingRule.addLongIdentifier("rejectAttributeTypeMissingEqualityMatchingRule", true);
        this.rejectAttributeTypesWithoutEqualityMatchingRule.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.rejectAttributeTypesWithoutEqualityMatchingRule);
        this.allowStructuralObjectClassesWithoutSuperior = new BooleanArgument(null, "allow-structural-object-classes-without-superior", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_MISSING_MISSING_OC_SUP.get());
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-structural-objectclasses-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allowStructuralObjectClassesWithoutSuperior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-structural-object-class-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-structural-objectclass-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allowStructuralObjectClassWithoutSuperior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-structural-classes-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allowStructuralClassesWithoutSuperior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-structural-class-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allowStructuralClassWithoutSuperior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-object-classes-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-objectclasses-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allowObjectClassesWithoutSuperior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-object-class-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allow-objectclass-without-superior", true);
        this.allowStructuralObjectClassesWithoutSuperior.addLongIdentifier("allowObjectClassWithoutSuperior", true);
        this.allowStructuralObjectClassesWithoutSuperior.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowStructuralObjectClassesWithoutSuperior);
        this.rejectObjectClassesWithMultipleSuperiors = new BooleanArgument(null, "reject-object-classes-with-multiple-superiors", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_REJECT_MULTIPLE_OC_SUP.get());
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("reject-objectclasses-with-multiple-superiors", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("rejectObjectClassesWithMultipleSuperiors", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("reject-object-class-with-multiple-superiors", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("reject-objectclass-with-multiple-superiors", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("rejectObjectClassWithMultipleSuperiors", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("reject-object-classes-with-multiple-superior-classes", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("reject-objectclasses-with-multiple-superior-classes", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("rejectObjectClassesWithMultipleSuperiorClasses", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("reject-object-class-with-multiple-superior-classes", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("reject-objectclass-with-multiple-superior-classes", true);
        this.rejectObjectClassesWithMultipleSuperiors.addLongIdentifier("rejectObjectClassWithMultipleSuperiorClasses", true);
        this.rejectObjectClassesWithMultipleSuperiors.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        if (pingIdentityDSAvailable) {
            this.rejectObjectClassesWithMultipleSuperiors.setHidden(true);
        }
        parser.addArgument(this.rejectObjectClassesWithMultipleSuperiors);
        this.allowEmptyDescriptions = new BooleanArgument(null, "allow-empty-descriptions", 1, SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_DESC_ALLOW_EMPTY_DESC.get());
        this.allowEmptyDescriptions.addLongIdentifier("allowEmptyDescriptions", true);
        this.allowEmptyDescriptions.addLongIdentifier("allow-empty-description", true);
        this.allowEmptyDescriptions.addLongIdentifier("allowEmptyDescription", true);
        this.allowEmptyDescriptions.addLongIdentifier("allow-empty-desc", true);
        this.allowEmptyDescriptions.addLongIdentifier("allowEmptyDESC", true);
        this.allowEmptyDescriptions.setArgumentGroupName(SchemaMessages.INFO_VALIDATE_SCHEMA_ARG_GROUP_VALIDATION.get());
        parser.addArgument(this.allowEmptyDescriptions);
        parser.addExclusiveArgumentSet(this.allowedElementType, this.prohibitedElementType, new Argument[0]);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        if (this.allowedElementType.isPresent()) {
            for (String value : this.allowedElementType.getValues()) {
                if (SchemaElementType.forName(value) != null) continue;
                String message = SchemaMessages.ERR_VALIDATE_SCHEMA_NO_SUCH_ELEMENT_TYPE.get(value, this.allowedElementType.getIdentifierString());
                this.completionMessage.set(message);
                throw new ArgumentException(message);
            }
        }
        if (this.prohibitedElementType.isPresent()) {
            EnumSet<SchemaElementType> allowedTypes = EnumSet.allOf(SchemaElementType.class);
            for (String value : this.prohibitedElementType.getValues()) {
                SchemaElementType type = SchemaElementType.forName(value);
                if (type == null) {
                    String message = SchemaMessages.ERR_VALIDATE_SCHEMA_NO_SUCH_ELEMENT_TYPE.get(value, this.prohibitedElementType.getIdentifierString());
                    this.completionMessage.set(message);
                    throw new ArgumentException(message);
                }
                allowedTypes.remove((Object)type);
            }
            if (allowedTypes.isEmpty()) {
                String message = SchemaMessages.ERR_VALIDATE_SCHEMA_ALL_ELEMENT_TYPES_PROHIBITED.get(this.prohibitedElementType.getIdentifierString());
                this.completionMessage.set(message);
                throw new ArgumentException(message);
            }
        }
        if (this.allowUndefinedElementType.isPresent()) {
            for (String value : this.allowUndefinedElementType.getValues()) {
                if (SchemaElementType.forName(value) != null) continue;
                String message = SchemaMessages.ERR_VALIDATE_SCHEMA_NO_SUCH_ELEMENT_TYPE.get(value, this.allowUndefinedElementType.getIdentifierString());
                this.completionMessage.set(message);
                throw new ArgumentException(message);
            }
        }
    }

    @Override
    public ResultCode doToolProcessing() {
        String finalMessage;
        EnumSet<SchemaElementType> allowedTypes;
        SchemaValidator schemaValidator = new SchemaValidator();
        schemaValidator.setEnsureSchemaEntryIsValid(true);
        schemaValidator.setAllowInvalidObjectClassInheritance(false);
        schemaValidator.setAllowCollectiveAttributes(true);
        schemaValidator.setAllowObsoleteElements(true);
        schemaValidator.setAllowMultipleEntriesPerFile(this.allowMultipleEntriesPerSchemaFile.isPresent());
        schemaValidator.setAllowSchemaFilesInSubDirectories(this.allowSchemaFilesInSubdirectories.isPresent());
        schemaValidator.setAllowRedefiningElements(this.allowRedefiningElements.isPresent());
        schemaValidator.setAllowElementsWithoutNames(this.allowElementsWithoutNames.isPresent());
        schemaValidator.setOIDValidation(this.allowNonNumericOIDs.isPresent(), this.allowNonNumericOIDs.isPresent(), !this.useLenientOIDValidation.isPresent());
        schemaValidator.setAllowNamesWithInitialDigit(this.useLenientNameValidation.isPresent());
        schemaValidator.setAllowNamesWithInitialHyphen(this.useLenientNameValidation.isPresent());
        schemaValidator.setAllowNamesWithUnderscore(this.useLenientNameValidation.isPresent());
        schemaValidator.setAllowEmptyDescription(this.allowEmptyDescriptions.isPresent());
        schemaValidator.setAllowAttributeTypesWithoutSyntax(this.allowAttributeTypesWithoutSyntax.isPresent());
        schemaValidator.setAllowAttributeTypesWithoutEqualityMatchingRule(!this.rejectAttributeTypesWithoutEqualityMatchingRule.isPresent());
        schemaValidator.setAllowStructuralObjectClassWithoutSuperior(this.allowStructuralObjectClassesWithoutSuperior.isPresent());
        schemaValidator.setAllowMultipleSuperiorObjectClasses(!this.rejectObjectClassesWithMultipleSuperiors.isPresent());
        if (this.allowedElementType.isPresent()) {
            allowedTypes = EnumSet.noneOf(SchemaElementType.class);
            for (String value : this.allowedElementType.getValues()) {
                allowedTypes.add(SchemaElementType.forName(value));
            }
            schemaValidator.setAllowedSchemaElementTypes(allowedTypes);
        } else if (this.prohibitedElementType.isPresent()) {
            allowedTypes = EnumSet.allOf(SchemaElementType.class);
            for (String value : this.prohibitedElementType.getValues()) {
                allowedTypes.remove((Object)SchemaElementType.forName(value));
            }
            schemaValidator.setAllowedSchemaElementTypes(allowedTypes);
        }
        if (this.allowUndefinedElementType.isPresent()) {
            EnumSet<SchemaElementType> elementTypes = EnumSet.noneOf(SchemaElementType.class);
            for (String value : this.allowUndefinedElementType.getValues()) {
                elementTypes.add(SchemaElementType.forName(value));
            }
            schemaValidator.setAllowReferencesToUndefinedElementTypes(elementTypes);
        }
        Schema schema = null;
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (File f : this.schemaPath.getValues()) {
            schema = schemaValidator.validateSchema(f, schema, errorMessages);
        }
        int numErrors = errorMessages.size();
        if (numErrors == 0) {
            this.completionMessage.set(SchemaMessages.INFO_VALIDATE_SCHEMA_NO_ERRORS.get());
            this.wrapOut(0, WRAP_COLUMN, SchemaMessages.INFO_VALIDATE_SCHEMA_NO_ERRORS.get());
            return ResultCode.SUCCESS;
        }
        if (numErrors == 1) {
            this.wrapErr(0, WRAP_COLUMN, SchemaMessages.ERR_VALIDATE_SCHEMA_ERROR_FOUND.get());
            finalMessage = SchemaMessages.ERR_VALIDATE_SCHEMA_ONE_ERROR.get();
        } else {
            this.wrapErr(0, WRAP_COLUMN, SchemaMessages.ERR_VALIDATE_SCHEMA_ERRORS_FOUND.get());
            finalMessage = SchemaMessages.ERR_VALIDATE_SCHEMA_MULTIPLE_ERRORS.get(numErrors);
        }
        for (String errorMessage : errorMessages) {
            this.err(new Object[0]);
            boolean firstLine = true;
            for (String line : StaticUtils.wrapLine(errorMessage, WRAP_COLUMN - 2)) {
                if (firstLine) {
                    this.err("* " + line);
                    firstLine = false;
                    continue;
                }
                this.err("  " + line);
            }
        }
        this.completionMessage.set(finalMessage);
        this.err(new Object[0]);
        this.wrapErr(0, WRAP_COLUMN, finalMessage);
        return ResultCode.DECODING_ERROR;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--schema-path", "/path/to/schema"}, SchemaMessages.INFO_VALIDATE_SCHEMA_EXAMPLE_1.get());
        examples.put(new String[]{"--schema-path", "/path/to/schema", "--allow-multiple-entries-per-schema-file", "--allow-schema-files-in-subdirectories", "--allow-redefining-elements", "--allow-undefined-element-type", "attribute-syntax", "--allow-undefined-element-type", "matching-rule", "--use-lenient-oid-validation", "--allow-non-numeric-oids", "--allow-elements-without-names", "--use-lenient-name-validation", "--allow-attribute-types-without-syntax", "--allow-structural-object-classes-without-superior", "--allow-empty-descriptions"}, SchemaMessages.INFO_VALIDATE_SCHEMA_EXAMPLE_2.get());
        return examples;
    }
}

