/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPConnectionHandlerConfiguration
implements Comparable<LDAPConnectionHandlerConfiguration>,
Comparator<LDAPConnectionHandlerConfiguration>,
Serializable {
    private static final String OC_LDAP_CONN_HANDLER = "ds-cfg-ldap-connection-handler";
    private static final String ATTR_ALLOW_START_TLS = "ds-cfg-allow-start-tls";
    private static final String ATTR_ENABLED = "ds-cfg-enabled";
    private static final String ATTR_LISTEN_ADDRESS = "ds-cfg-listen-address";
    private static final String ATTR_LISTEN_PORT = "ds-cfg-listen-port";
    private static final String ATTR_NAME = "cn";
    private static final String ATTR_USE_SSL = "ds-cfg-use-ssl";
    private static final long serialVersionUID = 6824077978334156627L;
    private final boolean isEnabled;
    private final boolean supportsStartTLS;
    private final boolean usesSSL;
    private final int port;
    private final List<String> listenAddresses;
    private final String name;

    LDAPConnectionHandlerConfiguration(String name, boolean isEnabled, List<String> listenAddresses, int port, boolean usesSSL, boolean supportsStartTLS) {
        this.name = name;
        this.isEnabled = isEnabled;
        this.listenAddresses = listenAddresses;
        this.port = port;
        this.usesSSL = usesSSL;
        this.supportsStartTLS = supportsStartTLS;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public List<String> getListenAddresses() {
        return this.listenAddresses;
    }

    public int getPort() {
        return this.port;
    }

    public boolean usesSSL() {
        return this.usesSSL;
    }

    public boolean supportsStartTLS() {
        return this.supportsStartTLS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LDAPConnectionHandlerConfiguration> readConfiguration(File configFile, boolean onlyEnabled) throws LDAPException {
        try (LDIFReader ldifReader = new LDIFReader(configFile);){
            ArrayList<LDAPConnectionHandlerConfiguration> configs = new ArrayList<LDAPConnectionHandlerConfiguration>();
            while (true) {
                List<String> listenAddresses;
                boolean supportsStartTLS;
                boolean usesSSL;
                Integer port;
                boolean isEnabled;
                String name;
                block28: {
                    int len$;
                    String[] arr$;
                    LinkedHashSet<String> s;
                    block29: {
                        block25: {
                            Object entry;
                            block26: {
                                String[] addressArray;
                                block27: {
                                    block24: {
                                        try {
                                            entry = ldifReader.readEntry();
                                        }
                                        catch (LDIFException e) {
                                            Debug.debugException(e);
                                            if (e.mayContinueReading()) continue;
                                            throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_LDAP_HANDLER_CANNOT_READ_CONFIG.get(configFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                                        }
                                        if (entry != null) break block24;
                                        if (configs.size() > 1) break block25;
                                        break block26;
                                    }
                                    if (!((Entry)entry).hasObjectClass(OC_LDAP_CONN_HANDLER) || (name = ((Entry)entry).getAttributeValue(ATTR_NAME)) == null || !(isEnabled = ((Entry)entry).hasAttributeValue(ATTR_ENABLED, "true")) && onlyEnabled || (port = ((Entry)entry).getAttributeValueAsInteger(ATTR_LISTEN_PORT)) == null || port < 1 || port > 65535) continue;
                                    usesSSL = ((Entry)entry).hasAttributeValue(ATTR_USE_SSL, "true");
                                    supportsStartTLS = usesSSL ? false : ((Entry)entry).hasAttributeValue(ATTR_ALLOW_START_TLS, "true");
                                    addressArray = ((Entry)entry).getAttributeValues(ATTR_LISTEN_ADDRESS);
                                    if (addressArray != null) break block27;
                                    listenAddresses = Collections.emptyList();
                                    break block28;
                                }
                                s = new LinkedHashSet<String>();
                                arr$ = addressArray;
                                len$ = arr$.length;
                                break block29;
                            }
                            entry = Collections.unmodifiableList(configs);
                            return entry;
                        }
                        TreeSet<LDAPConnectionHandlerConfiguration> configSet = new TreeSet<LDAPConnectionHandlerConfiguration>((Comparator)configs.get(0));
                        configSet.addAll(configs);
                        List<LDAPConnectionHandlerConfiguration> list = Collections.unmodifiableList(new ArrayList(configSet));
                        return list;
                    }
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String address = arr$[i$];
                        try {
                            InetAddress a = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getByName(address);
                            if (a.isAnyLocalAddress()) {
                                continue;
                            }
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                        s.add(address);
                    }
                    listenAddresses = Collections.unmodifiableList(new ArrayList(s));
                }
                configs.add(new LDAPConnectionHandlerConfiguration(name, isEnabled, listenAddresses, port, usesSSL, supportsStartTLS));
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UnboundIDDSMessages.ERR_LDAP_HANDLER_CANNOT_READ_CONFIG.get(configFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
        }
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LDAPConnectionHandlerConfiguration)) {
            return false;
        }
        LDAPConnectionHandlerConfiguration c = (LDAPConnectionHandlerConfiguration)o;
        return this.name.equalsIgnoreCase(c.name) && this.isEnabled == c.isEnabled && this.listenAddresses.equals(c.listenAddresses) && this.port == c.port && this.usesSSL == c.usesSSL && this.supportsStartTLS == c.supportsStartTLS;
    }

    @Override
    public int compareTo(LDAPConnectionHandlerConfiguration config) {
        if (config == null) {
            return -1;
        }
        if (this.isEnabled != config.isEnabled) {
            if (this.isEnabled) {
                return -1;
            }
            return 1;
        }
        if (this.usesSSL != config.usesSSL) {
            if (this.usesSSL) {
                return -1;
            }
            return 1;
        }
        if (this.supportsStartTLS != config.supportsStartTLS) {
            if (this.supportsStartTLS) {
                return -1;
            }
            return 1;
        }
        if (!this.name.equalsIgnoreCase(config.name)) {
            if (this.usesSSL) {
                if (this.name.equalsIgnoreCase("LDAPS Connection Handler")) {
                    return -1;
                }
                if (config.name.equalsIgnoreCase("LDAPS Connection Handler")) {
                    return 1;
                }
            } else {
                if (this.name.equalsIgnoreCase("LDAP Connection Handler")) {
                    return -1;
                }
                if (config.name.equalsIgnoreCase("LDAP Connection Handler")) {
                    return 1;
                }
            }
        }
        if (!this.listenAddresses.equals(config.listenAddresses)) {
            if (this.listenAddresses.isEmpty()) {
                return -1;
            }
            if (config.listenAddresses.isEmpty()) {
                return 1;
            }
        }
        if (this.port != config.port) {
            if (this.port < config.port) {
                return -1;
            }
            return 1;
        }
        return this.name.toLowerCase().compareTo(config.name.toLowerCase());
    }

    @Override
    public int compare(LDAPConnectionHandlerConfiguration c1, LDAPConnectionHandlerConfiguration c2) {
        return c1.compareTo(c2);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPConnectionHandlerConfiguration(name='");
        buffer.append(this.name);
        buffer.append("', isEnabled=");
        buffer.append(this.isEnabled);
        buffer.append(", usesSSL=");
        buffer.append(this.usesSSL);
        buffer.append(", supportsStartTLS=");
        buffer.append(this.supportsStartTLS);
        buffer.append(", listenAddresses={");
        Iterator<String> iterator = this.listenAddresses.iterator();
        while (iterator.hasNext()) {
            buffer.append(" '");
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(" }, listenPort=");
        buffer.append(this.port);
        buffer.append(')');
    }
}

