/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.PasswordPolicyStateJSONField;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityError;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityNotice;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityWarning;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordPolicyStateJSON
implements Serializable {
    public static final String PASSWORD_POLICY_STATE_JSON_ATTRIBUTE = "ds-pwp-state-json";
    private static final String USABILITY_FIELD_MESSAGE = "message";
    private static final String USABILITY_FIELD_TYPE_ID = "type-id";
    private static final String USABILITY_FIELD_TYPE_NAME = "type-name";
    private static final long serialVersionUID = -3953182526241789456L;
    private final JSONObject passwordPolicyStateObject;

    public PasswordPolicyStateJSON(JSONObject passwordPolicyStateObject) {
        this.passwordPolicyStateObject = passwordPolicyStateObject;
    }

    public static PasswordPolicyStateJSON get(LDAPInterface connection, String userDN) throws LDAPException {
        SearchResultEntry userEntry = connection.getEntry(userDN, PASSWORD_POLICY_STATE_JSON_ATTRIBUTE);
        if (userEntry == null) {
            throw new LDAPException(ResultCode.NO_SUCH_OBJECT, UnboundIDDSMessages.ERR_PW_POLICY_STATE_JSON_GET_NO_SUCH_USER.get(userDN));
        }
        return PasswordPolicyStateJSON.get(userEntry);
    }

    public static PasswordPolicyStateJSON get(Entry userEntry) throws LDAPException {
        JSONObject jsonObject;
        String valueString = userEntry.getAttributeValue(PASSWORD_POLICY_STATE_JSON_ATTRIBUTE);
        if (valueString == null) {
            return null;
        }
        try {
            jsonObject = new JSONObject(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_PW_POLICY_STATE_JSON_GET_CANNOT_DECODE.get(PASSWORD_POLICY_STATE_JSON_ATTRIBUTE, userEntry.getDN()), e);
        }
        return new PasswordPolicyStateJSON(jsonObject);
    }

    public JSONObject getPasswordPolicyStateJSONObject() {
        return this.passwordPolicyStateObject;
    }

    public String getPasswordPolicyDN() {
        return this.passwordPolicyStateObject.getFieldAsString(PasswordPolicyStateJSONField.PASSWORD_POLICY_DN.getFieldName());
    }

    public Boolean getAccountIsUsable() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_USABLE.getFieldName());
    }

    public List<PasswordPolicyStateAccountUsabilityError> getAccountUsabilityErrors() {
        ArrayList<PasswordPolicyStateAccountUsabilityError> errors = new ArrayList<PasswordPolicyStateAccountUsabilityError>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.ACCOUNT_USABILITY_ERRORS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                if (!(v instanceof JSONObject)) continue;
                JSONObject o = (JSONObject)v;
                String typeName = o.getFieldAsString(USABILITY_FIELD_TYPE_NAME);
                Integer typeID = o.getFieldAsInteger(USABILITY_FIELD_TYPE_ID);
                String message = o.getFieldAsString(USABILITY_FIELD_MESSAGE);
                if (typeName == null || typeID == null) continue;
                errors.add(new PasswordPolicyStateAccountUsabilityError(typeID, typeName, message));
            }
        }
        return Collections.unmodifiableList(errors);
    }

    public List<PasswordPolicyStateAccountUsabilityWarning> getAccountUsabilityWarnings() {
        ArrayList<PasswordPolicyStateAccountUsabilityWarning> warnings = new ArrayList<PasswordPolicyStateAccountUsabilityWarning>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.ACCOUNT_USABILITY_WARNINGS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                if (!(v instanceof JSONObject)) continue;
                JSONObject o = (JSONObject)v;
                String typeName = o.getFieldAsString(USABILITY_FIELD_TYPE_NAME);
                Integer typeID = o.getFieldAsInteger(USABILITY_FIELD_TYPE_ID);
                String message = o.getFieldAsString(USABILITY_FIELD_MESSAGE);
                if (typeName == null || typeID == null) continue;
                warnings.add(new PasswordPolicyStateAccountUsabilityWarning(typeID, typeName, message));
            }
        }
        return Collections.unmodifiableList(warnings);
    }

    public List<PasswordPolicyStateAccountUsabilityNotice> getAccountUsabilityNotices() {
        ArrayList<PasswordPolicyStateAccountUsabilityNotice> notices = new ArrayList<PasswordPolicyStateAccountUsabilityNotice>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.ACCOUNT_USABILITY_NOTICES.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                if (!(v instanceof JSONObject)) continue;
                JSONObject o = (JSONObject)v;
                String typeName = o.getFieldAsString(USABILITY_FIELD_TYPE_NAME);
                Integer typeID = o.getFieldAsInteger(USABILITY_FIELD_TYPE_ID);
                String message = o.getFieldAsString(USABILITY_FIELD_MESSAGE);
                if (typeName == null || typeID == null) continue;
                notices.add(new PasswordPolicyStateAccountUsabilityNotice(typeID, typeName, message));
            }
        }
        return Collections.unmodifiableList(notices);
    }

    public Boolean getHasStaticPassword() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_STATIC_PASSWORD.getFieldName());
    }

    public Date getPasswordChangedTime() {
        return this.getDate(PasswordPolicyStateJSONField.PASSWORD_CHANGED_TIME);
    }

    public Integer getSecondsSincePasswordChange() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_PASSWORD_CHANGE.getFieldName());
    }

    public Boolean getAccountIsDisabled() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_DISABLED.getFieldName());
    }

    public Boolean getAccountIsNotYetActive() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_NOT_YET_ACTIVE.getFieldName());
    }

    public Date getAccountActivationTime() {
        return this.getDate(PasswordPolicyStateJSONField.ACCOUNT_ACTIVATION_TIME);
    }

    public Integer getSecondsUntilAccountActivation() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_ACCOUNT_ACTIVATION.getFieldName());
    }

    public Integer getSecondsSinceAccountActivation() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_ACCOUNT_ACTIVATION.getFieldName());
    }

    public Boolean getAccountIsExpired() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_EXPIRED.getFieldName());
    }

    public Date getAccountExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.ACCOUNT_EXPIRATION_TIME);
    }

    public Integer getSecondsUntilAccountExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_ACCOUNT_EXPIRATION.getFieldName());
    }

    public Integer getSecondsSinceAccountExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_ACCOUNT_EXPIRATION.getFieldName());
    }

    public Boolean getPasswordIsExpired() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.PASSWORD_IS_EXPIRED.getFieldName());
    }

    public Integer getMaximumPasswordAgeSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_AGE_SECONDS.getFieldName());
    }

    public Date getPasswordExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_TIME);
    }

    public Integer getSecondsUntilPasswordExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_PASSWORD_EXPIRATION.getFieldName());
    }

    public Integer getSecondsSincePasswordExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_PASSWORD_EXPIRATION.getFieldName());
    }

    public Integer getPasswordExpirationWarningIntervalSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNING_INTERVAL_SECONDS.getFieldName());
    }

    public Boolean getExpirePasswordsWithoutWarning() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.EXPIRE_PASSWORDS_WITHOUT_WARNING.getFieldName());
    }

    public Boolean getPasswordExpirationWarningIssued() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNING_ISSUED.getFieldName());
    }

    public Date getPasswordExpirationWarningTime() {
        return this.getDate(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNING_TIME);
    }

    public Integer getSecondsUntilPasswordExpirationWarning() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING.getFieldName());
    }

    public Integer getSecondsSincePasswordExpirationWarning() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_PASSWORD_EXPIRATION_WARNING.getFieldName());
    }

    public Boolean getAccountIsFailureLocked() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_FAILURE_LOCKED.getFieldName());
    }

    public Integer getFailureLockoutCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_COUNT.getFieldName());
    }

    public Integer getCurrentAuthenticationFailureCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.CURRENT_AUTHENTICATION_FAILURE_COUNT.getFieldName());
    }

    public Integer getRemainingAuthenticationFailureCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.REMAINING_AUTHENTICATION_FAILURE_COUNT.getFieldName());
    }

    public List<Date> getAuthenticationFailureTimes() {
        ArrayList<Date> authFailureTimes = new ArrayList<Date>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.AUTHENTICATION_FAILURE_TIMES.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    String valueString = ((JSONString)v).stringValue();
                    authFailureTimes.add(StaticUtils.decodeRFC3339Time(valueString));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(authFailureTimes);
    }

    public Date getFailureLockoutTime() {
        return this.getDate(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_TIME);
    }

    public Integer getFailureLockoutDurationSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_DURATION_SECONDS.getFieldName());
    }

    public Date getFailureLockoutExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_EXPIRATION_TIME);
    }

    public Integer getSecondsRemainingInFailureLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_REMAINING_IN_FAILURE_LOCKOUT.getFieldName());
    }

    public Date getLastLoginTime() {
        return this.getDate(PasswordPolicyStateJSONField.LAST_LOGIN_TIME);
    }

    public Integer getSecondsSinceLastLogin() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_LAST_LOGIN.getFieldName());
    }

    public String getLastLoginIPAddress() {
        return this.passwordPolicyStateObject.getFieldAsString(PasswordPolicyStateJSONField.LAST_LOGIN_IP_ADDRESS.getFieldName());
    }

    public Boolean getAccountIsIdleLocked() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_IDLE_LOCKED.getFieldName());
    }

    public Integer getIdleLockoutIntervalSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.IDLE_LOCKOUT_INTERVAL_SECONDS.getFieldName());
    }

    public Date getIdleLockoutTime() {
        return this.getDate(PasswordPolicyStateJSONField.IDLE_LOCKOUT_TIME);
    }

    public Integer getSecondsUntilIdleLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_IDLE_LOCKOUT.getFieldName());
    }

    public Integer getSecondsSinceIdleLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_IDLE_LOCKOUT.getFieldName());
    }

    public Boolean getMustChangePassword() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.MUST_CHANGE_PASSWORD.getFieldName());
    }

    public Boolean getAccountIsResetLocked() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_RESET_LOCKED.getFieldName());
    }

    public Boolean getForceChangeOnAdd() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.FORCE_CHANGE_ON_ADD.getFieldName());
    }

    public Boolean getForceChangeOnReset() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.FORCE_CHANGE_ON_RESET.getFieldName());
    }

    public Integer getMaximumPasswordResetAgeSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_RESET_AGE_SECONDS.getFieldName());
    }

    public Date getResetLockoutTime() {
        return this.getDate(PasswordPolicyStateJSONField.RESET_LOCKOUT_TIME);
    }

    public Integer getSecondsUntilResetLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_RESET_LOCKOUT.getFieldName());
    }

    public Integer getMaximumPasswordHistoryCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_HISTORY_COUNT.getFieldName());
    }

    public Integer getMaximumPasswordHistoryDurationSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_HISTORY_DURATION_SECONDS.getFieldName());
    }

    public Integer getCurrentPasswordHistoryCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.CURRENT_PASSWORD_HISTORY_COUNT.getFieldName());
    }

    public Boolean getIsWithinMinimumPasswordAge() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.IS_WITHIN_MINIMUM_PASSWORD_AGE.getFieldName());
    }

    public Integer getMinimumPasswordAgeSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MINIMUM_PASSWORD_AGE_SECONDS.getFieldName());
    }

    public Date getMinimumPasswordAgeExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.MINIMUM_PASSWORD_AGE_EXPIRATION_TIME);
    }

    public Integer getSecondsRemainingInMinimumPasswordAge() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_REMAINING_IN_MINIMUM_PASSWORD_AGE.getFieldName());
    }

    public Integer getMaximumGraceLoginCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_GRACE_LOGIN_COUNT.getFieldName());
    }

    public Integer getUsedGraceLoginCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.USED_GRACE_LOGIN_COUNT.getFieldName());
    }

    public Integer getRemainingGraceLoginCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.REMAINING_GRACE_LOGIN_COUNT.getFieldName());
    }

    public List<Date> getGraceLoginUseTimes() {
        ArrayList<Date> graceLoginTimes = new ArrayList<Date>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.GRACE_LOGIN_USE_TIMES.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    String valueString = ((JSONString)v).stringValue();
                    graceLoginTimes.add(StaticUtils.decodeRFC3339Time(valueString));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(graceLoginTimes);
    }

    public Boolean getHasRetiredPassword() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_RETIRED_PASSWORD.getFieldName());
    }

    public Date getRetiredPasswordExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.RETIRED_PASSWORD_EXPIRATION_TIME);
    }

    public Integer getSecondsUntilRetiredPasswordExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_RETIRED_PASSWORD_EXPIRATION.getFieldName());
    }

    public Boolean getRequireSecureAuthentication() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.REQUIRE_SECURE_AUTHENTICATION.getFieldName());
    }

    public Boolean getRequireSecurePasswordChanges() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.REQUIRE_SECURE_PASSWORD_CHANGES.getFieldName());
    }

    public List<String> getAvailableSASLMechanisms() {
        ArrayList<String> saslMechanismNames = new ArrayList<String>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.AVAILABLE_SASL_MECHANISMS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    saslMechanismNames.add(((JSONString)v).stringValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(saslMechanismNames);
    }

    public List<String> getAvailableOTPDeliveryMechanisms() {
        ArrayList<String> deliveryMechanismNames = new ArrayList<String>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.AVAILABLE_OTP_DELIVERY_MECHANISMS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    deliveryMechanismNames.add(((JSONString)v).stringValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(deliveryMechanismNames);
    }

    public Boolean getHasTOTPSharedSecret() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_TOTP_SHARED_SECRET.getFieldName());
    }

    public Boolean getHasRegisteredYubiKeyOTPDevice() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_REGISTERED_YUBIKEY_OTP_DEVICE.getFieldName());
    }

    private Date getDate(PasswordPolicyStateJSONField field) {
        String stringValue = this.passwordPolicyStateObject.getFieldAsString(field.getFieldName());
        if (stringValue == null) {
            return null;
        }
        try {
            return StaticUtils.decodeRFC3339Time(stringValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public String toString() {
        return this.passwordPolicyStateObject.toSingleLineString();
    }
}

