/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.DiskSpaceInfo;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DiskSpaceUsageMonitorEntry
extends MonitorEntry {
    static final String DISK_SPACE_USAGE_MONITOR_OC = "ds-disk-space-usage-monitor-entry";
    private static final String ATTR_CURRENT_STATE = "current-disk-space-state";
    private static final String ATTR_PREFIX_CONSUMER_NAME = "disk-space-consumer-name-";
    private static final String ATTR_PREFIX_CONSUMER_PATH = "disk-space-consumer-path-";
    private static final String ATTR_PREFIX_CONSUMER_TOTAL_BYTES = "disk-space-consumer-total-bytes-";
    private static final String ATTR_PREFIX_CONSUMER_USABLE_BYTES = "disk-space-consumer-usable-bytes-";
    private static final String ATTR_PREFIX_CONSUMER_USABLE_PERCENT = "disk-space-consumer-usable-percent-";
    private static final long serialVersionUID = -4717940564786806566L;
    private final List<DiskSpaceInfo> diskSpaceInfo;
    private final String currentState = this.getString("current-disk-space-state");

    public DiskSpaceUsageMonitorEntry(Entry entry) {
        super(entry);
        String name;
        int i = 1;
        ArrayList<DiskSpaceInfo> list = new ArrayList<DiskSpaceInfo>(5);
        while ((name = this.getString(ATTR_PREFIX_CONSUMER_NAME + i)) != null) {
            String path = this.getString(ATTR_PREFIX_CONSUMER_PATH + i);
            Long totalBytes = this.getLong(ATTR_PREFIX_CONSUMER_TOTAL_BYTES + i);
            Long usableBytes = this.getLong(ATTR_PREFIX_CONSUMER_USABLE_BYTES + i);
            Long usablePercent = this.getLong(ATTR_PREFIX_CONSUMER_USABLE_PERCENT + i);
            list.add(new DiskSpaceInfo(name, path, totalBytes, usableBytes, usablePercent));
            ++i;
        }
        this.diskSpaceInfo = Collections.unmodifiableList(list);
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public List<DiskSpaceInfo> getDiskSpaceInfo() {
        return this.diskSpaceInfo;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_DISK_SPACE_USAGE_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_DISK_SPACE_USAGE_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(10));
        if (this.currentState != null) {
            DiskSpaceUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_STATE, MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_CURRENT_STATE.get(), MonitorMessages.INFO_DISK_SPACE_USAGE_DESC_CURRENT_STATE.get(), this.currentState);
        }
        if (!this.diskSpaceInfo.isEmpty()) {
            int i = 1;
            for (DiskSpaceInfo info : this.diskSpaceInfo) {
                if (info.getConsumerName() != null) {
                    DiskSpaceUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_PREFIX_CONSUMER_NAME + i, MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_DISK_SPACE_CONSUMER_PREFIX.get() + ' ' + i + ' ' + MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_NAME_SUFFIX.get(), MonitorMessages.INFO_DISK_SPACE_USAGE_DESC_NAME.get(), info.getConsumerName());
                }
                if (info.getPath() != null) {
                    DiskSpaceUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_PREFIX_CONSUMER_PATH + i, MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_DISK_SPACE_CONSUMER_PREFIX.get() + ' ' + i + ' ' + MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_PATH_SUFFIX.get(), MonitorMessages.INFO_DISK_SPACE_USAGE_DESC_PATH.get(), info.getPath());
                }
                if (info.getTotalBytes() != null) {
                    DiskSpaceUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_PREFIX_CONSUMER_TOTAL_BYTES + i, MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_DISK_SPACE_CONSUMER_PREFIX.get() + ' ' + i + ' ' + MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_TOTAL_BYTES_SUFFIX.get(), MonitorMessages.INFO_DISK_SPACE_USAGE_DESC_TOTAL_BYTES.get(), info.getTotalBytes());
                }
                if (info.getUsableBytes() != null) {
                    DiskSpaceUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_PREFIX_CONSUMER_USABLE_BYTES + i, MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_DISK_SPACE_CONSUMER_PREFIX.get() + ' ' + i + ' ' + MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_USABLE_BYTES_SUFFIX.get(), MonitorMessages.INFO_DISK_SPACE_USAGE_DESC_USABLE_BYTES.get(), info.getUsableBytes());
                }
                if (info.getUsableBytes() != null) {
                    DiskSpaceUsageMonitorEntry.addMonitorAttribute(attrs, ATTR_PREFIX_CONSUMER_USABLE_PERCENT + i, MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_DISK_SPACE_CONSUMER_PREFIX.get() + ' ' + i + ' ' + MonitorMessages.INFO_DISK_SPACE_USAGE_DISPNAME_USABLE_PERCENT_SUFFIX.get(), MonitorMessages.INFO_DISK_SPACE_USAGE_DESC_USABLE_PERCENT.get(), info.getUsablePercent());
                }
                ++i;
            }
        }
        return Collections.unmodifiableMap(attrs);
    }
}

