/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DurationArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GenerateServerProfileTask
extends Task {
    static final String GENERATE_SERVER_PROFILE_TASK_CLASS = "com.unboundid.directory.server.tasks.GenerateServerProfileTask";
    private static final String ATTR_INCLUDE_PATH = "ds-task-generate-server-profile-include-path";
    private static final String ATTR_PROFILE_ROOT = "ds-task-generate-server-profile-root";
    private static final String ATTR_RETAIN_AGE = "ds-task-generate-server-profile-retain-age";
    private static final String ATTR_RETAIN_COUNT = "ds-task-generate-server-profile-retain-count";
    private static final String ATTR_ZIP = "ds-task-generate-server-profile-zip";
    private static final String OC_GENERATE_SERVER_PROFILE_TASK = "ds-task-generate-server-profile";
    private static final TaskProperty PROPERTY_INCLUDE_PATH = new TaskProperty("ds-task-generate-server-profile-include-path", TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DISPLAY_NAME_INCLUDE_PATH.get(), TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DESCRIPTION_INCLUDE_PATH.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_PROFILE_ROOT = new TaskProperty("ds-task-generate-server-profile-root", TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DISPLAY_NAME_PROFILE_ROOT.get(), TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DESCRIPTION_PROFILE_ROOT.get(), String.class, false, false, false);
    static final TaskProperty PROPERTY_RETAIN_AGE = new TaskProperty("ds-task-generate-server-profile-retain-age", TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DISPLAY_NAME_RETAIN_AGE.get(), TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DESCRIPTION_RETAIN_AGE.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_RETAIN_COUNT = new TaskProperty("ds-task-generate-server-profile-retain-count", TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DISPLAY_NAME_RETAIN_COUNT.get(), TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DESCRIPTION_RETAIN_COUNT.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_ZIP = new TaskProperty("ds-task-generate-server-profile-zip", TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DISPLAY_NAME_ZIP.get(), TaskMessages.INFO_GENERATE_SERVER_PROFILE_ATTR_DESCRIPTION_ZIP.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = -6569877503912024942L;
    private final Boolean zipProfile;
    private final Integer retainCount;
    private final List<String> includePaths;
    private final String profileRoot;
    private final String retainAge;

    public GenerateServerProfileTask() {
        this.zipProfile = null;
        this.includePaths = null;
        this.profileRoot = null;
        this.retainCount = null;
        this.retainAge = null;
    }

    public GenerateServerProfileTask(String taskID, String profileRoot, List<String> includePaths, Boolean zipProfile, Integer retainCount, Long retainAgeMillis) {
        this(taskID, profileRoot, includePaths, zipProfile, retainCount, retainAgeMillis, null, null, null, null, null, null, null, null, null, null);
    }

    public GenerateServerProfileTask(String taskID, String profileRoot, List<String> includePaths, Boolean zipProfile, Integer retainCount, Long retainAgeMillis, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) {
        super(taskID, GENERATE_SERVER_PROFILE_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.profileRoot = profileRoot;
        this.zipProfile = zipProfile;
        this.retainCount = retainCount;
        this.includePaths = includePaths == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(includePaths));
        this.retainAge = retainAgeMillis == null ? null : DurationArgument.nanosToDuration(TimeUnit.MILLISECONDS.toNanos(retainAgeMillis));
    }

    public GenerateServerProfileTask(Entry entry) throws TaskException {
        super(entry);
        this.profileRoot = entry.getAttributeValue(ATTR_PROFILE_ROOT);
        this.zipProfile = entry.getAttributeValueAsBoolean(ATTR_ZIP);
        this.retainCount = entry.getAttributeValueAsInteger(ATTR_RETAIN_COUNT);
        String[] includePathValues = entry.getAttributeValues(ATTR_INCLUDE_PATH);
        this.includePaths = includePathValues == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(includePathValues));
        this.retainAge = entry.getAttributeValue(ATTR_RETAIN_AGE);
        if (this.retainAge != null) {
            try {
                DurationArgument.parseDuration(this.retainAge, TimeUnit.MILLISECONDS);
            }
            catch (ArgumentException e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_GENERATE_SERVER_PROFILE_ENTRY_INVALID_RETAIN_AGE.get(entry.getDN(), this.retainAge, e.getMessage()), e);
            }
        }
    }

    public GenerateServerProfileTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(GENERATE_SERVER_PROFILE_TASK_CLASS, properties);
        Boolean zip = null;
        Long rCount = null;
        String profRoot = null;
        String rAge = null;
        ArrayList<String> incPaths = new ArrayList<String>();
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_PROFILE_ROOT)) {
                profRoot = GenerateServerProfileTask.parseString(p, values, null);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_PATH)) {
                String[] pathArray = GenerateServerProfileTask.parseStrings(p, values, null);
                if (pathArray == null) continue;
                incPaths.addAll(Arrays.asList(pathArray));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ZIP)) {
                zip = GenerateServerProfileTask.parseBoolean(p, values, null);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_RETAIN_COUNT)) {
                rCount = GenerateServerProfileTask.parseLong(p, values, null);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_RETAIN_AGE)) continue;
            rAge = GenerateServerProfileTask.parseString(p, values, null);
            try {
                DurationArgument.parseDuration(rAge, TimeUnit.MILLISECONDS);
            }
            catch (ArgumentException e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_GENERATE_SERVER_PROFILE_PROPS_INVALID_RETAIN_AGE.get(rAge, e.getMessage()));
            }
        }
        this.profileRoot = profRoot;
        this.includePaths = incPaths;
        this.zipProfile = zip;
        this.retainAge = rAge;
        this.retainCount = rCount == null ? null : Integer.valueOf(rCount.intValue());
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_GENERATE_SERVER_PROFILE.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_GENERATE_SERVER_PROFILE.get();
    }

    public String getProfileRoot() {
        return this.profileRoot;
    }

    public List<String> getIncludePaths() {
        return this.includePaths;
    }

    public Boolean getZipProfile() {
        return this.zipProfile;
    }

    public Integer getRetainCount() {
        return this.retainCount;
    }

    public String getRetainAge() {
        return this.retainAge;
    }

    public Long getRetainAgeMillis() throws TaskException {
        if (this.retainAge == null) {
            return null;
        }
        try {
            return DurationArgument.parseDuration(this.retainAge, TimeUnit.MILLISECONDS);
        }
        catch (ArgumentException e) {
            Debug.debugException(e);
            throw new TaskException(TaskMessages.ERR_GENERATE_SERVER_PROFILE_CANNOT_PARSE_RETAIN_AGE.get(this.retainAge, e.getMessage()), e);
        }
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_GENERATE_SERVER_PROFILE_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(5);
        if (this.profileRoot != null) {
            attrList.add(new Attribute(ATTR_PROFILE_ROOT, this.profileRoot));
        }
        if (!this.includePaths.isEmpty()) {
            attrList.add(new Attribute(ATTR_INCLUDE_PATH, this.includePaths));
        }
        if (this.zipProfile != null) {
            attrList.add(new Attribute(ATTR_ZIP, this.zipProfile.toString()));
        }
        if (this.retainCount != null) {
            attrList.add(new Attribute(ATTR_RETAIN_COUNT, String.valueOf(this.retainCount)));
        }
        if (this.retainAge != null) {
            attrList.add(new Attribute(ATTR_RETAIN_AGE, this.retainAge));
        }
        return Collections.unmodifiableList(attrList);
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_PROFILE_ROOT, PROPERTY_INCLUDE_PATH, PROPERTY_ZIP, PROPERTY_RETAIN_COUNT, PROPERTY_RETAIN_AGE));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(10));
        if (this.profileRoot != null) {
            props.put(PROPERTY_PROFILE_ROOT, Collections.singletonList(this.profileRoot));
        }
        if (!this.includePaths.isEmpty()) {
            props.put(PROPERTY_INCLUDE_PATH, Collections.unmodifiableList(this.includePaths));
        }
        if (this.zipProfile != null) {
            props.put(PROPERTY_ZIP, Collections.singletonList(this.zipProfile));
        }
        if (this.retainCount != null) {
            props.put(PROPERTY_RETAIN_COUNT, Collections.singletonList(this.retainCount.longValue()));
        }
        if (this.retainAge != null) {
            props.put(PROPERTY_RETAIN_AGE, Collections.singletonList(this.retainAge));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

