/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPCompareOutputHandler;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.LinkedHashMap;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class LDAPCompareJSONOutputHandler
extends LDAPCompareOutputHandler {
    private static final String FIELD_NAME_ASSERTION_VALUE = "assertion-value";
    private static final String FIELD_NAME_ATTRIBUTE = "attribute-name";
    private static final String FIELD_NAME_DIAGNOSTIC_MESSAGE = "diagnostic-message";
    private static final String FIELD_NAME_DN = "entry-dn";
    private static final String FIELD_NAME_MATCHED_DN = "matched-dn";
    private static final String FIELD_NAME_REFERRAL_URLS = "referral-urls";
    private static final String FIELD_NAME_RESULT_CODE_NAME = "result-code-name";
    private static final String FIELD_NAME_RESULT_CODE_VALUE = "result-code-value";

    LDAPCompareJSONOutputHandler() {
    }

    @Override
    String formatResult(CompareRequest request, LDAPResult result) {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>();
        fields.put(FIELD_NAME_DN, new JSONString(request.getDN()));
        fields.put(FIELD_NAME_ATTRIBUTE, new JSONString(request.getAttributeName()));
        fields.put(FIELD_NAME_ASSERTION_VALUE, new JSONString(request.getAssertionValue()));
        fields.put(FIELD_NAME_RESULT_CODE_VALUE, new JSONNumber(result.getResultCode().intValue()));
        fields.put(FIELD_NAME_RESULT_CODE_NAME, new JSONString(result.getResultCode().getName()));
        if (result.getDiagnosticMessage() != null) {
            fields.put(FIELD_NAME_DIAGNOSTIC_MESSAGE, new JSONString(result.getDiagnosticMessage()));
        }
        if (result.getMatchedDN() != null) {
            fields.put(FIELD_NAME_MATCHED_DN, new JSONString(result.getMatchedDN()));
        }
        if (result.getReferralURLs().length > 0) {
            JSONValue[] referralURLValues = new JSONValue[result.getReferralURLs().length];
            for (int i = 0; i < referralURLValues.length; ++i) {
                referralURLValues[i] = new JSONString(result.getReferralURLs()[i]);
            }
            fields.put(FIELD_NAME_REFERRAL_URLS, new JSONArray(referralURLValues));
        }
        return new JSONObject(fields).toSingleLineString();
    }
}

