/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPExtendedOperationException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedRequest;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedResult;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedRequest;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetAuthorizationEntryRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetUserResourceLimitsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.NoOpRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PurgePasswordRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RetirePasswordRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionPostConnectProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPModify;
import com.unboundid.ldap.sdk.unboundidds.tools.ReportBindResultLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPPasswordModify
extends LDAPCommandLineTool
implements UnsolicitedNotificationHandler {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private static final String ASSURED_REPLICATION_LOCAL_LEVEL_NONE = "none";
    private static final String ASSURED_REPLICATION_LOCAL_LEVEL_RECEIVED_ANY_SERVER = "received-any-server";
    private static final String ASSURED_REPLICATION_LOCAL_LEVEL_PROCESSED_ALL_SERVERS = "processed-all-servers";
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_NONE = "none";
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ANY_REMOTE_LOCATION = "received-any-remote-location";
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ALL_REMOTE_LOCATIONS = "received-all-remote-locations";
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_PROCESSED_ALL_REMOTE_SERVERS = "processed-all-remote-servers";
    private static final String PASSWORD_CHANGE_METHOD_PW_MOD_EXTOP = "password-modify-extended-operation";
    private static final String PASSWORD_CHANGE_METHOD_LDAP_MOD = "ldap-modify";
    private static final String PASSWORD_CHANGE_METHOD_AD = "active-directory";
    private static final String BIND_DN_ARGUMENT_LONG_IDENTIFIER = "bindDN";
    private static final String DEFAULT_PASSWORD_ATTRIBUTE = "userPassword";
    private static final String AD_PASSWORD_ATTRIBUTE = "unicodePwd";
    private static final List<String> DEFAULT_USERNAME_ATTRIBUTES = Collections.singletonList("uid");
    private static final List<String> AD_USERNAME_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("samAccountName", "userPrincipalName"));
    private static final String MICROSOFT_BASE_OID = "1.2.840.113556";
    private final AtomicReference<String> completionMessage = new AtomicReference();
    private ArgumentParser argumentParser = null;
    private BooleanArgument followReferrals = null;
    private BooleanArgument generateClientSideNewPassword = null;
    private BooleanArgument getPasswordValidationDetails = null;
    private BooleanArgument getUserResourceLimits = null;
    private BooleanArgument noOperation = null;
    private BooleanArgument promptForCurrentPassword = null;
    private BooleanArgument promptForNewPassword = null;
    private BooleanArgument provideBindDNAsUserIdentity = null;
    private BooleanArgument purgeCurrentPassword = null;
    private BooleanArgument retireCurrentPassword = null;
    private BooleanArgument scriptFriendly = null;
    private BooleanArgument useAdministrativeSession = null;
    private BooleanArgument useAssuredReplication = null;
    private BooleanArgument useAuthorizationIdentityControl = null;
    private BooleanArgument usePasswordPolicyControlOnBind = null;
    private BooleanArgument usePasswordPolicyControlOnUpdate = null;
    private BooleanArgument verbose = null;
    private ControlArgument bindControl = null;
    private ControlArgument updateControl = null;
    private DNArgument searchBaseDN = null;
    private DurationArgument assuredReplicationTimeout = null;
    private FileArgument currentPasswordFile = null;
    private FileArgument newPasswordFile = null;
    private IntegerArgument generatedPasswordLength = null;
    private StringArgument assuredReplicationLocalLevel = null;
    private StringArgument assuredReplicationRemoteLevel = null;
    private StringArgument currentPassword = null;
    private StringArgument generatedPasswordCharacterSet = null;
    private StringArgument getAuthorizationEntryAttribute = null;
    private StringArgument newPassword = null;
    private StringArgument operationPurpose = null;
    private StringArgument passwordAttribute = null;
    private StringArgument passwordChangeMethod = null;
    private StringArgument passwordUpdateBehavior = null;
    private StringArgument userIdentity = null;
    private StringArgument usernameAttribute = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDAPPasswordModify.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        LDAPPasswordModify tool = new LDAPPasswordModify(out, err);
        return tool.runTool(args);
    }

    public LDAPPasswordModify(OutputStream out, OutputStream err) {
        super(out, err);
    }

    @Override
    public String getToolName() {
        return "ldappasswordmodify";
    }

    @Override
    public String getToolDescription() {
        return ToolMessages.INFO_PWMOD_TOOL_DESCRIPTION_1.get();
    }

    @Override
    public List<String> getAdditionalDescriptionParagraphs() {
        return Collections.unmodifiableList(Arrays.asList(ToolMessages.INFO_PWMOD_TOOL_DESCRIPTION_2.get(), ToolMessages.INFO_PWMOD_TOOL_DESCRIPTION_3.get(), ToolMessages.INFO_PWMOD_TOOL_DESCRIPTION_4.get()));
    }

    @Override
    public String getToolVersion() {
        return "5.1.0";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean supportsAuthentication() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    protected boolean supportsSASLHelp() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected List<Control> getBindControls() {
        ArrayList<Control> bindControls = new ArrayList<Control>(10);
        if (this.bindControl.isPresent()) {
            bindControls.addAll(this.bindControl.getValues());
        }
        if (this.useAuthorizationIdentityControl.isPresent()) {
            bindControls.add(new AuthorizationIdentityRequestControl(false));
        }
        if (this.getAuthorizationEntryAttribute.isPresent()) {
            bindControls.add(new GetAuthorizationEntryRequestControl(true, true, this.getAuthorizationEntryAttribute.getValues()));
        }
        if (this.getUserResourceLimits.isPresent()) {
            bindControls.add(new GetUserResourceLimitsRequestControl());
        }
        if (this.usePasswordPolicyControlOnBind.isPresent()) {
            bindControls.add(new PasswordPolicyRequestControl());
        }
        return bindControls;
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setFollowReferrals(this.followReferrals.isPresent());
        options.setUnsolicitedNotificationHandler(this);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    @Override
    protected String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.argumentParser = parser;
        this.userIdentity = new StringArgument(Character.valueOf('a'), "userIdentity", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_AUTHZID.get(), ToolMessages.INFO_PWMOD_ARG_DESC_USER_IDENTITY.get());
        this.userIdentity.addLongIdentifier("user-identity", true);
        this.userIdentity.addLongIdentifier("userDN", true);
        this.userIdentity.addLongIdentifier("user-dn", true);
        this.userIdentity.addLongIdentifier("authzID", true);
        this.userIdentity.addLongIdentifier("authz-id", true);
        this.userIdentity.addLongIdentifier("authorizationID", true);
        this.userIdentity.addLongIdentifier("authorization-id", true);
        this.userIdentity.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_USER_IDENTITY.get());
        parser.addArgument(this.userIdentity);
        this.provideBindDNAsUserIdentity = new BooleanArgument(Character.valueOf('A'), "provideBindDNAsUserIdentity", 1, ToolMessages.INFO_PWMOD_ARG_DESC_PROVIDE_BIND_DN_AS_USER_IDENTITY.get());
        this.provideBindDNAsUserIdentity.addLongIdentifier("provide-bind-dn-as-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provideBindDNForUserIdentity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provide-bind-dn-for-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provideDNAsUserIdentity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provide-dn-as-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provideDNForUserIdentity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provide-dn-for-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("useBindDNAsUserIdentity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("use-bind-dn-as-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("useBindDNForUserIdentity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("use-bind-dn-for-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("useDNAsUserIdentity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("use-dn-as-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("useDNForUserIdentity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("use-dn-for-user-identity", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("useBindDNForAuthzID", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("use-bind-dn-for-authz-id", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provideDNForAuthzID", true);
        this.provideBindDNAsUserIdentity.addLongIdentifier("provide-dn-for-authz-id", true);
        this.provideBindDNAsUserIdentity.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_USER_IDENTITY.get());
        parser.addArgument(this.provideBindDNAsUserIdentity);
        this.usernameAttribute = new StringArgument(null, "usernameAttribute", false, 0, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_ATTRIBUTE_NAME.get(), ToolMessages.INFO_PWMOD_ARG_DESC_USERNAME_ATTRIBUTE.get());
        this.usernameAttribute.addLongIdentifier("username-attribute", true);
        this.usernameAttribute.addLongIdentifier("usernameAttr", true);
        this.usernameAttribute.addLongIdentifier("username-attr", true);
        this.usernameAttribute.addLongIdentifier("userIDAttribute", true);
        this.usernameAttribute.addLongIdentifier("user-id-attribute", true);
        this.usernameAttribute.addLongIdentifier("userIDAttr", true);
        this.usernameAttribute.addLongIdentifier("user-id-attr", true);
        this.usernameAttribute.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_USER_IDENTITY.get());
        parser.addArgument(this.usernameAttribute);
        this.searchBaseDN = new DNArgument(Character.valueOf('b'), "searchBaseDN", false, 0, null, ToolMessages.INFO_PWMOD_ARG_DESC_SEARCH_BASE_DN.get(), DN.NULL_DN);
        this.searchBaseDN.addLongIdentifier("search-base-dn", true);
        this.searchBaseDN.addLongIdentifier("baseDN", true);
        this.searchBaseDN.addLongIdentifier("base-dn", true);
        this.searchBaseDN.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_USER_IDENTITY.get());
        parser.addArgument(this.searchBaseDN);
        this.newPassword = new StringArgument(Character.valueOf('n'), "newPassword", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_PASSWORD.get(), ToolMessages.INFO_PWMOD_ARG_DESC_NEW_PASSWORD.get());
        this.newPassword.addLongIdentifier("new-password", true);
        this.newPassword.addLongIdentifier("newPW", true);
        this.newPassword.addLongIdentifier("new-pw", true);
        this.newPassword.addLongIdentifier("new", true);
        this.newPassword.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_NEW_PASSWORD.get());
        parser.addArgument(this.newPassword);
        this.newPasswordFile = new FileArgument(Character.valueOf('N'), "newPasswordFile", false, 1, null, ToolMessages.INFO_PWMOD_ARG_DESC_NEW_PASSWORD_FILE.get(), true, true, true, false);
        this.newPasswordFile.addLongIdentifier("new-password-file", true);
        this.newPasswordFile.addLongIdentifier("newPWFile", true);
        this.newPasswordFile.addLongIdentifier("new-pw-file", true);
        this.newPasswordFile.addLongIdentifier("newFile", true);
        this.newPasswordFile.addLongIdentifier("new-file", true);
        this.newPasswordFile.addLongIdentifier("newPasswordPath", true);
        this.newPasswordFile.addLongIdentifier("new-password-path", true);
        this.newPasswordFile.addLongIdentifier("newPWPath", true);
        this.newPasswordFile.addLongIdentifier("new-pw-path", true);
        this.newPasswordFile.addLongIdentifier("newPath", true);
        this.newPasswordFile.addLongIdentifier("new-path", true);
        this.newPasswordFile.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_NEW_PASSWORD.get());
        parser.addArgument(this.newPasswordFile);
        this.promptForNewPassword = new BooleanArgument(null, "promptForNewPassword", 1, ToolMessages.INFO_PWMOD_ARG_DESC_PROMPT_FOR_NEW_PASSWORD.get());
        this.promptForNewPassword.addLongIdentifier("prompt-for-new-password", true);
        this.promptForNewPassword.addLongIdentifier("promptForNewPW", true);
        this.promptForNewPassword.addLongIdentifier("prompt-for-new-pw", true);
        this.promptForNewPassword.addLongIdentifier("promptForNew", true);
        this.promptForNewPassword.addLongIdentifier("prompt-for-new", true);
        this.promptForNewPassword.addLongIdentifier("promptNew", true);
        this.promptForNewPassword.addLongIdentifier("prompt-new", true);
        this.promptForNewPassword.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_NEW_PASSWORD.get());
        parser.addArgument(this.promptForNewPassword);
        this.generateClientSideNewPassword = new BooleanArgument(null, "generateClientSideNewPassword", 1, ToolMessages.INFO_PWMOD_ARG_DESC_GENERATE_CLIENT_SIDE_NEW_PASSWORD.get());
        this.generateClientSideNewPassword.addLongIdentifier("generate-client-side-new-password", true);
        this.generateClientSideNewPassword.addLongIdentifier("generateClientSideNewPW", true);
        this.generateClientSideNewPassword.addLongIdentifier("generate-client-side-new-pw", true);
        this.generateClientSideNewPassword.addLongIdentifier("generateNewPassword", true);
        this.generateClientSideNewPassword.addLongIdentifier("generate-new-password", true);
        this.generateClientSideNewPassword.addLongIdentifier("generateNewPW", true);
        this.generateClientSideNewPassword.addLongIdentifier("generate-new-pw", true);
        this.generateClientSideNewPassword.addLongIdentifier("generatePassword", true);
        this.generateClientSideNewPassword.addLongIdentifier("generate-password", true);
        this.generateClientSideNewPassword.addLongIdentifier("generatePW", true);
        this.generateClientSideNewPassword.addLongIdentifier("generate-pw", true);
        this.generateClientSideNewPassword.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_NEW_PASSWORD.get());
        parser.addArgument(this.generateClientSideNewPassword);
        this.generatedPasswordLength = new IntegerArgument(null, "generatedPasswordLength", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_LENGTH.get(), ToolMessages.INFO_PWMOD_ARG_DESC_GENERATED_PASSWORD_LENGTH.get(), 1, Integer.MAX_VALUE, 12);
        this.generatedPasswordLength.addLongIdentifier("generated-password-length", true);
        this.generatedPasswordLength.addLongIdentifier("generatedPWLength", true);
        this.generatedPasswordLength.addLongIdentifier("generated-pw-length", true);
        this.generatedPasswordLength.addLongIdentifier("passwordLength", true);
        this.generatedPasswordLength.addLongIdentifier("password-length", true);
        this.generatedPasswordLength.addLongIdentifier("pwLength", true);
        this.generatedPasswordLength.addLongIdentifier("pw-length", true);
        this.generatedPasswordLength.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_NEW_PASSWORD.get());
        parser.addArgument(this.generatedPasswordLength);
        this.generatedPasswordCharacterSet = new StringArgument(null, "generatedPasswordCharacterSet", false, 0, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_CHARS.get(), ToolMessages.INFO_PWMOD_ARG_DESC_GENERATED_PASSWORD_CHARACTER_SET.get(), null, Collections.unmodifiableList(Arrays.asList("abcdefghijmnopqrstuvwxyz", "ABCDEFGHJLMNPQRSTUVWXYZ", "23456789", "@#-_=+.")));
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-password-character-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generatedPWCharacterSet", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-pw-character-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generatedPasswordCharSet", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-password-char-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-password-charset", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generatedPWCharSet", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-pw-char-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-pw-charset", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generatedPasswordCharacters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-password-characters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generatedPWCharacters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-pw-characters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generatedPasswordChars", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-password-chars", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generatedPWChars", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("generated-pw-chars", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("passwordCharacters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("password-characters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pwCharacters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pw-characters", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("passwordCharacterSet", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("password-character-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pwCharacterSet", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pw-character-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("passwordCharSet", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("password-charset", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("password-char-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pwCharSet", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pw-charset", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pw-char-set", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("passwordChars", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("password-chars", true);
        this.generatedPasswordCharacterSet.addLongIdentifier("pw-chars", true);
        this.generatedPasswordCharacterSet.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_NEW_PASSWORD.get());
        parser.addArgument(this.generatedPasswordCharacterSet);
        this.currentPassword = new StringArgument(Character.valueOf('c'), "currentPassword", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_PASSWORD.get(), ToolMessages.INFO_PWMOD_ARG_DESC_CURRENT_PASSWORD.get());
        this.currentPassword.addLongIdentifier("current-password", true);
        this.currentPassword.addLongIdentifier("currentPW", true);
        this.currentPassword.addLongIdentifier("current-pw", true);
        this.currentPassword.addLongIdentifier("current", true);
        this.currentPassword.addLongIdentifier("oldPassword", true);
        this.currentPassword.addLongIdentifier("old-password", true);
        this.currentPassword.addLongIdentifier("oldPW", true);
        this.currentPassword.addLongIdentifier("old-pw", true);
        this.currentPassword.addLongIdentifier("old", true);
        this.currentPassword.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_CURRENT_PASSWORD.get());
        parser.addArgument(this.currentPassword);
        this.currentPasswordFile = new FileArgument(Character.valueOf('C'), "currentPasswordFile", false, 1, null, ToolMessages.INFO_PWMOD_ARG_DESC_CURRENT_PASSWORD_FILE.get(), true, true, true, false);
        this.currentPasswordFile.addLongIdentifier("current-password-file", true);
        this.currentPasswordFile.addLongIdentifier("currentPWFile", true);
        this.currentPasswordFile.addLongIdentifier("current-pw-file", true);
        this.currentPasswordFile.addLongIdentifier("currentFile", true);
        this.currentPasswordFile.addLongIdentifier("current-file", true);
        this.currentPasswordFile.addLongIdentifier("currentPasswordPath", true);
        this.currentPasswordFile.addLongIdentifier("current-password-path", true);
        this.currentPasswordFile.addLongIdentifier("currentPWPath", true);
        this.currentPasswordFile.addLongIdentifier("current-pw-path", true);
        this.currentPasswordFile.addLongIdentifier("currentPath", true);
        this.currentPasswordFile.addLongIdentifier("current-path", true);
        this.currentPasswordFile.addLongIdentifier("oldPasswordFile", true);
        this.currentPasswordFile.addLongIdentifier("old-password-file", true);
        this.currentPasswordFile.addLongIdentifier("oldPWFile", true);
        this.currentPasswordFile.addLongIdentifier("old-pw-file", true);
        this.currentPasswordFile.addLongIdentifier("oldFile", true);
        this.currentPasswordFile.addLongIdentifier("old-file", true);
        this.currentPasswordFile.addLongIdentifier("oldPasswordPath", true);
        this.currentPasswordFile.addLongIdentifier("old-password-path", true);
        this.currentPasswordFile.addLongIdentifier("oldPWPath", true);
        this.currentPasswordFile.addLongIdentifier("old-pw-path", true);
        this.currentPasswordFile.addLongIdentifier("oldPath", true);
        this.currentPasswordFile.addLongIdentifier("old-path", true);
        this.currentPasswordFile.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_CURRENT_PASSWORD.get());
        parser.addArgument(this.currentPasswordFile);
        this.promptForCurrentPassword = new BooleanArgument(null, "promptForCurrentPassword", 1, ToolMessages.INFO_PWMOD_ARG_DESC_PROMPT_FOR_CURRENT_PASSWORD.get());
        this.promptForCurrentPassword.addLongIdentifier("prompt-for-current-password", true);
        this.promptForCurrentPassword.addLongIdentifier("promptForCurrentPW", true);
        this.promptForCurrentPassword.addLongIdentifier("prompt-for-current-pw", true);
        this.promptForCurrentPassword.addLongIdentifier("promptForCurrent", true);
        this.promptForCurrentPassword.addLongIdentifier("prompt-for-current", true);
        this.promptForCurrentPassword.addLongIdentifier("promptCurrent", true);
        this.promptForCurrentPassword.addLongIdentifier("prompt-current", true);
        this.promptForCurrentPassword.addLongIdentifier("promptForOldPassword", true);
        this.promptForCurrentPassword.addLongIdentifier("prompt-for-old-password", true);
        this.promptForCurrentPassword.addLongIdentifier("promptForOldPW", true);
        this.promptForCurrentPassword.addLongIdentifier("prompt-for-old-pw", true);
        this.promptForCurrentPassword.addLongIdentifier("promptForOld", true);
        this.promptForCurrentPassword.addLongIdentifier("prompt-for-old", true);
        this.promptForCurrentPassword.addLongIdentifier("promptOld", true);
        this.promptForCurrentPassword.addLongIdentifier("prompt-old", true);
        this.promptForCurrentPassword.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_CURRENT_PASSWORD.get());
        parser.addArgument(this.promptForCurrentPassword);
        this.bindControl = new ControlArgument(null, "bindControl", false, 0, null, ToolMessages.INFO_PWMOD_ARG_DESC_BIND_CONTROL.get());
        this.bindControl.addLongIdentifier("bind-control", true);
        this.bindControl.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_BIND_CONTROL.get());
        parser.addArgument(this.bindControl);
        this.useAuthorizationIdentityControl = new BooleanArgument(null, "useAuthorizationIdentityControl", 1, ToolMessages.INFO_PWMOD_ARG_DESC_USE_AUTHZ_ID_CONTROL.get());
        this.useAuthorizationIdentityControl.addLongIdentifier("use-authorization-identity-control", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("useAuthorizationID-control", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("use-authorization-id-control", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("authorizationIdentityControl", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("authorization-identity-control", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("authorizationIDControl", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("authorization-id-control", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("authzIDControl", true);
        this.useAuthorizationIdentityControl.addLongIdentifier("authz-id-control", true);
        this.useAuthorizationIdentityControl.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_BIND_CONTROL.get());
        parser.addArgument(this.useAuthorizationIdentityControl);
        this.usePasswordPolicyControlOnBind = new BooleanArgument(null, "usePasswordPolicyControlOnBind", 1, ToolMessages.INFO_PWMOD_ARG_DESC_USE_PW_POLICY_CONTROL_ON_BIND.get());
        this.usePasswordPolicyControlOnBind.addLongIdentifier("use-password-policy-control-on-bind", true);
        this.usePasswordPolicyControlOnBind.addLongIdentifier("usePWPolicyControlOnBind", true);
        this.usePasswordPolicyControlOnBind.addLongIdentifier("use-pw-policy-control-on-bind", true);
        this.usePasswordPolicyControlOnBind.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_BIND_CONTROL.get());
        parser.addArgument(this.usePasswordPolicyControlOnBind);
        this.getAuthorizationEntryAttribute = new StringArgument(null, "getAuthorizationEntryAttribute", false, 0, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_ATTRIBUTE_NAME.get(), ToolMessages.INFO_PWMOD_ARG_DESC_GET_AUTHZ_ENTRY_ATTRIBUTE.get());
        this.getAuthorizationEntryAttribute.addLongIdentifier("get-authorization-entry-attribute", true);
        this.getAuthorizationEntryAttribute.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_BIND_CONTROL.get());
        parser.addArgument(this.getAuthorizationEntryAttribute);
        this.getUserResourceLimits = new BooleanArgument(null, "getUserResourceLimits", 1, ToolMessages.INFO_PWMOD_ARG_DESC_GET_USER_RESOURCE_LIMITS.get());
        this.getUserResourceLimits.addLongIdentifier("get-user-resource-limits", true);
        this.getUserResourceLimits.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_BIND_CONTROL.get());
        parser.addArgument(this.getUserResourceLimits);
        this.updateControl = new ControlArgument(Character.valueOf('J'), "updateControl", false, 0, null, ToolMessages.INFO_PWMOD_ARG_DESC_UPDATE_CONTROL.get());
        this.updateControl.addLongIdentifier("update-control", true);
        this.updateControl.addLongIdentifier("control", true);
        this.updateControl.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.updateControl);
        this.usePasswordPolicyControlOnUpdate = new BooleanArgument(null, "usePasswordPolicyControlOnUpdate", 1, ToolMessages.INFO_PWMOD_ARG_DESC_USE_PW_POLICY_CONTROL_ON_UPDATE.get());
        this.usePasswordPolicyControlOnUpdate.addLongIdentifier("use-password-policy-control-on-update", true);
        this.usePasswordPolicyControlOnUpdate.addLongIdentifier("usePWPolicyControlOnUpdate", true);
        this.usePasswordPolicyControlOnUpdate.addLongIdentifier("use-pw-policy-control-on-update", true);
        this.usePasswordPolicyControlOnUpdate.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.usePasswordPolicyControlOnUpdate);
        this.noOperation = new BooleanArgument(null, "noOperation", 1, ToolMessages.INFO_PWMOD_ARG_DESC_NO_OPERATION.get());
        this.noOperation.addLongIdentifier("no-operation", true);
        this.noOperation.addLongIdentifier("noOp", true);
        this.noOperation.addLongIdentifier("no-op", true);
        this.noOperation.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.noOperation);
        this.getPasswordValidationDetails = new BooleanArgument(null, "getPasswordValidationDetails", 1, ToolMessages.INFO_PWMOD_ARG_DESC_GET_PW_VALIDATION_DETAILS.get());
        this.getPasswordValidationDetails.addLongIdentifier("get-password-validation-details", true);
        this.getPasswordValidationDetails.addLongIdentifier("getPWValidationDetails", true);
        this.getPasswordValidationDetails.addLongIdentifier("get-pw-validation-details", true);
        this.getPasswordValidationDetails.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.getPasswordValidationDetails);
        this.retireCurrentPassword = new BooleanArgument(null, "retireCurrentPassword", 1, ToolMessages.INFO_PWMOD_ARG_DESC_RETIRE_CURRENT_PASSWORD.get());
        this.retireCurrentPassword.addLongIdentifier("retire-current-password", true);
        this.retireCurrentPassword.addLongIdentifier("retireCurrentPW", true);
        this.retireCurrentPassword.addLongIdentifier("retire-current-pw", true);
        this.retireCurrentPassword.addLongIdentifier("retirePassword", true);
        this.retireCurrentPassword.addLongIdentifier("retire-password", true);
        this.retireCurrentPassword.addLongIdentifier("retirePW", true);
        this.retireCurrentPassword.addLongIdentifier("retire-pw", true);
        this.retireCurrentPassword.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.retireCurrentPassword);
        this.purgeCurrentPassword = new BooleanArgument(null, "purgeCurrentPassword", 1, ToolMessages.INFO_PWMOD_ARG_DESC_PURGE_CURRENT_PASSWORD.get());
        this.purgeCurrentPassword.addLongIdentifier("purge-current-password", true);
        this.purgeCurrentPassword.addLongIdentifier("purgeCurrentPW", true);
        this.purgeCurrentPassword.addLongIdentifier("purge-current-pw", true);
        this.purgeCurrentPassword.addLongIdentifier("purgePassword", true);
        this.purgeCurrentPassword.addLongIdentifier("purge-password", true);
        this.purgeCurrentPassword.addLongIdentifier("purgePW", true);
        this.purgeCurrentPassword.addLongIdentifier("purge-pw", true);
        this.purgeCurrentPassword.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.purgeCurrentPassword);
        this.passwordUpdateBehavior = new StringArgument(null, "passwordUpdateBehavior", false, 0, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_NAME_VALUE.get(), ToolMessages.INFO_PWMOD_ARG_DESC_PASSWORD_UPDATE_BEHAVIOR.get());
        this.passwordUpdateBehavior.addLongIdentifier("password-update-behavior", true);
        this.passwordUpdateBehavior.addLongIdentifier("pwUpdateBehavior", true);
        this.passwordUpdateBehavior.addLongIdentifier("pw-update-behavior", true);
        this.passwordUpdateBehavior.addLongIdentifier("updateBehavior", true);
        this.passwordUpdateBehavior.addLongIdentifier("update-behavior", true);
        this.passwordUpdateBehavior.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.passwordUpdateBehavior);
        this.useAssuredReplication = new BooleanArgument(null, "useAssuredReplication", 1, ToolMessages.INFO_PWMOD_ARG_DESC_ASSURED_REPLICATION.get());
        this.useAssuredReplication.addLongIdentifier("use-assured-replication", true);
        this.useAssuredReplication.addLongIdentifier("assuredReplication", true);
        this.useAssuredReplication.addLongIdentifier("assured-replication", true);
        this.useAssuredReplication.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.useAssuredReplication);
        this.assuredReplicationLocalLevel = new StringArgument(null, "assuredReplicationLocalLevel", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_LEVEL.get(), ToolMessages.INFO_PWMOD_ARG_DESC_ASSURED_REPLICATION_LOCAL_LEVEL.get(), StaticUtils.setOf("none", ASSURED_REPLICATION_LOCAL_LEVEL_RECEIVED_ANY_SERVER, ASSURED_REPLICATION_LOCAL_LEVEL_PROCESSED_ALL_SERVERS));
        this.assuredReplicationLocalLevel.addLongIdentifier("assured-replication-local-level", true);
        this.assuredReplicationLocalLevel.addLongIdentifier("localLevel", true);
        this.assuredReplicationLocalLevel.addLongIdentifier("local-level", true);
        this.assuredReplicationLocalLevel.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.assuredReplicationLocalLevel);
        this.assuredReplicationRemoteLevel = new StringArgument(null, "assuredReplicationRemoteLevel", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_LEVEL.get(), ToolMessages.INFO_PWMOD_ARG_DESC_ASSURED_REPLICATION_REMOTE_LEVEL.get(), StaticUtils.setOf("none", ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ANY_REMOTE_LOCATION, ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ALL_REMOTE_LOCATIONS, ASSURED_REPLICATION_REMOTE_LEVEL_PROCESSED_ALL_REMOTE_SERVERS));
        this.assuredReplicationRemoteLevel.addLongIdentifier("assured-replication-remote-level", true);
        this.assuredReplicationRemoteLevel.addLongIdentifier("remoteLevel", true);
        this.assuredReplicationRemoteLevel.addLongIdentifier("remote-level", true);
        this.assuredReplicationRemoteLevel.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.assuredReplicationRemoteLevel);
        this.assuredReplicationTimeout = new DurationArgument(null, "assuredReplicationTimeout", false, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_TIMEOUT.get(), ToolMessages.INFO_PWMOD_ARG_DESC_ASSURED_REPLICATION_TIMEOUT.get());
        this.assuredReplicationTimeout.addLongIdentifier("assured-replication-timeout", true);
        this.assuredReplicationTimeout.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.assuredReplicationTimeout);
        this.operationPurpose = new StringArgument(null, "operationPurpose", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_PURPOSE.get(), ToolMessages.INFO_PWMOD_ARG_DESC_OPERATION_PURPOSE.get());
        this.operationPurpose.addLongIdentifier("operation-purpose", true);
        this.operationPurpose.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_UPDATE_CONTROL.get());
        parser.addArgument(this.operationPurpose);
        this.passwordAttribute = new StringArgument(null, "passwordAttribute", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_ATTRIBUTE_NAME.get(), ToolMessages.INFO_PWMOD_ARG_DESC_PASSWORD_ATTRIBUTE.get(), DEFAULT_PASSWORD_ATTRIBUTE);
        this.passwordAttribute.addLongIdentifier("password-attribute", true);
        this.passwordAttribute.addLongIdentifier("passwordAttr", true);
        this.passwordAttribute.addLongIdentifier("password-attr", true);
        this.passwordAttribute.addLongIdentifier("pwAttribute", true);
        this.passwordAttribute.addLongIdentifier("pw-attribute", true);
        this.passwordAttribute.addLongIdentifier("pwAttr", true);
        this.passwordAttribute.addLongIdentifier("pw-attr", true);
        this.passwordAttribute.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_OTHER.get());
        this.passwordChangeMethod = new StringArgument(null, "passwordChangeMethod", false, 1, ToolMessages.INFO_PWMOD_ARG_PLACEHOLDER_CHANGE_METHOD.get(), ToolMessages.INFO_PWMOD_ARG_DESC_PASSWORD_CHANGE_METHOD.get(), StaticUtils.setOf(PASSWORD_CHANGE_METHOD_PW_MOD_EXTOP, PASSWORD_CHANGE_METHOD_LDAP_MOD, PASSWORD_CHANGE_METHOD_AD));
        this.passwordChangeMethod.addLongIdentifier("password-change-method", true);
        this.passwordChangeMethod.addLongIdentifier("pwChangeMethod", true);
        this.passwordChangeMethod.addLongIdentifier("pw-change-method", true);
        this.passwordChangeMethod.addLongIdentifier("changeMethod", true);
        this.passwordChangeMethod.addLongIdentifier("change-method", true);
        this.passwordChangeMethod.addLongIdentifier("method", true);
        this.passwordChangeMethod.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_OTHER.get());
        parser.addArgument(this.passwordChangeMethod);
        this.followReferrals = new BooleanArgument(null, "followReferrals", 1, ToolMessages.INFO_PWMOD_ARG_DESC_FOLLOW_REFERRALS.get());
        this.followReferrals.addLongIdentifier("follow-referrals", true);
        this.followReferrals.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_OTHER.get());
        parser.addArgument(this.followReferrals);
        this.useAdministrativeSession = new BooleanArgument(null, "useAdministrativeSession", 1, ToolMessages.INFO_PWMOD_ARG_DESC_USE_ADMIN_SESSION.get());
        this.useAdministrativeSession.addLongIdentifier("use-administrative-session", true);
        this.useAdministrativeSession.addLongIdentifier("useAdminSession", true);
        this.useAdministrativeSession.addLongIdentifier("use-admin-session", true);
        this.useAdministrativeSession.addLongIdentifier("administrativeSession", true);
        this.useAdministrativeSession.addLongIdentifier("administrative-session", true);
        this.useAdministrativeSession.addLongIdentifier("adminSession", true);
        this.useAdministrativeSession.addLongIdentifier("admin-session", true);
        this.useAdministrativeSession.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_OTHER.get());
        parser.addArgument(this.useAdministrativeSession);
        this.verbose = new BooleanArgument(Character.valueOf('v'), "verbose", 1, ToolMessages.INFO_PWMOD_ARG_DESC_VERBOSE.get());
        this.verbose.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_OTHER.get());
        parser.addArgument(this.verbose);
        this.scriptFriendly = new BooleanArgument(null, "script-friendly", 1, ToolMessages.INFO_PWMOD_ARG_DESC_SCRIPT_FRIENDLY.get());
        this.scriptFriendly.setArgumentGroupName(ToolMessages.INFO_PWMOD_ARG_GROUP_OTHER.get());
        this.scriptFriendly.setHidden(true);
        parser.addArgument(this.scriptFriendly);
        parser.addExclusiveArgumentSet(this.userIdentity, this.provideBindDNAsUserIdentity, new Argument[0]);
        DNArgument bindDNArgument = parser.getDNArgument(BIND_DN_ARGUMENT_LONG_IDENTIFIER);
        parser.addDependentArgumentSet(this.provideBindDNAsUserIdentity, bindDNArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.newPassword, this.newPasswordFile, this.promptForNewPassword, this.generateClientSideNewPassword);
        parser.addDependentArgumentSet(this.generatedPasswordLength, this.generateClientSideNewPassword, new Argument[0]);
        parser.addDependentArgumentSet(this.generatedPasswordCharacterSet, this.generateClientSideNewPassword, new Argument[0]);
        parser.addExclusiveArgumentSet(this.currentPassword, this.currentPasswordFile, this.promptForCurrentPassword);
        parser.addDependentArgumentSet(this.assuredReplicationLocalLevel, this.useAssuredReplication, new Argument[0]);
        parser.addDependentArgumentSet(this.assuredReplicationRemoteLevel, this.useAssuredReplication, new Argument[0]);
        parser.addDependentArgumentSet(this.assuredReplicationTimeout, this.useAssuredReplication, new Argument[0]);
        parser.addExclusiveArgumentSet(this.retireCurrentPassword, this.purgeCurrentPassword, new Argument[0]);
    }

    @Override
    protected Set<Character> getSuppressedShortIdentifiers() {
        return StaticUtils.setOf(Character.valueOf('N'));
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        if (this.generatedPasswordCharacterSet.isPresent()) {
            for (String charSet : this.generatedPasswordCharacterSet.getValues()) {
                if (!charSet.isEmpty()) continue;
                throw new ArgumentException(ToolMessages.ERR_PWMOD_CHAR_SET_EMPTY.get(this.generatedPasswordCharacterSet.getIdentifierString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        try (LDAPConnectionPool pool = null;){
            String updateMethod;
            StartAdministrativeSessionPostConnectProcessor p = this.useAdministrativeSession.isPresent() ? new StartAdministrativeSessionPostConnectProcessor(new StartAdministrativeSessionExtendedRequest(this.getToolName(), true, new Control[0])) : null;
            pool = this.getConnectionPool(1, 2, 0, p, null, true, new ReportBindResultLDAPConnectionPoolHealthCheck(this, true, this.verbose.isPresent()));
            try {
                updateMethod = this.getPasswordUpdateMethod(pool);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.logCompletionMessage(true, e.getMessage());
                ResultCode resultCode = e.getResultCode();
                if (pool != null) {
                    pool.close();
                }
                return resultCode;
            }
            switch (updateMethod) {
                case "password-modify-extended-operation": {
                    ResultCode resultCode = this.doPasswordModifyExtendedOperation(pool);
                    return resultCode;
                }
                case "active-directory": {
                    ResultCode resultCode = this.doLDAPModifyPasswordUpdate(pool, true);
                    return resultCode;
                }
            }
            ResultCode resultCode = this.doLDAPModifyPasswordUpdate(pool, false);
            return resultCode;
        }
    }

    private String getPasswordUpdateMethod(LDAPConnectionPool pool) throws LDAPException {
        RootDSE rootDSE;
        if (this.passwordChangeMethod.isPresent()) {
            switch (StaticUtils.toLowerCase(this.passwordChangeMethod.getValue())) {
                case "password-modify-extended-operation": {
                    return PASSWORD_CHANGE_METHOD_PW_MOD_EXTOP;
                }
                case "ldap-modify": {
                    return PASSWORD_CHANGE_METHOD_LDAP_MOD;
                }
                case "active-directory": {
                    return PASSWORD_CHANGE_METHOD_AD;
                }
            }
        }
        try {
            rootDSE = pool.getRootDSE();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(e.getResultCode(), ToolMessages.ERR_PWMOD_CANNOT_RETRIEVE_ROOT_DSE.get(String.valueOf(e.getResultCode()), e.getMessage(), this.passwordChangeMethod.getIdentifierString()), e);
        }
        if (rootDSE == null) {
            throw new LDAPException(ResultCode.NO_RESULTS_RETURNED, ToolMessages.ERR_PWMOD_CANNOT_RETRIEVE_ROOT_DSE.get(this.passwordChangeMethod.getIdentifierString()));
        }
        if (rootDSE.supportsExtendedOperation("1.3.6.1.4.1.4203.1.11.1")) {
            if (this.verbose.isPresent()) {
                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_SELECTING_PW_MOD_EXTOP_METHOD.get());
            }
            return PASSWORD_CHANGE_METHOD_PW_MOD_EXTOP;
        }
        int numMicrosoftControlsSupported = 0;
        for (String oid : rootDSE.getSupportedControlOIDs()) {
            if (!oid.startsWith("1.2.840.113556.")) continue;
            ++numMicrosoftControlsSupported;
        }
        if (numMicrosoftControlsSupported >= 20) {
            if (this.verbose.isPresent()) {
                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_SELECTING_AD_METHOD_CONTROL_COUNT.get(numMicrosoftControlsSupported, MICROSOFT_BASE_OID));
            }
            return PASSWORD_CHANGE_METHOD_AD;
        }
        if (this.verbose.isPresent()) {
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_DEFAULTING_TO_LDAP_MOD.get());
        }
        return PASSWORD_CHANGE_METHOD_LDAP_MOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultCode doPasswordModifyExtendedOperation(LDAPConnectionPool pool) {
        Control[] controls;
        byte[] newPW;
        byte[] currentPW;
        String identity;
        try {
            identity = this.getUserIdentity(null, false);
            currentPW = this.getCurrentPassword();
            newPW = this.getNewPassword();
            controls = this.getUpdateControls();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.logCompletionMessage(true, e.getMessage());
            return e.getResultCode();
        }
        PasswordModifyExtendedRequest passwordModifyRequest = new PasswordModifyExtendedRequest(identity, currentPW, newPW, controls);
        LDAPConnection connection = null;
        try {
            connection = pool.getConnection();
            PasswordModifyExtendedResult passwordModifyResult = (PasswordModifyExtendedResult)connection.processExtendedOperation(passwordModifyRequest);
            this.out(new Object[0]);
            this.out(ToolMessages.INFO_PWMOD_EXTOP_RESULT_HEADER.get());
            for (String string : ResultUtils.formatResult(passwordModifyResult, true, 0, WRAP_COLUMN)) {
                this.out(string);
            }
            this.out(new Object[0]);
            String generatedPassword = passwordModifyResult.getGeneratedPassword();
            if (passwordModifyResult.getResultCode() == ResultCode.SUCCESS) {
                this.logCompletionMessage(false, ToolMessages.INFO_PWMOD_EXTOP_SUCCESSFUL.get());
                if (generatedPassword != null) {
                    this.out(new Object[0]);
                    this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_SERVER_GENERATED_PW.get(generatedPassword));
                }
                ResultCode resultCode = ResultCode.SUCCESS;
                return resultCode;
            }
            if (passwordModifyResult.getResultCode() == ResultCode.NO_OPERATION) {
                this.logCompletionMessage(false, ToolMessages.INFO_PWMOD_EXTOP_NO_OP.get());
                if (generatedPassword != null) {
                    this.out(new Object[0]);
                    this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_SERVER_GENERATED_PW.get(generatedPassword));
                }
                ResultCode resultCode = ResultCode.SUCCESS;
                return resultCode;
            }
            if (passwordModifyResult.getResultCode() == ResultCode.REFERRAL && this.followReferrals.isPresent() && passwordModifyResult.getReferralURLs().length > 0) {
                ResultCode resultCode = this.followPasswordModifyReferral(passwordModifyRequest, passwordModifyResult, connection, 1);
                return resultCode;
            }
            this.logCompletionMessage(true, ToolMessages.ERR_PWMOD_EXTOP_FAILED.get(String.valueOf(passwordModifyResult.getResultCode()), passwordModifyResult.getDiagnosticMessage()));
            ResultCode resultCode = passwordModifyResult.getResultCode();
            return resultCode;
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.err(new Object[0]);
            this.err(ToolMessages.INFO_PWMOD_EXTOP_RESULT_HEADER.get());
            for (String string : ResultUtils.formatResult(e, true, 0, WRAP_COLUMN)) {
                this.err(string);
            }
            this.err(new Object[0]);
            if (connection != null) {
                pool.releaseDefunctConnection(connection);
                connection = null;
            }
            this.logCompletionMessage(true, ToolMessages.ERR_PWMOD_EXTOP_ERROR.get(String.valueOf(e.getResultCode()), e.getMessage()));
            ResultCode resultCode = e.getResultCode();
            return resultCode;
        }
        finally {
            if (connection != null) {
                pool.releaseConnection(connection);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultCode followPasswordModifyReferral(PasswordModifyExtendedRequest request, PasswordModifyExtendedResult result, LDAPConnection receivedOnConnection, int referralCount) {
        ArrayList<LDAPURL> referralURLs = new ArrayList<LDAPURL>();
        for (String urlString : result.getReferralURLs()) {
            try {
                referralURLs.add(new LDAPURL(urlString));
            }
            catch (LDAPException e) {
                Debug.debugException(e);
            }
        }
        if (referralURLs.isEmpty()) {
            this.logCompletionMessage(true, ToolMessages.ERR_PWMOD_EXTOP_NO_VALID_REFERRAL_URLS.get(String.valueOf(result)));
            return ResultCode.REFERRAL;
        }
        LDAPException firstException = null;
        Iterator i$ = referralURLs.iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.logCompletionMessage(true, ToolMessages.ERR_PWMOD_FOLLOW_REFERRAL_FAILED.get(String.valueOf(firstException.getResultCode()), firstException.getDiagnosticMessage()));
                return firstException.getResultCode();
            }
            LDAPURL url = (LDAPURL)i$.next();
            try {
                LDAPConnection referralConnection = receivedOnConnection.getReferralConnection(url, receivedOnConnection);
                Throwable throwable = null;
                try {
                    String referredUserIdentity = url.getBaseDN().isNullDN() ? request.getUserIdentity() : url.getBaseDN().toString();
                    PasswordModifyExtendedRequest referralRequest = new PasswordModifyExtendedRequest(referredUserIdentity, request.getOldPassword(), request.getNewPassword(), request.getControls());
                    PasswordModifyExtendedResult referralResult = (PasswordModifyExtendedResult)referralConnection.processExtendedOperation(referralRequest);
                    this.out(new Object[0]);
                    this.out(ToolMessages.INFO_PWMOD_EXTOP_RESULT_HEADER.get());
                    for (String string : ResultUtils.formatResult(referralResult, true, 0, WRAP_COLUMN)) {
                        this.out(string);
                    }
                    this.out(new Object[0]);
                    String generatedPassword = referralResult.getGeneratedPassword();
                    if (referralResult.getResultCode() == ResultCode.SUCCESS) {
                        this.logCompletionMessage(false, ToolMessages.INFO_PWMOD_EXTOP_SUCCESSFUL.get());
                        if (generatedPassword != null) {
                            this.out(new Object[0]);
                            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_SERVER_GENERATED_PW.get(generatedPassword));
                        }
                        ResultCode resultCode = ResultCode.SUCCESS;
                        return resultCode;
                    }
                    if (referralResult.getResultCode() == ResultCode.NO_OPERATION) {
                        this.logCompletionMessage(false, ToolMessages.INFO_PWMOD_EXTOP_NO_OP.get());
                        if (generatedPassword != null) {
                            this.out(new Object[0]);
                            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_SERVER_GENERATED_PW.get(generatedPassword));
                        }
                        ResultCode resultCode = ResultCode.SUCCESS;
                        return resultCode;
                    }
                    if (referralResult.getResultCode() == ResultCode.REFERRAL) {
                        int n = receivedOnConnection.getConnectionOptions().getReferralHopLimit();
                        if (referralCount > n) {
                            this.logCompletionMessage(true, ToolMessages.ERR_PWMOD_TOO_MANY_REFERRALS.get());
                            ResultCode resultCode = ResultCode.REFERRAL_LIMIT_EXCEEDED;
                            return resultCode;
                        }
                        ResultCode resultCode = this.followPasswordModifyReferral(referralRequest, referralResult, referralConnection, referralCount + 1);
                        return resultCode;
                    }
                    if (firstException != null) continue;
                    firstException = new LDAPExtendedOperationException(referralResult);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (referralConnection == null) continue;
                    if (throwable != null) {
                        try {
                            referralConnection.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    referralConnection.close();
                }
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                if (firstException != null) continue;
                firstException = e;
                continue;
            }
            break;
        }
    }

    private ResultCode doLDAPModifyPasswordUpdate(LDAPConnectionPool pool, boolean isActiveDirectory) {
        LDAPResult modifyResult;
        String passwordAttr;
        Control[] controls;
        byte[] newPW;
        byte[] currentPW;
        String identity;
        try {
            identity = this.getUserIdentity(pool, isActiveDirectory);
            currentPW = this.getCurrentPassword();
            newPW = this.getNewPassword();
            controls = this.getUpdateControls();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.logCompletionMessage(true, e.getMessage());
            return e.getResultCode();
        }
        if (newPW == null) {
            this.logCompletionMessage(true, ToolMessages.ERR_PWMOD_NO_NEW_PW_FOR_MODIFY.get(this.newPassword.getIdentifierString(), this.newPasswordFile.getIdentifierString(), this.promptForNewPassword.getIdentifierString(), this.generateClientSideNewPassword.getIdentifierString()));
            return ResultCode.PARAM_ERROR;
        }
        if (isActiveDirectory) {
            passwordAttr = AD_PASSWORD_ATTRIBUTE;
            currentPW = LDAPPasswordModify.encodePasswordForActiveDirectory(currentPW);
            newPW = LDAPPasswordModify.encodePasswordForActiveDirectory(newPW);
        } else {
            passwordAttr = this.passwordAttribute.getValue();
        }
        ModifyRequest modifyRequest = currentPW == null ? new ModifyRequest(identity, new Modification(ModificationType.REPLACE, passwordAttr, newPW)) : new ModifyRequest(identity, new Modification(ModificationType.DELETE, passwordAttr, currentPW), new Modification(ModificationType.ADD, passwordAttr, newPW));
        modifyRequest.setControls(controls);
        try {
            modifyResult = pool.modify(modifyRequest);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            modifyResult = e.toLDAPResult();
        }
        this.out(new Object[0]);
        this.out(ToolMessages.INFO_PWMOD_MODIFY_RESULT_HEADER.get());
        for (String line : ResultUtils.formatResult(modifyResult, true, 0, WRAP_COLUMN)) {
            this.out(line);
        }
        this.out(new Object[0]);
        if (modifyResult.getResultCode() == ResultCode.SUCCESS) {
            this.logCompletionMessage(false, ToolMessages.INFO_PWMOD_MODIFY_SUCCESSFUL.get());
            return ResultCode.SUCCESS;
        }
        if (modifyResult.getResultCode() == ResultCode.NO_OPERATION) {
            this.logCompletionMessage(false, ToolMessages.INFO_PWMOD_MODIFY_NO_OP.get());
            return ResultCode.SUCCESS;
        }
        this.logCompletionMessage(true, ToolMessages.ERR_PWMOD_MODIFY_FAILED.get(String.valueOf(modifyResult.getResultCode()), modifyResult.getDiagnosticMessage()));
        return modifyResult.getResultCode();
    }

    static byte[] encodePasswordForActiveDirectory(byte[] pw) {
        if (pw == null) {
            return null;
        }
        String quotedPassword = '\"' + StaticUtils.toUTF8String(pw) + '\"';
        return quotedPassword.getBytes(StandardCharsets.UTF_16LE);
    }

    private String getUserIdentity(LDAPConnectionPool pool, boolean isActiveDirectory) throws LDAPException {
        DN parsedUserDN;
        String userDN;
        String identity = null;
        DNArgument bindDNArgument = this.argumentParser.getDNArgument(BIND_DN_ARGUMENT_LONG_IDENTIFIER);
        if (this.userIdentity.isPresent()) {
            identity = this.userIdentity.getValue();
        } else if (this.provideBindDNAsUserIdentity.isPresent()) {
            identity = bindDNArgument.getStringValue();
            if (pool == null && this.verbose.isPresent()) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_USING_USER_IDENTITY_FROM_DN_FOR_EXTOP.get(identity));
            }
        } else if (pool == null && this.verbose.isPresent()) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_OMITTING_USER_IDENTITY_FROM_EXTOP.get());
        }
        if (pool == null) {
            return identity;
        }
        if (identity == null) {
            DN bindDN;
            if (bindDNArgument.isPresent() && !(bindDN = bindDNArgument.getValue()).isNullDN()) {
                return bindDN.toString();
            }
            WhoAmIExtendedRequest whoAmIRequest = new WhoAmIExtendedRequest();
            try {
                WhoAmIExtendedResult whoAmIResult = (WhoAmIExtendedResult)pool.processExtendedOperation(whoAmIRequest);
                if (whoAmIResult.getResultCode() == ResultCode.SUCCESS) {
                    identity = whoAmIResult.getAuthorizationID();
                }
            }
            catch (LDAPException e) {
                Debug.debugException(e);
            }
        }
        if (identity == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_PWMOD_CANNOT_DETERMINE_USER_IDENTITY.get(this.userIdentity.getIdentifierString()));
        }
        String lowerIdentity = StaticUtils.toLowerCase(identity);
        if (lowerIdentity.startsWith("dn:")) {
            userDN = identity.substring(3).trim();
        } else if (lowerIdentity.startsWith("u:")) {
            String username = identity.substring(2).trim();
            if (username.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_PWMOD_USER_IDENTITY_EMPTY_USERNAME.get(this.userIdentity.getIdentifierString()));
            }
            userDN = this.searchForUser(pool, username, isActiveDirectory);
        } else {
            userDN = identity;
        }
        try {
            parsedUserDN = new DN(userDN);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_PWMOD_USER_IDENTITY_NOT_VALID_DN.get(userDN, this.userIdentity.getIdentifierString()), e);
        }
        if (parsedUserDN.isNullDN()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_PWMOD_USER_IDENTITY_EMPTY_DN.get(this.userIdentity.getIdentifierString()));
        }
        if (this.verbose.isPresent()) {
            this.out(new Object[0]);
            ToolMessages.INFO_PWMOD_USER_IDENTITY_DN_FOR_MOD.get(userDN);
        }
        return userDN;
    }

    private String searchForUser(LDAPConnectionPool pool, String username, boolean isActiveDirectory) throws LDAPException {
        SearchResult searchResult;
        Filter filter;
        List<String> filterAttributeNames = this.usernameAttribute.isPresent() ? this.usernameAttribute.getValues() : (isActiveDirectory ? AD_USERNAME_ATTRIBUTES : DEFAULT_USERNAME_ATTRIBUTES);
        if (filterAttributeNames.size() == 1) {
            filter = Filter.createEqualityFilter(filterAttributeNames.get(0), username);
        } else {
            ArrayList<Filter> orComponents = new ArrayList<Filter>(filterAttributeNames.size());
            for (String attrName : filterAttributeNames) {
                orComponents.add(Filter.createEqualityFilter(attrName, username));
            }
            filter = Filter.createORFilter(orComponents);
        }
        SearchRequest searchRequest = new SearchRequest(this.searchBaseDN.getStringValue(), SearchScope.SUB, filter, "1.1");
        searchRequest.setSizeLimit(1);
        if (this.verbose.isPresent()) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_ISSUING_SEARCH_FOR_USER.get(String.valueOf(searchRequest), username));
        }
        LDAPException searchException = null;
        try {
            searchResult = pool.search(searchRequest);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            searchException = e;
            searchResult = new SearchResult(e);
        }
        if (this.verbose.isPresent()) {
            this.out(new Object[0]);
            for (String line : ResultUtils.formatResult(searchResult, true, 0, WRAP_COLUMN)) {
                this.out(line);
            }
        }
        if (searchResult.getResultCode() == ResultCode.SUCCESS) {
            if (searchResult.getEntryCount() == 1) {
                return searchResult.getSearchEntries().get(0).getDN();
            }
            throw new LDAPException(ResultCode.NO_RESULTS_RETURNED, ToolMessages.ERR_PWMOD_SEARCH_FOR_USER_NO_MATCHES.get(username));
        }
        if (searchResult.getResultCode() == ResultCode.SIZE_LIMIT_EXCEEDED) {
            throw new LDAPException(ResultCode.SIZE_LIMIT_EXCEEDED, ToolMessages.ERR_PWMOD_SEARCH_FOR_USER_MULTIPLE_MATCHES.get(username), searchException);
        }
        throw new LDAPException(searchResult.getResultCode(), ToolMessages.ERR_PWMOD_SEARCH_FOR_USER_FAILED.get(username, String.valueOf(searchResult.getResultCode()), searchResult.getDiagnosticMessage()), searchException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getCurrentPassword() throws LDAPException {
        if (this.currentPassword.isPresent()) {
            return StaticUtils.getBytes(this.currentPassword.getValue());
        }
        if (this.currentPasswordFile.isPresent()) {
            File f = this.currentPasswordFile.getValue();
            try {
                char[] currentPasswordChars = this.getPasswordFileReader().readPassword(f);
                return StaticUtils.getBytes(new String(currentPasswordChars));
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new LDAPException(e.getResultCode(), ToolMessages.ERR_PWMOD_CANNOT_READ_CURRENT_PW_FILE.get(f.getAbsolutePath(), e.getMessage()), e);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_PWMOD_CANNOT_READ_CURRENT_PW_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (!this.promptForCurrentPassword.isPresent()) {
            return null;
        }
        while (true) {
            this.getOut().print(ToolMessages.INFO_PWMOD_PROMPT_CURRENT_PW.get());
            try {
                byte[] pwBytes = PasswordReader.readPassword();
                if (pwBytes != null && pwBytes.length != 0) {
                    return pwBytes;
                }
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_PWMOD_PW_EMPTY.get());
                this.err(new Object[0]);
            }
            catch (Exception e) {
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_PWMOD_CANNOT_PROMPT_FOR_CURRENT_PW.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getNewPassword() throws LDAPException {
        if (this.newPassword.isPresent()) {
            return StaticUtils.getBytes(this.newPassword.getValue());
        }
        if (this.newPasswordFile.isPresent()) {
            File f = this.newPasswordFile.getValue();
            try {
                char[] newPasswordChars = this.getPasswordFileReader().readPassword(f);
                return StaticUtils.getBytes(new String(newPasswordChars));
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new LDAPException(e.getResultCode(), ToolMessages.ERR_PWMOD_CANNOT_READ_NEW_PW_FILE.get(f.getAbsolutePath(), e.getMessage()), e);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_PWMOD_CANNOT_READ_NEW_PW_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (!this.promptForNewPassword.isPresent()) {
            if (this.generateClientSideNewPassword.isPresent()) {
                return this.generatePassword();
            }
            return null;
        }
        while (true) {
            this.getOut().print(ToolMessages.INFO_PWMOD_PROMPT_NEW_PW.get());
            try {
                byte[] pwBytes = PasswordReader.readPassword();
                if (pwBytes == null || pwBytes.length == 0) {
                    this.err(new Object[0]);
                    this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_PWMOD_PW_EMPTY.get());
                    this.err(new Object[0]);
                    continue;
                }
                this.getOut().print(ToolMessages.INFO_PWMOD_CONFIRM_NEW_PW.get());
                byte[] confirmBytes = PasswordReader.readPassword();
                if (confirmBytes != null && Arrays.equals(pwBytes, confirmBytes)) {
                    Arrays.fill(confirmBytes, (byte)0);
                    return pwBytes;
                }
                Arrays.fill(pwBytes, (byte)0);
                Arrays.fill(confirmBytes, (byte)0);
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_PWMOD_NEW_PW_MISMATCH.get());
                this.err(new Object[0]);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_PWMOD_CANNOT_PROMPT_FOR_NEW_PW.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    private byte[] generatePassword() {
        int length = this.generatedPasswordLength.getValue();
        StringBuilder generatedPassword = new StringBuilder(length);
        SecureRandom random = new SecureRandom();
        StringBuilder allPasswordCharacters = new StringBuilder();
        for (String charSet : this.generatedPasswordCharacterSet.getValues()) {
            allPasswordCharacters.append(charSet);
            generatedPassword.append(charSet.charAt(random.nextInt(charSet.length())));
        }
        while (generatedPassword.length() < length) {
            generatedPassword.append(allPasswordCharacters.charAt(random.nextInt(allPasswordCharacters.length())));
        }
        StringBuilder scrambledPassword = new StringBuilder(generatedPassword.length());
        while (true) {
            if (generatedPassword.length() == 1) break;
            int pos = random.nextInt(generatedPassword.length());
            scrambledPassword.append(generatedPassword.charAt(pos));
            generatedPassword.deleteCharAt(pos);
        }
        scrambledPassword.append(generatedPassword.charAt(0));
        String scrambledPasswordString = scrambledPassword.toString();
        this.out(new Object[0]);
        this.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_PWMOD_CLIENT_SIDE_GEN_PW.get(this.getToolName(), scrambledPasswordString));
        return StaticUtils.getBytes(scrambledPasswordString);
    }

    private Control[] getUpdateControls() throws LDAPException {
        ArrayList<Control> controls = new ArrayList<Control>();
        if (this.updateControl.isPresent()) {
            controls.addAll(this.updateControl.getValues());
        }
        if (this.usePasswordPolicyControlOnUpdate.isPresent()) {
            controls.add(new PasswordPolicyRequestControl());
        }
        if (this.noOperation.isPresent()) {
            controls.add(new NoOpRequestControl());
        }
        if (this.getPasswordValidationDetails.isPresent()) {
            controls.add(new PasswordValidationDetailsRequestControl());
        }
        if (this.retireCurrentPassword.isPresent()) {
            controls.add(new RetirePasswordRequestControl(false));
        }
        if (this.purgeCurrentPassword.isPresent()) {
            controls.add(new PurgePasswordRequestControl(false));
        }
        if (this.passwordUpdateBehavior.isPresent()) {
            controls.add(LDAPModify.createPasswordUpdateBehaviorRequestControl(this.passwordUpdateBehavior.getIdentifierString(), this.passwordUpdateBehavior.getValues()));
        }
        if (this.operationPurpose.isPresent()) {
            controls.add(new OperationPurposeRequestControl(false, this.getToolName(), this.getToolVersion(), LDAPPasswordModify.class.getName() + ".getUpdateControls", this.operationPurpose.getValue()));
        }
        if (this.useAssuredReplication.isPresent()) {
            AssuredReplicationLocalLevel localLevel = null;
            if (this.assuredReplicationLocalLevel.isPresent()) {
                String level = this.assuredReplicationLocalLevel.getValue();
                if (level.equalsIgnoreCase("none")) {
                    localLevel = AssuredReplicationLocalLevel.NONE;
                } else if (level.equalsIgnoreCase(ASSURED_REPLICATION_LOCAL_LEVEL_RECEIVED_ANY_SERVER)) {
                    localLevel = AssuredReplicationLocalLevel.RECEIVED_ANY_SERVER;
                } else if (level.equalsIgnoreCase(ASSURED_REPLICATION_LOCAL_LEVEL_PROCESSED_ALL_SERVERS)) {
                    localLevel = AssuredReplicationLocalLevel.PROCESSED_ALL_SERVERS;
                }
            }
            AssuredReplicationRemoteLevel remoteLevel = null;
            if (this.assuredReplicationRemoteLevel.isPresent()) {
                String level = this.assuredReplicationRemoteLevel.getValue();
                if (level.equalsIgnoreCase("none")) {
                    remoteLevel = AssuredReplicationRemoteLevel.NONE;
                } else if (level.equalsIgnoreCase(ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ANY_REMOTE_LOCATION)) {
                    remoteLevel = AssuredReplicationRemoteLevel.RECEIVED_ANY_REMOTE_LOCATION;
                } else if (level.equalsIgnoreCase(ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ALL_REMOTE_LOCATIONS)) {
                    remoteLevel = AssuredReplicationRemoteLevel.RECEIVED_ALL_REMOTE_LOCATIONS;
                } else if (level.equalsIgnoreCase(ASSURED_REPLICATION_REMOTE_LEVEL_PROCESSED_ALL_REMOTE_SERVERS)) {
                    remoteLevel = AssuredReplicationRemoteLevel.PROCESSED_ALL_REMOTE_SERVERS;
                }
            }
            Long timeoutMillis = null;
            if (this.assuredReplicationTimeout.isPresent()) {
                timeoutMillis = this.assuredReplicationTimeout.getValue(TimeUnit.MILLISECONDS);
            }
            controls.add(new AssuredReplicationRequestControl(true, localLevel, localLevel, remoteLevel, remoteLevel, timeoutMillis, false));
        }
        return controls.toArray(StaticUtils.NO_CONTROLS);
    }

    private void logCompletionMessage(boolean isError, String message) {
        this.completionMessage.compareAndSet(null, message);
        if (isError) {
            this.wrapErr(0, WRAP_COLUMN, message);
        } else {
            this.wrapOut(0, WRAP_COLUMN, message);
        }
    }

    @Override
    public void handleUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        ArrayList<String> lines = new ArrayList<String>(10);
        ResultUtils.formatUnsolicitedNotification(lines, notification, true, 0, WRAP_COLUMN);
        for (String line : lines) {
            this.err(line);
        }
        this.err(new Object[0]);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "636", "--useSSL", "--userIdentity", "u:jdoe", "--promptForCurrentPassword", "--promptForNewPassword"}, ToolMessages.INFO_PWMOD_EXAMPLE_1.get());
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "636", "--useSSL", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPasswordFile", "admin-password.txt", "--userIdentity", "uid=jdoe,ou=People,dc=example,dc=com", "--generateClientSideNewPassword", "--passwordChangeMethod", PASSWORD_CHANGE_METHOD_LDAP_MOD}, ToolMessages.INFO_PWMOD_EXAMPLE_2.get());
        return examples;
    }
}

