/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.unboundidds.tools.ToolInvocationLogDetails;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ToolInvocationLogger {
    private static final String LOG_MESSAGE_DATE_FORMAT = "dd/MMM/yyyy:HH:mm:ss.SSS Z";
    static final String PROPERTY_TEST_INSTANCE_ROOT = ToolInvocationLogger.class.getName() + ".testInstanceRootPath";

    private ToolInvocationLogger() {
    }

    public static ToolInvocationLogDetails getLogMessageDetails(String commandName, boolean logByDefault, PrintStream toolErrorStream) {
        File parentDirectory;
        String instanceRootPath = StaticUtils.getSystemProperty(PROPERTY_TEST_INSTANCE_ROOT);
        if (instanceRootPath == null && (instanceRootPath = StaticUtils.getEnvironmentVariable("INSTANCE_ROOT")) == null) {
            return ToolInvocationLogDetails.createDoNotLogDetails(commandName);
        }
        File instanceRootDirectory = new File(instanceRootPath).getAbsoluteFile();
        if (!instanceRootDirectory.exists() || !instanceRootDirectory.isDirectory()) {
            return ToolInvocationLogDetails.createDoNotLogDetails(commandName);
        }
        File defaultToolInvocationLogFile = StaticUtils.constructPath(instanceRootDirectory, "logs", "tools", "tool-invocation.log");
        boolean canUseDefaultLog = defaultToolInvocationLogFile.exists() ? defaultToolInvocationLogFile.isFile() : (parentDirectory = defaultToolInvocationLogFile.getParentFile()).exists() && parentDirectory.isDirectory();
        File invocationLoggingPropertiesFile = StaticUtils.constructPath(instanceRootDirectory, "config", "tool-invocation-logging.properties");
        if (!invocationLoggingPropertiesFile.exists()) {
            if (logByDefault && canUseDefaultLog) {
                return ToolInvocationLogDetails.createLogDetails(commandName, null, Collections.singleton(defaultToolInvocationLogFile), toolErrorStream);
            }
            return ToolInvocationLogDetails.createDoNotLogDetails(commandName);
        }
        Properties loggingProperties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(invocationLoggingPropertiesFile);){
            loggingProperties.load(inputStream);
        }
        catch (Exception e) {
            Debug.debugException(e);
            ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_ERROR_LOADING_PROPERTIES_FILE.get(invocationLoggingPropertiesFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), toolErrorStream);
            return ToolInvocationLogDetails.createDoNotLogDetails(commandName);
        }
        Boolean logInvocation = ToolInvocationLogger.getBooleanProperty(commandName + ".log-tool-invocations", loggingProperties, invocationLoggingPropertiesFile, null, toolErrorStream);
        if (logInvocation == null) {
            logInvocation = ToolInvocationLogger.getBooleanProperty("default.log-tool-invocations", loggingProperties, invocationLoggingPropertiesFile, null, toolErrorStream);
        }
        if (logInvocation == null) {
            logInvocation = logByDefault;
        }
        if (!logInvocation.booleanValue()) {
            return ToolInvocationLogDetails.createDoNotLogDetails(commandName);
        }
        HashSet<File> logFiles = new HashSet<File>(StaticUtils.computeMapCapacity(2));
        String toolSpecificLogFilePathPropertyName = commandName + ".log-file-path";
        File toolSpecificLogFile = ToolInvocationLogger.getLogFileProperty(toolSpecificLogFilePathPropertyName, loggingProperties, invocationLoggingPropertiesFile, instanceRootDirectory, toolErrorStream);
        if (toolSpecificLogFile != null) {
            logFiles.add(toolSpecificLogFile);
        }
        if (ToolInvocationLogger.getBooleanProperty(commandName + ".include-in-default-log", loggingProperties, invocationLoggingPropertiesFile, true, toolErrorStream).booleanValue()) {
            String defaultLogFilePathPropertyName = "default.log-file-path";
            File defaultLogFile = ToolInvocationLogger.getLogFileProperty("default.log-file-path", loggingProperties, invocationLoggingPropertiesFile, instanceRootDirectory, toolErrorStream);
            if (defaultLogFile != null) {
                logFiles.add(defaultLogFile);
            } else if (canUseDefaultLog) {
                logFiles.add(defaultToolInvocationLogFile);
            } else {
                ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_NO_LOG_FILES.get(commandName, invocationLoggingPropertiesFile.getAbsolutePath(), toolSpecificLogFilePathPropertyName, "default.log-file-path"), toolErrorStream);
            }
        }
        if (logFiles.isEmpty()) {
            return ToolInvocationLogDetails.createDoNotLogDetails(commandName);
        }
        return ToolInvocationLogDetails.createLogDetails(commandName, null, logFiles, toolErrorStream);
    }

    private static Boolean getBooleanProperty(String propertyName, Properties properties, File propertiesFilePath, Boolean defaultValue, PrintStream toolErrorStream) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        if (propertyValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (propertyValue.equalsIgnoreCase("false")) {
            return false;
        }
        ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_CANNOT_PARSE_BOOLEAN_PROPERTY.get(propertyValue, propertyName, propertiesFilePath.getAbsolutePath()), toolErrorStream);
        return defaultValue;
    }

    private static File getLogFileProperty(String propertyName, Properties properties, File propertiesFilePath, File instanceRootDirectory, PrintStream toolErrorStream) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            return null;
        }
        File configuredFile = new File(propertyValue);
        File absoluteFile = configuredFile.isAbsolute() ? configuredFile : new File(instanceRootDirectory.getAbsolutePath() + File.separator + propertyValue);
        if (absoluteFile.exists()) {
            if (absoluteFile.isFile()) {
                return absoluteFile;
            }
            ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_PATH_NOT_FILE.get(propertyValue, propertyName, propertiesFilePath.getAbsolutePath()), toolErrorStream);
        } else {
            File parentFile = absoluteFile.getParentFile();
            if (parentFile.exists() && parentFile.isDirectory()) {
                return absoluteFile;
            }
            ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_PATH_PARENT_MISSING.get(propertyValue, propertyName, propertiesFilePath.getAbsolutePath(), parentFile.getAbsolutePath()), toolErrorStream);
        }
        return null;
    }

    public static void logLaunchMessage(ToolInvocationLogDetails logDetails, List<ObjectPair<String, String>> commandLineArguments, List<ObjectPair<String, String>> propertiesFileArguments, String propertiesFilePath) {
        String value;
        String name;
        StringBuilder msgBuffer = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LOG_MESSAGE_DATE_FORMAT);
        msgBuffer.append("# [");
        msgBuffer.append(dateFormat.format(new Date()));
        msgBuffer.append(']');
        msgBuffer.append(StaticUtils.EOL);
        msgBuffer.append("# Command Name: ");
        msgBuffer.append(logDetails.getCommandName());
        msgBuffer.append(StaticUtils.EOL);
        msgBuffer.append("# Invocation ID: ");
        msgBuffer.append(logDetails.getInvocationID());
        msgBuffer.append(StaticUtils.EOL);
        String systemUserName = StaticUtils.getSystemProperty("user.name");
        if (systemUserName != null && !systemUserName.isEmpty()) {
            msgBuffer.append("# System User: ");
            msgBuffer.append(systemUserName);
            msgBuffer.append(StaticUtils.EOL);
        }
        if (!propertiesFileArguments.isEmpty()) {
            msgBuffer.append("# Arguments obtained from '");
            msgBuffer.append(propertiesFilePath);
            msgBuffer.append("':");
            msgBuffer.append(StaticUtils.EOL);
            for (ObjectPair<String, String> argPair : propertiesFileArguments) {
                msgBuffer.append("#      ");
                name = argPair.getFirst();
                if (name.startsWith("-")) {
                    msgBuffer.append(name);
                } else {
                    msgBuffer.append(StaticUtils.cleanExampleCommandLineArgument(name));
                }
                value = argPair.getSecond();
                if (value != null) {
                    msgBuffer.append(' ');
                    msgBuffer.append(ToolInvocationLogger.getCleanArgumentValue(name, value));
                }
                msgBuffer.append(StaticUtils.EOL);
            }
        }
        msgBuffer.append(logDetails.getCommandName());
        for (ObjectPair<String, String> argPair : commandLineArguments) {
            msgBuffer.append(' ');
            name = argPair.getFirst();
            if (name.startsWith("-")) {
                msgBuffer.append(name);
            } else {
                msgBuffer.append(StaticUtils.cleanExampleCommandLineArgument(name));
            }
            if ((value = argPair.getSecond()) == null) continue;
            msgBuffer.append(' ');
            msgBuffer.append(ToolInvocationLogger.getCleanArgumentValue(name, value));
        }
        msgBuffer.append(StaticUtils.EOL);
        msgBuffer.append(StaticUtils.EOL);
        byte[] logMessageBytes = StaticUtils.getBytes(msgBuffer.toString());
        for (File logFile : logDetails.getLogFiles()) {
            ToolInvocationLogger.logMessageToFile(logMessageBytes, logFile, logDetails.getToolErrorStream());
        }
    }

    private static String getCleanArgumentValue(String name, String value) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (!(!lowerName.contains("password") && !lowerName.contains("passphrase") && !lowerName.endsWith("-pin") && !name.endsWith("Pin") && !name.endsWith("PIN") || lowerName.contains("passwordfile") || lowerName.contains("password-file") || lowerName.contains("passwordpath") || lowerName.contains("password-path") || lowerName.contains("passphrasefile") || lowerName.contains("passphrase-file") || lowerName.contains("passphrasepath") || lowerName.contains("passphrase-path") || StaticUtils.toLowerCase(value).contains("redacted"))) {
            return "'*****REDACTED*****'";
        }
        return StaticUtils.cleanExampleCommandLineArgument(value);
    }

    public static void logCompletionMessage(ToolInvocationLogDetails logDetails, Integer exitCode, String exitMessage) {
        StringBuilder msgBuffer = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LOG_MESSAGE_DATE_FORMAT);
        msgBuffer.append("# [");
        msgBuffer.append(dateFormat.format(new Date()));
        msgBuffer.append(']');
        msgBuffer.append(StaticUtils.EOL);
        msgBuffer.append("# Command Name: ");
        msgBuffer.append(logDetails.getCommandName());
        msgBuffer.append(StaticUtils.EOL);
        msgBuffer.append("# Invocation ID: ");
        msgBuffer.append(logDetails.getInvocationID());
        msgBuffer.append(StaticUtils.EOL);
        if (exitCode != null) {
            msgBuffer.append("# Exit Code: ");
            msgBuffer.append(exitCode);
            msgBuffer.append(StaticUtils.EOL);
        }
        if (exitMessage != null) {
            msgBuffer.append("# Exit Message: ");
            ToolInvocationLogger.cleanMessage(exitMessage, msgBuffer);
            msgBuffer.append(StaticUtils.EOL);
        }
        msgBuffer.append(StaticUtils.EOL);
        byte[] logMessageBytes = StaticUtils.getBytes(msgBuffer.toString());
        for (File logFile : logDetails.getLogFiles()) {
            ToolInvocationLogger.logMessageToFile(logMessageBytes, logFile, logDetails.getToolErrorStream());
        }
    }

    private static void cleanMessage(String message, StringBuilder buffer) {
        for (char c : message.toCharArray()) {
            if (c >= ' ' && c <= '~') {
                buffer.append(c);
                continue;
            }
            for (byte b : StaticUtils.getBytes(Character.toString(c))) {
                buffer.append('\\');
                StaticUtils.toHex(b, buffer);
            }
        }
    }

    private static void logMessageToFile(byte[] logMessageBytes, File logFile, PrintStream toolErrorStream) {
        FileAttribute[] fileAttributes;
        EnumSet<StandardOpenOption> openOptionsSet = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.DSYNC);
        if (StaticUtils.isWindows()) {
            fileAttributes = new FileAttribute[]{};
        } else {
            EnumSet<PosixFilePermission> filePermissionsSet = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            FileAttribute<Set<PosixFilePermission>> filePermissionsAttribute = PosixFilePermissions.asFileAttribute(filePermissionsSet);
            fileAttributes = new FileAttribute[]{filePermissionsAttribute};
        }
        try (FileChannel fileChannel = FileChannel.open(logFile.toPath(), openOptionsSet, fileAttributes);
             FileLock fileLock = ToolInvocationLogger.acquireFileLock(fileChannel, logFile, toolErrorStream);){
            if (fileLock != null) {
                try {
                    fileChannel.write(ByteBuffer.wrap(logMessageBytes));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_ERROR_WRITING_LOG_MESSAGE.get(logFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), toolErrorStream);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_ERROR_OPENING_LOG_FILE.get(logFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), toolErrorStream);
        }
    }

    private static FileLock acquireFileLock(FileChannel fileChannel, File logFile, PrintStream toolErrorStream) {
        try {
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock != null) {
                return fileLock;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        int numAttempts = 1;
        long stopWaitingTime = System.currentTimeMillis() + 1000L;
        while (System.currentTimeMillis() <= stopWaitingTime) {
            try {
                Thread.sleep(10L);
                FileLock fileLock = fileChannel.tryLock();
                if (fileLock != null) {
                    return fileLock;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            ++numAttempts;
        }
        ToolInvocationLogger.printError(ToolMessages.ERR_TOOL_LOGGER_UNABLE_TO_ACQUIRE_FILE_LOCK.get(logFile.getAbsolutePath(), numAttempts), toolErrorStream);
        return null;
    }

    private static void printError(String message, PrintStream toolErrorStream) {
        toolErrorStream.println();
        int maxWidth = StaticUtils.TERMINAL_WIDTH_COLUMNS - 3;
        for (String line : StaticUtils.wrapLine(message, maxWidth)) {
            toolErrorStream.println("# " + line);
        }
    }
}

