/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FIFOEntryCacheMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String FIFO_ENTRY_CACHE_MONITOR_OC = "ds-fifo-entry-cache-monitor-entry";
    @NotNull
    private static final String ATTR_CACHE_NAME = "cacheName";
    @NotNull
    private static final String ATTR_ENTRY_CACHE_HITS = "entryCacheHits";
    @NotNull
    private static final String ATTR_ENTRY_CACHE_TRIES = "entryCacheTries";
    @NotNull
    private static final String ATTR_ENTRY_CACHE_HIT_RATIO = "entryCacheHitRatio";
    @NotNull
    private static final String ATTR_MAX_ENTRY_CACHE_SIZE = "maxEntryCacheSize";
    @NotNull
    private static final String ATTR_CURRENT_ENTRY_CACHE_COUNT = "currentEntryCacheCount";
    @NotNull
    private static final String ATTR_MAX_ENTRY_CACHE_COUNT = "maxEntryCacheCount";
    @NotNull
    private static final String ATTR_ENTRIES_ADDED_OR_UPDATED = "entriesAddedOrUpdated";
    @NotNull
    private static final String ATTR_EVICTIONS_DUE_TO_MAX_MEMORY = "evictionsDueToMaxMemory";
    @NotNull
    private static final String ATTR_EVICTIONS_DUE_TO_MAX_ENTRIES = "evictionsDueToMaxEntries";
    @NotNull
    private static final String ATTR_ENTRIES_NOT_ADDED_ALREADY_PRESENT = "entriesNotAddedAlreadyPresent";
    @NotNull
    private static final String ATTR_ENTRIES_NOT_ADDED_DUE_TO_MAX_MEMORY = "entriesNotAddedDueToMaxMemory";
    @NotNull
    private static final String ATTR_ENTRIES_NOT_ADDED_DUE_TO_FILTER = "entriesNotAddedDueToFilter";
    @NotNull
    private static final String ATTR_ENTRIES_NOT_ADDED_DUE_TO_ENTRY_SMALLNESS = "entriesNotAddedDueToEntrySmallness";
    @NotNull
    private static final String ATTR_LOW_MEMORY_OCCURRENCES = "lowMemoryOccurrences";
    @NotNull
    private static final String ATTR_PERCENT_FULL_MAX_ENTRIES = "percentFullMaxEntries";
    @NotNull
    private static final String ATTR_JVM_MEMORY_MAX_PERCENT_THRESHOLD = "jvmMemoryMaxPercentThreshold";
    @NotNull
    private static final String ATTR_JVM_MEMORY_CURRENT_PERCENT_FULL = "jvmMemoryCurrentPercentFull";
    @NotNull
    private static final String ATTR_JVM_MEMORY_BELOW_MAX_MEMORY_PERCENT = "jvmMemoryBelowMaxMemoryPercent";
    @NotNull
    private static final String ATTR_IS_FULL = "isFull";
    @NotNull
    private static final String ATTR_CAPACITY_DETAILS = "capacityDetails";
    private static final long serialVersionUID = -3340643698412829407L;
    @Nullable
    private final Boolean isFull = this.getBoolean("isFull");
    @Nullable
    private final Long currentEntryCacheCount = this.getLong("currentEntryCacheCount");
    @Nullable
    private final Long entriesAddedOrUpdated = this.getLong("entriesAddedOrUpdated");
    @Nullable
    private final Long entriesNotAddedAlreadyPresent = this.getLong("entriesNotAddedAlreadyPresent");
    @Nullable
    private final Long entriesNotAddedDueToEntrySmallness = this.getLong("entriesNotAddedDueToEntrySmallness");
    @Nullable
    private final Long entriesNotAddedDueToFilter = this.getLong("entriesNotAddedDueToFilter");
    @Nullable
    private final Long entriesNotAddedDueToMaxMemory = this.getLong("entriesNotAddedDueToMaxMemory");
    @Nullable
    private final Long entryCacheHitRatio = this.getLong("entryCacheHitRatio");
    @Nullable
    private final Long entryCacheHits = this.getLong("entryCacheHits");
    @Nullable
    private final Long entryCacheTries = this.getLong("entryCacheTries");
    @Nullable
    private final Long evictionsDueToMaxEntries = this.getLong("evictionsDueToMaxEntries");
    @Nullable
    private final Long evictionsDueToMaxMemory = this.getLong("evictionsDueToMaxMemory");
    @Nullable
    private final Long jvmMemoryBelowMaxMemoryPercent = this.getLong("jvmMemoryBelowMaxMemoryPercent");
    @Nullable
    private final Long jvmMemoryCurrentPercentFull = this.getLong("jvmMemoryCurrentPercentFull");
    @Nullable
    private final Long jvmMemoryMaxPercentThreshold = this.getLong("jvmMemoryMaxPercentThreshold");
    @Nullable
    private final Long lowMemoryOccurrences = this.getLong("lowMemoryOccurrences");
    @Nullable
    private final Long maxEntryCacheCount = this.getLong("maxEntryCacheCount");
    @Nullable
    private final Long maxEntryCacheSize = this.getLong("maxEntryCacheSize");
    @Nullable
    private final Long percentFullMaxEntries = this.getLong("percentFullMaxEntries");
    @Nullable
    private final String cacheName = this.getString("cacheName");
    @Nullable
    private final String capacityDetails = this.getString("capacityDetails");

    public FIFOEntryCacheMonitorEntry(@NotNull Entry entry) {
        super(entry);
    }

    @Nullable
    public String getCacheName() {
        return this.cacheName;
    }

    @Nullable
    public Long getEntryCacheHits() {
        return this.entryCacheHits;
    }

    @Nullable
    public Long getEntryCacheTries() {
        return this.entryCacheTries;
    }

    @Nullable
    public Long getEntryCacheHitRatio() {
        return this.entryCacheHitRatio;
    }

    @Nullable
    public Long getMaxEntryCacheSizeBytes() {
        return this.maxEntryCacheSize;
    }

    @Nullable
    public Long getCurrentEntryCacheCount() {
        return this.currentEntryCacheCount;
    }

    @Nullable
    public Long getMaxEntryCacheCount() {
        return this.maxEntryCacheCount;
    }

    @Nullable
    public Long getEntriesAddedOrUpdated() {
        return this.entriesAddedOrUpdated;
    }

    @Nullable
    public Long getEvictionsDueToMaxMemory() {
        return this.evictionsDueToMaxMemory;
    }

    @Nullable
    public Long getEvictionsDueToMaxEntries() {
        return this.evictionsDueToMaxEntries;
    }

    @Nullable
    public Long getEntriesNotAddedAlreadyPresent() {
        return this.entriesNotAddedAlreadyPresent;
    }

    @Nullable
    public Long getEntriesNotAddedDueToMaxMemory() {
        return this.entriesNotAddedDueToMaxMemory;
    }

    @Nullable
    public Long getEntriesNotAddedDueToFilter() {
        return this.entriesNotAddedDueToFilter;
    }

    @Nullable
    public Long getEntriesNotAddedDueToEntrySmallness() {
        return this.entriesNotAddedDueToEntrySmallness;
    }

    @Nullable
    public Long getLowMemoryOccurrences() {
        return this.lowMemoryOccurrences;
    }

    @Nullable
    public Long getPercentFullMaxEntries() {
        return this.percentFullMaxEntries;
    }

    @Nullable
    public Long getJVMMemoryMaxPercentThreshold() {
        return this.jvmMemoryMaxPercentThreshold;
    }

    @Nullable
    public Long getJVMMemoryCurrentPercentFull() {
        return this.jvmMemoryCurrentPercentFull;
    }

    @Nullable
    public Long getJVMMemoryBelowMaxMemoryPercent() {
        return this.jvmMemoryBelowMaxMemoryPercent;
    }

    @Nullable
    public Boolean isFull() {
        return this.isFull;
    }

    @Nullable
    public String getCapacityDetails() {
        return this.capacityDetails;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_FIFO_ENTRY_CACHE_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_FIFO_ENTRY_CACHE_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(30));
        if (this.cacheName != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CACHE_NAME, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_CACHE_NAME.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_CACHE_NAME.get(), this.cacheName);
        }
        if (this.entryCacheHits != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRY_CACHE_HITS, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_HITS.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_HITS.get(), this.entryCacheHits);
        }
        if (this.entryCacheTries != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRY_CACHE_TRIES, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_TRIES.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_TRIES.get(), this.entryCacheTries);
        }
        if (this.entryCacheHitRatio != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRY_CACHE_HIT_RATIO, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_HIT_RATIO.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_HIT_RATIO.get(), this.entryCacheHitRatio);
        }
        if (this.maxEntryCacheSize != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_ENTRY_CACHE_SIZE, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_MAX_MEM.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_MAX_MEM.get(), this.maxEntryCacheSize);
        }
        if (this.currentEntryCacheCount != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_ENTRY_CACHE_COUNT, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_CURRENT_COUNT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_CURRENT_COUNT.get(), this.currentEntryCacheCount);
        }
        if (this.maxEntryCacheCount != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_ENTRY_CACHE_COUNT, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_MAX_COUNT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_MAX_COUNT.get(), this.maxEntryCacheCount);
        }
        if (this.entriesAddedOrUpdated != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRIES_ADDED_OR_UPDATED, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_PUT_COUNT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_PUT_COUNT.get(), this.entriesAddedOrUpdated);
        }
        if (this.evictionsDueToMaxMemory != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_EVICTIONS_DUE_TO_MAX_MEMORY, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_EVICT_MEM.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_EVICT_MEM.get(), this.evictionsDueToMaxMemory);
        }
        if (this.evictionsDueToMaxEntries != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_EVICTIONS_DUE_TO_MAX_ENTRIES, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_EVICT_COUNT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_EVICT_COUNT.get(), this.evictionsDueToMaxEntries);
        }
        if (this.entriesNotAddedAlreadyPresent != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRIES_NOT_ADDED_ALREADY_PRESENT, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_NO_PUT_ALREADY_PRESENT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_NO_PUT_ALREADY_PRESENT.get(), this.entriesNotAddedAlreadyPresent);
        }
        if (this.entriesNotAddedDueToMaxMemory != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRIES_NOT_ADDED_DUE_TO_MAX_MEMORY, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_NO_PUT_MEM.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_NO_PUT_MEM.get(), this.entriesNotAddedDueToMaxMemory);
        }
        if (this.entriesNotAddedDueToFilter != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRIES_NOT_ADDED_DUE_TO_FILTER, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_NO_PUT_FILTER.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_NO_PUT_FILTER.get(), this.entriesNotAddedDueToFilter);
        }
        if (this.entriesNotAddedDueToEntrySmallness != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRIES_NOT_ADDED_DUE_TO_ENTRY_SMALLNESS, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_NO_PUT_TOO_SMALL.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_NO_PUT_TOO_SMALL.get(), this.entriesNotAddedDueToEntrySmallness);
        }
        if (this.lowMemoryOccurrences != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_LOW_MEMORY_OCCURRENCES, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_LOW_MEM_COUNT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_LOW_MEM_COUNT.get(), this.lowMemoryOccurrences);
        }
        if (this.percentFullMaxEntries != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_PERCENT_FULL_MAX_ENTRIES, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_ENTRY_COUNT_PERCENT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_ENTRY_COUNT_PERCENT.get(), this.percentFullMaxEntries);
        }
        if (this.jvmMemoryMaxPercentThreshold != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_MEMORY_MAX_PERCENT_THRESHOLD, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_JVM_MEM_MAX_PERCENT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_JVM_MEM_MAX_PERCENT.get(), this.jvmMemoryMaxPercentThreshold);
        }
        if (this.jvmMemoryCurrentPercentFull != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_MEMORY_CURRENT_PERCENT_FULL, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_JVM_MEM_CURRENT_PERCENT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_JVM_MEM_CURRENT_PERCENT.get(), this.jvmMemoryCurrentPercentFull);
        }
        if (this.jvmMemoryBelowMaxMemoryPercent != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_MEMORY_BELOW_MAX_MEMORY_PERCENT, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_JVM_MEM_BELOW_MAX_PERCENT.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_JVM_MEM_BELOW_MAX_PERCENT.get(), this.jvmMemoryBelowMaxMemoryPercent);
        }
        if (this.isFull != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_IS_FULL, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_IS_FULL.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_IS_FULL.get(), this.isFull);
        }
        if (this.capacityDetails != null) {
            FIFOEntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CAPACITY_DETAILS, MonitorMessages.INFO_FIFO_ENTRY_CACHE_DISPNAME_CAPACITY_DETAILS.get(), MonitorMessages.INFO_FIFO_ENTRY_CACHE_DESC_CAPACITY_DETAILS.get(), this.capacityDetails);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

