/*
 * Decompiled with CFR 0.152.
 */
package com.uttesh.pdfngreport;

import com.uttesh.pdfngreport.PDFGenerator;
import com.uttesh.pdfngreport.common.Constants;
import com.uttesh.pdfngreport.model.ResultMeta;
import com.uttesh.pdfngreport.util.PDFCache;
import com.uttesh.pdfngreport.util.PdfngUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;

public class PDFReportDataListener
implements ISuiteListener {
    public static Map<String, ResultMeta> result = new HashMap<String, ResultMeta>();

    public void onStart(ISuite isuite) {
        if (result != null && result.size() > 0) {
            result = new HashMap<String, ResultMeta>();
        }
    }

    public void onFinish(ISuite isuite) {
        ResultMeta resultMeta = null;
        String suiteName = isuite.getName() != null ? isuite.getName() : "";
        String configPath = isuite.getParameter("pdfngreport-properties");
        PdfngUtil pdfngUtil = new PdfngUtil();
        pdfngUtil.loadProperties(configPath);
        Map suiteResults = isuite.getResults();
        for (ISuiteResult sr : suiteResults.values()) {
            if (result.get(suiteName) != null) {
                resultMeta = result.get(suiteName);
            } else {
                resultMeta = new ResultMeta();
                resultMeta.setSuiteName(suiteName);
            }
            ITestContext tc = sr.getTestContext();
            if (tc.getFailedTests().getAllResults() != null && tc.getFailedTests().getAllResults().size() > 0) {
                resultMeta.getFailedList().add(tc.getFailedTests().getAllResults());
            }
            if (tc.getPassedTests().getAllResults() != null && tc.getPassedTests().getAllResults().size() > 0) {
                resultMeta.getPassedList().add(tc.getPassedTests().getAllResults());
            }
            if (tc.getSkippedTests().getAllResults() == null || tc.getSkippedTests().getAllResults().size() <= 0) continue;
            resultMeta.getSkippedList().add(tc.getSkippedTests().getAllResults());
        }
        if (result.size() > 0) {
            PDFGenerator generator = new PDFGenerator();
            String outpurDir = System.getProperty("pdfreport.outputdir");
            if (outpurDir == null || outpurDir.trim().length() == 0) {
                outpurDir = (String)PDFCache.getConfig("pdfreport.outputdir");
            }
            try {
                generator.generateReport(outpurDir + "\\" + suiteName + "_" + Constants.PDF_REPORT_FILE_NAME, result);
            }
            catch (Exception ex) {
                Logger.getLogger(PDFReportDataListener.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

