/*
 * Decompiled with CFR 0.152.
 */
package com.uttesh.pdfngreport;

import com.uttesh.pdfngreport.PDFGenerator;
import com.uttesh.pdfngreport.common.Constants;
import com.uttesh.pdfngreport.model.ResultMeta;
import com.uttesh.pdfngreport.util.PDFCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class PDFReportGenerateListener
implements ITestListener,
ISuiteListener {
    public static Map<String, ResultMeta> result = new HashMap<String, ResultMeta>();
    public static String suiteName = "";
    public static String className = "";

    public void onStart(ISuite isuite) {
    }

    public void onFinish(ISuite isuite) {
        System.out.println("On suite finish :" + result.size());
        if (result.size() > 0) {
            PDFGenerator generator = new PDFGenerator();
            String outpurDir = System.getProperty("pdfreport.outputdir");
            if (outpurDir == null || outpurDir.trim().length() == 0) {
                outpurDir = (String)PDFCache.getConfig("pdfreport.outputdir");
            }
            try {
                generator.generateReport(outpurDir + "\\" + Constants.PDF_REPORT_FILE_NAME, result);
            }
            catch (Exception ex) {
                Logger.getLogger(PDFReportGenerateListener.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void onTestStart(ITestResult itr) {
        className = itr.getTestClass().getName();
    }

    public void onTestSuccess(ITestResult itr) {
    }

    public void onTestFailure(ITestResult itr) {
    }

    public void onTestSkipped(ITestResult itr) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult itr) {
    }

    public void onStart(ITestContext itc) {
    }

    public void onFinish(ITestContext itc) {
        ResultMeta resultMeta = new ResultMeta();
        System.out.println("Class :" + className + " passed :" + itc.getPassedTests().getAllResults().size());
        System.out.println("Class :" + className + " failed :" + itc.getFailedTests().getAllResults().size());
        System.out.println("Class :" + className + " skipped :" + itc.getSkippedTests().getAllResults().size());
        ArrayList<Set<ITestResult>> passedList = new ArrayList<Set<ITestResult>>();
        passedList.add(itc.getPassedTests().getAllResults());
        ArrayList<Set<ITestResult>> failedList = new ArrayList<Set<ITestResult>>();
        failedList.add(itc.getFailedTests().getAllResults());
        ArrayList<Set<ITestResult>> skippedList = new ArrayList<Set<ITestResult>>();
        skippedList.add(itc.getSkippedTests().getAllResults());
        resultMeta.setFailedList(failedList);
        resultMeta.setPassedList(passedList);
        resultMeta.setSkippedList(skippedList);
        result.put(className, resultMeta);
    }
}

