/*
 * Decompiled with CFR 0.152.
 */
package com.uttesh.pdfngreport.handler;

import com.uttesh.pdfngreport.util.PdfLogger;
import com.uttesh.pdfngreport.util.PdfngUtil;
import com.uttesh.pdfngreport.util.chart.ChartStyle;
import com.uttesh.pdfngreport.util.xml.ReportData;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PdfReportHandler {
    PdfLogger logger = PdfLogger.getLogger(PdfReportHandler.class.getName());
    String reportLocation = PdfngUtil.getReportLocation();

    public int generateXmlData(ReportData reportData) {
        int fileName = UUID.randomUUID().toString().substring(0, 3).hashCode();
        File file = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ReportData.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            file = reportData.getOsName().equalsIgnoreCase("w") ? new File(this.reportLocation + "\\" + fileName + ".xml") : new File(this.reportLocation + "/" + fileName + ".xml");
            marshaller.marshal((Object)reportData, file);
        }
        catch (JAXBException ex) {
            Logger.getLogger(PdfReportHandler.class.getName()).log(Level.SEVERE, null, ex);
            new File(this.reportLocation + "/" + fileName + ".xml").delete();
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePdfReport(ReportData reportData, File reportFile) throws FileNotFoundException, FOPException, TransformerConfigurationException, TransformerException, IOException, InterruptedException, URISyntaxException {
        int fileName = this.generateXmlData(reportData);
        File xmlfile = null;
        xmlfile = reportData.getOsName().equalsIgnoreCase("w") ? new File(this.reportLocation + "\\" + fileName + ".xml") : new File(this.reportLocation + "/" + fileName + ".xml");
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("com/uttesh/config/report.xsl");
        File pdffile = reportFile;
        FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        OutputStream out = new FileOutputStream(pdffile);
        out = new BufferedOutputStream(out);
        try {
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(input));
            transformer.setParameter("versionParam", "2.0");
            StreamSource src = new StreamSource(xmlfile);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (reportData.getOsName().equalsIgnoreCase("w")) {
                new File(this.reportLocation + "\\" + fileName + ".xml").delete();
            } else {
                new File(this.reportLocation + "/" + fileName + ".xml").delete();
            }
            System.exit(-1);
        }
        finally {
            out.close();
            if (reportData.getOsName().equalsIgnoreCase("w")) {
                new File(this.reportLocation + "\\" + fileName + ".xml").delete();
                new File(this.reportLocation + "\\" + "chart.png").delete();
            } else {
                new File(this.reportLocation + "/" + fileName + ".xml").delete();
                new File(this.reportLocation + "/" + "chart.png").delete();
            }
        }
    }

    public void generateChart(DefaultPieDataset dataSet, String os) throws FileNotFoundException, IOException {
        try {
            JFreeChart chart = ChartFactory.createPieChart3D((String)"", (PieDataset)dataSet, (boolean)true, (boolean)true, (boolean)false);
            ChartStyle.theme(chart);
            PiePlot3D plot = (PiePlot3D)chart.getPlot();
            plot.setForegroundAlpha(0.6f);
            plot.setCircular(true);
            plot.setSectionPaint((Comparable)((Object)"Passed"), (Paint)Color.decode("#019244"));
            plot.setSectionPaint((Comparable)((Object)"Failed"), (Paint)Color.decode("#EE6044"));
            plot.setSectionPaint((Comparable)((Object)"Skipped"), (Paint)Color.decode("#F0AD4E"));
            Color transparent = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            plot.setLabelOutlinePaint((Paint)transparent);
            plot.setLabelBackgroundPaint((Paint)transparent);
            plot.setLabelShadowPaint((Paint)transparent);
            plot.setLabelLinkPaint((Paint)Color.GRAY);
            Font font = new Font("SansSerif", 0, 10);
            plot.setLabelFont(font);
            StandardPieSectionLabelGenerator gen = new StandardPieSectionLabelGenerator("{0}: {1} ({2})", (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0%"));
            plot.setLabelGenerator((PieSectionLabelGenerator)gen);
            if (os != null && os.equalsIgnoreCase("w")) {
                ChartUtilities.saveChartAsPNG((File)new File(this.reportLocation + "\\" + "chart.png"), (JFreeChart)chart, (int)560, (int)200);
            } else {
                ChartUtilities.saveChartAsPNG((File)new File(this.reportLocation + "/" + "chart.png"), (JFreeChart)chart, (int)560, (int)200);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (os != null && os.equalsIgnoreCase("w")) {
                new File(this.reportLocation + "\\" + "chart.png").delete();
            } else {
                new File(this.reportLocation + "/" + "chart.png").delete();
            }
            System.exit(-1);
        }
    }

    public void pieExplodeChart(DefaultPieDataset dataSet, String os) {
        try {
            JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)dataSet, (boolean)true, (boolean)true, (boolean)false);
            ChartStyle.theme(chart);
            PiePlot plot = (PiePlot)chart.getPlot();
            plot.setForegroundAlpha(0.6f);
            plot.setCircular(true);
            plot.setSectionPaint((Comparable)((Object)"Passed"), (Paint)Color.decode("#019244"));
            plot.setSectionPaint((Comparable)((Object)"Failed"), (Paint)Color.decode("#EE6044"));
            plot.setSectionPaint((Comparable)((Object)"Skipped"), (Paint)Color.decode("#F0AD4E"));
            Color transparent = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            plot.setLabelOutlinePaint((Paint)transparent);
            plot.setLabelBackgroundPaint((Paint)transparent);
            plot.setLabelShadowPaint((Paint)transparent);
            plot.setLabelLinkPaint((Paint)Color.GRAY);
            Font font = new Font("SansSerif", 0, 10);
            plot.setLabelFont(font);
            plot.setLabelPaint((Paint)Color.DARK_GRAY);
            plot.setExplodePercent((Comparable)((Object)"Passed"), 0.1);
            plot.setSimpleLabels(true);
            StandardPieSectionLabelGenerator gen = new StandardPieSectionLabelGenerator("{1} ({2})", (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0%"));
            plot.setLabelGenerator((PieSectionLabelGenerator)gen);
            if (os != null && os.equalsIgnoreCase("w")) {
                ChartUtilities.saveChartAsPNG((File)new File(this.reportLocation + "\\" + "chart.png"), (JFreeChart)chart, (int)560, (int)200);
            } else {
                ChartUtilities.saveChartAsPNG((File)new File(this.reportLocation + "/" + "chart.png"), (JFreeChart)chart, (int)560, (int)200);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (os != null && os.equalsIgnoreCase("w")) {
                new File(this.reportLocation + "\\" + "chart.png").delete();
            } else {
                new File(this.reportLocation + "/" + "chart.png").delete();
            }
            System.exit(-1);
        }
    }
}

