/*
 * Decompiled with CFR 0.152.
 */
package com.uttesh.pdfngreport.util;

import com.uttesh.pdfngreport.exceptionHandler.ReportException;
import com.uttesh.pdfngreport.util.ExceptionBean;
import com.uttesh.pdfngreport.util.PDFCache;
import com.uttesh.pdfngreport.util.xml.ExceptionMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ExceptionSummary {
    PDFCache cache = new PDFCache();

    public List<ExceptionMeta> getSummary() {
        ArrayList<ExceptionMeta> list = new ArrayList<ExceptionMeta>();
        try {
            ExceptionSummary exceptionSummary = this;
            Set<Object> keys = exceptionSummary.cache.getAllKeys();
            ExceptionMeta exceptionMeta = null;
            for (Object key : keys) {
                exceptionMeta = new ExceptionMeta();
                ExceptionBean exceptionBean = (ExceptionBean)PDFCache.get(key);
                exceptionMeta.setErrorCode((String)key);
                exceptionMeta.setDescription(ExceptionSummary.getStackTraceString(exceptionBean.getThrowable()));
                StackTraceElement[] elems = exceptionBean.getThrowable().getStackTrace();
                exceptionMeta.setHeading(exceptionBean.getLable());
                for (StackTraceElement stackTraceElement : elems) {
                    exceptionMeta.setStackTrace(stackTraceElement.toString());
                }
                if (exceptionMeta == null || exceptionMeta.getDescription().length() <= 0 || exceptionMeta.getStackTrace().length() <= 0) continue;
                list.add(exceptionMeta);
            }
            return list;
        }
        catch (Exception e) {
            throw new ReportException("Exception Summary", e);
        }
    }

    private static String getStackTraceString(Throwable e) {
        Throwable cause;
        StringBuilder sb = new StringBuilder();
        sb.append(e.toString());
        sb.append("\n");
        StackTraceElement[] stack = e.getStackTrace();
        if (stack != null) {
            for (StackTraceElement stackTraceElement : stack) {
                sb.append("\tat ");
                sb.append(stackTraceElement.toString());
                sb.append("\n");
            }
        }
        if ((cause = e.getCause()) != null) {
            sb.append("Caused by: ");
            sb.append(ExceptionSummary.getStackTraceString(cause));
        }
        return sb.toString();
    }
}

