/*
 * Decompiled with CFR 0.152.
 */
package com.uttesh.pdfngreport.util;

import com.uttesh.pdfngreport.common.ImageUtils;
import com.uttesh.pdfngreport.model.SystemMeta;
import com.uttesh.pdfngreport.util.PDFCache;
import com.uttesh.pdfngreport.util.xml.ReportData;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class PdfngUtil {
    public static Properties prop = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(String path) {
        InputStream input = null;
        try {
            PDFCache cache = new PDFCache();
            input = new FileInputStream(path);
            prop.load(input);
            for (String string : prop.keySet()) {
                PDFCache.putConfig(string, prop.get(string));
            }
            PDFCache.putConfig("pdfngreport-properties", prop.get("pdfreport.title.text"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getProp(String name) {
        return prop.getProperty(name);
    }

    public static String getReportLocation() {
        String location = System.getProperty("pdfreport.outputdir");
        if (location == null || location.trim().length() == 0) {
            location = (String)PDFCache.getConfig("pdfreport.outputdir");
        }
        return location;
    }

    public void populateReportDataProperties(ReportData reportData) throws Exception {
        String exceptionPage;
        String titleAlign;
        String reportTitle = (String)PDFCache.getConfig("pdfreport.title.text");
        String reportLocation = (String)PDFCache.getConfig("pdfreport.outputdir");
        String logoFile = (String)PDFCache.getConfig("pdfreport.report.logo.file");
        String logo = (String)PDFCache.getConfig("pdfreport.logo");
        String chart = (String)PDFCache.getConfig("pdfreport.chart");
        String logoAlign = (String)PDFCache.getConfig("pdfreport.report.logo.align");
        if (logoAlign == null || logoAlign.trim().length() == 0) {
            logoAlign = "right";
        }
        if ((titleAlign = (String)PDFCache.getConfig("pdfreport.title.align")) == null || titleAlign.trim().length() == 0) {
            titleAlign = "left";
        }
        exceptionPage = ((exceptionPage = (String)PDFCache.getConfig("pdfreport.exception.page")) != null || exceptionPage.trim().length() > 0) && exceptionPage.equalsIgnoreCase("hide") ? "hide" : "show";
        InputStream exceptionIcon = this.getClass().getClassLoader().getResourceAsStream("com/uttesh/images/round/exception.png");
        reportData.setReportTitle(reportTitle);
        reportData.setTitleAlign(titleAlign);
        reportData.setReportLocation(reportLocation);
        reportData.setChart(chart);
        reportData.setLogoFile(logoFile);
        reportData.setLogo(logo);
        reportData.setLogoAlign(logoAlign);
        reportData.setExceptionPage(exceptionPage);
        reportData.setExceptionIcon(ImageUtils.imageToBase64String(exceptionIcon));
        this.populatedSystemDetails(reportData);
    }

    public String getSystemDetails(String buildVersion) {
        try {
            SystemMeta systemMeta = new SystemMeta();
            systemMeta.setHostName(this.getHostName());
            systemMeta.setJavaVersion(System.getProperty("java.version"));
            systemMeta.setJvmVendor(System.getProperty("java.vendor"));
            systemMeta.setOsArchitecture(System.getProperty("os.arch"));
            systemMeta.setOs(System.getProperty("os.name"));
            systemMeta.setUserName(System.getProperty("user.name"));
            if (buildVersion == null && buildVersion.trim().length() == 0) {
                buildVersion = "";
            }
            String details = buildVersion.trim() + " - " + systemMeta.getUserName() + "@" + systemMeta.getHostName() + " - java " + systemMeta.getJavaVersion() + "(" + systemMeta.getJvmVendor() + ") - " + systemMeta.getOs() + "(" + systemMeta.getOsArchitecture() + ")";
            System.out.println(" build system details : " + details);
            return details;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void populatedSystemDetails(ReportData reportData) {
        String buildVersion = (String)PDFCache.getConfig("pdfreport.app.build.version");
        reportData.setBuildVersion(buildVersion != null ? buildVersion : "");
        String buildDetailsMode = (String)PDFCache.getConfig("pdfreport.build.system.details.by");
        String name = System.getProperty("os.name").trim().substring(0, 1);
        reportData.setOsName(name.toLowerCase());
        if (buildDetailsMode != null && buildDetailsMode.equalsIgnoreCase("manual")) {
            reportData.setBuildSystemDetailsBy("manual");
            reportData.setAdditionLine1((String)PDFCache.getConfig("pdfreport.additional.line1"));
            reportData.setAdditionLine2((String)PDFCache.getConfig("pdfreport.additional.line2"));
            reportData.setAdditionLine3((String)PDFCache.getConfig("pdfreport.additional.line3"));
        } else if (buildDetailsMode != null && buildDetailsMode.equalsIgnoreCase("code")) {
            reportData.setBuildSystemDetailsBy("code");
            reportData.setBuildSystemDetails(this.getSystemDetails(buildVersion));
        }
    }

    private String getHostName() throws UnknownHostException {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr != null) {
                return addr.getHostName();
            }
        }
        catch (Exception e) {
            System.out.println("Unable to find the host name, Still execution can continue");
        }
        return "";
    }
}

