/*
 * Decompiled with CFR 0.152.
 */
package com.uttesh.pdfngreport.util.pdf;

import com.uttesh.pdfngreport.common.Constants;
import com.uttesh.pdfngreport.model.TableMeta;
import com.uttesh.pdfngreport.util.ExceptionBean;
import com.uttesh.pdfngreport.util.PDFCache;
import com.uttesh.pdfngreport.util.PdfLogger;
import com.uttesh.pdfngreport.util.xml.ColumnHeader;
import com.uttesh.pdfngreport.util.xml.Row;
import com.uttesh.pdfngreport.util.xml.RowMeta;
import com.uttesh.pdfngreport.util.xml.Table;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class GenerateTable {
    PdfLogger logger = PdfLogger.getLogger(GenerateTable.class.getName());
    private int exceptionCount = 0;
    private static long totalExecutionTime = 0L;

    public void generate(Set<ITestResult> results, Table table, String status) {
        ArrayList<ColumnHeader> columns = new ArrayList<ColumnHeader>();
        String[] names = Constants.STATUS_TABLE_COLUMS;
        String failedTestScreenShotLink = null;
        String showLink = null;
        String exceptionPage = null;
        if (status.equalsIgnoreCase("PASSED")) {
            GenerateTable.populateColumnHeader(columns, names, "#5CB85C");
        } else if (status.equalsIgnoreCase("FAILED")) {
            exceptionPage = (String)PDFCache.getConfig("pdfreport.exception.page");
            if ((exceptionPage != null || exceptionPage.trim().length() > 0) && exceptionPage.equalsIgnoreCase("hide")) {
                exceptionPage = "hide";
                names = Constants.FAILED_STATUS_TABLE_COLUMS_NO_EXCEPTION;
            } else {
                exceptionPage = "show";
                showLink = (String)PDFCache.getConfig("pdfreport.show.selenium.screenshot.link");
                if (showLink != null) {
                    failedTestScreenShotLink = (String)PDFCache.getConfig("pdfreport.selenium.failed.test.screenshot.outputdir");
                }
                names = Constants.FAILED_STATUS_TABLE_COLUMS;
            }
            GenerateTable.populateColumnHeader(columns, names, "#D9534F");
        } else {
            GenerateTable.populateColumnHeader(columns, names, "#F0AD4E");
        }
        String timeFormat = (String)PDFCache.getConfig("pdfngreport.time.column.format");
        if (timeFormat == null || timeFormat.isEmpty()) {
            timeFormat = "MMMM dd YYYY hh:MM:ss";
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<TableMeta> dataList = new ArrayList<TableMeta>();
        this.populateTableData(dataList, results, status, timeFormat);
        Collections.sort(dataList, TableMeta.TableMetaComparator);
        Row row = null;
        RowMeta rowMeta = null;
        for (TableMeta tableMeta : dataList) {
            row = new Row();
            rowMeta = new RowMeta();
            if (exceptionPage != null) {
                rowMeta.setExceptionPage(exceptionPage);
            }
            if (failedTestScreenShotLink != null) {
                rowMeta.setFailedScreenShotLocation(failedTestScreenShotLink);
                rowMeta.setShowScreenshotLink("show");
            }
            rowMeta.setPackagePath(tableMeta.getPackagePath());
            rowMeta.setClassName(tableMeta.getClassName());
            if (tableMeta.getTestName() != null && tableMeta.getTestName().trim().length() > 0) {
                rowMeta.setMethod(tableMeta.getTestName());
            } else {
                rowMeta.setMethod(tableMeta.getMethod());
            }
            rowMeta.setTimeTaken(tableMeta.getTimeTaken());
            rowMeta.setTime(tableMeta.getTime());
            rowMeta.setStatus(status);
            rowMeta.setBlockId(tableMeta.getBlockId());
            rowMeta.setTableName(status);
            row.setRowMeta(rowMeta);
            rows.add(row);
        }
        table.setColumnHeader(columns);
        table.setRow(rows);
        String name = System.getProperty("os.name").trim().substring(0, 1);
        table.setOsName(name.toLowerCase());
    }

    private String populateSpace(String text) {
        StringBuilder sb = new StringBuilder();
        if (text.length() > 30) {
            sb.append(text.substring(0, 30));
            sb.append("\n");
            sb.append(text.substring(30, text.length()));
            sb.append("\n");
            return sb.toString();
        }
        return text;
    }

    private void populateTableData(List<TableMeta> tableMetas, Set<ITestResult> results, String status, String timeFormat) {
        PdfLogger.log("----------------------- " + status + " Test class/methods " + "-----------------");
        TableMeta tableMeta = null;
        for (ITestResult result : results) {
            tableMeta = new TableMeta();
            tableMeta.setStatus(status);
            String[] str = result.getTestClass().getName().trim().split("\\.");
            String className = result.getTestClass().getName();
            String _className = "";
            if (str.length > 0) {
                String packageName;
                String instanceName = result.getTestClass().getName();
                className = str[str.length - 1];
                if (className != null) {
                    _className = className;
                    _className = this.populateSpace(_className);
                }
                if ((packageName = instanceName.substring(0, instanceName.indexOf(className) - 1)) != null) {
                    packageName = this.populateSpace(packageName);
                }
                tableMeta.setPackagePath(packageName);
                tableMeta.setClassName(_className);
            } else {
                tableMeta.setPackagePath(_className);
                tableMeta.setClassName(_className);
            }
            PdfLogger.log("| class :: " + className + " :: method :: " + result.getMethod().getMethodName() + " |");
            PdfLogger.log("-------------------------------------------------------------------------");
            String testName = result.getTestName();
            tableMeta.setTestName(testName);
            String methodName = result.getMethod().getMethodName();
            Test _test = result.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class);
            if (_test != null && _test.testName() != null && _test.testName().trim().length() > 0) {
                methodName = _test.testName();
            }
            tableMeta.setMethod(this.populateSpace(methodName));
            long duration = result.getEndMillis() - result.getStartMillis();
            totalExecutionTime += duration;
            tableMeta.setTimeTaken(duration + "");
            String timeTaken = new SimpleDateFormat(timeFormat).format(result.getStartMillis());
            tableMeta.setTime(timeTaken);
            tableMeta.setBlockId(className + "_" + result.getMethod().getMethodName());
            if (status.equalsIgnoreCase("FAILED")) {
                ExceptionBean exceptionBean = new ExceptionBean();
                exceptionBean.setLable(className + "(" + result.getMethod().getMethodName() + ")");
                this.exceptionLog(result, tableMeta, exceptionBean);
            }
            tableMetas.add(tableMeta);
        }
        PdfLogger.log("--------------------- END " + status + " Test class/methods " + "--------------------");
        PdfLogger.log("\n\n");
    }

    private void exceptionLog(ITestResult result, TableMeta tableMeta, ExceptionBean exceptionBean) {
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            tableMeta.setBlockId(tableMeta.getClassName() + "_" + tableMeta.getMethod());
            exceptionBean.setThrowable(throwable);
            PDFCache.put(tableMeta.getBlockId(), exceptionBean);
            ++this.exceptionCount;
        }
    }

    public static void populateColumnHeader(List<ColumnHeader> columns, String[] names, String color) {
        ColumnHeader columnHeader = null;
        for (String name : names) {
            columnHeader = new ColumnHeader();
            columnHeader.setColorCode(color);
            columnHeader.setName(name);
            columns.add(columnHeader);
        }
    }

    public int getExceptionCount() {
        return this.exceptionCount;
    }

    public void setExceptionCount(int exceptionCount) {
        this.exceptionCount = exceptionCount;
    }

    public static long getTotalExecutionTime() {
        return totalExecutionTime;
    }

    public static void setTotalExecutionTime(long totalExecutionTime) {
        GenerateTable.totalExecutionTime = totalExecutionTime;
    }
}

