/*
 * Decompiled with CFR 0.152.
 */
package com.uttesh.pdfngreport.util.pdf;

import com.uttesh.pdfngreport.common.Constants;
import com.uttesh.pdfngreport.common.ImageUtils;
import com.uttesh.pdfngreport.handler.PdfReportHandler;
import com.uttesh.pdfngreport.model.ResultMeta;
import com.uttesh.pdfngreport.util.PDFCache;
import com.uttesh.pdfngreport.util.PdfngUtil;
import com.uttesh.pdfngreport.util.pdf.SuccessTable;
import com.uttesh.pdfngreport.util.xml.ColumnHeader;
import com.uttesh.pdfngreport.util.xml.Row;
import com.uttesh.pdfngreport.util.xml.RowMeta;
import com.uttesh.pdfngreport.util.xml.Table;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.general.DefaultPieDataset;
import org.testng.ITestResult;

public class StatisticsTable {
    int passed = 0;
    int skipped = 0;
    int failed = 0;
    double percent = 0.0;
    String reportLocation = PdfngUtil.getReportLocation();

    public void populateData(Map<String, ResultMeta> result, Table statisticsTable) throws IOException {
        ArrayList<ColumnHeader> columns = new ArrayList<ColumnHeader>();
        String[] names = Constants.STATISTIC_TABLE_COLUMS;
        PdfReportHandler pdfReportHandler = new PdfReportHandler();
        String chartDisplay = "show";
        if (System.getProperty("pdfreport.chart") != null && ((chartDisplay = System.getProperty("pdfreport.chart")) == null || chartDisplay.trim().length() == 0)) {
            chartDisplay = (String)PDFCache.getConfig("pdfreport.chart");
        }
        String pieChartType = "normal";
        if (chartDisplay.equalsIgnoreCase("show") && ((pieChartType = System.getProperty("pdfreport.pie.chart.type")) == null || pieChartType.trim().length() == 0)) {
            pieChartType = (String)PDFCache.getConfig("pdfreport.pie.chart.type");
        }
        String os = System.getProperty("os.name").trim().substring(0, 1);
        statisticsTable.setOsName(os.toLowerCase());
        for (String className : result.keySet()) {
            ResultMeta resultMeta = result.get(className);
            this.passed += this.getPassedCount(resultMeta);
            this.skipped += this.getSkippedCount(resultMeta);
            this.failed += this.getFailedCount(resultMeta);
            double total = this.passed + this.skipped + this.failed;
            this.percent = (double)this.passed / total * 100.0;
            this.percent = (double)Math.round(this.percent * 100.0) / 100.0;
        }
        StatisticsTable.populateColumnHeader(columns, names, "#5BC0DE");
        ArrayList<Row> rows = new ArrayList<Row>();
        RowMeta rowMeta = new RowMeta();
        rowMeta.setPassed("" + this.passed);
        rowMeta.setSkipped("" + this.skipped);
        rowMeta.setFailed("" + this.failed);
        rowMeta.setPercentage("" + this.percent + "%");
        rowMeta.setTableName("Statistics");
        Row row = new Row();
        row.setRowMeta(rowMeta);
        rows.add(row);
        statisticsTable.setColumnHeader(columns);
        statisticsTable.setRow(rows);
        statisticsTable.setTableName("Statistics");
        statisticsTable.setTableHeaderColor("#0079B6");
        try {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("com/uttesh/images/round/statistics.png");
            statisticsTable.setTableHeaderIcon(ImageUtils.imageToBase64String(input));
        }
        catch (Exception ex) {
            Logger.getLogger(SuccessTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        statisticsTable.setReportLocation(this.reportLocation);
        if (chartDisplay.equalsIgnoreCase("show")) {
            DefaultPieDataset dataSet = new DefaultPieDataset();
            dataSet.setValue((Comparable)((Object)"Failed"), (double)this.failed);
            dataSet.setValue((Comparable)((Object)"Skipped"), (double)this.skipped);
            dataSet.setValue((Comparable)((Object)"Passed"), (double)this.passed);
            if (pieChartType.equalsIgnoreCase("normal")) {
                pdfReportHandler.generateChart(dataSet, os);
            } else {
                pdfReportHandler.pieExplodeChart(dataSet, os);
            }
        }
    }

    public static void populateColumnHeader(List<ColumnHeader> columns, String[] names, String color) {
        ColumnHeader columnHeader = null;
        for (String name : names) {
            columnHeader = new ColumnHeader();
            columnHeader.setColorCode(color);
            columnHeader.setName(name);
            columns.add(columnHeader);
        }
    }

    private int getPassedCount(ResultMeta resultMeta) {
        int count = 0;
        for (Set<ITestResult> passed : resultMeta.getPassedList()) {
            count += passed.size();
        }
        return count;
    }

    private int getFailedCount(ResultMeta resultMeta) {
        int count = 0;
        for (Set<ITestResult> failed : resultMeta.getFailedList()) {
            count += failed.size();
        }
        return count;
    }

    private int getSkippedCount(ResultMeta resultMeta) {
        int count = 0;
        for (Set<ITestResult> skipped : resultMeta.getSkippedList()) {
            count += skipped.size();
        }
        return count;
    }
}

