/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;

public class LocalhostUtil {
    private static String hostIp = "NONE";
    private static String hostName = "NONE";
    public static String localhostName;

    public static String getHostIp() {
        try {
            if (hostIp.equals("NONE")) {
                hostIp = LocalhostUtil.getLocalhostStr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostIp;
    }

    public static String getHostName() {
        try {
            if (hostName.equals("NONE")) {
                hostName = LocalhostUtil.getLocalHostName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    private static String getLocalhostStr() {
        InetAddress localhost = LocalhostUtil.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    private static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = LocalhostUtil.localAddressList((Filter<InetAddress>)((Filter)address -> !address.isLoopbackAddress() && address instanceof Inet4Address));
        if (CollUtil.isNotEmpty(localAddressList)) {
            InetAddress address2 = null;
            for (InetAddress inetAddress : localAddressList) {
                if (!inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (null != address2) continue;
                address2 = inetAddress;
            }
            if (null != address2) {
                return address2;
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UtilException((Throwable)e);
        }
        if (networkInterfaces == null) {
            throw new UtilException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.accept((Object)inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    private static String getLocalHostName() {
        if (StrUtil.isNotBlank((CharSequence)localhostName)) {
            return localhostName;
        }
        InetAddress localhost = LocalhostUtil.getLocalhost();
        if (null != localhost) {
            String name = localhost.getHostName();
            if (StrUtil.isEmpty((CharSequence)name)) {
                name = localhost.getHostAddress();
            }
            localhostName = name;
        }
        return localhostName;
    }
}

