/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data;

import com.google.common.base.Objects;
import com.yubico.u2f.U2fException;
import com.yubico.u2f.data.DataObject;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class Device
extends DataObject
implements Serializable {
    private static final long serialVersionUID = -142942195464329902L;
    public static final int INITIAL_COUNTER_VALUE = 0;
    private final byte[] keyHandle;
    private final byte[] publicKey;
    private final byte[] attestationCert;
    private int counter;

    public Device(byte[] keyHandle, byte[] publicKey, X509Certificate attestationCert, int counter) {
        this.keyHandle = keyHandle;
        this.publicKey = publicKey;
        this.attestationCert = attestationCert.getPublicKey().getEncoded();
        this.counter = counter;
    }

    public byte[] getKeyHandle() {
        return this.keyHandle;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate getAttestationCertificate() throws CertificateException {
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteInputStream(this.attestationCert));
    }

    public int getCounter() {
        return this.counter;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyHandle, this.publicKey, this.attestationCert});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Device)) {
            return false;
        }
        Device that = (Device)obj;
        return Arrays.equals(this.keyHandle, that.keyHandle) && Arrays.equals(this.publicKey, that.publicKey) && Arrays.equals(this.attestationCert, that.attestationCert);
    }

    public String toString() {
        return this.toJson();
    }

    public static Device fromJson(String json) {
        return (Device)GSON.fromJson(json, Device.class);
    }

    public int checkAndIncrementCounter(int clientCounter) throws U2fException {
        if (clientCounter <= this.counter) {
            throw new U2fException("Counter value smaller than expected!");
        }
        return ++this.counter;
    }
}

