/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages.key;

import com.google.common.base.Objects;
import com.yubico.u2f.U2F;
import com.yubico.u2f.U2fException;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.data.messages.key.util.ByteSink;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class RawAuthenticateResponse {
    public static final byte USER_PRESENT_FLAG = 1;
    private final byte userPresence;
    private final int counter;
    private final byte[] signature;

    public RawAuthenticateResponse(byte userPresence, int counter, byte[] signature) {
        this.userPresence = userPresence;
        this.counter = counter;
        this.signature = signature;
    }

    public static RawAuthenticateResponse fromBase64(String rawDataBase64) throws U2fException {
        ByteInputStream bytes = new ByteInputStream(Base64.decodeBase64((String)rawDataBase64));
        return new RawAuthenticateResponse(bytes.readSigned(), bytes.readInteger(), bytes.readAll());
    }

    public void checkSignature(String appId, byte[] clientData, byte[] publicKey) throws U2fException {
        byte[] signedBytes = RawAuthenticateResponse.packBytesToSign(U2F.crypto.hash(appId), this.userPresence, this.counter, U2F.crypto.hash(clientData));
        U2F.crypto.checkSignature(U2F.crypto.decodePublicKey(publicKey), signedBytes, this.signature);
    }

    public static byte[] packBytesToSign(byte[] appIdHash, byte userPresence, int counter, byte[] challengeHash) {
        return ByteSink.create().put(appIdHash).put(userPresence).putInt(counter).put(challengeHash).toByteArray();
    }

    public byte getUserPresence() {
        return this.userPresence;
    }

    public int getCounter() {
        return this.counter;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userPresence, this.counter, this.signature});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawAuthenticateResponse other = (RawAuthenticateResponse)obj;
        if (this.counter != other.counter) {
            return false;
        }
        if (!Arrays.equals(this.signature, other.signature)) {
            return false;
        }
        return this.userPresence == other.userPresence;
    }

    public void checkUserPresence() throws U2fException {
        if (this.userPresence != 1) {
            throw new U2fException("User presence invalid during authentication");
        }
    }
}

