/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages.key;

import com.google.common.base.Objects;
import com.yubico.u2f.U2F;
import com.yubico.u2f.U2fException;
import com.yubico.u2f.data.Device;
import com.yubico.u2f.data.messages.key.util.ByteInputStream;
import com.yubico.u2f.data.messages.key.util.ByteSink;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class RawRegisterResponse {
    public static final byte REGISTRATION_RESERVED_BYTE_VALUE = 5;
    public static final byte REGISTRATION_SIGNED_RESERVED_BYTE_VALUE = 0;
    final byte[] userPublicKey;
    final byte[] keyHandle;
    final X509Certificate attestationCertificate;
    final byte[] signature;

    public RawRegisterResponse(byte[] userPublicKey, byte[] keyHandle, X509Certificate attestationCertificate, byte[] signature) {
        this.userPublicKey = userPublicKey;
        this.keyHandle = keyHandle;
        this.attestationCertificate = attestationCertificate;
        this.signature = signature;
    }

    public static RawRegisterResponse fromBase64(String rawDataBase64) throws U2fException {
        ByteInputStream bytes = new ByteInputStream(Base64.decodeBase64((String)rawDataBase64));
        byte reservedByte = bytes.readSigned();
        if (reservedByte != 5) {
            throw new U2fException(String.format("Incorrect value of reserved byte. Expected: %d. Was: %d", (byte)5, reservedByte));
        }
        try {
            return new RawRegisterResponse(bytes.read(65), bytes.read(bytes.readUnsigned()), (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bytes), bytes.readAll());
        }
        catch (CertificateException e) {
            throw new U2fException("Error when parsing attestation certificate", e);
        }
    }

    public void checkSignature(String appId, byte[] clientData) throws U2fException {
        byte[] signedBytes = RawRegisterResponse.packBytesToSign(U2F.crypto.hash(appId), U2F.crypto.hash(clientData), this.keyHandle, this.userPublicKey);
        U2F.crypto.checkSignature(this.attestationCertificate, signedBytes, this.signature);
    }

    public static byte[] packBytesToSign(byte[] appIdHash, byte[] clientDataHash, byte[] keyHandle, byte[] userPublicKey) throws U2fException {
        return ByteSink.create().put((byte)0).put(appIdHash).put(clientDataHash).put(keyHandle).put(userPublicKey).toByteArray();
    }

    public Device createDevice() {
        return new Device(this.keyHandle, this.userPublicKey, this.attestationCertificate, 0);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userPublicKey, this.keyHandle, this.attestationCertificate, this.signature});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawRegisterResponse other = (RawRegisterResponse)obj;
        if (!this.attestationCertificate.equals(other.attestationCertificate)) {
            return false;
        }
        if (!Arrays.equals(this.keyHandle, other.keyHandle)) {
            return false;
        }
        if (!Arrays.equals(this.signature, other.signature)) {
            return false;
        }
        return Arrays.equals(this.userPublicKey, other.userPublicKey);
    }
}

