/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.Conversation;
import dalma.ConversationState;
import dalma.Engine;
import dalma.container.LogUtil;
import dalma.impl.XmlFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompletedConversation
implements Conversation,
Serializable {
    private final int id;
    private final String title;
    private final long startDate;
    private final long endDate;
    private final ConversationState state;
    private final LogRecord[] logs;
    private transient List<LogRecord> logView;

    CompletedConversation(Conversation that) {
        this.id = that.getId();
        this.title = that.getTitle();
        this.startDate = that.getStartDate().getTime();
        this.endDate = that.getCompletionDate().getTime();
        this.state = that.getState();
        ArrayList<LogRecord> ll = new ArrayList<LogRecord>();
        for (LogRecord lr : that.getLog()) {
            if (lr == null) continue;
            ll.add(lr);
        }
        this.logs = ll.toArray(new LogRecord[ll.size()]);
    }

    public int getId() {
        return this.id;
    }

    public Engine getEngine() {
        throw this.uoe();
    }

    public ConversationState getState() {
        return this.state;
    }

    public void remove(Throwable cause) {
        throw this.uoe();
    }

    public void join() {
        throw this.uoe();
    }

    public String getTitle() {
        return this.title;
    }

    public List<LogRecord> getLog() {
        if (this.logView == null) {
            this.logView = Collections.unmodifiableList(Arrays.asList(this.logs));
        }
        return this.logView;
    }

    public Date getStartDate() {
        return new Date(this.startDate);
    }

    public Date getCompletionDate() {
        return new Date(this.endDate);
    }

    public Logger getLogger() {
        return LogUtil.NULL_LOGGER;
    }

    private UnsupportedOperationException uoe() {
        return new UnsupportedOperationException("This operation is not available on the completed conversation");
    }

    public static CompletedConversation load(File file) throws IOException {
        return (CompletedConversation)new XmlFile(file).read();
    }

    public void save(File file) throws IOException {
        new XmlFile(file).write((Object)this);
    }
}

