/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.Executor;
import dalma.container.ClassLoaderImpl;
import dalma.container.ContainerMBean;
import dalma.container.FailedOperationException;
import dalma.container.LogUtil;
import dalma.container.MBeanProxy;
import dalma.container.Module;
import dalma.container.Redeployer;
import dalma.container.WorkflowApplication;
import dalma.helpers.Java5Executor;
import dalma.impl.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Container
implements ContainerMBean {
    final File homeDir;
    final File appsDir;
    protected final Executor executor;
    final Map<String, WorkflowApplication> applications;
    final List<Module> modules;
    private final Redeployer redeployer;
    protected final MBeanServer mbeanServer;
    final ClassLoader appClassLoader;
    private static final Logger DEFAULT_LOGGER = Logger.getLogger(Container.class.getName());
    final Logger loggerAggregate = LogUtil.newAnonymousLogger(DEFAULT_LOGGER);
    private final Logger logger = LogUtil.newAnonymousLogger(this.loggerAggregate);

    public Container(File root, Executor executor) throws IOException {
        this.homeDir = root.getAbsoluteFile();
        this.modules = this.findModules();
        this.appsDir = new File(this.homeDir, "apps");
        this.executor = executor;
        this.appClassLoader = this.createClassLoader();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.applications = this.findApps();
        for (WorkflowApplication app : this.applications.values()) {
            try {
                if (!app.isConfigured()) continue;
                app.start();
            }
            catch (FailedOperationException e) {
                this.logger.log(Level.WARNING, "Failed to start " + app.getName(), e);
            }
        }
        try {
            MBeanProxy.register(this.mbeanServer, new ObjectName("dalma:dir=" + ObjectName.quote(this.homeDir.toString())), ContainerMBean.class, this);
        }
        catch (JMException e) {
            this.logger.log(Level.WARNING, "Failed to register to JMX", e);
        }
        this.redeployer = new Redeployer(this);
        this.logger.info("Auto-redeployment activated");
    }

    public Logger getAggregateLogger() {
        return this.loggerAggregate;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private ClassLoader createClassLoader() throws IOException {
        ClassLoaderImpl cl = new ClassLoaderImpl(this.getClass().getClassLoader());
        cl.addJarFiles(new File(this.homeDir, "lib"));
        for (Module mod : this.modules) {
            cl.addJarFiles(mod.dir);
        }
        return cl;
    }

    @Override
    public void stop() {
        for (WorkflowApplication app : this.applications.values()) {
            app.stop();
        }
    }

    @Override
    public void unload() {
        for (WorkflowApplication app : this.applications.values()) {
            app.unload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized WorkflowApplication deploy(String name, byte[] data) throws FailedOperationException, InterruptedException {
        this.logger.info("Accepting application '" + name + "'");
        File tmpFile = new File(this.appsDir, name + ".tmp");
        try {
            FileOutputStream os = new FileOutputStream(tmpFile);
            try {
                ((OutputStream)os).write(data);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new FailedOperationException("Failed to write to a file", e);
        }
        Future<WorkflowApplication> ft = this.redeployer.getFuture(new File(this.appsDir, name));
        File darFile = new File(this.appsDir, name + ".dar");
        if (darFile.exists()) {
            darFile.delete();
        }
        tmpFile.renameTo(darFile);
        try {
            return ft.get(15L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw new FailedOperationException("Deployment failed", e.getCause());
        }
        catch (TimeoutException e) {
            throw new FailedOperationException("Operation timed out", e);
        }
    }

    protected WorkflowApplication deploy(File appsubdir) throws FailedOperationException {
        WorkflowApplication wa = new WorkflowApplication(this, appsubdir);
        this.applications.put(wa.getName(), wa);
        if (wa.isConfigured()) {
            wa.start();
        }
        return wa;
    }

    public Collection<WorkflowApplication> getApplications() {
        return Collections.unmodifiableCollection(this.applications.values());
    }

    public WorkflowApplication getApplication(String name) {
        return this.applications.get(name);
    }

    private List<Module> findModules() {
        ArrayList<Module> r = new ArrayList<Module>();
        File[] modules = new File(this.homeDir, "modules").listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        if (modules != null) {
            for (File mod : modules) {
                r.add(new Module(this, mod));
            }
        }
        return Collections.unmodifiableList(r);
    }

    private Map<String, WorkflowApplication> findApps() {
        File[] dars;
        if (!this.appsDir.exists()) {
            this.logger.severe("Workflow application directory doesn't exist: " + this.appsDir);
            return Collections.emptyMap();
        }
        for (File dar : dars = this.appsDir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.getPath().endsWith(".dar");
            }
        })) {
            this.explode(dar);
        }
        File[] subdirs = this.appsDir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        Hashtable<String, WorkflowApplication> apps = new Hashtable<String, WorkflowApplication>();
        for (File subdir : subdirs) {
            try {
                apps.put(subdir.getName(), new WorkflowApplication(this, subdir));
            }
            catch (FailedOperationException e) {
                this.logger.log(Level.WARNING, "Failed to load from " + subdir, e);
            }
        }
        return apps;
    }

    @Override
    public File getHomeDir() {
        return this.homeDir;
    }

    public File getConfigFile() {
        return new File(new File(this.homeDir, "conf"), "dalma.properties");
    }

    public static Container create(File home) throws IOException {
        Properties conf = Container.loadProperties(home);
        Container container = new Container(home, (Executor)new Java5Executor(Executors.newFixedThreadPool(Container.readProperty(conf, "thread.count", 5))));
        Logger logger = container.logger;
        int jmxPort = Container.readProperty(conf, "jmx.port", -1);
        if (jmxPort >= 0) {
            try {
                logger.info("Initializing JMXMP connector at port " + jmxPort);
                JMXServiceURL url = new JMXServiceURL("jmxmp", null, jmxPort);
                JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, ManagementFactory.getPlatformMBeanServer());
                cs.start();
                logger.info("Started JMXMP connector");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to start JMXMP", e);
            }
        }
        return container;
    }

    private static int readProperty(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            DEFAULT_LOGGER.severe("Configuration value for " + key + " must be int, but found \"" + value + "\"");
            return defaultValue;
        }
    }

    private static File getConfigFile(File home, String name) {
        return new File(new File(home, "conf"), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File home) {
        Properties props = new Properties();
        File config = Container.getConfigFile(home, "dalma.properties");
        if (config.exists()) {
            try {
                FileInputStream in = new FileInputStream(config);
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                DEFAULT_LOGGER.log(Level.SEVERE, "Failed to read " + config, e);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void explode(File dar) {
        try {
            String name = dar.getName();
            File exploded = new File(dar.getParentFile(), name.substring(0, name.length() - 4));
            if (exploded.exists()) {
                if (exploded.lastModified() > dar.lastModified()) {
                    return;
                }
                Util.deleteRecursive((File)exploded);
            }
            this.logger.info("Extracting " + dar);
            byte[] buf = new byte[1024];
            JarFile archive = new JarFile(dar);
            Enumeration<JarEntry> e = archive.entries();
            while (e.hasMoreElements()) {
                JarEntry j = e.nextElement();
                File dst = new File(exploded, j.getName());
                if (j.isDirectory()) {
                    dst.mkdirs();
                    continue;
                }
                dst.getParentFile().mkdirs();
                InputStream in = archive.getInputStream(j);
                FileOutputStream out = new FileOutputStream(dst);
                try {
                    int sz;
                    while ((sz = in.read(buf)) >= 0) {
                        out.write(buf, 0, sz);
                    }
                }
                finally {
                    in.close();
                    out.close();
                }
            }
            archive.close();
        }
        catch (IOException x) {
            this.logger.log(Level.SEVERE, "Unable to extract " + dar, x);
        }
    }

    static {
        try {
            new URL("http://dummy/").openConnection().setDefaultUseCaches(false);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

