/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

abstract class FileChangeMonitor {
    private static final Logger logger = Logger.getLogger(FileChangeMonitor.class.getName());
    private static final Set<WeakReference<FileChangeMonitor>> monitors = new HashSet<WeakReference<FileChangeMonitor>>();
    private static final Thread monitorThread = new Thread("Dalma file change monitor"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3000L);
                        Set set = monitors;
                        synchronized (set) {
                            Iterator itr = monitors.iterator();
                            while (itr.hasNext()) {
                                WeakReference wr = (WeakReference)itr.next();
                                FileChangeMonitor job = (FileChangeMonitor)wr.get();
                                if (job == null) {
                                    itr.remove();
                                    continue;
                                }
                                try {
                                    if (job.check()) continue;
                                    itr.remove();
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                            while (monitors.isEmpty()) {
                                monitors.wait();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    };
    private final File dir;
    private Map<String, Entry> files;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(FileChangeMonitor job) {
        Set<WeakReference<FileChangeMonitor>> set = monitors;
        synchronized (set) {
            monitors.add(new WeakReference<FileChangeMonitor>(job));
            monitors.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChangeMonitor(File dir) {
        this.dir = dir;
        if (!dir.exists()) {
            throw new IllegalArgumentException("No such directory " + dir);
        }
        this.files = new HashMap<String, Entry>();
        for (File f : dir.listFiles()) {
            this.files.put(f.getName(), new Entry(f));
        }
        Set<WeakReference<FileChangeMonitor>> set = monitors;
        synchronized (set) {
            monitors.add(new WeakReference<FileChangeMonitor>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Set<WeakReference<FileChangeMonitor>> set = monitors;
        synchronized (set) {
            Iterator<WeakReference<FileChangeMonitor>> itr = monitors.iterator();
            while (itr.hasNext()) {
                WeakReference<FileChangeMonitor> wr = itr.next();
                if (wr.get() != this) continue;
                itr.remove();
                return;
            }
        }
        throw new IllegalStateException("already cancelled");
    }

    protected abstract void onUpdated(File var1);

    protected abstract void onAdded(File var1);

    protected abstract void onDeleted(File var1);

    private boolean check() {
        HashMap<String, Entry> newMap = new HashMap<String, Entry>();
        if (!this.dir.isDirectory()) {
            return false;
        }
        for (File f : this.dir.listFiles()) {
            String name = f.getName();
            Entry entry = this.files.get(name);
            if (entry == null) {
                newMap.put(name, new Entry(f));
                this.onAdded(f);
                continue;
            }
            long t = f.lastModified();
            if (entry.timestamp < t) {
                this.onUpdated(f);
                entry.timestamp = t;
            }
            newMap.put(name, entry);
            this.files.remove(name);
        }
        for (Entry e : this.files.values()) {
            this.onDeleted(e.file);
        }
        this.files = newMap;
        return true;
    }

    static {
        monitorThread.setDaemon(true);
        monitorThread.start();
    }

    private class Entry {
        private final File file;
        private long timestamp;

        public Entry(File file) {
            this.file = file;
            this.timestamp = file.lastModified();
        }
    }
}

