/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.container.Container;
import dalma.container.FailedOperationException;
import dalma.container.FileChangeMonitor;
import dalma.container.WorkflowApplication;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Redeployer
extends FileChangeMonitor {
    private static final Logger logger = Logger.getLogger(Redeployer.class.getName());
    private final Container container;
    private final Map<File, PassiveFutureTask<WorkflowApplication>> futures = new Hashtable<File, PassiveFutureTask<WorkflowApplication>>();

    Redeployer(Container container) {
        super(container.appsDir);
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<WorkflowApplication> getFuture(File dirName) {
        Map<File, PassiveFutureTask<WorkflowApplication>> map = this.futures;
        synchronized (map) {
            PassiveFutureTask<WorkflowApplication> ft = this.futures.get(dirName);
            if (ft == null) {
                ft = new PassiveFutureTask();
                this.futures.put(dirName, ft);
            }
            return ft;
        }
    }

    @Override
    protected void onAdded(File file) {
        if (Redeployer.isDar(file)) {
            this.container.explode(file);
        }
        if (file.isDirectory()) {
            logger.info("New application '" + file.getName() + "' detected. Deploying.");
            try {
                WorkflowApplication wa = this.container.deploy(file);
                this.notifyFutures(file, wa);
            }
            catch (FailedOperationException e) {
                logger.log(Level.SEVERE, "Unable to deploy", e);
                this.notifyFutures(file, e);
            }
        }
    }

    @Override
    protected void onUpdated(File file) {
        if (Redeployer.isDar(file)) {
            String name = file.getName();
            WorkflowApplication wa = this.container.getApplication(name = name.substring(0, name.length() - 4));
            if (wa != null) {
                logger.info("Dar file is updated for application '" + wa.getName() + "'. Stopping.");
                wa.unload();
            }
            this.container.explode(file);
        }
        if (file.isDirectory()) {
            try {
                WorkflowApplication wa = this.container.getApplication(file.getName());
                if (wa != null) {
                    logger.info("Changed detected in application '" + wa.getName() + "'. Re-deploying.");
                    wa.unload();
                    wa.load();
                    if (wa.isConfigured()) {
                        wa.start();
                    }
                } else {
                    wa = this.container.deploy(file);
                }
                this.notifyFutures(file, wa);
            }
            catch (FailedOperationException e) {
                logger.log(Level.SEVERE, "Unable to redeploy", e);
                this.notifyFutures(file, e);
            }
        }
    }

    @Override
    protected void onDeleted(File file) {
        WorkflowApplication wa = this.container.getApplication(file.getName());
        if (wa != null) {
            logger.info("Application '" + file.getName() + "' is removed. Undeploying.");
            wa.remove();
            this.notifyFutures(file, (WorkflowApplication)null);
        }
    }

    private void notifyFutures(File file, FailedOperationException e) {
        PassiveFutureTask<WorkflowApplication> ft = this.futures.remove(file);
        if (ft != null) {
            ft.abortWith(e);
        }
    }

    private void notifyFutures(File file, WorkflowApplication wa) {
        PassiveFutureTask<WorkflowApplication> ft = this.futures.remove(file);
        if (ft != null) {
            ft.completeWith(wa);
        }
    }

    private static boolean isDar(File f) {
        return f.getName().endsWith(".dar");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PassiveFutureTask<V>
    extends FutureTask<V> {
        private NoopCallable<V> callable;

        public PassiveFutureTask() {
            this(new NoopCallable());
        }

        private PassiveFutureTask(NoopCallable<V> c) {
            super(c);
            this.callable = c;
        }

        public void completeWith(V v) {
            ((NoopCallable)this.callable).v = v;
            this.run();
        }

        public void abortWith(Exception e) {
            assert (e != null);
            ((NoopCallable)this.callable).e = e;
            this.run();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class NoopCallable<V>
        implements Callable<V> {
            private V v;
            private Exception e;

            NoopCallable() {
            }

            @Override
            public V call() throws Exception {
                if (this.e != null) {
                    throw this.e;
                }
                return this.v;
            }
        }
    }
}

