/*
 * Decompiled with CFR 0.152.
 */
package dalma.container;

import dalma.Conversation;
import dalma.Description;
import dalma.Engine;
import dalma.EngineListener;
import dalma.ErrorHandler;
import dalma.Program;
import dalma.container.ClassLoaderImpl;
import dalma.container.CompletedConversationList;
import dalma.container.Container;
import dalma.container.FailedOperationException;
import dalma.container.LogRotationPolicy;
import dalma.container.LogUtil;
import dalma.container.MBeanProxy;
import dalma.container.WorkflowApplicationMBean;
import dalma.container.WorkflowState;
import dalma.container.model.IllegalResourceException;
import dalma.container.model.InjectionException;
import dalma.container.model.Model;
import dalma.impl.EngineImpl;
import dalma.impl.LogRecorder;
import dalma.impl.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkflowApplication
implements WorkflowApplicationMBean {
    private final String name;
    private EngineImpl engine;
    private ClassLoaderImpl classLoader;
    private Class<?> mainClass;
    private Model<?> model;
    public final Container owner;
    private final File workDir;
    private final File appDir;
    private final File confFile;
    private Program program;
    private ObjectName objectName;
    private WorkflowState state;
    final Logger loggerAggregate;
    private final Logger logger;
    private int daysToKeepLog = -1;
    private final LogRotationPolicy logPolicy = new LogRotationPolicy(){

        public boolean keep(Conversation conv) {
            if (WorkflowApplication.this.daysToKeepLog == -1) {
                return true;
            }
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(6, -WorkflowApplication.this.daysToKeepLog);
            return conv.getCompletionDate().getTime() > cal.getTimeInMillis();
        }
    };
    private final CompletedConversationList ccList;
    private final LogRecorder inclusiveLogs;
    private final LogRecorder exclusiveLogs;
    private final Object undeployLock = new Object();
    private boolean undeployed = false;
    private static final String LOG_ROTATION_KEY = "!log-rotation-days";

    public WorkflowApplication(Container owner, File appDir) throws FailedOperationException {
        this.owner = owner;
        this.name = appDir.getName();
        this.workDir = new File(new File(owner.getHomeDir(), "work"), this.name);
        this.confFile = new File(new File(new File(owner.getHomeDir(), "conf"), "apps"), this.name + ".properties");
        this.appDir = appDir;
        this.state = WorkflowState.UNLOADED;
        this.loggerAggregate = LogUtil.newAnonymousLogger(owner.loggerAggregate);
        this.logger = LogUtil.newAnonymousLogger(this.loggerAggregate);
        File clog = new File(this.workDir, "completed-logs");
        clog.mkdirs();
        this.ccList = new CompletedConversationList(clog);
        File excLog = new File(this.workDir, "logs/exclusive");
        excLog.mkdirs();
        this.exclusiveLogs = new LogRecorder(excLog);
        this.logger.addHandler((Handler)this.exclusiveLogs);
        File incLog = new File(this.workDir, "logs/inclusive");
        incLog.mkdirs();
        this.inclusiveLogs = new LogRecorder(incLog);
        this.loggerAggregate.addHandler((Handler)this.inclusiveLogs);
        try {
            Properties props = this.loadConfigProperties();
            this.daysToKeepLog = Integer.parseInt(props.getProperty(LOG_ROTATION_KEY, "-1"));
        }
        catch (IOException e) {
            throw new FailedOperationException("Failed to load configuration " + this.confFile, e);
        }
        this.setLogPolicy();
        try {
            this.objectName = new ObjectName("dalma:container=" + ObjectName.quote(owner.getHomeDir().toString()) + ",name=" + this.name);
            MBeanProxy.register(owner.mbeanServer, this.objectName, WorkflowApplicationMBean.class, this);
        }
        catch (JMException e) {
            this.logger.log(Level.WARNING, "Failed to register to JMX", e);
        }
        this.load();
    }

    public void setDaysToKeepLog(int d) throws IOException {
        this.daysToKeepLog = d;
        Properties props = this.loadConfigProperties();
        props.setProperty(LOG_ROTATION_KEY, String.valueOf(d));
        this.saveConfigProperties(props);
        this.setLogPolicy();
    }

    private void setLogPolicy() {
        this.ccList.setPolicy(this.logPolicy);
        this.inclusiveLogs.setDaysToKeepLog(this.daysToKeepLog);
        this.exclusiveLogs.setDaysToKeepLog(this.daysToKeepLog);
    }

    public List<LogRecord> getLogs(boolean inclusive) {
        return (inclusive ? this.inclusiveLogs : this.exclusiveLogs).getLogs();
    }

    public int getDaysToKeepLog() {
        return this.daysToKeepLog;
    }

    @Override
    public boolean isConfigured() {
        if (this.state == WorkflowState.UNLOADED) {
            return false;
        }
        try {
            return this.model.checkConfiguration(this.loadConfigProperties());
        }
        catch (IOException e) {
            this.log("Failed to check the configuration", e);
            return false;
        }
    }

    public Date getDeployDate() {
        return new Date(this.appDir.lastModified());
    }

    @Override
    public synchronized void load() throws FailedOperationException {
        if (this.state != WorkflowState.UNLOADED) {
            return;
        }
        this.logger.info("Loading " + this.name);
        try {
            assert (this.classLoader == null);
            this.classLoader = this.createClassLoader();
        }
        catch (IOException e) {
            throw new FailedOperationException("Failed to set up a ClassLoader", e);
        }
        try {
            this.mainClass = this.classLoader.loadMainClass();
        }
        catch (ClassNotFoundException e) {
            throw new FailedOperationException("Failed to load the main class from application", e);
        }
        catch (IOException e) {
            throw new FailedOperationException("Failed to load the main class from application", e);
        }
        catch (LinkageError e) {
            throw new FailedOperationException("Failed to load the main class from application", e);
        }
        try {
            this.model = new Model(this.mainClass);
        }
        catch (IllegalResourceException e) {
            throw new FailedOperationException("Failed to configure program", e);
        }
        catch (LinkageError e) {
            throw new FailedOperationException("Failed to configure program", e);
        }
        this.state = WorkflowState.STOPPED;
        this.logger.info("Loaded " + this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws FailedOperationException {
        this.load();
        if (this.state == WorkflowState.RUNNING) {
            return;
        }
        this.logger.info("Starting " + this.name);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Object main;
            block21: {
                try {
                    this.engine = new EngineImpl(new File(this.workDir, "data"), (ClassLoader)this.classLoader, this.owner.executor);
                    this.engine.setOwner((Object)this);
                    this.engine.setErrorHandler(new ErrorHandler(){

                        public void onError(Throwable t) {
                            WorkflowApplication.this.logger.log(Level.SEVERE, t.getMessage(), t);
                        }
                    });
                }
                catch (IOException e) {
                    throw new FailedOperationException("Failed to start engine", e);
                }
                this.engine.getAggregateLogger().setParent(this.loggerAggregate);
                main = this.mainClass.newInstance();
                if (main instanceof Program) break block21;
                this.logger.severe(this.mainClass.getName() + " doesn't extend the Program class");
                return;
            }
            try {
                this.program = (Program)main;
                this.program.setLogger(this.logger);
                this.program.setEngine(this.engine);
            }
            catch (InstantiationException e) {
                throw new FailedOperationException("Failed to load the main class from application", e);
            }
            catch (IllegalAccessException e) {
                throw new FailedOperationException("Failed to load the main class from application", e);
            }
            try {
                this.model.inject((Engine)this.engine, this.program, this.loadConfigProperties());
            }
            catch (InjectionException e) {
                throw new FailedOperationException("Failed to configure program", e);
            }
            catch (ParseException e) {
                throw new FailedOperationException("Failed to configure program", e);
            }
            catch (IOException e) {
                throw new FailedOperationException("Failed to configure program", e);
            }
            try {
                this.program.init((Engine)this.engine);
            }
            catch (Throwable e) {
                throw new FailedOperationException(this.mainClass.getName() + ".init() method reported an exception", e);
            }
            this.engine.addListener(new EngineListener(){

                public void onConversationCompleted(Conversation conv) {
                    WorkflowApplication.this.ccList.add(conv);
                }
            });
            this.engine.start();
            try {
                this.program.main((Engine)this.engine);
            }
            catch (Throwable e) {
                throw new FailedOperationException(this.mainClass.getName() + ".main() method reported an exception", e);
            }
            this.state = WorkflowState.RUNNING;
            this.logger.info("Started " + this.name);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
            if (this.state != WorkflowState.RUNNING) {
                this.program = null;
                if (this.engine.isStarted()) {
                    this.engine.stop();
                }
                this.engine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadConfigProperties() throws IOException {
        Properties props = new Properties();
        if (this.confFile.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.confFile));
            try {
                props.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfigProperties(Properties props) throws IOException {
        this.confFile.getParentFile().mkdirs();
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.confFile));
        try {
            props.store(fos, null);
        }
        finally {
            ((OutputStream)fos).close();
        }
    }

    private void log(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }

    private ClassLoaderImpl createClassLoader() throws IOException {
        ClassLoaderImpl cl = new ClassLoaderImpl(this.owner.appClassLoader);
        cl.addJarFiles(this.appDir);
        cl.addPathFile(this.appDir);
        cl.makeContinuable();
        return cl;
    }

    @Override
    public synchronized void stop() {
        if (this.state != WorkflowState.RUNNING) {
            return;
        }
        this.logger.info("Stopping " + this.name);
        if (this.program != null) {
            try {
                this.program.cleanup((Engine)this.engine);
            }
            catch (Exception e) {
                this.log(this.program.getClass().getName() + ".cleanup() method reported an exception", e);
            }
            this.program = null;
        }
        this.engine.stop();
        this.engine = null;
        this.state = WorkflowState.STOPPED;
        this.logger.info("Stopped " + this.name);
    }

    @Override
    public synchronized void unload() {
        this.stop();
        if (this.state == WorkflowState.UNLOADED) {
            return;
        }
        this.classLoader.cleanup();
        this.classLoader = null;
        this.mainClass = null;
        this.model = null;
        this.state = WorkflowState.UNLOADED;
        this.logger.info("Unloaded " + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.mainClass == null) {
            return "(not available for unloaded workflow)";
        }
        Description d = this.mainClass.getAnnotation(Description.class);
        if (d == null) {
            return "(no description available)";
        }
        return d.value();
    }

    @Override
    public WorkflowState getState() {
        return this.state;
    }

    @Override
    public File getConfigFile() {
        return this.confFile;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Model<?> getModel() {
        return this.model;
    }

    public Program getProgram() {
        return this.program;
    }

    public Map<Integer, Conversation> getCompletedConversations() {
        return this.ccList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void remove() {
        Object object = this.undeployLock;
        synchronized (object) {
            this.owner.applications.remove(this.getName());
            if (this.objectName != null) {
                try {
                    this.owner.mbeanServer.unregisterMBean(this.objectName);
                }
                catch (JMException e) {
                    this.logger.log(Level.WARNING, "Failed to unregister " + this.objectName);
                }
                finally {
                    this.objectName = null;
                }
            }
            this.stop();
            this.undeployed = true;
            this.undeployLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy() throws FailedOperationException {
        this.unload();
        Object object = this.undeployLock;
        synchronized (object) {
            if (!this.undeployed) {
                File dar = new File(this.owner.appsDir, this.name + ".dar");
                if (dar.exists() && !dar.delete()) {
                    throw new FailedOperationException("failed to delete " + this.appDir);
                }
                try {
                    Util.deleteRecursive((File)this.appDir);
                    Util.deleteRecursive((File)this.workDir);
                }
                catch (IOException e) {
                    throw new FailedOperationException("Unable to clean up the application directory " + this.appDir, e);
                }
                try {
                    this.undeployLock.wait(15000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.undeployed) {
                    throw new FailedOperationException("Operation timed out");
                }
            }
        }
    }
}

