/*
 * Decompiled with CFR 0.152.
 */
package dalma.container.model;

import dalma.EndPoint;
import dalma.Engine;
import java.io.File;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Converter<T> {
    public static final Converter[] ALL = new Converter[]{new Converter<String>(){

        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public String load(Engine engine, String propertyName, String value) {
            return value;
        }

        public String save(String value) {
            return value;
        }
    }, new Converter<File>(){

        @Override
        public Class<File> getType() {
            return File.class;
        }

        @Override
        public File load(Engine engine, String propertyName, String value) {
            return new File(value);
        }

        public String save(String value) {
            return value;
        }
    }, new Converter<Boolean>(){

        @Override
        public Class<Boolean> getType() {
            return Boolean.class;
        }

        @Override
        public Boolean load(Engine engine, String propertyName, String value) {
            return Boolean.valueOf(value);
        }

        public String save(Boolean value) {
            if (value == null) {
                value = false;
            }
            return Boolean.toString(value);
        }
    }, new Converter<Integer>(){

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public Integer load(Engine engine, String propertyName, String value) throws ParseException {
            if (value == null) {
                return 0;
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ParseException(value, -1);
            }
        }

        public String save(Integer value) {
            if (value == null) {
                return null;
            }
            return Integer.toString(value);
        }
    }, new Converter<EndPoint>(){

        @Override
        public Class<EndPoint> getType() {
            return EndPoint.class;
        }

        @Override
        public EndPoint load(Engine engine, String propertyName, String value) throws ParseException {
            return engine.addEndPoint(propertyName, value);
        }
    }};

    Converter() {
    }

    abstract Class<T> getType();

    abstract T load(Engine var1, String var2, String var3) throws ParseException;

    public static <V> Converter<? super V> get(Class<V> type) {
        for (Converter conv : ALL) {
            if (!conv.getType().isAssignableFrom(type)) continue;
            return conv;
        }
        return null;
    }
}

