/*
 * Decompiled with CFR 0.152.
 */
package dalma.endpoints.irc;

import dalma.endpoints.irc.Buddy;
import dalma.endpoints.irc.IRCEndPoint;
import dalma.endpoints.irc.Session;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.clientstate.Member;
import f00f.net.irc.martyr.commands.InviteCommand;
import f00f.net.irc.martyr.commands.JoinCommand;
import f00f.net.irc.martyr.commands.KickCommand;
import f00f.net.irc.martyr.commands.MessageCommand;
import f00f.net.irc.martyr.commands.PartCommand;
import f00f.net.irc.martyr.commands.RawCommand;
import f00f.net.irc.martyr.commands.TopicCommand;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Channel
extends Session {
    private final String name;
    private boolean joined;

    public Channel(IRCEndPoint endpoint, String name) {
        super(endpoint);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void join() {
        this.makeSureNotJoined();
        this.endpoint.connection.sendCommand((OutCommand)new JoinCommand(this.name));
        this.joined = true;
    }

    public synchronized void join(String secret) {
        this.makeSureNotJoined();
        this.endpoint.connection.sendCommand((OutCommand)new JoinCommand(this.name, secret));
        this.joined = true;
    }

    public synchronized boolean isJoined() {
        return this.getChannelInfo() != null;
    }

    private synchronized void makeSureNotJoined() {
        if (this.joined) {
            throw new IllegalStateException("already joined");
        }
    }

    public void invite(Buddy buddy) {
        this.endpoint.connection.sendCommand((OutCommand)new InviteCommand(buddy.name, this.name));
    }

    public void kick(Buddy buddy, String comment) {
        this.endpoint.connection.sendCommand((OutCommand)new KickCommand(this.name, buddy.name, comment));
    }

    public void knock(String msg) {
        this.makeSureNotJoined();
        this.endpoint.connection.sendCommand((OutCommand)new RawCommand(this.name, msg));
    }

    public Collection<Buddy> getMembers() {
        ArrayList<Buddy> buddies = new ArrayList<Buddy>();
        Enumeration members = this.getChannelInfo().getMembers();
        while (members.hasMoreElements()) {
            Member m = (Member)members.nextElement();
            Buddy b = this.endpoint.getBuddy(m.getNick().getNick());
            buddies.add(b);
        }
        return buddies;
    }

    private f00f.net.irc.martyr.clientstate.Channel getChannelInfo() {
        return this.endpoint.connection.getClientState().getChannel(this.name);
    }

    public String getTopic() {
        return this.getChannelInfo().getTopic();
    }

    public void setTopic(String newTopic) {
        this.endpoint.connection.sendCommand((OutCommand)new TopicCommand(this.name, newTopic));
    }

    public void setMode(Object ... modes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void send(String message) {
        this.endpoint.connection.sendCommand((OutCommand)new MessageCommand(this.name, message));
    }

    @Override
    public synchronized void close() {
        this.endpoint.connection.sendCommand((OutCommand)new PartCommand(this.name));
        this.joined = false;
    }

    @Override
    protected Object writeReplace() {
        return new Moniker(this.endpoint, this.name);
    }

    private static final class Moniker
    implements Serializable {
        private final IRCEndPoint endPoint;
        private final String channelName;
        private static final long serialVersionUID = 1L;

        public Moniker(IRCEndPoint endPoint, String channelName) {
            this.endPoint = endPoint;
            this.channelName = channelName;
        }

        private Object readResolve() {
            return this.endPoint.getChannel(this.channelName);
        }
    }
}

