/*
 * Decompiled with CFR 0.152.
 */
package dalma.endpoints.irc;

import dalma.endpoints.irc.AutoReconnectEx;
import dalma.endpoints.irc.Buddy;
import dalma.endpoints.irc.Channel;
import dalma.endpoints.irc.Message;
import dalma.endpoints.irc.MessageListener;
import dalma.endpoints.irc.NewSessionListener;
import dalma.endpoints.irc.PrivateChat;
import dalma.impl.EndPointImpl;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.commands.InviteCommand;
import f00f.net.irc.martyr.commands.MessageCommand;
import f00f.net.irc.martyr.commands.NickCommand;
import f00f.net.irc.martyr.commands.RawCommand;
import f00f.net.irc.martyr.services.AutoRegister;
import f00f.net.irc.martyr.services.AutoResponder;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRCEndPoint
extends EndPointImpl {
    private final Map<String, Channel> channels = new Hashtable<String, Channel>();
    private final Map<String, Buddy> buddies = new Hashtable<String, Buddy>();
    private static final Logger logger = Logger.getLogger(IRCEndPoint.class.getName());
    final IRCConnection connection = new IRCConnection();
    private NewSessionListener newSessionListener;
    private final AutoReconnectEx autoReconnect;

    public IRCEndPoint(String endpointName, String ircServer, int port, String nickname) {
        super(endpointName);
        new AutoRegister(this.connection, nickname, nickname, nickname);
        new AutoResponder(this.connection);
        this.autoReconnect = new AutoReconnectEx(this.connection, ircServer, port);
        this.connection.addCommandObserver((Observer)new MessageListener(this));
    }

    public IRCEndPoint(String endpointName, String ircServer, String nickname) {
        this(endpointName, ircServer, 6667, nickname);
    }

    protected void start() {
        this.autoReconnect.go();
    }

    protected void stop() {
        this.connection.disconnect();
    }

    public NewSessionListener getNewSessionListener() {
        return this.newSessionListener;
    }

    public void setNewSessionListener(NewSessionListener newSessionListener) {
        this.newSessionListener = newSessionListener;
    }

    public void setAway(String status) {
        this.connection.sendCommand((OutCommand)new RawCommand("AWAY", status));
    }

    public void setNick(String nickname) {
        this.connection.sendCommand((OutCommand)new NickCommand(nickname));
    }

    public Collection<Channel> listChannels() {
        throw new UnsupportedOperationException();
    }

    void onMessageReceived(MessageCommand cmd) {
        String dest = cmd.getDest().toLowerCase();
        Buddy sender = this.getBuddy(cmd.getSource().getNick());
        if (cmd.isPrivateToUs(this.connection.getClientState())) {
            Message msg = new Message(sender, cmd.getMessage(), null);
            PrivateChat chat = sender.getChat();
            if (chat != null) {
                chat.onMessageReceived(msg);
                return;
            }
            NewSessionListener sl = this.newSessionListener;
            if (sl != null) {
                chat = sender.openChat();
                chat.onMessageReceived(msg);
                sl.onNewPrivateChat(chat);
                return;
            }
            return;
        }
        Channel channel = this.channels.get(dest);
        if (channel != null) {
            channel.onMessageReceived(new Message(sender, cmd.getMessage(), channel));
            return;
        }
        logger.log(Level.WARNING, "Unrecognized message: " + cmd.renderParams());
    }

    void onInvite(InviteCommand cmd) {
        if (!cmd.getNick().equals(this.getNickName())) {
            return;
        }
        Channel ch = this.getChannel(cmd.getChannel());
        if (ch.isJoined()) {
            return;
        }
        Buddy sender = this.getBuddy(cmd.getUser().getNick());
        NewSessionListener sl = this.newSessionListener;
        if (sl != null) {
            sl.onInvite(sender, ch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buddy getBuddy(String nickname) {
        Map<String, Buddy> map = this.buddies;
        synchronized (map) {
            Buddy buddy = this.buddies.get(nickname);
            if (buddy == null) {
                buddy = new Buddy(this, nickname);
                this.buddies.put(nickname, buddy);
            }
            return buddy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String channelName) {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            Channel ch = this.channels.get(channelName);
            if (ch == null) {
                ch = new Channel(this, channelName);
                this.channels.put(channelName, ch);
            }
            return ch;
        }
    }

    public String getNickName() {
        return this.connection.getClientState().getNick().getNick();
    }
}

