/*
 * Decompiled with CFR 0.152.
 */
package dalma.endpoints.irc;

import dalma.endpoints.irc.Buddy;
import dalma.endpoints.irc.IRCEndPoint;
import dalma.endpoints.irc.Session;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.commands.MessageCommand;
import java.io.Serializable;

public final class PrivateChat
extends Session {
    private final Buddy buddy;

    PrivateChat(IRCEndPoint endpoint, Buddy buddy) {
        super(endpoint);
        this.buddy = buddy;
    }

    public Buddy getBuddy() {
        return this.buddy;
    }

    public void send(String message) {
        this.endpoint.connection.sendCommand((OutCommand)new MessageCommand(this.buddy.getName(), message));
    }

    public void close() {
        this.buddy.onChatClosed();
    }

    protected Object writeReplace() {
        return new Moniker(this.buddy);
    }

    private static final class Moniker
    implements Serializable {
        private final Buddy buddy;
        private static final long serialVersionUID = 1L;

        public Moniker(Buddy buddy) {
            this.buddy = buddy;
        }

        private Object readResolve() {
            return this.buddy.getChat();
        }
    }
}

